/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.dialogs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import pdb_editor.coordinate.CoordinateTable;
import pdb_editor.coordinate.SearchSelectDialog;
import pdb_editor.dialogs.ResultData;
import pdb_reader.DataSet;
import pdb_reader.FormulaEvaluator;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.Coordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindClosestAtomDistancesDialog
extends JDialog {
    private final String ExcludeLabelBase = "Number of Atoms To Be Excluded : ";
    private final String SelectedLabelBase = "Number of Atoms Selected To Be Used : ";
    private CoordinateTable maintable = null;
    private DataSet maindata = null;
    private SearchSelectDialog selectedDialog = null;
    private SearchSelectDialog excludedDialog = null;
    private double distanceMax = 10.0;
    private double distanceMin = 0.0;
    private Coordinate OriginMaxCoord = null;
    private Coordinate OriginMinCoord = null;
    private Coordinate OriginMaxFracCoord = null;
    private Coordinate OriginMinFracCoord = null;
    private Coordinate OriginSearchMaxCoord = null;
    private Coordinate OriginSearchMinCoord = null;
    private Coordinate OriginSearchMaxFracCoord = null;
    private Coordinate OriginSearchMinFracCoord = null;
    private int excludeRangeAfter = 3;
    private int excludeRangeBefore = 3;
    private HashMap<Object, Coordinate> searchOrigin = null;
    private HashMap<Atom, Coordinate[]> searchPoints = null;
    private HashMap<Object, ResultData[]> searchResult = null;
    private ResultData[] searchResultAll = null;
    private JCheckBoxMenuItem[] OriginColumnMenu = null;
    private JCheckBoxMenuItem[] TargetColumnMenu = null;
    int[] ColumnDisplayed = null;
    private ButtonGroup buttonGroupSelectAtom;
    private ButtonGroup buttonGroupSelectCoordinate;
    private JButton jButtonCalculate;
    private JButton jButtonClose;
    private JButton jButtonSearchExclude;
    private JButton jButtonSearchSelect;
    private JCheckBox jCheckBoxCheckSymmetry;
    private JCheckBox jCheckBoxConditionExclude;
    private JCheckBox jCheckBoxConditionSelect;
    private JCheckBox jCheckBoxCoordinatePoints;
    private JCheckBox jCheckBoxExcludeAfter;
    private JCheckBox jCheckBoxExcludeBefore;
    private JCheckBox jCheckBoxExcludeWithin;
    private JCheckBox jCheckBoxIncludeSelected;
    private JDialog jDialogResult;
    private JFileChooser jFileChooser;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelNumberAtomExcluded;
    private JLabel jLabelNumberAtomSelected;
    private JMenuBar jMenuBar;
    private JMenu jMenuFile;
    private JMenu jMenuFound;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemSaveAs;
    private JMenu jMenuOrigin;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonAtoms;
    private JRadioButton jRadioButtonChains;
    private JRadioButton jRadioButtonFractional;
    private JRadioButton jRadioButtonOrthogonal;
    private JRadioButton jRadioButtonResidues;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPaneCoordinateList;
    private JTable jTableResult;
    private JTextArea jTextAreaCoordinateInput;
    private JTextField jTextFieldDistanceMax;
    private JTextField jTextFieldDistanceMin;
    private JTextField jTextFieldExcludeAfterNumber;
    private JTextField jTextFieldExcludeBeforeNumber;

    public FindClosestAtomDistancesDialog(Frame parent, boolean modal, CoordinateTable tablein) {
        super(parent, modal);
        this.maintable = tablein;
        this.maindata = tablein.getMainData();
        this.initComponents();
        this.initButtonGroup();
        this.jLabelNumberAtomExcluded.setText("Number of Atoms To Be Excluded : ");
        this.jLabelNumberAtomSelected.setText("Number of Atoms Selected To Be Used : ");
        this.selectedDialog = new SearchSelectDialog(null, true, "Select", this.maintable, true);
        this.excludedDialog = new SearchSelectDialog(null, true, "Exclude", this.maintable, true);
        this.initResultColumnCheckMenu();
    }

    private void initResultColumnCheckMenu() {
        this.OriginColumnMenu = new JCheckBoxMenuItem[35];
        this.TargetColumnMenu = new JCheckBoxMenuItem[35];
        int[] OriginSelected = new int[]{1, 7, 8, 2};
        int[] TargetSelected = new int[]{1, 7, 8, 2};
        for (int i = 0; i < this.OriginColumnMenu.length; ++i) {
            this.OriginColumnMenu[i] = new JCheckBoxMenuItem();
            this.TargetColumnMenu[i] = new JCheckBoxMenuItem();
            this.OriginColumnMenu[i].setSelected(Global.IntegerArrayContains(OriginSelected, i));
            this.TargetColumnMenu[i].setSelected(Global.IntegerArrayContains(TargetSelected, i));
            this.OriginColumnMenu[i].setText(Atom.DataToolTip[i]);
            this.TargetColumnMenu[i].setText(Atom.DataToolTip[i]);
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FindClosestAtomDistancesDialog.this.initColumnDisplayed();
                    FindClosestAtomDistancesDialog.this.jTableResult.setModel(new ResultTableData());
                }
            };
            this.OriginColumnMenu[i].addActionListener(al);
            this.TargetColumnMenu[i].addActionListener(al);
            this.jMenuOrigin.add(this.OriginColumnMenu[i]);
            this.jMenuFound.add(this.TargetColumnMenu[i]);
        }
    }

    private void initButtonGroup() {
        this.buttonGroupSelectAtom.add(this.jRadioButtonAtoms);
        this.buttonGroupSelectAtom.add(this.jRadioButtonChains);
        this.buttonGroupSelectAtom.add(this.jRadioButtonResidues);
        this.buttonGroupSelectCoordinate.add(this.jRadioButtonFractional);
        this.buttonGroupSelectCoordinate.add(this.jRadioButtonOrthogonal);
    }

    private void initColumnDisplayed() {
        int i;
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (i = 0; i < this.OriginColumnMenu.length; ++i) {
            if (!this.OriginColumnMenu[i].isSelected()) continue;
            r.add(i);
        }
        for (i = 0; i < this.TargetColumnMenu.length; ++i) {
            if (!this.TargetColumnMenu[i].isSelected()) continue;
            r.add(i + 35);
        }
        r.add(70);
        r.add(71);
        this.ColumnDisplayed = Global.ConvertIntegerArrayToIntArray(r.toArray(new Integer[r.size()]));
    }

    private void Run() {
        this.getSearchOptionValues();
        this.generateSearchOrigin();
        if (this.searchOrigin.size() > 0) {
            this.generateSearchPoints();
            this.calculateDistance();
            this.showResult();
        }
    }

    private void showResult() {
        this.initColumnDisplayed();
        this.jTableResult.setModel(new ResultTableData());
        this.jTableResult.setAutoCreateRowSorter(true);
        this.jDialogResult.show();
    }

    private void generateSearchPoints() {
        this.searchPoints = new HashMap();
        this.sortAtomsBySelectExcludeOption();
        this.generateSearchPointCoordinateList();
    }

    private void calculateDistance() {
        this.searchResult = new HashMap();
        ArrayList<ResultData> foundall = new ArrayList<ResultData>();
        for (Object current : this.searchOrigin.keySet()) {
            Coordinate c = this.searchOrigin.get(current);
            for (Atom target : this.searchPoints.keySet()) {
                Coordinate[] list = this.searchPoints.get(target);
                ArrayList<ResultData> found = new ArrayList<ResultData>();
                for (int k = 0; k < list.length; ++k) {
                    double d;
                    if (list[k] == null || !((d = list[k].CalculateDistance(c)) <= this.distanceMax) || !(d >= this.distanceMin) || !this.targetSatisfiesCriteria(current, target, k)) continue;
                    ResultData rd = new ResultData(current, target, k, d);
                    found.add(rd);
                    foundall.add(rd);
                }
                this.searchResult.put(current, found.toArray(new ResultData[found.size()]));
            }
        }
        this.searchResultAll = foundall.toArray(new ResultData[foundall.size()]);
    }

    private boolean targetSatisfiesCriteria(Object current, Atom target, int symop) {
        if (symop > 0) {
            return true;
        }
        if (current.getClass().equals(Global.stringclass.getClass())) {
            return true;
        }
        Atom c = (Atom)current;
        if (c.equals(target)) {
            return false;
        }
        if (c.ChainID() != target.ChainID()) {
            return true;
        }
        int cresnum = c.ResidueNumber();
        int tresnum = target.ResidueNumber();
        if (this.jCheckBoxExcludeWithin.isSelected() && cresnum == tresnum) {
            return false;
        }
        if (this.jCheckBoxExcludeAfter.isSelected() && tresnum > cresnum && tresnum <= cresnum + this.excludeRangeAfter) {
            return false;
        }
        return !this.jCheckBoxExcludeBefore.isSelected() || tresnum >= cresnum || tresnum < cresnum - this.excludeRangeBefore;
    }

    private void generateSearchPointCoordinateList() {
        for (Atom key : this.searchPoints.keySet()) {
            ArrayList<Coordinate> list = new ArrayList<Coordinate>();
            if (this.isInOriginBoundary(key.OrthogonalCoordinate())) {
                list.add(key.OrthogonalCoordinate());
            } else {
                list.add(null);
            }
            if (this.jCheckBoxCheckSymmetry.isSelected()) {
                FormulaEvaluator[][] ops = this.generateSymmOpFormulas();
                Coordinate[] fcs = this.generateSymmetryMates(ops, key.FractionalCoordinate());
                Coordinate[] ocs = this.adjustFractionalCoordinatesAndTransformToOrthogonal(fcs);
                for (int j = 0; j < ocs.length; ++j) {
                    if (this.isInOriginBoundary(ocs[j])) {
                        list.add(ocs[j]);
                        continue;
                    }
                    list.add(null);
                }
            }
            this.searchPoints.put(key, list.toArray(new Coordinate[list.size()]));
        }
    }

    private Coordinate[] adjustFractionalCoordinatesAndTransformToOrthogonal(Coordinate[] fcs) {
        Coordinate[] r = new Coordinate[fcs.length];
        for (int i = 0; i < fcs.length; ++i) {
            r[i] = Global.TransformCoordinates(this.maindata.Spacegroup().scaleInverse(), this.findClosestFractionalCoordinate(fcs[i]));
        }
        return r;
    }

    private Coordinate findClosestFractionalCoordinate(Coordinate c) {
        Coordinate[] max = this.findClosestFractionalCoordinateAndDifference(this.OriginMaxFracCoord, c);
        Coordinate[] min = this.findClosestFractionalCoordinateAndDifference(this.OriginMinFracCoord, c);
        double xbest = max[0].x();
        double ybest = max[0].y();
        double zbest = max[0].z();
        if (max[1].x() > min[1].x()) {
            xbest = min[0].x();
        }
        if (max[1].y() > min[1].y()) {
            ybest = min[0].y();
        }
        if (max[1].z() > min[1].z()) {
            zbest = min[0].z();
        }
        return new Coordinate(xbest, ybest, zbest);
    }

    private Coordinate[] findClosestFractionalCoordinateAndDifference(Coordinate base, Coordinate adj) {
        double[] dx = this.findClosestFractionalAndDifferenece(base.x(), adj.x());
        double[] dy = this.findClosestFractionalAndDifferenece(base.y(), adj.y());
        double[] dz = this.findClosestFractionalAndDifferenece(base.z(), adj.z());
        return new Coordinate[]{new Coordinate(dx[0], dy[0], dz[0]), new Coordinate(dx[1], dy[1], dz[1])};
    }

    private double[] findClosestFractionalAndDifferenece(double n1, double n2) {
        double corrx = n2 + Math.floor(n1) - Math.floor(n2);
        double dx = n1 - corrx;
        if (dx < -0.5) {
            corrx -= 1.0;
            dx += 1.0;
        }
        if (dx > 0.5) {
            corrx += 1.0;
            dx -= 1.0;
        }
        return new double[]{corrx, Math.abs(dx)};
    }

    private Coordinate[] generateSymmetryMates(FormulaEvaluator[][] f, Coordinate list) {
        Coordinate[] r = new Coordinate[f.length];
        for (int i = 0; i < f.length; ++i) {
            HashMap<String, Double> vars = this.getFormulaVariables(list);
            r[i] = new Coordinate(f[i][0].evaluateExpression(vars), f[i][1].evaluateExpression(vars), f[i][2].evaluateExpression(vars));
        }
        return r;
    }

    private HashMap<String, Double> getFormulaVariables(Coordinate a) {
        HashMap<String, Double> r = new HashMap<String, Double>();
        r.put("X", a.x());
        r.put("Y", a.y());
        r.put("Z", a.z());
        return r;
    }

    private FormulaEvaluator[][] generateSymmOpFormulas() {
        String[][] ops = this.maindata.Spacegroup().symmetryOperators();
        FormulaEvaluator[][] f = new FormulaEvaluator[ops.length - 1][3];
        for (int i = 1; i < ops.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                f[i - 1][j] = new FormulaEvaluator(ops[i][j]);
            }
        }
        return f;
    }

    private void sortAtomsBySelectExcludeOption() {
        Atom a;
        int i;
        Integer[] list;
        if (this.jCheckBoxConditionSelect.isSelected()) {
            list = this.selectedDialog.getFoundCoordinateIndicies();
            for (i = 0; i < list.length; ++i) {
                a = this.maindata.Atoms().get(list[i]);
                this.searchPoints.put(a, null);
            }
        } else {
            for (int i2 = 0; i2 < this.maindata.Atoms().size(); ++i2) {
                Atom a2 = this.maindata.Atoms().get(i2);
                this.searchPoints.put(a2, null);
            }
        }
        if (this.jCheckBoxConditionExclude.isSelected()) {
            list = this.excludedDialog.getFoundCoordinateIndicies();
            for (i = 0; i < list.length; ++i) {
                a = this.maindata.Atoms().get(list[i]);
                this.searchPoints.remove(a);
            }
        }
    }

    private void getSearchOptionValues() {
        this.distanceMax = Double.parseDouble(this.jTextFieldDistanceMax.getText());
        this.distanceMin = Double.parseDouble(this.jTextFieldDistanceMin.getText());
        this.excludeRangeAfter = Integer.parseInt(this.jTextFieldExcludeAfterNumber.getText());
        this.excludeRangeBefore = Integer.parseInt(this.jTextFieldExcludeBeforeNumber.getText());
    }

    private void generateSearchBoundary() {
        Coordinate c = this.OriginMaxCoord;
        Coordinate d = this.OriginMinCoord;
        if (c != null) {
            this.OriginSearchMaxCoord = new Coordinate(c.x() + this.distanceMax, c.y() + this.distanceMax, c.z() + this.distanceMax);
            this.OriginSearchMinCoord = new Coordinate(d.x() - this.distanceMax, d.y() - this.distanceMax, d.z() - this.distanceMax);
            if (this.maindata.Spacegroup().scale() != null) {
                double[][] m = this.maindata.Spacegroup().scale();
                this.OriginMaxFracCoord = Global.TransformCoordinates(m, this.OriginMaxCoord);
                this.OriginMinFracCoord = Global.TransformCoordinates(m, this.OriginMinCoord);
                this.OriginSearchMaxFracCoord = Global.TransformCoordinates(m, this.OriginSearchMaxCoord);
                this.OriginSearchMinFracCoord = Global.TransformCoordinates(m, this.OriginSearchMinCoord);
            }
        }
    }

    private boolean isInOriginBoundary(Coordinate c) {
        if (c.x() > this.OriginSearchMaxCoord.x()) {
            return false;
        }
        if (c.y() > this.OriginSearchMaxCoord.y()) {
            return false;
        }
        if (c.z() > this.OriginSearchMaxCoord.z()) {
            return false;
        }
        if (c.x() < this.OriginSearchMinCoord.x()) {
            return false;
        }
        if (c.y() < this.OriginSearchMinCoord.y()) {
            return false;
        }
        return !(c.z() < this.OriginSearchMinCoord.z());
    }

    private void updateOriginMaxMin(Coordinate c) {
        if (this.OriginMaxCoord == null) {
            this.OriginMaxCoord = c.clone();
        }
        if (this.OriginMinCoord == null) {
            this.OriginMinCoord = c.clone();
        }
        if (c.x() > this.OriginMaxCoord.x()) {
            this.OriginMaxCoord.x(c.x());
        }
        if (c.y() > this.OriginMaxCoord.y()) {
            this.OriginMaxCoord.y(c.y());
        }
        if (c.z() > this.OriginMaxCoord.z()) {
            this.OriginMaxCoord.z(c.z());
        }
        if (c.x() < this.OriginMinCoord.x()) {
            this.OriginMinCoord.x(c.x());
        }
        if (c.y() < this.OriginMinCoord.y()) {
            this.OriginMinCoord.y(c.y());
        }
        if (c.z() < this.OriginMinCoord.z()) {
            this.OriginMinCoord.z(c.z());
        }
    }

    private void generateSearchOrigin() {
        this.searchOrigin = new HashMap();
        this.OriginMaxCoord = null;
        this.OriginMinCoord = null;
        if (this.jCheckBoxIncludeSelected.isSelected()) {
            int[] indicies = null;
            if (this.jRadioButtonAtoms.isSelected()) {
                indicies = this.maintable.getSelectedRows();
            }
            if (this.jRadioButtonResidues.isSelected()) {
                indicies = this.maindata.getResiduesIndicies(this.maintable.getSelectedRows());
            }
            if (this.jRadioButtonChains.isSelected()) {
                indicies = this.maindata.getChainIndicies(this.maintable.getSelectedRows());
            }
            if (indicies != null) {
                for (int i = 0; i < indicies.length; ++i) {
                    Atom a = this.maindata.Atoms().get(indicies[i]);
                    this.updateOriginMaxMin(a.OrthogonalCoordinate());
                    this.searchOrigin.put(a, a.OrthogonalCoordinate());
                }
            }
        }
        if (this.jCheckBoxCoordinatePoints.isSelected()) {
            String NamePreText = "Point";
            Coordinate[] coords = this.getCoordinatesFromText(this.jTextAreaCoordinateInput.getText(), this.jRadioButtonFractional.isSelected());
            for (int i = 0; i < coords.length; ++i) {
                this.updateOriginMaxMin(coords[i]);
                int index = i + 1;
                this.searchOrigin.put(NamePreText + ' ' + index, coords[i]);
            }
        }
        this.generateSearchBoundary();
    }

    private Coordinate[] getCoordinatesFromText(String textin, boolean fractional) {
        double[] nums = Global.ExtractAllNumbers(textin);
        Coordinate[] r = new Coordinate[nums.length / 3];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new Coordinate(nums[i * 3], nums[i * 3 + 1], nums[i * 3 + 2]);
            if (!fractional) continue;
            r[i] = Global.TransformCoordinates(this.maindata.Spacegroup().scaleInverse(), r[i]);
        }
        return r;
    }

    private void initComponents() {
        this.buttonGroupSelectAtom = new ButtonGroup();
        this.buttonGroupSelectCoordinate = new ButtonGroup();
        this.jDialogResult = new JDialog();
        this.jScrollPane1 = new JScrollPane();
        this.jTableResult = new JTable();
        this.jMenuBar = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemSaveAs = new JMenuItem();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuOrigin = new JMenu();
        this.jMenuFound = new JMenu();
        this.jFileChooser = new JFileChooser();
        this.jPanel1 = new JPanel();
        this.jCheckBoxIncludeSelected = new JCheckBox();
        this.jRadioButtonChains = new JRadioButton();
        this.jRadioButtonResidues = new JRadioButton();
        this.jRadioButtonAtoms = new JRadioButton();
        this.jCheckBoxCoordinatePoints = new JCheckBox();
        this.jScrollPaneCoordinateList = new JScrollPane();
        this.jTextAreaCoordinateInput = new JTextArea();
        this.jRadioButtonOrthogonal = new JRadioButton();
        this.jRadioButtonFractional = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldDistanceMax = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldDistanceMin = new JTextField();
        this.jCheckBoxExcludeWithin = new JCheckBox();
        this.jCheckBoxExcludeAfter = new JCheckBox();
        this.jCheckBoxExcludeBefore = new JCheckBox();
        this.jCheckBoxCheckSymmetry = new JCheckBox();
        this.jCheckBoxConditionSelect = new JCheckBox();
        this.jCheckBoxConditionExclude = new JCheckBox();
        this.jTextFieldExcludeAfterNumber = new JTextField();
        this.jTextFieldExcludeBeforeNumber = new JTextField();
        this.jLabelNumberAtomSelected = new JLabel();
        this.jLabelNumberAtomExcluded = new JLabel();
        this.jButtonSearchSelect = new JButton();
        this.jButtonSearchExclude = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonCalculate = new JButton();
        this.jDialogResult.setTitle("Atom Distance Result");
        this.jDialogResult.setMinimumSize(new Dimension(800, 600));
        this.jTableResult.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTableResult.setAutoResizeMode(0);
        this.jTableResult.setCellSelectionEnabled(true);
        this.jScrollPane1.setViewportView(this.jTableResult);
        this.jMenuFile.setText("File");
        this.jMenuItemSaveAs.setText("Save As Text File");
        this.jMenuItemSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindClosestAtomDistancesDialog.this.jMenuItemSaveAsActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemSaveAs);
        this.jMenuItemExit.setText("Close");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindClosestAtomDistancesDialog.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBar.add(this.jMenuFile);
        this.jMenuOrigin.setText("Origin Columns");
        this.jMenuBar.add(this.jMenuOrigin);
        this.jMenuFound.setText("Found Columns");
        this.jMenuBar.add(this.jMenuFound);
        GroupLayout jDialogResultLayout = new GroupLayout(this.jDialogResult.getContentPane());
        this.jDialogResult.getContentPane().setLayout(jDialogResultLayout);
        jDialogResultLayout.setHorizontalGroup(jDialogResultLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 452, Short.MAX_VALUE).addGroup(jDialogResultLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogResultLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane1).addGap(0, 0, 0))));
        jDialogResultLayout.setVerticalGroup(jDialogResultLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 424, Short.MAX_VALUE).addGroup(jDialogResultLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jDialogResultLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jScrollPane1).addGap(1, 1, 1))));
        this.jFileChooser.setDialogTitle("Save Result as Tab Delimited Text");
        this.jFileChooser.setDialogType(1);
        this.setDefaultCloseOperation(2);
        this.setTitle("Find Closest Atom Distances");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                FindClosestAtomDistancesDialog.this.formWindowClosed(evt);
            }

            public void windowClosing(WindowEvent evt) {
                FindClosestAtomDistancesDialog.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Origination Atoms / Coordinate"));
        this.jCheckBoxIncludeSelected.setSelected(true);
        this.jCheckBoxIncludeSelected.setText("Include selected");
        this.jRadioButtonChains.setText("Chains");
        this.jRadioButtonResidues.setSelected(true);
        this.jRadioButtonResidues.setText("Residues");
        this.jRadioButtonAtoms.setText("Atoms");
        this.jCheckBoxCoordinatePoints.setText("Coordinate points");
        this.jTextAreaCoordinateInput.setColumns(20);
        this.jTextAreaCoordinateInput.setRows(5);
        this.jScrollPaneCoordinateList.setViewportView(this.jTextAreaCoordinateInput);
        this.jRadioButtonOrthogonal.setSelected(true);
        this.jRadioButtonOrthogonal.setText("Orthogonal");
        this.jRadioButtonFractional.setText("Fractional");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneCoordinateList, -1, 406, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxIncludeSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonChains).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonResidues).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonAtoms)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBoxCoordinatePoints).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonOrthogonal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonFractional))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxIncludeSelected).addComponent(this.jRadioButtonChains).addComponent(this.jRadioButtonResidues).addComponent(this.jRadioButtonAtoms)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxCoordinatePoints).addComponent(this.jRadioButtonOrthogonal).addComponent(this.jRadioButtonFractional)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPaneCoordinateList, -1, 98, Short.MAX_VALUE).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Search Options"));
        this.jLabel1.setText("Search limit maximum distance (in Angstroms)");
        this.jTextFieldDistanceMax.setText("10.00");
        this.jLabel2.setText("Search limit minimum distance (in Angstroms)");
        this.jTextFieldDistanceMin.setText("0.00");
        this.jCheckBoxExcludeWithin.setSelected(true);
        this.jCheckBoxExcludeWithin.setText("Exclude distance between atoms within the same residue");
        this.jCheckBoxExcludeAfter.setSelected(true);
        this.jCheckBoxExcludeAfter.setText("Exclude distance between atoms within residue number range plus");
        this.jCheckBoxExcludeBefore.setSelected(true);
        this.jCheckBoxExcludeBefore.setText("Exclude distance between atoms within residue number range minus");
        this.jCheckBoxCheckSymmetry.setSelected(true);
        this.jCheckBoxCheckSymmetry.setText("Check all symmetry mates");
        this.jCheckBoxConditionSelect.setText("Search only within atoms satisfying following conditions");
        this.jCheckBoxConditionExclude.setText("Exclude atoms satisfying following conditions");
        this.jTextFieldExcludeAfterNumber.setText("3");
        this.jTextFieldExcludeBeforeNumber.setText("3");
        this.jLabelNumberAtomSelected.setText("# of Atoms Selected :");
        this.jLabelNumberAtomExcluded.setText("# of Atoms Excluded :");
        this.jButtonSearchSelect.setText("Search & Select");
        this.jButtonSearchSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindClosestAtomDistancesDialog.this.jButtonSearchSelectActionPerformed(evt);
            }
        });
        this.jButtonSearchExclude.setText("Search & Exclude");
        this.jButtonSearchExclude.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindClosestAtomDistancesDialog.this.jButtonSearchExcludeActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxConditionSelect).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonSearchSelect)).addComponent(this.jCheckBoxExcludeWithin, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxExcludeAfter).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTextFieldExcludeAfterNumber, -1, 57, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxExcludeBefore).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldExcludeBeforeNumber, -1, 53, Short.MAX_VALUE)).addComponent(this.jCheckBoxCheckSymmetry, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldDistanceMax).addComponent(this.jTextFieldDistanceMin, -1, 49, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxConditionExclude).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSearchExclude)))).addGroup(jPanel2Layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.jLabelNumberAtomSelected)).addGroup(jPanel2Layout.createSequentialGroup().addGap(39, 39, 39).addComponent(this.jLabelNumberAtomExcluded))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldDistanceMax, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldDistanceMin, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCheckSymmetry).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxExcludeWithin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxExcludeAfter).addComponent(this.jTextFieldExcludeAfterNumber, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxExcludeBefore).addComponent(this.jTextFieldExcludeBeforeNumber, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxConditionSelect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNumberAtomSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxConditionExclude).addComponent(this.jButtonSearchExclude)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelNumberAtomExcluded)).addComponent(this.jButtonSearchSelect)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindClosestAtomDistancesDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonCalculate.setText("Calculate");
        this.jButtonCalculate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindClosestAtomDistancesDialog.this.jButtonCalculateActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonCalculate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose).addGap(14, 14, 14)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCalculate).addComponent(this.jButtonClose)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSearchSelectActionPerformed(ActionEvent evt) {
        this.selectedDialog.show(true);
        this.jLabelNumberAtomSelected.setText("Number of Atoms Selected To Be Used : " + this.selectedDialog.getFoundCoordinateIndicies().length);
    }

    private void formWindowClosing(WindowEvent evt) {
    }

    private void formWindowClosed(WindowEvent evt) {
        this.selectedDialog.dispose();
        this.excludedDialog.dispose();
        this.jDialogResult.dispose();
    }

    private void jButtonSearchExcludeActionPerformed(ActionEvent evt) {
        this.excludedDialog.show(true);
        this.jLabelNumberAtomExcluded.setText("Number of Atoms To Be Excluded : " + this.excludedDialog.getFoundCoordinateIndicies().length);
    }

    private void jButtonCalculateActionPerformed(ActionEvent evt) {
        this.Run();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.jDialogResult.hide();
    }

    private void jMenuItemSaveAsActionPerformed(ActionEvent evt) {
        if (this.jFileChooser.showSaveDialog(this) == 0) {
            File file = this.jFileChooser.getSelectedFile();
            Global.SaveTextFile(file.getPath(), Global.FormatTabbedTextFromTable(this.jTableResult, true));
        }
    }

    class ResultTableData
    extends AbstractTableModel {
        ResultTableData() {
        }

        public int getRowCount() {
            return FindClosestAtomDistancesDialog.this.searchResultAll.length;
        }

        public Class getColumnClass(int cI) {
            if (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] == 71) {
                return Global.doubleclass.getClass();
            }
            if (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] == 70) {
                return Global.integerclass.getClass();
            }
            if (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] < 35) {
                return Atom.DataClass[FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI]];
            }
            return Atom.DataClass[FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] - 35];
        }

        public int getColumnCount() {
            return FindClosestAtomDistancesDialog.this.ColumnDisplayed.length;
        }

        public String getColumnName(int cI) {
            if (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] == 71) {
                return "Distance";
            }
            if (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] == 70) {
                return "Symm";
            }
            if (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] < 35) {
                return "Origin " + Atom.DataList[FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI]];
            }
            return "Found " + Atom.DataList[FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] - 35];
        }

        public Object getValueAt(int rI, int cI) {
            if (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] == 71) {
                return ((FindClosestAtomDistancesDialog)FindClosestAtomDistancesDialog.this).searchResultAll[rI].Distance;
            }
            if (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] == 70) {
                return ((FindClosestAtomDistancesDialog)FindClosestAtomDistancesDialog.this).searchResultAll[rI].Symmop;
            }
            if (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] < 35) {
                if (((FindClosestAtomDistancesDialog)FindClosestAtomDistancesDialog.this).searchResultAll[rI].Origin.getClass().equals(Global.stringclass.getClass())) {
                    String s = (String)((FindClosestAtomDistancesDialog)FindClosestAtomDistancesDialog.this).searchResultAll[rI].Origin;
                    switch (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI]) {
                        case 1: {
                            return s;
                        }
                        case 10: {
                            return ((Coordinate)FindClosestAtomDistancesDialog.this.searchOrigin.get(s)).x();
                        }
                        case 11: {
                            return ((Coordinate)FindClosestAtomDistancesDialog.this.searchOrigin.get(s)).y();
                        }
                        case 12: {
                            return ((Coordinate)FindClosestAtomDistancesDialog.this.searchOrigin.get(s)).z();
                        }
                    }
                    return null;
                }
                return ((Atom)((FindClosestAtomDistancesDialog)FindClosestAtomDistancesDialog.this).searchResultAll[rI].Origin).TableData(FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI]);
            }
            if (FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] >= 35) {
                int i = FindClosestAtomDistancesDialog.this.ColumnDisplayed[cI] - 35;
                return ((FindClosestAtomDistancesDialog)FindClosestAtomDistancesDialog.this).searchResultAll[rI].Target.TableData(i);
            }
            return null;
        }
    }
}

