/*
 * Decompiled with CFR 0.152.
 */
package pdb_editor.dialogs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.FormulaEvaluator;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.Coordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateSymmetryMateDialog
extends JDialog {
    private EditorFrame Parent = null;
    private DataModel tabledata = null;
    private CoordinateTable maintable = null;
    private DataSet maindata = null;
    private String[][] symmops = null;
    private boolean[] selectedops = null;
    private String[] selectedChains = null;
    private char[][] newchainid = null;
    private TreeSet<Character> allChainID = null;
    private ButtonGroup buttonGroupAtomSelection;
    private JButton jButtonClose;
    private JButton jButtonGenerate;
    private JButton jButtonResetAll;
    private JButton jButtonSelectAll;
    private JButton jButtonSelectNone;
    private JCheckBox jCheckBoxForceBoundary;
    private JCheckBox jCheckBoxMoveExisting;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonAllAtoms;
    private JRadioButton jRadioButtonSelectedAtoms;
    private JRadioButton jRadioButtonSelectedChains;
    private JScrollPane jScrollPane1;
    private JTable jTable;

    public GenerateSymmetryMateDialog(Frame parent, boolean modal, CoordinateTable ctable) {
        super(parent, modal);
        try {
            this.Parent = (EditorFrame)parent;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.maintable = ctable;
        this.maindata = this.maintable.getMainData();
        this.symmops = (String[][])this.maindata.Spacegroup().symmetryOperators().clone();
        this.selectedops = new boolean[this.symmops.length];
        this.selectedops[0] = false;
        for (int i = 1; i < this.selectedops.length; ++i) {
            this.selectedops[i] = true;
        }
        this.getAllChains();
        this.makeNewChainID();
        this.tabledata = new DataModel();
        this.initComponents();
        this.setColumnWidth();
        this.initButtonGroup();
    }

    private void setColumnWidth() {
        TableColumn column = null;
        block6: for (int i = 0; i < this.tabledata.getColumnCount(); ++i) {
            column = this.jTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(25);
                    continue block6;
                }
                case 1: {
                    column.setPreferredWidth(60);
                    continue block6;
                }
                case 2: {
                    column.setPreferredWidth(60);
                    continue block6;
                }
                case 3: {
                    column.setPreferredWidth(60);
                    continue block6;
                }
                default: {
                    column.setPreferredWidth(25);
                }
            }
        }
    }

    private void initButtonGroup() {
        this.buttonGroupAtomSelection.add(this.jRadioButtonAllAtoms);
        this.buttonGroupAtomSelection.add(this.jRadioButtonSelectedAtoms);
        this.buttonGroupAtomSelection.add(this.jRadioButtonSelectedChains);
        this.jRadioButtonAllAtoms.setSelected(true);
    }

    private void makeNewChainID() {
        char[] temp = new char[this.selectedChains.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.selectedChains[i].charAt(0);
        }
        TreeSet usedChainID = (TreeSet)this.allChainID.clone();
        this.newchainid = new char[this.symmops.length][this.selectedChains.length];
        for (int i = 0; i < this.newchainid.length; ++i) {
            for (int j = 0; j < this.newchainid[i].length; ++j) {
                while (usedChainID.contains(Character.valueOf(temp[j]))) {
                    int n = j;
                    temp[n] = (char)(temp[n] + '\u0001');
                }
                this.newchainid[i][j] = temp[j];
                usedChainID.add(Character.valueOf(temp[j]));
            }
        }
    }

    private void getAllChains() {
        TreeSet<String> list = new TreeSet<String>();
        this.allChainID = new TreeSet();
        for (Atom a : this.maindata.Atoms()) {
            this.allChainID.add(Character.valueOf(a.ChainID()));
            list.add("" + a.ChainID());
        }
        this.selectedChains = list.toArray(new String[list.size()]);
    }

    private void Run() {
        if (this.Parent != null) {
            this.Parent.listenForUndoStart("Generate symmetry");
        }
        int[] indicies = this.getAtomIndicies();
        for (int i = 0; i < this.selectedops.length; ++i) {
            if (!this.selectedops[i]) continue;
            Atom[] list = this.getSelectedAtoms(indicies, i);
            this.doSymmetryOperation(i, list);
        }
        if (this.Parent != null) {
            this.Parent.listenForUndoStop();
        }
        this.maintable.fireTableDataChanged();
    }

    private void doSymmetryOperation(int OpNum, Atom[] list) {
        FormulaEvaluator[] f = this.getSymmOpFormula(OpNum);
        for (int i = 0; i < list.length; ++i) {
            Atom a = list[i];
            HashMap<String, Double> vars = this.getFormulaVariables(a);
            Coordinate c = new Coordinate(f[0].evaluateExpression(vars), f[1].evaluateExpression(vars), f[2].evaluateExpression(vars));
            if (this.jCheckBoxForceBoundary.isSelected()) {
                this.forceFractional(c);
            }
            a.FractionalCoordinate(c);
        }
    }

    private void forceFractional(Coordinate c) {
        c.x(Global.ForceFractionalNumber(c.x(), 0, 1));
        c.y(Global.ForceFractionalNumber(c.y(), 0, 1));
        c.z(Global.ForceFractionalNumber(c.z(), 0, 1));
    }

    private HashMap<String, Double> getFormulaVariables(Atom a) {
        HashMap<String, Double> r = new HashMap<String, Double>();
        r.put("X", a.x());
        r.put("Y", a.y());
        r.put("Z", a.z());
        return r;
    }

    private FormulaEvaluator[] getSymmOpFormula(int OpNum) {
        FormulaEvaluator[] f = new FormulaEvaluator[3];
        for (int i = 0; i < f.length; ++i) {
            f[i] = new FormulaEvaluator(this.symmops[OpNum][i]);
        }
        return f;
    }

    private Atom[] getSelectedAtoms(int[] indicies, int SymmOpNum) {
        if (this.jCheckBoxMoveExisting.isSelected()) {
            return this.maindata.getAtoms(indicies);
        }
        TreeMap<Character, Character> changeID = this.getChainIDChange(SymmOpNum);
        Atom[] list = this.maindata.CopyAtoms(true, indicies);
        for (int i = 0; i < list.length; ++i) {
            if (!changeID.containsKey(Character.valueOf(list[i].ChainID()))) continue;
            list[i].ChainID(changeID.get(Character.valueOf(list[i].ChainID())).charValue());
        }
        return list;
    }

    private TreeMap<Character, Character> getChainIDChange(int SymmOpNum) {
        TreeMap<Character, Character> r = new TreeMap<Character, Character>();
        int j = 0;
        for (char c : this.allChainID) {
            r.put(Character.valueOf(c), Character.valueOf(this.newchainid[SymmOpNum][j++]));
        }
        return r;
    }

    private int[] getAtomIndicies() {
        if (this.jRadioButtonAllAtoms.isSelected()) {
            return Global.GenerateIntegerIndiciesArray(this.maindata.Atoms().size());
        }
        if (this.jRadioButtonSelectedAtoms.isSelected()) {
            return this.maintable.getSelectedRows();
        }
        if (this.jRadioButtonSelectedChains.isSelected()) {
            return this.maindata.getChainIndicies(this.maintable.getSelectedRows());
        }
        return null;
    }

    private void initComponents() {
        this.buttonGroupAtomSelection = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable = new JTable();
        this.jButtonSelectAll = new JButton();
        this.jButtonSelectNone = new JButton();
        this.jButtonResetAll = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jRadioButtonAllAtoms = new JRadioButton();
        this.jRadioButtonSelectedChains = new JRadioButton();
        this.jRadioButtonSelectedAtoms = new JRadioButton();
        this.jCheckBoxMoveExisting = new JCheckBox();
        this.jCheckBoxForceBoundary = new JCheckBox();
        this.jButtonClose = new JButton();
        this.jButtonGenerate = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Generate Symmetry Mate");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Symmetry Operations"));
        this.jTable.setModel(this.tabledata);
        this.jTable.setAutoResizeMode(0);
        this.jTable.setCellSelectionEnabled(true);
        this.jScrollPane1.setViewportView(this.jTable);
        this.jButtonSelectAll.setText("Select All");
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateSymmetryMateDialog.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        this.jButtonSelectNone.setText("Deselect All");
        this.jButtonSelectNone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateSymmetryMateDialog.this.jButtonSelectNoneActionPerformed(evt);
            }
        });
        this.jButtonResetAll.setText("Default ChainID");
        this.jButtonResetAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateSymmetryMateDialog.this.jButtonResetAllActionPerformed(evt);
            }
        });
        this.jLabel1.setText("x = x op;  y = y op;  z = z op;  All other columns = New chain ID");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jButtonSelectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectNone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 56, Short.MAX_VALUE).addComponent(this.jButtonResetAll)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(24, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 343, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 239, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonResetAll).addComponent(this.jButtonSelectAll).addComponent(this.jButtonSelectNone))));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Atom Selection"));
        this.jRadioButtonAllAtoms.setText("All Atoms");
        this.jRadioButtonSelectedChains.setText("Selected Chains");
        this.jRadioButtonSelectedAtoms.setText("Selected Atoms");
        this.jCheckBoxMoveExisting.setText("Do not generate new atoms / Move existing atoms");
        this.jCheckBoxMoveExisting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateSymmetryMateDialog.this.jCheckBoxMoveExistingActionPerformed(evt);
            }
        });
        this.jCheckBoxForceBoundary.setText("Force fractional coordinate boundary from 0 to 1");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jRadioButtonAllAtoms).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSelectedChains).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonSelectedAtoms)).addComponent(this.jCheckBoxMoveExisting).addComponent(this.jCheckBoxForceBoundary)).addContainerGap(68, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonAllAtoms).addComponent(this.jRadioButtonSelectedChains).addComponent(this.jRadioButtonSelectedAtoms)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxMoveExisting).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxForceBoundary).addGap(0, 0, Short.MAX_VALUE)));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateSymmetryMateDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonGenerate.setText("Generate");
        this.jButtonGenerate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenerateSymmetryMateDialog.this.jButtonGenerateActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonGenerate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonGenerate)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.selectedops.length; ++i) {
            this.selectedops[i] = true;
        }
        this.tabledata.fireTableDataChanged();
    }

    private void jButtonSelectNoneActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.selectedops.length; ++i) {
            this.selectedops[i] = false;
        }
        this.tabledata.fireTableDataChanged();
    }

    private void jButtonResetAllActionPerformed(ActionEvent evt) {
        this.makeNewChainID();
        this.tabledata.fireTableDataChanged();
    }

    private void jCheckBoxMoveExistingActionPerformed(ActionEvent evt) {
        this.jButtonSelectNoneActionPerformed(null);
        if (this.selectedops.length > 1) {
            this.selectedops[1] = true;
        }
        this.tabledata.fireTableDataChanged();
    }

    private void jButtonGenerateActionPerformed(ActionEvent evt) {
        this.Run();
    }

    class DataModel
    extends AbstractTableModel {
        DataModel() {
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "x";
                }
                case 2: {
                    return "y";
                }
                case 3: {
                    return "z";
                }
            }
            return GenerateSymmetryMateDialog.this.selectedChains[col - 4];
        }

        public int getRowCount() {
            return GenerateSymmetryMateDialog.this.symmops.length;
        }

        public int getColumnCount() {
            return GenerateSymmetryMateDialog.this.selectedChains.length + 4;
        }

        public Object getValueAt(int ri, int ci) {
            switch (ci) {
                case 0: {
                    return GenerateSymmetryMateDialog.this.selectedops[ri];
                }
                case 1: {
                    return GenerateSymmetryMateDialog.this.symmops[ri][0];
                }
                case 2: {
                    return GenerateSymmetryMateDialog.this.symmops[ri][1];
                }
                case 3: {
                    return GenerateSymmetryMateDialog.this.symmops[ri][2];
                }
            }
            return "" + GenerateSymmetryMateDialog.this.newchainid[ri][ci - 4];
        }

        public void setValueAt(Object v, int r, int c) {
            switch (c) {
                case 0: {
                    this.setOperators((Boolean)v, r);
                    break;
                }
                case 1: {
                    ((GenerateSymmetryMateDialog)GenerateSymmetryMateDialog.this).symmops[r][0] = (String)v;
                    break;
                }
                case 2: {
                    ((GenerateSymmetryMateDialog)GenerateSymmetryMateDialog.this).symmops[r][1] = (String)v;
                    break;
                }
                case 3: {
                    ((GenerateSymmetryMateDialog)GenerateSymmetryMateDialog.this).symmops[r][2] = (String)v;
                }
            }
            if (c > 3) {
                String s = (String)v;
                int id = 32;
                if (s.length() > 0) {
                    id = s.charAt(s.length() - 1);
                }
                int[] rows = GenerateSymmetryMateDialog.this.jTable.getSelectedRows();
                int[] cols = GenerateSymmetryMateDialog.this.jTable.getSelectedColumns();
                for (int i = 0; i < rows.length; ++i) {
                    for (int j = 0; j < cols.length; ++j) {
                        if (cols[j] <= 3) continue;
                        ((GenerateSymmetryMateDialog)GenerateSymmetryMateDialog.this).newchainid[rows[i]][cols[j] - 4] = id;
                    }
                }
            }
        }

        public void setOperators(boolean v, int r) {
            if (GenerateSymmetryMateDialog.this.jCheckBoxMoveExisting.isSelected()) {
                ((GenerateSymmetryMateDialog)GenerateSymmetryMateDialog.this).selectedops[r] = true;
                for (int i = 0; i < GenerateSymmetryMateDialog.this.selectedops.length; ++i) {
                    if (i == r) continue;
                    ((GenerateSymmetryMateDialog)GenerateSymmetryMateDialog.this).selectedops[i] = false;
                    this.fireTableRowsUpdated(i, i);
                }
            } else {
                ((GenerateSymmetryMateDialog)GenerateSymmetryMateDialog.this).selectedops[r] = v;
            }
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Global.booleanclass.getClass();
            }
            return Global.stringclass.getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }
}

