/*
 * Decompiled with CFR 0.152.
 */
package pdb_reader;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import pdb_reader.DataSet;
import pdb_reader.data.Coordinate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Global {
    public static Boolean booleanclass = false;
    public static Integer integerclass = 0;
    public static Double doubleclass = 0.1;
    public static String stringclass = "";
    public static Character charclass = Character.valueOf(' ');
    public static double DegreeToRadian = 0.0174532925;
    public static String[] calculateAvgSDMaxMin_Headers = new String[]{"Count", "Average", "Std Dev", "Max Atom", "Max Value", "Min Atom", "Min Value"};
    public static int calculateAvgSDMaxMin_CountIndex = 0;
    public static int calculateAvgSDMaxMin_AvgIndex = 1;
    public static int calculateAvgSDMaxMin_SDIndex = 2;
    public static int calculateAvgSDMaxMin_MaxRowIndex = 3;
    public static int calculateAvgSDMaxMin_MaxValueIndex = 4;
    public static int calculateAvgSDMaxMin_MinRowIndex = 5;
    public static int calculateAvgSDMaxMin_MinValueIndex = 6;
    public static int[] calculateAvgSDMaxMin_IntegerColumns = new int[]{calculateAvgSDMaxMin_CountIndex, calculateAvgSDMaxMin_MaxRowIndex, calculateAvgSDMaxMin_MinRowIndex};

    public static int compareObjects(Object a1, Object a2) {
        int dataType = -1;
        if (dataType == -1 && a1.getClass().equals(booleanclass.getClass())) {
            dataType = 0;
        }
        if (dataType == -1 && a1.getClass().equals(charclass.getClass())) {
            dataType = 1;
        }
        if (dataType == -1 && a1.getClass().equals(integerclass.getClass())) {
            dataType = 2;
        }
        if (dataType == -1 && a1.getClass().equals(doubleclass.getClass())) {
            dataType = 3;
        }
        if (dataType == -1 && a1.getClass().equals(stringclass.getClass())) {
            dataType = 4;
        }
        switch (dataType) {
            case 0: {
                int i1 = (Boolean)a1 != false ? 1 : 0;
                int i2 = (Boolean)a2 != false ? 1 : 0;
                return i1 - i2;
            }
            case 1: {
                return ((Character)a1).charValue() - ((Character)a2).charValue();
            }
            case 2: {
                return (Integer)a1 - (Integer)a2;
            }
            case 3: {
                double d = (Double)a1 - (Double)a2;
                if (d > 0.0) {
                    return 1;
                }
                if (d < 0.0) {
                    return -1;
                }
                return 0;
            }
            case 4: {
                return ((String)a1).compareTo((String)a2);
            }
        }
        return 0;
    }

    public static String AddFileExtension(String filename, String extension) {
        extension = '.' + extension;
        boolean append = false;
        if (filename.length() > extension.length()) {
            if (!filename.substring(filename.length() - extension.length()).equals(extension)) {
                append = true;
            }
        } else {
            append = true;
        }
        if (append) {
            filename = filename + extension;
        }
        return filename;
    }

    public static String GetSubstring(String s, int startindex, int endindex) {
        if (s.length() > startindex) {
            if (s.length() <= endindex) {
                return s.substring(startindex);
            }
            return s.substring(startindex, endindex);
        }
        return null;
    }

    public static double CorrectRange(double Value, double Maximum, double Minimum) {
        if (Value > Maximum) {
            return Maximum;
        }
        if (Value < Minimum) {
            return Minimum;
        }
        return Value;
    }

    public static int CorrectRange(int Value, int Maximum, int Minimum) {
        if (Value > Maximum) {
            return Maximum;
        }
        if (Value < Minimum) {
            return Minimum;
        }
        return Value;
    }

    public static void SaveTextFile(String Filename, String TextLines) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(Filename));
            bw.write(TextLines);
            bw.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error saving " + Filename + '\n' + e.getMessage(), "Error saving file", 0);
        }
    }

    public static String[] ReadTextFile(String Filename) {
        ArrayList<String> al = new ArrayList<String>();
        try {
            String s;
            BufferedReader br = new BufferedReader(new FileReader(Filename));
            while ((s = br.readLine()) != null) {
                al.add(s);
            }
            br.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] result = new String[al.size()];
        al.toArray(result);
        return result;
    }

    public static String[] ReadTextResource(String ResourceName) {
        ArrayList<String> al = new ArrayList<String>();
        URL u = DataSet.class.getResource(ResourceName);
        try {
            String s;
            InputStream is = (InputStream)u.getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((s = br.readLine()) != null) {
                al.add(s);
            }
            br.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        String[] result = new String[al.size()];
        al.toArray(result);
        return result;
    }

    public static Object ConvertString(String In, Class c) {
        if (c.equals(booleanclass.getClass())) {
            return Boolean.parseBoolean(In);
        }
        if (c.equals(integerclass.getClass())) {
            return Integer.parseInt(In);
        }
        if (c.equals(doubleclass.getClass())) {
            return Double.parseDouble(In);
        }
        if (c.equals(charclass.getClass())) {
            return Character.valueOf(In.charAt(0));
        }
        if (c.equals(In.getClass())) {
            return In;
        }
        return null;
    }

    public static int[] ConvertIntegerArrayToIntArray(Integer[] arrayin) {
        int[] r = new int[arrayin.length];
        for (int i = 0; i < arrayin.length; ++i) {
            r[i] = arrayin[i];
        }
        return r;
    }

    public static boolean StringArrayContains(String[] arrayin, String target) {
        target = target.trim();
        for (int i = 0; i < arrayin.length; ++i) {
            if (!target.equals(arrayin[i])) continue;
            return true;
        }
        return false;
    }

    public static int StringArrayFindIndex(String[] arrayin, String target) {
        for (int i = 0; i < arrayin.length; ++i) {
            if (!target.equals(arrayin[i])) continue;
            return i;
        }
        return -1;
    }

    public static int StringArrayFindIndexForSubstring(String[] arrayin, String target) {
        for (int i = 0; i < arrayin.length; ++i) {
            if (arrayin[i].length() < target.length() || !arrayin[i].substring(0, target.length()).equals(target)) continue;
            return i;
        }
        return -1;
    }

    public static int StringArrayFindIndexForSubstring(String[] arrayin, String target, int startindex) {
        for (int i = startindex; i < arrayin.length; ++i) {
            if (arrayin[i].length() < target.length() || !arrayin[i].substring(0, target.length()).equals(target)) continue;
            return i;
        }
        return -1;
    }

    public static boolean IntegerArrayContains(int[] arrayin, int target) {
        for (int i = 0; i < arrayin.length; ++i) {
            if (arrayin[i] != target) continue;
            return true;
        }
        return false;
    }

    public static int IntegerArrayFindIndex(int[] array, int target) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static String[][] TabulateStringByLineTab(String source) {
        return Global.TabulateStringByDelimiters(source, "\\n", "\\t");
    }

    public static String[][] TabulateStringByDelimiters(String source, String regex1, String regex2) {
        String[][] result = null;
        String[] split = source.split(regex1);
        result = new String[split.length][];
        for (int i = 0; i < result.length; ++i) {
            String[] sub = split[i].split(regex2);
            result[i] = sub;
        }
        return result;
    }

    public static String GetFileExtension(File f) {
        String fn = f.getAbsolutePath();
        int index = -1;
        boolean stop = false;
        for (int i = fn.length() - 2; i >= 0; --i) {
            switch (fn.charAt(i)) {
                case '.': {
                    index = i;
                    stop = true;
                    break;
                }
                case '\\': {
                    stop = true;
                    break;
                }
                case '/': {
                    stop = true;
                }
            }
            if (stop) break;
        }
        if (index != -1) {
            return fn.substring(index + 1).toUpperCase();
        }
        return null;
    }

    public static String TrimFileName(String fileName, int parentlevel) {
        int i;
        String[] parts = null;
        boolean backslash = false;
        if (fileName.charAt(0) == '/') {
            backslash = false;
            parts = fileName.split("/");
        } else {
            parts = fileName.split("\\\\");
            backslash = true;
        }
        StringBuilder sb = new StringBuilder();
        if (parts.length <= parentlevel + 1) {
            return fileName;
        }
        if (backslash) {
            sb.append(parts[0] + '\\');
        }
        if ((i = parts.length - parentlevel - 1) < 0) {
            i = 0;
        }
        if (i > 0 && !backslash) {
            sb.append("/.../");
        }
        if (i < 1 && backslash) {
            i = 1;
        }
        if (i > 1 && backslash) {
            sb.append("...\\");
        }
        while (i < parts.length) {
            sb.append(parts[i]);
            if (i != parts.length - 1) {
                if (backslash) {
                    sb.append('\\');
                } else {
                    sb.append('/');
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static boolean IsIdentityMatrix(double[][] m) {
        for (int i = 0; i < m.length; ++i) {
            if (m[i].length != m.length) {
                return false;
            }
            for (int j = 0; j < m[i].length; ++j) {
                if (i == j && m[i][j] != 1.0) {
                    return false;
                }
                if (i == j || m[i][j] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public static double Determinant4x4Matrix(double[][] m) {
        double value = m[0][3] * m[1][2] * m[2][1] * m[3][0] - m[0][2] * m[1][3] * m[2][1] * m[3][0] - m[0][3] * m[1][1] * m[2][2] * m[3][0] + m[0][1] * m[1][3] * m[2][2] * m[3][0] + m[0][2] * m[1][1] * m[2][3] * m[3][0] - m[0][1] * m[1][2] * m[2][3] * m[3][0] - m[0][3] * m[1][2] * m[2][0] * m[3][1] + m[0][2] * m[1][3] * m[2][0] * m[3][1] + m[0][3] * m[1][0] * m[2][2] * m[3][1] - m[0][0] * m[1][3] * m[2][2] * m[3][1] - m[0][2] * m[1][0] * m[2][3] * m[3][1] + m[0][0] * m[1][2] * m[2][3] * m[3][1] + m[0][3] * m[1][1] * m[2][0] * m[3][2] - m[0][1] * m[1][3] * m[2][0] * m[3][2] - m[0][3] * m[1][0] * m[2][1] * m[3][2] + m[0][0] * m[1][3] * m[2][1] * m[3][2] + m[0][1] * m[1][0] * m[2][3] * m[3][2] - m[0][0] * m[1][1] * m[2][3] * m[3][2] - m[0][2] * m[1][1] * m[2][0] * m[3][3] + m[0][1] * m[1][2] * m[2][0] * m[3][3] + m[0][2] * m[1][0] * m[2][1] * m[3][3] - m[0][0] * m[1][2] * m[2][1] * m[3][3] - m[0][1] * m[1][0] * m[2][2] * m[3][3] + m[0][0] * m[1][1] * m[2][2] * m[3][3];
        return value;
    }

    public static double[][] Inverse4x4Matrix(double[][] m) {
        double[][] n = new double[4][4];
        n[0][0] = m[1][2] * m[2][3] * m[3][1] - m[1][3] * m[2][2] * m[3][1] + m[1][3] * m[2][1] * m[3][2] - m[1][1] * m[2][3] * m[3][2] - m[1][2] * m[2][1] * m[3][3] + m[1][1] * m[2][2] * m[3][3];
        n[0][1] = m[0][3] * m[2][2] * m[3][1] - m[0][2] * m[2][3] * m[3][1] - m[0][3] * m[2][1] * m[3][2] + m[0][1] * m[2][3] * m[3][2] + m[0][2] * m[2][1] * m[3][3] - m[0][1] * m[2][2] * m[3][3];
        n[0][2] = m[0][2] * m[1][3] * m[3][1] - m[0][3] * m[1][2] * m[3][1] + m[0][3] * m[1][1] * m[3][2] - m[0][1] * m[1][3] * m[3][2] - m[0][2] * m[1][1] * m[3][3] + m[0][1] * m[1][2] * m[3][3];
        n[0][3] = m[0][3] * m[1][2] * m[2][1] - m[0][2] * m[1][3] * m[2][1] - m[0][3] * m[1][1] * m[2][2] + m[0][1] * m[1][3] * m[2][2] + m[0][2] * m[1][1] * m[2][3] - m[0][1] * m[1][2] * m[2][3];
        n[1][0] = m[1][3] * m[2][2] * m[3][0] - m[1][2] * m[2][3] * m[3][0] - m[1][3] * m[2][0] * m[3][2] + m[1][0] * m[2][3] * m[3][2] + m[1][2] * m[2][0] * m[3][3] - m[1][0] * m[2][2] * m[3][3];
        n[1][1] = m[0][2] * m[2][3] * m[3][0] - m[0][3] * m[2][2] * m[3][0] + m[0][3] * m[2][0] * m[3][2] - m[0][0] * m[2][3] * m[3][2] - m[0][2] * m[2][0] * m[3][3] + m[0][0] * m[2][2] * m[3][3];
        n[1][2] = m[0][3] * m[1][2] * m[3][0] - m[0][2] * m[1][3] * m[3][0] - m[0][3] * m[1][0] * m[3][2] + m[0][0] * m[1][3] * m[3][2] + m[0][2] * m[1][0] * m[3][3] - m[0][0] * m[1][2] * m[3][3];
        n[1][3] = m[0][2] * m[1][3] * m[2][0] - m[0][3] * m[1][2] * m[2][0] + m[0][3] * m[1][0] * m[2][2] - m[0][0] * m[1][3] * m[2][2] - m[0][2] * m[1][0] * m[2][3] + m[0][0] * m[1][2] * m[2][3];
        n[2][0] = m[1][1] * m[2][3] * m[3][0] - m[1][3] * m[2][1] * m[3][0] + m[1][3] * m[2][0] * m[3][1] - m[1][0] * m[2][3] * m[3][1] - m[1][1] * m[2][0] * m[3][3] + m[1][0] * m[2][1] * m[3][3];
        n[2][1] = m[0][3] * m[2][1] * m[3][0] - m[0][1] * m[2][3] * m[3][0] - m[0][3] * m[2][0] * m[3][1] + m[0][0] * m[2][3] * m[3][1] + m[0][1] * m[2][0] * m[3][3] - m[0][0] * m[2][1] * m[3][3];
        n[2][2] = m[0][1] * m[1][3] * m[3][0] - m[0][3] * m[1][1] * m[3][0] + m[0][3] * m[1][0] * m[3][1] - m[0][0] * m[1][3] * m[3][1] - m[0][1] * m[1][0] * m[3][3] + m[0][0] * m[1][1] * m[3][3];
        n[2][3] = m[0][3] * m[1][1] * m[2][0] - m[0][1] * m[1][3] * m[2][0] - m[0][3] * m[1][0] * m[2][1] + m[0][0] * m[1][3] * m[2][1] + m[0][1] * m[1][0] * m[2][3] - m[0][0] * m[1][1] * m[2][3];
        n[3][0] = m[1][2] * m[2][1] * m[3][0] - m[1][1] * m[2][2] * m[3][0] - m[1][2] * m[2][0] * m[3][1] + m[1][0] * m[2][2] * m[3][1] + m[1][1] * m[2][0] * m[3][2] - m[1][0] * m[2][1] * m[3][2];
        n[3][1] = m[0][1] * m[2][2] * m[3][0] - m[0][2] * m[2][1] * m[3][0] + m[0][2] * m[2][0] * m[3][1] - m[0][0] * m[2][2] * m[3][1] - m[0][1] * m[2][0] * m[3][2] + m[0][0] * m[2][1] * m[3][2];
        n[3][2] = m[0][2] * m[1][1] * m[3][0] - m[0][1] * m[1][2] * m[3][0] - m[0][2] * m[1][0] * m[3][1] + m[0][0] * m[1][2] * m[3][1] + m[0][1] * m[1][0] * m[3][2] - m[0][0] * m[1][1] * m[3][2];
        n[3][3] = m[0][1] * m[1][2] * m[2][0] - m[0][2] * m[1][1] * m[2][0] + m[0][2] * m[1][0] * m[2][1] - m[0][0] * m[1][2] * m[2][1] - m[0][1] * m[1][0] * m[2][2] + m[0][0] * m[1][1] * m[2][2];
        double scale = 1.0 / Global.Determinant4x4Matrix(m);
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < 4) {
                double[] dArray = n[i];
                int n2 = j++;
                dArray[n2] = dArray[n2] * scale;
            }
        }
        return n;
    }

    public static double[][] GenerateTransformationMatrix(double[] d12Elements) {
        double[][] r = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int index = i * 4 + j;
                r[i][j] = index < 12 ? d12Elements[index] : (index < 15 ? 0.0 : 1.0);
            }
        }
        return r;
    }

    public static double[][] GenerateTransformationFromRotationMatrix(double[] d9Elements) {
        double[][] r = new double[4][4];
        int k = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                r[i][j] = j < 3 & i < 3 ? d9Elements[k++] : (i * 4 + j < 15 ? 0.0 : 1.0);
            }
        }
        return r;
    }

    public static double[][] GenerateSymmetricMatrix(double[] elements) {
        int size = (int)Math.sqrt(elements.length);
        double[][] r = new double[size][size];
        int k = 0;
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                r[i][j] = elements[k++];
            }
        }
        return r;
    }

    public static double[][] GenerateTranformationMatrixFromEulerAngles(double[] angles) {
        double alpha = angles[0];
        double beta = angles[1];
        double gamma = angles[2];
        double degtorad = 0.0174532925;
        double c1 = Math.cos(alpha * degtorad);
        double c2 = Math.cos(beta * degtorad);
        double c3 = Math.cos(gamma * degtorad);
        double s1 = Math.sin(alpha * degtorad);
        double s2 = Math.sin(beta * degtorad);
        double s3 = Math.sin(gamma * degtorad);
        return Global.GenerateTransformationFromRotationMatrix(new double[]{c1 * c2 * c3 - s1 * s3, -c3 * s1 - c1 * c2 * s3, c1 * s2, c2 * c3 * s1 + c1 * s3, c1 * c3 - c2 * s1 * s3, s1 * s2, -c3 * s2, s2 * s3, c2});
    }

    public static double[][] GenerateTranformationMatrixFromPolarAngles(double[] angles) {
        double omega = angles[0];
        double phi = angles[1];
        double kappa = angles[2];
        double degtorad = 0.0174532925;
        double c1 = Math.cos(omega * degtorad);
        double c2 = Math.cos(phi * degtorad);
        double c3 = Math.cos(kappa * degtorad);
        double s1 = Math.sin(omega * degtorad);
        double s2 = Math.sin(phi * degtorad);
        double s3 = Math.sin(kappa * degtorad);
        double[] dircos = new double[4];
        dircos[1] = s1 * c2;
        dircos[2] = s1 * s2;
        dircos[3] = c1;
        double[][] rotn = new double[4][4];
        for (int i = 1; i < 4; ++i) {
            for (int j = 1; j < 4; ++j) {
                int k1;
                int k = k1 = 6 - i - j;
                if (k1 < 1 | k1 > 3) {
                    k = 3;
                }
                double epsijk = (double)((i - j) * (j - k) * (k - i)) / 2.0;
                rotn[i][j] = dircos[i] * dircos[j] * (1.0 - c3) - epsijk * dircos[k] * s3;
                if (i != j) continue;
                rotn[i][j] = rotn[i][j] + c3;
            }
        }
        return Global.GenerateTransformationFromRotationMatrix(new double[]{rotn[1][1], rotn[1][2], rotn[1][3], rotn[2][1], rotn[2][2], rotn[2][3], rotn[3][1], rotn[3][2], rotn[3][3]});
    }

    public static double[][] GenerateTranformationMatrixFromTranslation(double[] xyz) {
        double[][] r = Global.IdentityMatrix(4);
        r[0][3] = xyz[0];
        r[1][3] = xyz[1];
        r[2][3] = xyz[2];
        return r;
    }

    public static double[][] IdentityMatrix(int one_dimension) {
        int d = one_dimension;
        double[][] r = new double[d][d];
        for (int i = 0; i < d; ++i) {
            for (int j = 0; j < d; ++j) {
                r[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return r;
    }

    public static double[][] MultiplyMatrix(double[][] M1, double[][] M2) {
        double[][] r = new double[M1.length][M2[0].length];
        for (int i = 0; i < r.length; ++i) {
            for (int j = 0; j < r[0].length; ++j) {
                double s = 0.0;
                for (int k = 0; k < M2.length; ++k) {
                    s += M1[i][k] * M2[k][j];
                }
                r[i][j] = s;
            }
        }
        return r;
    }

    public static Coordinate TransformCoordinates(double[][] m, Coordinate c) {
        double[] om = new double[]{c.x(), c.y(), c.z(), 1.0};
        double[] r = new double[4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n = i;
                r[n] = r[n] + m[i][j] * om[j];
            }
        }
        return new Coordinate(r[0], r[1], r[2]);
    }

    public static String FormatTabbedTextFromSelected(JTable tablein) {
        StringBuilder sb = new StringBuilder();
        int[] cols = tablein.getSelectedColumns();
        int[] rows = tablein.getSelectedRows();
        for (int r = 0; r < rows.length; ++r) {
            for (int c = 0; c < cols.length; ++c) {
                sb.append(tablein.getModel().getValueAt(rows[r], cols[c]).toString());
                if (c == cols.length - 1) continue;
                sb.append('\t');
            }
            if (r == rows.length - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String FormatTabbedTextFromTable(JTable tablein, boolean ColumnLabel) {
        StringBuilder sb = new StringBuilder();
        int rows = tablein.getModel().getRowCount();
        int cols = tablein.getModel().getColumnCount();
        if (ColumnLabel) {
            for (int c = 0; c < cols; ++c) {
                sb.append(tablein.getModel().getColumnName(c));
                if (c == cols - 1) continue;
                sb.append('\t');
            }
            sb.append('\n');
        }
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                sb.append(tablein.getModel().getValueAt(r, c).toString());
                if (c == cols - 1) continue;
                sb.append('\t');
            }
            if (r == rows - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String[] SubtractArray(String[] Array1, String[] Array2) {
        ArrayList<String> r = new ArrayList<String>();
        for (int i = 0; i < Array1.length; ++i) {
            if (Global.StringArrayContains(Array2, Array1[i])) continue;
            r.add(Array1[i]);
        }
        return r.toArray(new String[r.size()]);
    }

    public static int CharArrayFindIndex(char[] Array, char Target) {
        for (int i = 0; i < Array.length; ++i) {
            if (Array[i] != Target) continue;
            return i;
        }
        return -1;
    }

    public static boolean CharArrayContains(char[] Array, char Target) {
        for (int i = 0; i < Array.length; ++i) {
            if (Array[i] != Target) continue;
            return true;
        }
        return false;
    }

    public static double[] calculateAvgSDMaxMin(Double[] list) {
        double[] r = new double[7];
        r[Global.calculateAvgSDMaxMin_CountIndex] = list.length;
        r[Global.calculateAvgSDMaxMin_AvgIndex] = 0.0;
        r[Global.calculateAvgSDMaxMin_MaxRowIndex] = 0.0;
        r[Global.calculateAvgSDMaxMin_MaxValueIndex] = list[0];
        r[Global.calculateAvgSDMaxMin_MinRowIndex] = 0.0;
        r[Global.calculateAvgSDMaxMin_MinValueIndex] = list[0];
        for (int i = 0; i < list.length; ++i) {
            int n = calculateAvgSDMaxMin_AvgIndex;
            r[n] = r[n] + list[i];
            if (list[i] > r[calculateAvgSDMaxMin_MaxValueIndex]) {
                r[Global.calculateAvgSDMaxMin_MaxRowIndex] = i;
                r[Global.calculateAvgSDMaxMin_MaxValueIndex] = list[i];
            }
            if (!(list[i] < r[calculateAvgSDMaxMin_MinValueIndex])) continue;
            r[Global.calculateAvgSDMaxMin_MinRowIndex] = i;
            r[Global.calculateAvgSDMaxMin_MinValueIndex] = list[i];
        }
        int n = calculateAvgSDMaxMin_AvgIndex;
        r[n] = r[n] / (double)list.length;
        r[Global.calculateAvgSDMaxMin_SDIndex] = Global.calculateSD(list, r[calculateAvgSDMaxMin_AvgIndex]);
        return r;
    }

    public static double[] calculateAvgSDMaxMin(double[] list) {
        double[] r = new double[7];
        r[Global.calculateAvgSDMaxMin_CountIndex] = list.length;
        r[Global.calculateAvgSDMaxMin_AvgIndex] = 0.0;
        r[Global.calculateAvgSDMaxMin_MaxRowIndex] = 0.0;
        r[Global.calculateAvgSDMaxMin_MaxValueIndex] = list[0];
        r[Global.calculateAvgSDMaxMin_MinRowIndex] = 0.0;
        r[Global.calculateAvgSDMaxMin_MinValueIndex] = list[0];
        for (int i = 0; i < list.length; ++i) {
            int n = calculateAvgSDMaxMin_AvgIndex;
            r[n] = r[n] + list[i];
            if (list[i] > r[calculateAvgSDMaxMin_MaxValueIndex]) {
                r[Global.calculateAvgSDMaxMin_MaxRowIndex] = i;
                r[Global.calculateAvgSDMaxMin_MaxValueIndex] = list[i];
            }
            if (!(list[i] < r[calculateAvgSDMaxMin_MinValueIndex])) continue;
            r[Global.calculateAvgSDMaxMin_MinRowIndex] = i;
            r[Global.calculateAvgSDMaxMin_MinValueIndex] = list[i];
        }
        int n = calculateAvgSDMaxMin_AvgIndex;
        r[n] = r[n] / (double)list.length;
        r[Global.calculateAvgSDMaxMin_SDIndex] = Global.calculateSD(list, r[calculateAvgSDMaxMin_AvgIndex]);
        return r;
    }

    public static double calculateSD(Double[] list, double avg) {
        double r = 0.0;
        for (int i = 0; i < list.length; ++i) {
            r += Math.pow(list[i] - avg, 2.0);
        }
        return Math.sqrt(r / (double)(list.length - 1));
    }

    public static double calculateSD(double[] list, double avg) {
        double r = 0.0;
        for (int i = 0; i < list.length; ++i) {
            r += Math.pow(list[i] - avg, 2.0);
        }
        return Math.sqrt(r / (double)(list.length - 1));
    }

    public static TreeMap<Object, Integer> getCount(Object[] list) {
        TreeMap<Object, Integer> r = new TreeMap<Object, Integer>();
        for (int i = 0; i < list.length; ++i) {
            if (!r.containsKey(list[i])) {
                r.put(list[i], new Integer(0));
                continue;
            }
            int v = r.get(list[i]);
            r.put(list[i], v++);
        }
        return r;
    }

    public static double[] ExtractAllNumbers(String s) {
        ArrayList<Double> r = new ArrayList<Double>();
        String[] spl = s.split("[^0-9.-]");
        for (int i = 0; i < spl.length; ++i) {
            if (spl[i].trim().equals("")) continue;
            try {
                r.add(Double.parseDouble(spl[i]));
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        double[] ret = new double[r.size()];
        for (int i = 0; i < r.size(); ++i) {
            ret[i] = (Double)r.get(i);
        }
        return ret;
    }

    public static int[] GenerateIntegerIndiciesArray(int size) {
        if (size == 0) {
            return null;
        }
        int[] r = new int[size];
        for (int i = 0; i < size; ++i) {
            r[i] = i;
        }
        return r;
    }

    public static double CalculateUnitcellVolume(double[] unitcellparameters) {
        double a = unitcellparameters[0];
        double b = unitcellparameters[1];
        double c = unitcellparameters[2];
        double cos_a = Math.cos(unitcellparameters[3] * DegreeToRadian);
        double cos_b = Math.cos(unitcellparameters[4] * DegreeToRadian);
        double cos_g = Math.cos(unitcellparameters[5] * DegreeToRadian);
        double anglefactor = 1.0 - cos_a * cos_a - cos_b * cos_b - cos_g * cos_g + 2.0 * Math.sqrt(cos_a * cos_b * cos_g);
        return a * b * c * anglefactor;
    }

    public static double[][] GenerateOrthogonalizationMatrix(double[] unitcellparameters) {
        double a = unitcellparameters[0];
        double b = unitcellparameters[1];
        double c = unitcellparameters[2];
        double alpha = unitcellparameters[3];
        double beta = unitcellparameters[4];
        double gamma = unitcellparameters[5];
        double cos_a = Math.cos(alpha * DegreeToRadian);
        double cos_b = Math.cos(beta * DegreeToRadian);
        double cos_g = Math.cos(gamma * DegreeToRadian);
        double sin_a = Math.sin(alpha * DegreeToRadian);
        double sin_b = Math.sin(beta * DegreeToRadian);
        double sin_g = Math.sin(gamma * DegreeToRadian);
        double cos_as = (cos_g * cos_b - cos_a) / (sin_b * sin_g);
        double sin_as = Math.sqrt(1.0 - cos_as * cos_as);
        return Global.GenerateTransformationFromRotationMatrix(new double[]{a, b * cos_g, c * cos_b, 0.0, b * sin_g, -c * sin_b * cos_as, 0.0, 0.0, c * sin_b * sin_as});
    }

    public static double[][] GenerateScaleMatrix(double[] unitcellparameters) {
        double[][] r = Global.Inverse4x4Matrix(Global.GenerateOrthogonalizationMatrix(unitcellparameters));
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!(r[i][j] < 0.0) || !(r[i][j] > -1.0E-8)) continue;
                r[i][j] = 0.0;
            }
        }
        return r;
    }

    public static double ForceFractionalNumber(double value, int lowerbound, int upperbound) {
        if (upperbound <= lowerbound) {
            return value;
        }
        while (value > (double)upperbound) {
            value -= 1.0;
        }
        while (value < (double)lowerbound) {
            value += 1.0;
        }
        return value;
    }

    public static String ExtendStringLength(String s, int newlength, char fillcharacter) {
        StringBuilder sb = new StringBuilder(s);
        for (int i = s.length(); i < newlength; ++i) {
            sb.append(fillcharacter);
        }
        return sb.toString();
    }
}

