/*
 * Decompiled with CFR 0.152.
 */
package pdb_reader.data;

import javax.swing.event.EventListenerList;
import pdb_reader.Global;
import pdb_reader.data.AtomDataChangeEvent;
import pdb_reader.data.AtomDataChangeEventListener;
import pdb_reader.data.AtomPDB;
import pdb_reader.data.Coordinate;
import pdb_reader.data.spacegroup.SpaceGroup;

public class Atom
implements Comparable {
    public static Atom atomclass = new Atom();
    public static final int HETROATOM_INDEX = 0;
    public static final int ATOMNUMBER_INDEX = 1;
    public static final int ATOMNAME_INDEX = 2;
    public static final int ELEMENT_INDEX = 3;
    public static final int CHARGE_INDEX = 4;
    public static final int ALTERNATELOCATION_INDEX = 5;
    public static final int RESIDUETYPE_INDEX = 6;
    public static final int CHAINID_INDEX = 7;
    public static final int RESIDUENUMBER_INDEX = 8;
    public static final int INSERTIONCODE_INDEX = 9;
    public static final int X_INDEX = 10;
    public static final int Y_INDEX = 11;
    public static final int Z_INDEX = 12;
    public static final int[] ORTHOGONALCOORDINATE_INDICES = new int[]{10, 11, 12};
    public static final int B_INDEX = 13;
    public static final int OCCUPANCY_INDEX = 14;
    public static final int U11_INDEX = 15;
    public static final int U22_INDEX = 16;
    public static final int U33_INDEX = 17;
    public static final int U12_INDEX = 18;
    public static final int U13_INDEX = 19;
    public static final int U23_INDEX = 20;
    public static final int[] ANISOTROPICU_INDICES = new int[]{15, 16, 17, 18, 19, 20};
    public static final int SIGMAX_INDEX = 21;
    public static final int SIGMAY_INDEX = 22;
    public static final int SIGMAZ_INDEX = 23;
    public static final int SIGMAB_INDEX = 24;
    public static final int[] SIGMAORTHOGONALCOORDINATE_INDICES = new int[]{21, 22, 23};
    public static final int SIGMAOCCUPANCY_INDEX = 25;
    public static final int SIGMAU11_INDEX = 26;
    public static final int SIGMAU22_INDEX = 27;
    public static final int SIGMAU33_INDEX = 28;
    public static final int SIGMAU12_INDEX = 29;
    public static final int SIGMAU13_INDEX = 30;
    public static final int SIGMAU23_INDEX = 31;
    public static final int[] SIGMAANISOTROPICU_INDICES = new int[]{26, 27, 28, 29, 30, 31};
    public static final int FRACX_INDEX = 32;
    public static final int FRACY_INDEX = 33;
    public static final int FRACZ_INDEX = 34;
    public static final int[] FRACTIONALCOORDINATE_INDICES = new int[]{32, 33, 34};
    public static final int TOTAL_NUMBER_OF_INDEX = 35;
    public static String[] DataList = new String[]{"HetroAtom", "Number", "Name", "Element", "Charge", "AltLoc", "Residue", "ChainID", "ResNum", "InsCode", "X", "Y", "Z", "B", "Occp", "U11", "U22", "U33", "U12", "U13", "U23", "SigX", "SigY", "SigZ", "SigB", "SigOccp", "SigU11", "SigU22", "SigU33", "SigU12", "SigU13", "SigU23", "x", "y", "z"};
    public static String[] DataToolTip = new String[]{"HetroAtom", "Atom Number", "Atom Name", "Element", "Charge", "Alternate Location", "Residue Type", "Chain ID", "Residue Number", "Insertion Code", "X", "Y", "Z", "B", "Occupancy", "U(1,1)", "U(2,2)", "U(3,3)", "U(1,2)", "U(1,3)", "U(2,3)", "Sigma X", "Sigma Y", "Sigma Z", "Sigma B", "Sigma Occupancy", "Sigma U(1,1)", "Sigma U(2,2)", "Sigma U(3,3)", "Sigma U(1,2)", "Sigma U(1,3)", "Sigma U(2,3)", "Fractional x", "Fractional y", "Fractional z"};
    public static Class[] DataClass = new Class[]{Global.booleanclass.getClass(), Global.integerclass.getClass(), Global.stringclass.getClass(), Global.stringclass.getClass(), Global.stringclass.getClass(), Global.charclass.getClass(), Global.stringclass.getClass(), Global.charclass.getClass(), Global.integerclass.getClass(), Global.charclass.getClass(), Global.doubleclass.getClass(), Global.doubleclass.getClass(), Global.doubleclass.getClass(), Global.doubleclass.getClass(), Global.doubleclass.getClass(), Global.integerclass.getClass(), Global.integerclass.getClass(), Global.integerclass.getClass(), Global.integerclass.getClass(), Global.integerclass.getClass(), Global.integerclass.getClass(), Global.doubleclass.getClass(), Global.doubleclass.getClass(), Global.doubleclass.getClass(), Global.doubleclass.getClass(), Global.doubleclass.getClass(), Global.integerclass.getClass(), Global.integerclass.getClass(), Global.integerclass.getClass(), Global.integerclass.getClass(), Global.integerclass.getClass(), Global.integerclass.getClass(), Global.doubleclass.getClass(), Global.doubleclass.getClass(), Global.doubleclass.getClass()};
    public static int[] DataTextSize = new int[]{35, 45, 45, 25, 25, 20, 35, 20, 40, 20, 65, 65, 65, 45, 45, 40, 40, 40, 40, 40, 40, 65, 65, 65, 45, 45, 40, 40, 40, 40, 40, 40, 65, 65, 65};
    private static String[] PROTEIN_BASIC_ATOMS = new String[]{"N", "H", "CA", "HA", "HA1", "HA2", "C", "O"};
    private static char[] GREEK_LETTER_ORDER = new char[]{'B', 'G', 'D', 'E', 'Z', 'H', 'T', 'I'};
    private static char[] ATOM_ORDER = new char[]{'N', 'C', 'O', 'S', 'H'};
    protected boolean hetroAtom = false;
    protected int atomNumber = 0;
    protected String atomType = null;
    protected char alternateLocation = (char)32;
    protected String residueType = null;
    protected char chainID = (char)32;
    protected int residueNumber = 0;
    protected char insertionCode = (char)32;
    protected Coordinate XYZ = null;
    protected Coordinate xyz = null;
    protected Coordinate sigmaXYZ = null;
    protected double B = 0.0;
    protected double sigmaB = 0.0;
    protected double occupancy = 1.0;
    protected double sigmaOccupancy = 0.0;
    protected String element = null;
    protected String charge = null;
    protected int[] anisotropicB = null;
    protected int[] sigmaU = null;
    protected SpaceGroup spaceGroup = null;
    protected EventListenerList dataChangeListener = new EventListenerList();
    protected boolean[] ReadingErrorRecords = new boolean[36];

    public static int compareAscending(Atom o1, Atom o2, int dataIndex) {
        Object a1 = o1.TableData(dataIndex);
        Object a2 = o2.TableData(dataIndex);
        if (a2 == null) {
            if (a1 == null) {
                return 0;
            }
            return 1;
        }
        if (a1 == null) {
            return -1;
        }
        if (dataIndex == 7) {
            return Atom.compareChainID(((Character)a1).charValue(), ((Character)a2).charValue());
        }
        if (dataIndex == 2) {
            return Atom.compareAtomName(o1, o2);
        }
        return Global.compareObjects(a1, a2);
    }

    public static int compareChainID(char a1, char a2) {
        if (a1 == ' ') {
            return a2 == ' ' ? 0 : 1;
        }
        if (a2 == ' ') {
            return -1;
        }
        return Global.compareObjects(Character.valueOf(a1), Character.valueOf(a2));
    }

    public static int compareAtomName(Atom a1, Atom a2) {
        int val1;
        int value;
        int va1;
        int v1;
        String c1 = a1.AtomType();
        String c2 = a2.AtomType();
        int i1 = Global.StringArrayFindIndex(PROTEIN_BASIC_ATOMS, c1);
        int i2 = Global.StringArrayFindIndex(PROTEIN_BASIC_ATOMS, c2);
        if (i1 == -1) {
            i1 = PROTEIN_BASIC_ATOMS.length;
        }
        if (i2 == -1) {
            i2 = PROTEIN_BASIC_ATOMS.length;
        }
        if ((v1 = i1 - i2) != 0) {
            return v1;
        }
        if (c1.length() < 2 && c2.length() < 2) {
            return Global.compareObjects(c1, c2);
        }
        if (c1.length() < 2) {
            return -1;
        }
        if (c2.length() < 2) {
            return 1;
        }
        if (Character.isDigit(c1.charAt(0))) {
            c1 = c1.substring(1) + c1.charAt(0);
        }
        if (Character.isDigit(c2.charAt(0))) {
            c2 = c2.substring(1) + c2.charAt(0);
        }
        int in1 = Global.CharArrayFindIndex(GREEK_LETTER_ORDER, c1.charAt(1));
        int in2 = Global.CharArrayFindIndex(GREEK_LETTER_ORDER, c2.charAt(1));
        if (in1 == -1) {
            in1 = GREEK_LETTER_ORDER.length;
        }
        if (in2 == -1) {
            in2 = GREEK_LETTER_ORDER.length;
        }
        if ((va1 = in1 - in2) != 0) {
            return va1;
        }
        if (c1.length() > 2 && c2.length() < 3) {
            return 1;
        }
        if (c1.length() < 3 && c2.length() > 2) {
            return -1;
        }
        if (c1.length() > 2 && c2.length() > 2 && (value = c1.charAt(2) - c2.charAt(2)) != 0) {
            return value;
        }
        int ind1 = Global.CharArrayFindIndex(ATOM_ORDER, c1.charAt(0));
        int ind2 = Global.CharArrayFindIndex(ATOM_ORDER, c2.charAt(0));
        if (ind1 == -1) {
            ind1 = ATOM_ORDER.length;
        }
        if (ind2 == -1) {
            ind2 = ATOM_ORDER.length;
        }
        if ((val1 = ind1 - ind2) != 0) {
            return val1;
        }
        return Global.compareObjects(c1, c2);
    }

    public boolean[] getReadingErrorRecords() {
        return this.ReadingErrorRecords;
    }

    public Atom() {
    }

    public Atom(SpaceGroup sg) {
        this.spaceGroup = sg;
        this.atomType = "";
        this.residueType = "";
        this.OrthogonalCoordinate(new Coordinate());
    }

    public Atom(int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate xyz, double B_Factor, String Element2) {
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.OrthogonalCoordinate(xyz);
        this.B_Factor(B_Factor);
        this.Element(Element2);
    }

    public Atom(int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, String Element2) {
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.OrthogonalCoordinate(OrthogonalCoordinate);
        this.B_Factor(B_Factor);
        this.Element(Element2);
        this.Occupancy(Occupancy);
    }

    public Atom(int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, int[] AnisotropicB, String Element2) {
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.OrthogonalCoordinate(OrthogonalCoordinate);
        this.B_Factor(B_Factor);
        this.Element(Element2);
        this.Occupancy(Occupancy);
        this.AnisotropicB(AnisotropicB);
    }

    public Atom(boolean HetroAtom, int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate xyz, double B_Factor, String Element2) {
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.OrthogonalCoordinate(xyz);
        this.B_Factor(B_Factor);
        this.Element(Element2);
        this.HetroAtom(HetroAtom);
    }

    public Atom(boolean HetroAtom, int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, String Element2) {
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.OrthogonalCoordinate(OrthogonalCoordinate);
        this.B_Factor(B_Factor);
        this.Element(Element2);
        this.HetroAtom(HetroAtom);
        this.Occupancy(Occupancy);
    }

    public Atom(boolean HetroAtom, int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, int[] AnisotropicB, String Element2) {
        this.HetroAtom(HetroAtom);
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.OrthogonalCoordinate(OrthogonalCoordinate);
        this.B_Factor(B_Factor);
        this.Occupancy(Occupancy);
        this.Element(Element2);
        this.AnisotropicB(AnisotropicB);
    }

    public Atom(int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate xyz, double B_Factor, String Element2) {
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.AlternateLocation(AlternateLocation);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.InsertionCode(InsertionCode);
        this.OrthogonalCoordinate(xyz);
        this.B_Factor(B_Factor);
        this.Element(Element2);
    }

    public Atom(int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, String Element2) {
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.AlternateLocation(AlternateLocation);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.InsertionCode(InsertionCode);
        this.OrthogonalCoordinate(OrthogonalCoordinate);
        this.B_Factor(B_Factor);
        this.Occupancy(Occupancy);
        this.Element(Element2);
    }

    public Atom(int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, int[] AnisotropicB, String Element2) {
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.AlternateLocation(AlternateLocation);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.InsertionCode(InsertionCode);
        this.OrthogonalCoordinate(OrthogonalCoordinate);
        this.B_Factor(B_Factor);
        this.Occupancy(Occupancy);
        this.Element(Element2);
        this.AnisotropicB(AnisotropicB);
    }

    public Atom(boolean HetroAtom, int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate xyz, double B_Factor, String Element2, String Charge) {
        this.HetroAtom(HetroAtom);
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.AlternateLocation(AlternateLocation);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.InsertionCode(InsertionCode);
        this.B_Factor(B_Factor);
        this.Element(Element2);
        this.Charge(Charge);
    }

    public Atom(boolean HetroAtom, int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, String Element2, String Charge) {
        this.HetroAtom(HetroAtom);
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.AlternateLocation(AlternateLocation);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.InsertionCode(InsertionCode);
        this.OrthogonalCoordinate(OrthogonalCoordinate);
        this.B_Factor(B_Factor);
        this.Occupancy(Occupancy);
        this.Element(Element2);
        this.Charge(Charge);
    }

    public Atom(boolean HetroAtom, int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, int[] AnisotropicB, String Element2, String Charge) {
        this.HetroAtom(HetroAtom);
        this.AtomNumber(AtomNumber);
        this.AtomType(AtomType);
        this.AlternateLocation(AlternateLocation);
        this.ResidueType(ResidueType);
        this.ChainID(ChainID);
        this.ResidueNumber(ResidueNumber);
        this.InsertionCode(InsertionCode);
        this.OrthogonalCoordinate(OrthogonalCoordinate);
        this.B_Factor(B_Factor);
        this.Occupancy(Occupancy);
        this.Element(Element2);
        this.AnisotropicB(AnisotropicB);
        this.Charge(Charge);
    }

    public boolean HetroAtom() {
        return this.hetroAtom;
    }

    public int AtomNumber() {
        return this.atomNumber;
    }

    public String AtomType() {
        return this.atomType;
    }

    public char AlternateLocation() {
        return this.alternateLocation;
    }

    public String ResidueType() {
        return this.residueType;
    }

    public char ChainID() {
        return this.chainID;
    }

    public int ResidueNumber() {
        return this.residueNumber;
    }

    public char InsertionCode() {
        return this.insertionCode;
    }

    public Coordinate OrthogonalCoordinate() {
        return this.XYZ;
    }

    public Double X() {
        if (this.OrthogonalCoordinate() != null) {
            return this.XYZ.x();
        }
        return null;
    }

    public Double Y() {
        if (this.OrthogonalCoordinate() != null) {
            return this.XYZ.y();
        }
        return null;
    }

    public Double Z() {
        if (this.OrthogonalCoordinate() != null) {
            return this.XYZ.z();
        }
        return null;
    }

    public Coordinate FractionalCoordinate() {
        return this.xyz;
    }

    public Double x() {
        if (this.FractionalCoordinate() != null) {
            return this.xyz.x();
        }
        return null;
    }

    public Double y() {
        if (this.FractionalCoordinate() != null) {
            return this.xyz.y();
        }
        return null;
    }

    public Double z() {
        if (this.FractionalCoordinate() != null) {
            return this.xyz.z();
        }
        return null;
    }

    public Coordinate SigmaCoordinate() {
        return this.sigmaXYZ;
    }

    public Double SigmaX() {
        if (this.SigmaCoordinate() != null) {
            return this.sigmaXYZ.x();
        }
        return null;
    }

    public Double SigmaY() {
        if (this.SigmaCoordinate() != null) {
            return this.sigmaXYZ.y();
        }
        return null;
    }

    public Double SigmaZ() {
        if (this.SigmaCoordinate() != null) {
            return this.sigmaXYZ.z();
        }
        return null;
    }

    public double B_Factor() {
        return this.B;
    }

    public double SigmaB_Factor() {
        return this.sigmaB;
    }

    public double Occupancy() {
        return this.occupancy;
    }

    public double SigmaOccupancy() {
        return this.sigmaOccupancy;
    }

    public String Element() {
        return this.element;
    }

    public String Charge() {
        return this.charge;
    }

    public int[] AnistropicB() {
        return this.anisotropicB;
    }

    public Integer U11() {
        if (this.AnistropicB() != null) {
            return this.AnistropicB()[0];
        }
        return null;
    }

    public Integer U22() {
        if (this.AnistropicB() != null) {
            return this.AnistropicB()[1];
        }
        return null;
    }

    public Integer U33() {
        if (this.AnistropicB() != null) {
            return this.AnistropicB()[2];
        }
        return null;
    }

    public Integer U12() {
        if (this.AnistropicB() != null) {
            return this.AnistropicB()[3];
        }
        return null;
    }

    public Integer U13() {
        if (this.AnistropicB() != null) {
            return this.AnistropicB()[4];
        }
        return null;
    }

    public Integer U23() {
        if (this.AnistropicB() != null) {
            return this.AnistropicB()[5];
        }
        return null;
    }

    public int[] SigmaU() {
        return this.sigmaU;
    }

    public Integer SigmaU11() {
        if (this.SigmaU() != null) {
            return this.SigmaU()[0];
        }
        return null;
    }

    public Integer SigmaU22() {
        if (this.SigmaU() != null) {
            return this.SigmaU()[1];
        }
        return null;
    }

    public Integer SigmaU33() {
        if (this.SigmaU() != null) {
            return this.SigmaU()[2];
        }
        return null;
    }

    public Integer SigmaU12() {
        if (this.SigmaU() != null) {
            return this.SigmaU()[3];
        }
        return null;
    }

    public Integer SigmaU13() {
        if (this.SigmaU() != null) {
            return this.SigmaU()[4];
        }
        return null;
    }

    public Integer SigmaU23() {
        if (this.SigmaU() != null) {
            return this.SigmaU()[5];
        }
        return null;
    }

    public SpaceGroup Spacegroup() {
        return this.spaceGroup;
    }

    public Object TableData(int index) {
        switch (index) {
            case 0: {
                return this.HetroAtom();
            }
            case 1: {
                return this.AtomNumber();
            }
            case 2: {
                return this.AtomType();
            }
            case 3: {
                return this.Element();
            }
            case 4: {
                return this.Charge();
            }
            case 5: {
                return Character.valueOf(this.AlternateLocation());
            }
            case 6: {
                return this.ResidueType();
            }
            case 7: {
                return Character.valueOf(this.ChainID());
            }
            case 8: {
                return this.ResidueNumber();
            }
            case 9: {
                return Character.valueOf(this.InsertionCode());
            }
            case 10: {
                return this.X();
            }
            case 11: {
                return this.Y();
            }
            case 12: {
                return this.Z();
            }
            case 13: {
                return this.B_Factor();
            }
            case 14: {
                return this.Occupancy();
            }
            case 15: {
                return this.U11();
            }
            case 16: {
                return this.U22();
            }
            case 17: {
                return this.U33();
            }
            case 18: {
                return this.U12();
            }
            case 19: {
                return this.U13();
            }
            case 20: {
                return this.U23();
            }
            case 21: {
                return this.SigmaX();
            }
            case 22: {
                return this.SigmaY();
            }
            case 23: {
                return this.SigmaZ();
            }
            case 24: {
                return this.SigmaB_Factor();
            }
            case 25: {
                return this.SigmaOccupancy();
            }
            case 26: {
                return this.SigmaU11();
            }
            case 27: {
                return this.SigmaU22();
            }
            case 28: {
                return this.SigmaU33();
            }
            case 29: {
                return this.SigmaU12();
            }
            case 30: {
                return this.SigmaU13();
            }
            case 31: {
                return this.SigmaU23();
            }
            case 32: {
                return this.x();
            }
            case 33: {
                return this.y();
            }
            case 34: {
                return this.z();
            }
        }
        return null;
    }

    public boolean HetroAtom(boolean HetroAtom) {
        this.fireDataChangedEvent(0, this.hetroAtom);
        this.hetroAtom = HetroAtom;
        return this.hetroAtom;
    }

    public int AtomNumber(int AtomNumber) {
        this.fireDataChangedEvent(1, this.atomNumber);
        this.atomNumber = AtomNumber;
        return this.atomNumber;
    }

    public String AtomType(String AtomType) {
        this.fireDataChangedEvent(2, this.atomType);
        this.atomType = AtomType;
        return this.atomType;
    }

    public char AlternateLocation(char AlternateLocation) {
        this.fireDataChangedEvent(5, Character.valueOf(this.alternateLocation));
        this.alternateLocation = AlternateLocation;
        return this.alternateLocation;
    }

    public String ResidueType(String ResidueType) {
        this.fireDataChangedEvent(6, this.residueType);
        this.residueType = ResidueType;
        return this.residueType;
    }

    public char ChainID(char ChainID) {
        this.fireDataChangedEvent(7, Character.valueOf(this.chainID));
        this.chainID = ChainID;
        return this.chainID;
    }

    public int ResidueNumber(int ResidueNumber) {
        this.fireDataChangedEvent(8, this.residueNumber);
        this.residueNumber = ResidueNumber;
        return this.residueNumber;
    }

    public char InsertionCode(char InsertionCode) {
        this.fireDataChangedEvent(9, Character.valueOf(this.insertionCode));
        this.insertionCode = InsertionCode;
        return this.insertionCode;
    }

    public Coordinate OrthogonalCoordinate(Coordinate Value) {
        this.fireDataChangedEvent(10, this.XYZ != null ? Double.valueOf(this.XYZ.x()) : null);
        this.fireDataChangedEvent(11, this.XYZ != null ? Double.valueOf(this.XYZ.y()) : null);
        this.fireDataChangedEvent(12, this.XYZ != null ? Double.valueOf(this.XYZ.z()) : null);
        this.XYZ = Value;
        this.GenerateFractionalCoordinate();
        return this.XYZ;
    }

    public double X(double X) {
        this.fireDataChangedEvent(10, this.XYZ != null ? Double.valueOf(this.XYZ.x()) : null);
        if (this.XYZ == null) {
            this.XYZ = new Coordinate();
        }
        this.XYZ.x(X);
        this.GenerateFractionalCoordinate();
        return this.XYZ.x();
    }

    public double Y(double Y) {
        this.fireDataChangedEvent(11, this.XYZ != null ? Double.valueOf(this.XYZ.y()) : null);
        if (this.XYZ == null) {
            this.XYZ = new Coordinate();
        }
        this.XYZ.y(Y);
        this.GenerateFractionalCoordinate();
        return this.XYZ.y();
    }

    public double Z(double Z) {
        this.fireDataChangedEvent(12, this.XYZ != null ? Double.valueOf(this.XYZ.z()) : null);
        if (this.XYZ == null) {
            this.XYZ = new Coordinate();
        }
        this.XYZ.z(Z);
        this.GenerateFractionalCoordinate();
        return this.XYZ.z();
    }

    public Coordinate FractionalCoordinate(Coordinate Value) {
        if (this.Spacegroup() != null) {
            this.fireDataChangedEvent(32, this.xyz != null ? Double.valueOf(this.xyz.x()) : null);
            this.fireDataChangedEvent(33, this.xyz != null ? Double.valueOf(this.xyz.y()) : null);
            this.fireDataChangedEvent(34, this.xyz != null ? Double.valueOf(this.xyz.z()) : null);
            this.xyz = Value;
            this.GenerateOrthogonalCoordinate();
            return this.xyz;
        }
        return null;
    }

    public Double x(double Value) {
        if (this.Spacegroup() != null) {
            this.fireDataChangedEvent(32, this.xyz != null ? Double.valueOf(this.xyz.x()) : null);
            if (this.xyz == null) {
                this.xyz = new Coordinate();
            }
            this.xyz.x(Value);
            this.GenerateOrthogonalCoordinate();
            return Value;
        }
        return 0.0;
    }

    public Double y(double Value) {
        if (this.Spacegroup() != null) {
            this.fireDataChangedEvent(33, this.xyz != null ? Double.valueOf(this.xyz.y()) : null);
            if (this.xyz == null) {
                this.xyz = new Coordinate();
            }
            this.xyz.y(Value);
            this.GenerateOrthogonalCoordinate();
            return Value;
        }
        return 0.0;
    }

    public Double z(double Value) {
        if (this.Spacegroup() != null) {
            this.fireDataChangedEvent(34, this.xyz != null ? Double.valueOf(this.xyz.z()) : null);
            if (this.xyz == null) {
                this.xyz = new Coordinate();
            }
            this.xyz.z(Value);
            this.GenerateOrthogonalCoordinate();
            return Value;
        }
        return 0.0;
    }

    public Coordinate SigmaCoordinate(Coordinate SigmaCoordinate) {
        this.fireDataChangedEvent(21, this.sigmaXYZ != null ? Double.valueOf(this.sigmaXYZ.x()) : null);
        this.fireDataChangedEvent(22, this.sigmaXYZ != null ? Double.valueOf(this.sigmaXYZ.y()) : null);
        this.fireDataChangedEvent(23, this.sigmaXYZ != null ? Double.valueOf(this.sigmaXYZ.z()) : null);
        this.sigmaXYZ = SigmaCoordinate;
        return this.sigmaXYZ;
    }

    public double SigmaX(double Value) {
        this.fireDataChangedEvent(21, this.sigmaXYZ != null ? Double.valueOf(this.sigmaXYZ.x()) : null);
        if (this.sigmaXYZ == null) {
            this.sigmaXYZ = new Coordinate();
        }
        return this.sigmaXYZ.x(Value);
    }

    public double SigmaY(double Value) {
        this.fireDataChangedEvent(22, this.sigmaXYZ != null ? Double.valueOf(this.sigmaXYZ.y()) : null);
        if (this.sigmaXYZ == null) {
            this.sigmaXYZ = new Coordinate();
        }
        return this.sigmaXYZ.y(Value);
    }

    public double SigmaZ(double Value) {
        this.fireDataChangedEvent(23, this.sigmaXYZ != null ? Double.valueOf(this.sigmaXYZ.z()) : null);
        if (this.sigmaXYZ == null) {
            this.sigmaXYZ = new Coordinate();
        }
        return this.sigmaXYZ.z(Value);
    }

    public double B_Factor(double B_Factor) {
        this.fireDataChangedEvent(13, this.B);
        this.B = B_Factor;
        return this.B;
    }

    public double SigmaB_Factor(double SigmaB_Factor) {
        this.fireDataChangedEvent(24, this.sigmaB);
        this.sigmaB = SigmaB_Factor;
        return this.sigmaB;
    }

    public double Occupancy(double Occupancy) {
        this.fireDataChangedEvent(14, this.occupancy);
        this.occupancy = Occupancy;
        return this.occupancy;
    }

    public double SigmaOccupancy(double SigmaOccupancy) {
        this.fireDataChangedEvent(25, this.sigmaOccupancy);
        this.sigmaOccupancy = SigmaOccupancy;
        return this.sigmaOccupancy;
    }

    public String Element(String Element2) {
        if (Element2 != null && Element2.length() > 2) {
            Element2 = Element2.substring(0, 2);
        }
        this.fireDataChangedEvent(3, this.element != null ? this.element : null);
        this.element = Element2;
        return this.element;
    }

    public String Charge(String Charge) {
        if (Charge != null && Charge.length() > 2) {
            Charge = Charge.substring(0, 2);
        }
        this.fireDataChangedEvent(4, this.charge != null ? this.charge : null);
        this.charge = Charge;
        return this.charge;
    }

    public int[] AnisotropicB(int[] AnisotropicB) {
        this.fireDataChangedEvent(15, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[0]) : null);
        this.fireDataChangedEvent(16, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[1]) : null);
        this.fireDataChangedEvent(17, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[2]) : null);
        this.fireDataChangedEvent(18, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[3]) : null);
        this.fireDataChangedEvent(19, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[4]) : null);
        this.fireDataChangedEvent(20, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[5]) : null);
        this.anisotropicB = AnisotropicB;
        return AnisotropicB;
    }

    public Integer U11(int Value) {
        this.fireDataChangedEvent(15, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[0]) : null);
        if (this.AnistropicB() == null) {
            this.anisotropicB = new int[6];
        }
        int n = Value;
        this.AnistropicB()[0] = n;
        return n;
    }

    public Integer U22(int Value) {
        this.fireDataChangedEvent(16, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[1]) : null);
        if (this.AnistropicB() == null) {
            this.anisotropicB = new int[6];
        }
        int n = Value;
        this.AnistropicB()[1] = n;
        return n;
    }

    public Integer U33(int Value) {
        this.fireDataChangedEvent(17, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[2]) : null);
        if (this.AnistropicB() == null) {
            this.anisotropicB = new int[6];
        }
        int n = Value;
        this.AnistropicB()[2] = n;
        return n;
    }

    public Integer U12(int Value) {
        this.fireDataChangedEvent(18, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[3]) : null);
        if (this.AnistropicB() == null) {
            this.anisotropicB = new int[6];
        }
        int n = Value;
        this.AnistropicB()[3] = n;
        return n;
    }

    public Integer U13(int Value) {
        this.fireDataChangedEvent(19, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[4]) : null);
        if (this.AnistropicB() == null) {
            this.anisotropicB = new int[6];
        }
        int n = Value;
        this.AnistropicB()[4] = n;
        return n;
    }

    public Integer U23(int Value) {
        this.fireDataChangedEvent(20, this.anisotropicB != null ? Integer.valueOf(this.anisotropicB[5]) : null);
        if (this.AnistropicB() == null) {
            this.anisotropicB = new int[6];
        }
        int n = Value;
        this.AnistropicB()[5] = n;
        return n;
    }

    public int[] SigmaU(int[] SigmaU) {
        this.fireDataChangedEvent(26, this.sigmaU != null ? Integer.valueOf(this.sigmaU[0]) : null);
        this.fireDataChangedEvent(27, this.sigmaU != null ? Integer.valueOf(this.sigmaU[1]) : null);
        this.fireDataChangedEvent(28, this.sigmaU != null ? Integer.valueOf(this.sigmaU[2]) : null);
        this.fireDataChangedEvent(29, this.sigmaU != null ? Integer.valueOf(this.sigmaU[3]) : null);
        this.fireDataChangedEvent(30, this.sigmaU != null ? Integer.valueOf(this.sigmaU[4]) : null);
        this.fireDataChangedEvent(31, this.sigmaU != null ? Integer.valueOf(this.sigmaU[5]) : null);
        this.sigmaU = SigmaU;
        return SigmaU;
    }

    public Integer SigmaU11(int Value) {
        this.fireDataChangedEvent(26, this.sigmaU != null ? Integer.valueOf(this.sigmaU[0]) : null);
        if (this.SigmaU() == null) {
            this.sigmaU = new int[6];
        }
        int n = Value;
        this.SigmaU()[0] = n;
        return n;
    }

    public Integer SigmaU22(int Value) {
        this.fireDataChangedEvent(27, this.sigmaU != null ? Integer.valueOf(this.sigmaU[1]) : null);
        if (this.SigmaU() == null) {
            this.sigmaU = new int[6];
        }
        int n = Value;
        this.SigmaU()[1] = n;
        return n;
    }

    public Integer SigmaU33(int Value) {
        this.fireDataChangedEvent(28, this.sigmaU != null ? Integer.valueOf(this.sigmaU[2]) : null);
        if (this.SigmaU() == null) {
            this.sigmaU = new int[6];
        }
        int n = Value;
        this.SigmaU()[2] = n;
        return n;
    }

    public Integer SigmaU12(int Value) {
        this.fireDataChangedEvent(29, this.sigmaU != null ? Integer.valueOf(this.sigmaU[3]) : null);
        if (this.SigmaU() == null) {
            this.sigmaU = new int[6];
        }
        int n = Value;
        this.SigmaU()[3] = n;
        return n;
    }

    public Integer SigmaU13(int Value) {
        this.fireDataChangedEvent(30, this.sigmaU != null ? Integer.valueOf(this.sigmaU[4]) : null);
        if (this.SigmaU() == null) {
            this.sigmaU = new int[6];
        }
        int n = Value;
        this.SigmaU()[4] = n;
        return n;
    }

    public Integer SigmaU23(int Value) {
        this.fireDataChangedEvent(31, this.sigmaU != null ? Integer.valueOf(this.sigmaU[5]) : null);
        if (this.SigmaU() == null) {
            this.sigmaU = new int[6];
        }
        int n = Value;
        this.SigmaU()[5] = n;
        return n;
    }

    public SpaceGroup Spacegroup(SpaceGroup Value) {
        this.spaceGroup = Value;
        return this.spaceGroup;
    }

    public Object TableData(int index, Object Value) {
        if (Value != null) {
            if (DataClass[index] == Global.charclass.getClass() && Value.getClass() == Global.stringclass.getClass()) {
                String s = (String)Value;
                Value = s.length() > 0 ? Character.valueOf(s.charAt(s.length() - 1)) : Character.valueOf(' ');
            }
            switch (index) {
                case 0: {
                    return this.HetroAtom((Boolean)Value);
                }
                case 1: {
                    return this.AtomNumber((Integer)Value);
                }
                case 2: {
                    return this.AtomType((String)Value);
                }
                case 3: {
                    return this.Element((String)Value);
                }
                case 4: {
                    return this.Charge((String)Value);
                }
                case 5: {
                    return Character.valueOf(this.AlternateLocation(((Character)Value).charValue()));
                }
                case 6: {
                    return this.ResidueType((String)Value);
                }
                case 7: {
                    return Character.valueOf(this.ChainID(((Character)Value).charValue()));
                }
                case 8: {
                    return this.ResidueNumber((Integer)Value);
                }
                case 9: {
                    return Character.valueOf(this.InsertionCode(((Character)Value).charValue()));
                }
                case 10: {
                    return this.X((Double)Value);
                }
                case 11: {
                    return this.Y((Double)Value);
                }
                case 12: {
                    return this.Z((Double)Value);
                }
                case 13: {
                    return this.B_Factor((Double)Value);
                }
                case 14: {
                    return this.Occupancy((Double)Value);
                }
                case 15: {
                    return this.U11((Integer)Value);
                }
                case 16: {
                    return this.U22((Integer)Value);
                }
                case 17: {
                    return this.U33((Integer)Value);
                }
                case 18: {
                    return this.U12((Integer)Value);
                }
                case 19: {
                    return this.U13((Integer)Value);
                }
                case 20: {
                    return this.U23((Integer)Value);
                }
                case 21: {
                    return this.SigmaX((Double)Value);
                }
                case 22: {
                    return this.SigmaY((Double)Value);
                }
                case 23: {
                    return this.SigmaZ((Double)Value);
                }
                case 24: {
                    return this.SigmaB_Factor((Double)Value);
                }
                case 25: {
                    return this.SigmaOccupancy((Double)Value);
                }
                case 26: {
                    return this.SigmaU11((Integer)Value);
                }
                case 27: {
                    return this.SigmaU22((Integer)Value);
                }
                case 28: {
                    return this.SigmaU33((Integer)Value);
                }
                case 29: {
                    return this.SigmaU12((Integer)Value);
                }
                case 30: {
                    return this.SigmaU13((Integer)Value);
                }
                case 31: {
                    return this.SigmaU23((Integer)Value);
                }
                case 32: {
                    return this.x((Double)Value);
                }
                case 33: {
                    return this.y((Double)Value);
                }
                case 34: {
                    return this.z((Double)Value);
                }
            }
        } else {
            switch (index) {
                case 15: {
                    return this.AnisotropicB(null);
                }
                case 16: {
                    return this.AnisotropicB(null);
                }
                case 17: {
                    return this.AnisotropicB(null);
                }
                case 18: {
                    return this.AnisotropicB(null);
                }
                case 19: {
                    return this.AnisotropicB(null);
                }
                case 20: {
                    return this.AnisotropicB(null);
                }
                case 21: {
                    return this.SigmaCoordinate(null);
                }
                case 22: {
                    return this.SigmaCoordinate(null);
                }
                case 23: {
                    return this.SigmaCoordinate(null);
                }
                case 26: {
                    return this.SigmaU(null);
                }
                case 27: {
                    return this.SigmaU(null);
                }
                case 28: {
                    return this.SigmaU(null);
                }
                case 29: {
                    return this.SigmaU(null);
                }
                case 30: {
                    return this.SigmaU(null);
                }
                case 31: {
                    return this.SigmaU(null);
                }
            }
        }
        return null;
    }

    public AtomPDB GetPDBAtomOfThis() {
        if (this.getClass() == AtomPDB.AtomPDBclass.getClass()) {
            return (AtomPDB)this;
        }
        return new AtomPDB(this);
    }

    public Atom clone() {
        Atom a = new Atom();
        a.hetroAtom = this.hetroAtom;
        a.atomNumber = this.atomNumber;
        a.atomType = this.atomType;
        a.alternateLocation = this.alternateLocation;
        a.residueType = this.residueType;
        a.chainID = this.chainID;
        a.residueNumber = this.residueNumber;
        a.insertionCode = this.insertionCode;
        a.XYZ = this.XYZ;
        a.xyz = this.xyz;
        a.sigmaXYZ = this.sigmaXYZ;
        a.B = this.B;
        a.sigmaB = this.sigmaB;
        a.occupancy = this.occupancy;
        a.sigmaOccupancy = this.sigmaOccupancy;
        a.element = this.element;
        a.charge = this.charge;
        a.anisotropicB = this.anisotropicB;
        a.sigmaU = this.sigmaU;
        a.spaceGroup = this.spaceGroup;
        return a;
    }

    protected void GenerateFractionalCoordinate() {
        if (this.Spacegroup() != null && this.Spacegroup().scale() != null) {
            this.xyz = Global.TransformCoordinates(this.spaceGroup.scale(), this.XYZ);
        }
    }

    protected void GenerateOrthogonalCoordinate() {
        if (this.Spacegroup().scaleInverse() != null) {
            this.XYZ = Global.TransformCoordinates(this.spaceGroup.scaleInverse(), this.xyz);
        }
    }

    public void addAtomDataChangeListener(AtomDataChangeEventListener listener) {
        this.dataChangeListener.add(AtomDataChangeEventListener.class, listener);
    }

    public void removeAtomDataChangeListener(AtomDataChangeEventListener listener) {
        this.dataChangeListener.remove(AtomDataChangeEventListener.class, listener);
    }

    protected void fireDataChangedEvent(int changedEntryNumber, Object OldValue) {
        AtomDataChangeEvent event = new AtomDataChangeEvent(this, changedEntryNumber, OldValue);
        Object[] listeners = this.dataChangeListener.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != AtomDataChangeEventListener.class) continue;
            ((AtomDataChangeEventListener)listeners[i + 1]).dataChanged(event);
        }
    }

    public int compareTo(Object o) {
        Atom b = (Atom)o;
        int diff_atomnum = this.AtomNumber() - b.AtomNumber();
        if (diff_atomnum != 0) {
            return diff_atomnum;
        }
        int diff_chain = Atom.compareChainID(this.ChainID(), b.chainID);
        if (diff_chain != 0) {
            return diff_chain;
        }
        int diff_resnum = this.ResidueNumber() - b.ResidueNumber();
        if (diff_resnum != 0) {
            return diff_resnum;
        }
        int diff_atomname = Atom.compareAtomName(this, b);
        if (diff_atomname != 0) {
            return diff_atomname;
        }
        int diff_altloc = this.AlternateLocation() - b.AlternateLocation();
        if (diff_altloc != 0) {
            return diff_altloc;
        }
        return 0;
    }
}

