/*
 * Decompiled with CFR 0.152.
 */
package pdb_reader.data;

import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.Coordinate;
import pdb_reader.data.spacegroup.SpaceGroup;

public class AtomPDB
extends Atom {
    public static AtomPDB AtomPDBclass = new AtomPDB();
    public static String[] Headers = new String[]{"ATOM", "HETATM"};
    public static String[] ContinueHeaders = new String[]{"SIGATM", "ANISOU", "SIGUIJ"};
    public static String[] IgnoreHeaders = new String[]{"TER"};
    public static final double CoordinateMaximum = 9999.999;
    public static final double CoordinateMinimum = -999.999;
    public static final int UMaximum = 9999999;
    public static final int UMinimum = -999999;
    public static final double BOccpMaximum = 999.99;
    public static final double BOccpMinimum = 0.0;

    private static Coordinate CorrectCoordinateRange(Coordinate Value) {
        if (Value != null) {
            Value.x(AtomPDB.CorrectCoordinateRange(Value.x()));
            Value.y(AtomPDB.CorrectCoordinateRange(Value.y()));
            Value.z(AtomPDB.CorrectCoordinateRange(Value.z()));
            return Value;
        }
        return null;
    }

    private static double CorrectCoordinateRange(double Value) {
        if (Value > 9999.999) {
            return 9999.999;
        }
        if (Value < -999.999) {
            return -999.999;
        }
        return Value;
    }

    private static int[] CorrectURange(int[] Value) {
        if (Value != null) {
            for (int i = 0; i < 6; ++i) {
                Value[i] = AtomPDB.CorrectURange(Value[i]);
            }
            return Value;
        }
        return null;
    }

    private static int CorrectURange(int Value) {
        if (Value > 9999999) {
            return 9999999;
        }
        if (Value < -999999) {
            return -999999;
        }
        return Value;
    }

    private static double CorrectBOccpRange(double Value) {
        if (Value > 999.99) {
            return 999.99;
        }
        if (Value < 0.0) {
            return 0.0;
        }
        return Value;
    }

    public AtomPDB() {
        this.CommonInitializer();
    }

    public AtomPDB(Atom a) {
        this.CommonInitializer();
        this.CopyFromAtom(a);
    }

    public AtomPDB(String PDB_ATOM_Line, SpaceGroup spacegroup) {
        this.CommonInitializer();
        this.Spacegroup(spacegroup);
        this.ReadPDBAtomLine(PDB_ATOM_Line);
    }

    public void CommonInitializer() {
    }

    public void CopyFromAtom(Atom Value) {
        this.AlternateLocation(Value.alternateLocation);
        if (Value.anisotropicB != null) {
            this.AnisotropicB((int[])Value.anisotropicB.clone());
        }
        this.AtomNumber(Value.atomNumber);
        this.AtomType(Value.atomType);
        this.B_Factor(Value.B);
        this.ChainID(Value.chainID);
        this.Charge(Value.charge);
        this.Element(Value.element);
        this.HetroAtom(Value.hetroAtom);
        this.InsertionCode(Value.insertionCode);
        if (Value.XYZ != null) {
            this.OrthogonalCoordinate(Value.XYZ.clone());
        }
        this.Occupancy(Value.occupancy);
        this.ResidueNumber(Value.residueNumber);
        this.ResidueType(Value.residueType);
        this.SigmaB_Factor(Value.sigmaB);
        this.SigmaOccupancy(Value.sigmaOccupancy);
        this.Spacegroup(Value.spaceGroup);
        if (Value.sigmaU != null) {
            this.SigmaU((int[])Value.sigmaU.clone());
        }
        if (Value.sigmaXYZ != null) {
            this.SigmaCoordinate(Value.sigmaXYZ.clone());
        }
        if (Value.xyz != null) {
            this.FractionalCoordinate(Value.xyz.clone());
        }
    }

    public int AtomNumber(int AtomNumber) {
        return super.AtomNumber(Global.CorrectRange(AtomNumber, 99999, 0));
    }

    public String AtomType(String AtomType) {
        if (AtomType != null && AtomType.length() > 4) {
            AtomType = AtomType.substring(0, 4);
        }
        return super.AtomType(AtomType);
    }

    public String ResidueType(String ResidueType) {
        return super.ResidueType(ResidueType.substring(0, 3));
    }

    public int ResidueNumber(int ResidueNumber) {
        return super.ResidueNumber(Global.CorrectRange(ResidueNumber, 9999, 0));
    }

    public Coordinate OrthogonalCoordinate(Coordinate Value) {
        return super.OrthogonalCoordinate(AtomPDB.CorrectCoordinateRange(Value));
    }

    public double X(double X) {
        return super.X(AtomPDB.CorrectCoordinateRange(X));
    }

    public double Y(double Y) {
        return super.Y(AtomPDB.CorrectCoordinateRange(Y));
    }

    public double Z(double Z) {
        return super.Z(AtomPDB.CorrectCoordinateRange(Z));
    }

    public Coordinate SigmaCoordinate(Coordinate Value) {
        return super.SigmaCoordinate(AtomPDB.CorrectCoordinateRange(Value));
    }

    public double SigmaX(double X) {
        return super.SigmaX(AtomPDB.CorrectCoordinateRange(X));
    }

    public double SigmaY(double Y) {
        return super.SigmaY(AtomPDB.CorrectCoordinateRange(Y));
    }

    public double SigmaZ(double Z) {
        return super.SigmaZ(AtomPDB.CorrectCoordinateRange(Z));
    }

    public int[] AnisotropicB(int[] AnisotropicB) {
        return super.AnisotropicB(AtomPDB.CorrectURange(AnisotropicB));
    }

    public Integer U11(int Value) {
        return super.U11(AtomPDB.CorrectURange(Value));
    }

    public Integer U22(int Value) {
        return super.U22(AtomPDB.CorrectURange(Value));
    }

    public Integer U33(int Value) {
        return super.U33(AtomPDB.CorrectURange(Value));
    }

    public Integer U12(int Value) {
        return super.U12(AtomPDB.CorrectURange(Value));
    }

    public Integer U13(int Value) {
        return super.U13(AtomPDB.CorrectURange(Value));
    }

    public Integer U23(int Value) {
        return super.U23(AtomPDB.CorrectURange(Value));
    }

    public int[] SigmaU(int[] SigmaU) {
        return super.SigmaU(AtomPDB.CorrectURange(SigmaU));
    }

    public Integer SigmaU11(int Value) {
        return super.SigmaU11(AtomPDB.CorrectURange(Value));
    }

    public Integer SigmaU22(int Value) {
        return super.SigmaU22(AtomPDB.CorrectURange(Value));
    }

    public Integer SigmaU33(int Value) {
        return super.SigmaU33(AtomPDB.CorrectURange(Value));
    }

    public Integer SigmaU12(int Value) {
        return super.SigmaU12(AtomPDB.CorrectURange(Value));
    }

    public Integer SigmaU13(int Value) {
        return super.SigmaU13(AtomPDB.CorrectURange(Value));
    }

    public Integer SigmaU23(int Value) {
        return super.SigmaU23(AtomPDB.CorrectURange(Value));
    }

    public double B_Factor(double B_Factor) {
        return super.B_Factor(AtomPDB.CorrectBOccpRange(B_Factor));
    }

    public double SigmaB_Factor(double SigmaB_Factor) {
        return super.SigmaB_Factor(AtomPDB.CorrectBOccpRange(SigmaB_Factor));
    }

    public double Occupancy(double Occupancy) {
        return super.Occupancy(AtomPDB.CorrectBOccpRange(Occupancy));
    }

    public double SigmaOccupancy(double SigmaOccupancy) {
        return super.SigmaOccupancy(AtomPDB.CorrectBOccpRange(SigmaOccupancy));
    }

    public void ReadPDBAtomLine(String Line) {
        for (int i = 0; i < this.ReadingErrorRecords.length; ++i) {
            this.ReadingErrorRecords[i] = false;
        }
        try {
            String AtomCode = Line.substring(0, 6).trim();
            if (AtomCode.equals("HETATM")) {
                this.hetroAtom = true;
            }
        }
        catch (Exception e) {
            this.ReportReadingError(0);
        }
        try {
            this.atomNumber = Integer.parseInt(Line.substring(6, 11).trim());
        }
        catch (Exception e) {
            this.ReportReadingError(1);
        }
        try {
            this.atomType = Line.substring(12, 16).trim();
        }
        catch (Exception e) {
            this.ReportReadingError(2);
        }
        try {
            this.alternateLocation = Line.charAt(16);
        }
        catch (Exception e) {
            this.ReportReadingError(5);
        }
        try {
            this.residueType = Line.substring(17, 20).trim();
        }
        catch (Exception e) {
            this.ReportReadingError(6);
        }
        try {
            this.chainID = Line.charAt(21);
        }
        catch (Exception e) {
            this.ReportReadingError(7);
        }
        try {
            this.residueNumber = Integer.parseInt(Line.substring(22, 26).trim());
        }
        catch (Exception e) {
            this.ReportReadingError(8);
        }
        try {
            this.insertionCode = Line.charAt(26);
        }
        catch (Exception e) {
            this.ReportReadingError(9);
        }
        Coordinate OC = new Coordinate();
        this.OrthogonalCoordinate(OC);
        this.sigmaXYZ = null;
        try {
            OC.x(Double.parseDouble(Line.substring(30, 38).trim()));
        }
        catch (Exception e) {
            this.ReportReadingError(10);
        }
        try {
            OC.y(Double.parseDouble(Line.substring(38, 46).trim()));
        }
        catch (Exception e) {
            this.ReportReadingError(11);
        }
        try {
            OC.z(Double.parseDouble(Line.substring(46, 54).trim()));
        }
        catch (Exception e) {
            this.ReportReadingError(12);
        }
        try {
            this.GenerateFractionalCoordinate();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.occupancy = Double.parseDouble(Line.substring(54, 60).trim());
        }
        catch (Exception e) {
            this.ReportReadingError(14);
        }
        try {
            this.B = Double.parseDouble(Line.substring(60, 66).trim());
        }
        catch (Exception e) {
            this.ReportReadingError(13);
        }
        try {
            try {
                this.element = Line.substring(76, 78).trim();
                this.charge = Line.substring(78, 80).trim();
            }
            catch (Exception e) {
                this.element = Line.substring(76).trim();
                this.charge = null;
            }
        }
        catch (Exception e1) {
            this.ReportReadingError(3);
            this.ReportReadingError(4);
        }
        this.anisotropicB = null;
        this.sigmaU = null;
    }

    public void AppendPDBInformation(String Line) {
        this.ReadPDBAnisouLine(Line);
        this.ReadPDBSigatmLine(Line);
        this.ReadPDBSiguijLine(Line);
    }

    public void ReadPDBAnisouLine(String Line) {
        if (Line.substring(0, 6).equals("ANISOU") && this.CheckRecordInformation(Line)) {
            this.anisotropicB = new int[6];
            try {
                this.anisotropicB[0] = Integer.parseInt(Line.substring(28, 35).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(15);
            }
            try {
                this.anisotropicB[1] = Integer.parseInt(Line.substring(35, 42).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(16);
            }
            try {
                this.anisotropicB[2] = Integer.parseInt(Line.substring(42, 49).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(17);
            }
            try {
                this.anisotropicB[3] = Integer.parseInt(Line.substring(49, 56).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(18);
            }
            try {
                this.anisotropicB[4] = Integer.parseInt(Line.substring(56, 63).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(19);
            }
            try {
                this.anisotropicB[5] = Integer.parseInt(Line.substring(63, 70).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(20);
            }
        }
    }

    public void ReadPDBSigatmLine(String Line) {
        if (Line.substring(0, 6).equals("SIGATM") && this.CheckRecordInformation(Line)) {
            this.sigmaXYZ = new Coordinate();
            try {
                this.sigmaXYZ.x(Double.parseDouble(Line.substring(30, 38).trim()));
            }
            catch (Exception e) {
                this.ReportReadingError(21);
            }
            try {
                this.sigmaXYZ.y(Double.parseDouble(Line.substring(38, 46).trim()));
            }
            catch (Exception e) {
                this.ReportReadingError(22);
            }
            try {
                this.sigmaXYZ.z(Double.parseDouble(Line.substring(46, 54).trim()));
            }
            catch (Exception e) {
                this.ReportReadingError(23);
            }
            try {
                this.sigmaOccupancy = Double.parseDouble(Line.substring(54, 60).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(25);
            }
            try {
                this.sigmaB = Double.parseDouble(Line.substring(60, 66).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(24);
            }
        }
    }

    public void ReadPDBSiguijLine(String Line) {
        if (Line.substring(0, 6).equals("SIGUIJ") && this.CheckRecordInformation(Line)) {
            this.sigmaU = new int[6];
            try {
                this.sigmaU[0] = Integer.parseInt(Line.substring(28, 35).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(26);
            }
            try {
                this.sigmaU[1] = Integer.parseInt(Line.substring(35, 42).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(27);
            }
            try {
                this.sigmaU[2] = Integer.parseInt(Line.substring(42, 49).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(28);
            }
            try {
                this.sigmaU[3] = Integer.parseInt(Line.substring(49, 56).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(29);
            }
            try {
                this.sigmaU[4] = Integer.parseInt(Line.substring(56, 63).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(30);
            }
            try {
                this.sigmaU[5] = Integer.parseInt(Line.substring(63, 70).trim());
            }
            catch (Exception e) {
                this.ReportReadingError(31);
            }
        }
    }

    public String WritePDBLine() {
        String SiguijLine;
        String AnisouLine;
        StringBuilder sb = new StringBuilder();
        String AtomLine = this.WritePDBAtomLine();
        if (AtomLine == null) {
            return null;
        }
        sb.append(AtomLine);
        sb.append('\n');
        String SigatmLine = this.WritePDBSigatmLine();
        if (SigatmLine != null) {
            sb.append(SigatmLine + '\n');
        }
        if ((AnisouLine = this.WritePDBAnisouLine()) != null) {
            sb.append(AnisouLine + '\n');
        }
        if ((SiguijLine = this.WritePDBSiguijLine()) != null) {
            sb.append(SiguijLine + '\n');
        }
        return sb.toString();
    }

    public String WritePDBAtomLine() {
        if (this.atomType != null && this.residueType != null && this.XYZ != null) {
            StringBuilder sb = new StringBuilder();
            if (this.hetroAtom) {
                sb.append(String.format("%-6s", Headers[1]));
            } else {
                sb.append(String.format("%-6s", Headers[0]));
            }
            sb.append(this.WritePDBCommonInformation());
            sb.append(this.WritePDBAtomCoordinate());
            sb.append(this.WritePDBCommonElementInformation(sb.length()));
            return sb.toString();
        }
        return null;
    }

    public String WritePDBSigatmLine() {
        if (this.atomType != null && this.residueType != null && this.sigmaXYZ != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ContinueHeaders[0]);
            sb.append(this.WritePDBCommonInformation());
            sb.append(this.WritePDBCoordinate(this.sigmaXYZ, this.sigmaOccupancy, this.sigmaB));
            sb.append(this.WritePDBCommonElementInformation(sb.length()));
            return sb.toString();
        }
        return null;
    }

    public String WritePDBAnisouLine() {
        if (this.atomType != null && this.residueType != null && this.anisotropicB != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ContinueHeaders[1]);
            sb.append(this.WritePDBCommonInformation());
            sb.append(this.WritePDBAnistropicB(this.anisotropicB));
            sb.append(this.WritePDBCommonElementInformation(sb.length()));
            return sb.toString();
        }
        return null;
    }

    public String WritePDBSiguijLine() {
        if (this.atomType != null && this.residueType != null && this.sigmaU != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(ContinueHeaders[2]);
            sb.append(this.WritePDBCommonInformation());
            sb.append(this.WritePDBAnistropicB(this.sigmaU));
            sb.append(this.WritePDBCommonElementInformation(sb.length()));
            return sb.toString();
        }
        return null;
    }

    private boolean CheckRecordInformation(String Line) {
        if (this.atomNumber != Integer.parseInt(Line.substring(6, 11).trim())) {
            return false;
        }
        if (!this.atomType.equals(Line.substring(12, 16).trim())) {
            return false;
        }
        if (this.alternateLocation != Line.charAt(16)) {
            return false;
        }
        if (!this.residueType.equals(Line.substring(17, 20).trim())) {
            return false;
        }
        if (this.chainID != Line.charAt(21)) {
            return false;
        }
        if (this.residueNumber != Integer.parseInt(Line.substring(22, 26).trim())) {
            return false;
        }
        return this.insertionCode == Line.charAt(26);
    }

    private String WritePDBCommonInformation() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%5d", this.atomNumber));
        if (this.atomType.length() > 3) {
            sb.append(String.format(" %-4s", this.atomType));
        } else {
            sb.append(String.format("  %-3s", this.atomType));
        }
        sb.append(this.alternateLocation);
        sb.append(String.format("%-3s ", this.residueType));
        sb.append(this.chainID);
        sb.append(String.format("%4d", this.residueNumber));
        sb.append(this.insertionCode);
        return sb.toString();
    }

    private String WritePDBCommonElementInformation(int currentlength) {
        StringBuilder sb = new StringBuilder();
        for (int i = currentlength; i < 77; ++i) {
            sb.append(' ');
        }
        sb.append(String.format("%-2s", this.element));
        if (this.charge != null) {
            sb.append(String.format("%-2s", this.charge));
        }
        return sb.toString();
    }

    private String WritePDBAtomCoordinate() {
        return this.WritePDBCoordinate(this.XYZ, this.occupancy, this.B);
    }

    private String WritePDBCoordinate(Coordinate cin, double occup, double Bin) {
        StringBuilder sb = new StringBuilder();
        sb.append("   ");
        sb.append(String.format("%8.3f", cin.x()));
        sb.append(String.format("%8.3f", cin.y()));
        sb.append(String.format("%8.3f", cin.z()));
        sb.append(String.format("%6.2f", occup));
        sb.append(String.format("%6.2f", Bin));
        return sb.toString();
    }

    private String WritePDBAnistropicB(int[] ab) {
        StringBuilder sb = new StringBuilder();
        sb.append(' ');
        sb.append(String.format("%7d", ab[0]));
        sb.append(String.format("%7d", ab[1]));
        sb.append(String.format("%7d", ab[2]));
        sb.append(String.format("%7d", ab[3]));
        sb.append(String.format("%7d", ab[4]));
        sb.append(String.format("%7d", ab[5]));
        return sb.toString();
    }

    public String WritePDBTerLine() {
        StringBuilder sb = new StringBuilder();
        sb.append("TER   ");
        sb.append(String.format("%5d", this.atomNumber));
        sb.append("      ");
        sb.append(String.format("%-3s ", this.residueType));
        sb.append(this.chainID);
        sb.append(String.format("%4d", this.residueNumber));
        sb.append(this.insertionCode);
        sb.append('\n');
        return sb.toString();
    }

    private void ReportReadingError() {
        this.ReadingErrorRecords[35] = true;
    }

    private void ReportReadingError(int DataIndex) {
        this.ReadingErrorRecords[DataIndex] = true;
        this.ReportReadingError();
    }
}

