/*
 * EditorFrame2.java
 *
 * Created on February 10, 2008, 7:01 PM
 */

package pdb_editor;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import pdb_reader.DataSet;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSetDataChangeEvent;
import pdb_reader.Global;
import pdb_editor.coordinate.EditCoordinateDialog;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import pdb_editor.coordinate.EditColumnListDialog;
import pdb_editor.coordinate.SearchSelectDialog;
import pdb_editor.dialogs.AtomSelectorDialog;
import pdb_editor.dialogs.CalculateNumberStatisticsDialog;
import pdb_editor.dialogs.EditConnectivityDialog;
import pdb_editor.dialogs.EditResidueNumberDialog;
import pdb_editor.dialogs.RotateTranslateAtomsDialog;
import pdb_editor.dialogs.EditSpacegroupDialog;
import pdb_editor.dialogs.ExtractSequenceDialog;
import pdb_editor.dialogs.FindClosestAtomDistancesDialog;
import pdb_editor.dialogs.GenerateSymmetryMateDialog;
import pdb_editor.dialogs.SortAtomsDialog;
import pdb_reader.DataSetDataChangeEventListener;
import pdb_reader.data.Atom;
import pdb_reader.data.AtomPDB;
import pdb_reader.data.AtomSelector;
import pdb_reader.data.spacegroup.SpaceGroup;

/**
 *
 * @author  Owner
 */
public class EditorFrame extends javax.swing.JFrame implements ClipboardOwner {
    
    private DataSet maindata = null;   //  @jve:decl-index=0:
    private CoordinateTable coordinateTable = null;
    private JScrollPane jScrollPane = null;
    private String statusLabelText = "";
    public boolean dataChangeNotSaved = false;
    private Stack<Object[]> undoStack = new Stack<Object[]> ();
    private Stack<Object[]> redoStack = new Stack<Object[]> ();
    private ArrayList<Object> undoEventRecord = null;
    private DataSetDataChangeEventListener undoEventListener = new DataSetDataChangeEventListener() {
        public void dataChanged(DataSetDataChangeEvent e) {
            undoEventRecord.add(e);
        }
    };
            
    /** Creates new form EditorFrame2 */
    public EditorFrame() {
        InitializeCommon();
    }
    public EditorFrame(boolean b){
	InitializeCommon();
	NewData();
    }
    public EditorFrame(String FileName) {
        InitializeCommon();
        LoadData(FileName);
    }
    
    private void InitializeCommon()
    {
        initComponents();
        setFiltersForFileChooser();
        InitializeSortMenuItems();
    }
    
    private void InitializeSortMenuItems()
    {
        class SortMenuItem extends JMenuItem {
            public int dataIndex;
            public SortMenuItem(int index) {dataIndex = index;}
        }
        
        java.awt.event.ActionListener ascendingAction = new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                performAtomSort(((SortMenuItem)e.getSource()).dataIndex, false);
            }
        };
        java.awt.event.ActionListener descendingAction = new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                performAtomSort(((SortMenuItem)e.getSource()).dataIndex, true);
            }
        };
        
        for (int i=0; i<Atom.TOTAL_NUMBER_OF_INDEX; i++)
        {
            SortMenuItem asc = new SortMenuItem(i);
            SortMenuItem des = new SortMenuItem(i);
            String name = Atom.DataToolTip[i];
            asc.setText(name);
            des.setText(name);
            asc.addActionListener(ascendingAction);
            des.addActionListener(descendingAction);
            this.jMenuSortAscending.add(asc);
            this.jMenuSortDescending.add(des);
        }
    }
    
    private void performAtomSort(int dataIndex, boolean descending)
    {
        if (coordinateTable != null)
        {
            String name = "Sort " + ((descending) ? "descending " : "ascending ") + Atom.DataToolTip[dataIndex];
            this.listenForUndoStart(name);  
            maindata.Sort(dataIndex, descending);
            coordinateTable.fireTableDataChanged();
            this.listenForUndoStop();
         }      
    }
    
    public void listenForUndoStart(String undoName)
    {
        undoEventRecord = new ArrayList<Object> ();
        undoEventRecord.add(undoName);
        maindata.addDataChangeListener(undoEventListener);
    }
    
    public void listenForUndoStop(boolean redo)
    {
        maindata.removeDataChangeListener(undoEventListener);
        if (undoEventRecord.size() > 1)
        {
            undoStack.push(undoEventRecord.toArray(new Object[undoEventRecord.size()]));
            this.jMenuItemUndo.setText("Undo - " + undoStack.peek()[0].toString());
            this.jMenuItemUndo.setEnabled(true);
            if (!redo)
            {
                redoStack.clear();
                this.jMenuItemRedo.setText("Redo");
                this.jMenuItemRedo.setEnabled(false);
            }
        }
    }
    
    public void listenForUndoStop()
    {
        listenForUndoStop(false);
    }
    
    private void listenForRedoStop()
    {
        maindata.removeDataChangeListener(undoEventListener);
        redoStack.push(undoEventRecord.toArray(new Object[undoEventRecord.size()]));
        this.jMenuItemRedo.setText("Redo - " + redoStack.peek()[0].toString());
        this.jMenuItemRedo.setEnabled(true);
    }
    
    private void undoPerform()
    {
        Object[] undoList = undoStack.pop();
        if (undoStack.empty()) 
        {
            this.jMenuItemUndo.setText("Undo");
            this.jMenuItemUndo.setEnabled(false);
        }
        else
        {
            this.jMenuItemUndo.setText("Undo - " + undoStack.peek()[0].toString());
            this.jMenuItemUndo.setEnabled(true);
        }
        
        listenForUndoStart(undoList[0].toString());
        int numberaffected = undoPerform(undoList);
        this.StatusLabelChange("Undo : " + undoList[0].toString() + " - " + numberaffected + " atoms changed");

        coordinateTable.fireTableDataChanged();
        listenForRedoStop();
    }
    
    private void redoPerform()
    {
        Object[] redoList = redoStack.pop();
        if (redoStack.empty()) 
        {
            this.jMenuItemRedo.setText("Redo");
            this.jMenuItemRedo.setEnabled(false);
        }
        else
        {
            this.jMenuItemRedo.setText("Redo - " + redoStack.peek()[0].toString());
            this.jMenuItemRedo.setEnabled(true);
        }
        
        listenForUndoStart(redoList[0].toString());
        int numberaffected = undoPerform(redoList);
        this.StatusLabelChange("Redo : " + redoList[0].toString() + " - " + numberaffected + " atoms changed");

        coordinateTable.fireTableDataChanged();
        listenForUndoStop(true);
    }
    
    private int undoPerform(Object[] undoList)
    {
        java.util.LinkedHashSet<Atom> count = new java.util.LinkedHashSet<Atom> ();
        for (int i=undoList.length - 1; i>0; i--)
        {
            DataSetDataChangeEvent d = (DataSetDataChangeEvent)undoList[i];
            switch (d.eventCode)
            {
                case DataSetDataChangeEvent.ADD_EVENT : 
                    if (maindata.Atoms().contains(d.atomChanged)) { maindata.Atoms().remove(d.atomChanged); count.add(d.atomChanged); }
                    break;
                case DataSetDataChangeEvent.DELETE_EVENT : 
                    if (!maindata.Atoms().contains(d.atomChanged)) { maindata.Atoms().add(d.lastIndex, d.atomChanged);  count.add(d.atomChanged); }
                    break;
                case DataSetDataChangeEvent.CHANGE_EVENT : 
                    d.atomChanged.TableData(d.atomChangeEvent.dataEntryAffected, d.atomChangeEvent.oldValue);
                     count.add(d.atomChanged);
                    break;
                case DataSetDataChangeEvent.SORT_EVENT :
                    maindata.fireDataChangeEvent(new DataSetDataChangeEvent(maindata, DataSetDataChangeEvent.SORT_EVENT));
                    maindata.Atoms(d.oldData);
                    break;
            }
        }
        return count.size();
    }
    
    private void setFiltersForFileChooser()
    {
        jFileChooser.addChoosableFileFilter(new FileFilter() {
            public boolean accept(File f) {
                if (f.isDirectory()) return true;
                String Ext = Global.GetFileExtension(f);
                if (Ext == null) return false;
                if (Ext.equals("PDB")) return true;
                return false;
            }
            public String getDescription() {
                return "RCSB Protein Data Bank File (*.pdb)"; 
            }
        });
    }

    private void StatusLabelChange(String Text)
    {
        statusLabelText = Text;
        this.jStatusLabel.setText(Text);
    }
    private void StatusLabelTemporary(String Text)
    {
        statusLabelText = this.jStatusLabel.getText();
        this.jStatusLabel.setText(Text);
    }
    private void StatusLabelTemporaryEnd()
    {
        this.jStatusLabel.setText(statusLabelText);
    }
    private void StatusLabelClear()
    {
        this.jStatusLabel.setText("");
    }
    public void StatusLabelReportCellSelectionChange()
    {
        int atomnumber = coordinateTable.getSelectedRowCount();
        int columnnumber = coordinateTable.getSelectedColumnCount();
        if ((atomnumber != 0) && (columnnumber != 0))
        {
            if ((atomnumber > 1) || (columnnumber > 1))
            {
                String atom = " atoms ";
                if (atomnumber == 1) atom = " atom ";
                String column = " columns ";
                if (columnnumber == 1) column = " column ";
                StatusLabelChange(atomnumber + atom + "and " + columnnumber + column + "selected");
            }
            else 
            {
                Atom a = maindata.Atoms().get(coordinateTable.getSelectedRow());
                String atomtext = "Atom " + a.AtomNumber() + ' ' + a.AtomType() + ' ' + a.ChainID() + a.ResidueNumber() + " : ";
                StatusLabelChange(atomtext + coordinateTable.getColumnName(coordinateTable.getSelectedColumn()) + " = " + coordinateTable.getModel().getValueAt(coordinateTable.getSelectedRow(), coordinateTable.getSelectedColumn()));
            }
        }
    }
    
    private void NewCoordinateFile()
    {
	if (maindata == null)
	{
            NewData();
	}
	else
	{
            EditorFrame nw = new EditorFrame(true);
            nw.setVisible(true);
	}
    }

    private void NewData()
    {
        maindata = new DataSet();
        maindata.addDataChangeListener(dataChangeNotSavedListener);
        //maindata.Atoms().add(new Atom());
        DisplayPDBData();
    }
        
    private void SaveCoordinateFileAs()
    {
        if (maindata != null)
        {
            int retValue = jFileChooser.showSaveDialog(EditorFrame.this);
            if (retValue == JFileChooser.APPROVE_OPTION)
            {
                String filename = Global.AddFileExtension(jFileChooser.getSelectedFile().getPath(), "pdb");
                
                String message = maindata.SaveFile(filename);
                if (message == null) {
                    this.setTitle("PDB Editor by JL - " + Global.TrimFileName(maindata.FileName(), 2));
                    this.StatusLabelChange("File successfully saved");
                    dataChangeNotSaved = false;
                }
                else JOptionPane.showMessageDialog(this, message, "Error Saving File", JOptionPane.ERROR_MESSAGE);                    
            }
        }
    }

    private void SaveCoordinateFile()
    {
        if (maindata != null)
        {
            if (maindata.FileName() == null)
            {
                SaveCoordinateFileAs();
            }
            else 
            {
                String message = maindata.SaveFile();
                if (message == null)
                {
                    this.StatusLabelChange("File successfully saved");
                    dataChangeNotSaved = false;
                }
                else JOptionPane.showMessageDialog(this, message, "Error Saving File", JOptionPane.ERROR_MESSAGE);                    
            }
        }
    }

    public void DeleteRecord()
    {
        if (maindata != null)
            if (coordinateTable.getSelectedRowCount() > 0)
        {
            this.listenForUndoStart("Delete selected atoms");
            maindata.DeleteAtoms(coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            coordinateTable.clearSelection();
            coordinateTable.fireTableDataChanged();
        }
    }

    private void SelectAllRecord()
    {
        if (coordinateTable != null)
            coordinateTable.selectAll();
    }
    
    
    
    private void LoadCoordinateFile()
    {
	int retValue = jFileChooser.showOpenDialog(EditorFrame.this);
	if (retValue == JFileChooser.APPROVE_OPTION)
	{
	    if (maindata == null)
	    {
	        LoadData(jFileChooser.getSelectedFile().getPath());
	    }
	    else
	    {
	        EditorFrame nw = new EditorFrame(jFileChooser.getSelectedFile().getPath());
	        nw.setVisible(true);
	    }
	}
    }
 
    private void LoadData(String FileName)
    {
        maindata = new DataSet(FileName);
        DisplayPDBData();
        String message = maindata.getReadingError();
        if (!message.equals(""))
        {
            pdb_editor.dialogs.OpenCoordinateErrorDialog errordialog = new pdb_editor.dialogs.OpenCoordinateErrorDialog(this, true, message);
            errordialog.show();
        }
        this.StatusLabelChange("Read and loaded " + maindata.Atoms().size() + " atom coordinates");
        maindata.addDataChangeListener(dataChangeNotSavedListener);
    }
   
    private void DisplayPDBData()
    {
	if (maindata.FileName() != null) 
            this.setTitle("PDB Editor by JL - " + Global.TrimFileName(maindata.FileName(), 2));
	else 
            this.setTitle("PDB Editor by JL - Untitled Coordinate");
	jTabbedPane.addTab("Coordinates", getJScrollPane());
    }

    private JScrollPane getJScrollPane() 
    {
        if (jScrollPane == null) 
        {
            coordinateTable = new CoordinateTable(this, maindata);
            jScrollPane = new JScrollPane(coordinateTable);
            jScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
            coordinateTable.setAutoResizeMode(0);
        }
        return jScrollPane;
    }

     public void lostOwnership(Clipboard clipboard, Transferable contents) 
     {
     }

     private void setClipboardContent(String s)
     {
         StringSelection stringSelection = new StringSelection( s );
         Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
         clipboard.setContents( stringSelection, this );
     }
     
     private String getClipboardString()
     {
          Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
          try {
            Object c = clipboard.getData(DataFlavor.stringFlavor);
            return (String)c;
          }
          catch (Exception e)
          {
          }
          return null;
     }

     public void PasteToCoordinateTable()
     {
         this.listenForUndoStart("Paste");
         String s = this.getClipboardString().trim();
         if (((coordinateTable.getSelectedColumnCount() > 0) && (coordinateTable.getSelectedRowCount() > 0)) 
                 || (maindata.Atoms().size() == 0))
         if (s!= null) 
         {
             switch (FindClipboardStringType(s))
            {
                case 0 : coordinateTable.PasteText(s); break;
                case 1 : AppendPDBData(s); break;
                case 2 : PasteSpaceGroupData(s); break;
            }
         }
         this.listenForUndoStop();
     }
    
     private int FindClipboardStringType(String s)
     {
         if (s.length() > 5)
         {
             String sub = s.substring(0, 6);
             if ((Global.StringArrayContains(AtomPDB.Headers, sub)) ||
                     (Global.StringArrayContains(AtomPDB.ContinueHeaders, sub)))
                 return 1;
             if (sub.equals(SpaceGroup.Headers[SpaceGroup.CRYST_INDEX]+'1'))
                 return 2;
         }
         return 0;
     }
     
     private void PasteSpaceGroupData(String s)
     {
         SpaceGroup sg = new SpaceGroup(s);
         EditSpacegroupDialog esd = new EditSpacegroupDialog(this, true, maindata, sg);
         esd.show();
         coordinateTable.fireTableDataChanged();

     }
     
     private void AppendPDBData(String s)
     {
         int rowstart = 0;
         if ((coordinateTable.getSelectedRow() != -1) && (maindata.Atoms().size() != 0))
            rowstart = coordinateTable.getSelectedRows()[coordinateTable.getSelectedRows().length - 1] + 1;
         else
             rowstart = maindata.Atoms().size() - 1;
         if (rowstart < 0) rowstart = 0;
         
         int PDBadd = maindata.AppendPDBInformation(s, rowstart);
         coordinateTable.clearSelection();
         
         coordinateTable.addRowSelectionInterval(rowstart, rowstart + PDBadd - 1);
         coordinateTable.addColumnSelectionInterval(0, coordinateTable.getColumnCount() - 1);
     }
     
     private void EditCoordinateData()
     {
        EditCoordinateDialog ecd = new EditCoordinateDialog(this, false, coordinateTable);
        ecd.show();
     }
     
     private void CoordinateTypeSelectedDelete(AtomSelector selector)
     {
        if (coordinateTable != null)
        {
            int count = maindata.deleteSelectorAtoms(selector, coordinateTable.getSelectedRows());
            this.StatusLabelChange(count + " coordinates deleted");
            coordinateTable.fireTableDataChanged();
        }
     }
     
     private void CoordinateTypeDelete(AtomSelector selector)
     {
        if (coordinateTable != null)
        {
            int count = maindata.deleteSelectorAtoms(selector);
            this.StatusLabelChange(count + " coordinates deleted");
            coordinateTable.fireTableDataChanged();
        }
     }

     private void selectCoordinateTableRows(Integer[] indicies)
     {
         coordinateTable.removeRowSelectionInterval(0, maindata.Atoms().size() - 1);
         for (int i=0; i<indicies.length; i++)
             coordinateTable.addRowSelectionInterval(indicies[i], indicies[i]);
         coordinateTable.editingCanceled(null);
     }
     
     private void setColumnValueToNull(int columnIndex, String undoName, boolean AllRows)
     {
         if (coordinateTable != null)
         {
             if (undoName != null) this.listenForUndoStart(undoName);
             int[] indicies = coordinateTable.getSelectedRows();
             int length = (AllRows) ? maindata.Atoms().size() : indicies.length;
             for (int i=0; i<length; i++)
             {
                int index = (AllRows) ? i : indicies[i];
                maindata.Atoms().get(index).TableData(columnIndex, null);
             }
             if (undoName != null) { 
                 this.listenForUndoStop();
                 this.StatusLabelChange(undoName + " - " + length + " atoms changed");
             }
             this.coordinateTable.fireTableDataChanged();
             
         }
     }
     
     public void dispose()
     {
         this.jDialogAbout.dispose();
         this.jDialogEventLogger.dispose();
         super.dispose();
     }
     
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jFileChooser = new javax.swing.JFileChooser();
        jDialogAbout = new javax.swing.JDialog();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jButton1 = new javax.swing.JButton();
        jDialogEventLogger = new javax.swing.JDialog();
        jScrollPane2 = new javax.swing.JScrollPane();
        jEventLoggerTextArea = new javax.swing.JTextArea();
        jEventLoggerButtonClose = new javax.swing.JButton();
        jEventLoggerButtonClear = new javax.swing.JButton();
        jToolBarMain = new javax.swing.JToolBar();
        jToolButtonNew = new javax.swing.JButton();
        jToolButtonOpen = new javax.swing.JButton();
        jToolButtonSave = new javax.swing.JButton();
        jToolButtonSaveAs = new javax.swing.JButton();
        jSeparator5 = new javax.swing.JToolBar.Separator();
        jToolButtonCopy = new javax.swing.JButton();
        jToolButtonCopyPDB = new javax.swing.JButton();
        jToolButtonCutPDB = new javax.swing.JButton();
        jToolButtonPaste = new javax.swing.JButton();
        jSeparator11 = new javax.swing.JToolBar.Separator();
        jToolButtonSearchSelect = new javax.swing.JButton();
        jToolButtonEditCoordinate = new javax.swing.JButton();
        jToolButtonCalculateStatistics = new javax.swing.JButton();
        jToolButtonExtractSequence = new javax.swing.JButton();
        jSeparator12 = new javax.swing.JToolBar.Separator();
        jToolButtonColumnDisplayed = new javax.swing.JButton();
        jToolBarStatus = new javax.swing.JToolBar();
        jStatusLabelIndent = new javax.swing.JLabel();
        jStatusLabel = new javax.swing.JLabel();
        jTabbedPane = new javax.swing.JTabbedPane();
        jMenuBar = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuItemNew = new javax.swing.JMenuItem();
        jMenuItemOpen = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        jMenuItemSave = new javax.swing.JMenuItem();
        jMenuItemSaveAs = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JSeparator();
        jMenuItemExit = new javax.swing.JMenuItem();
        jMenuEdit = new javax.swing.JMenu();
        jMenuItemUndo = new javax.swing.JMenuItem();
        jMenuItemRedo = new javax.swing.JMenuItem();
        jSeparator14 = new javax.swing.JSeparator();
        jMenuItemCopy = new javax.swing.JMenuItem();
        jMenuItemCopyPDB = new javax.swing.JMenuItem();
        jMenuItemCopySpacegroup = new javax.swing.JMenuItem();
        jMenuItemCutPDB = new javax.swing.JMenuItem();
        jMenuItemPaste = new javax.swing.JMenuItem();
        jSeparator3 = new javax.swing.JSeparator();
        jMenuItemEdit = new javax.swing.JMenuItem();
        jSeparator17 = new javax.swing.JSeparator();
        jMenuItemInsertEmptyAtom = new javax.swing.JMenuItem();
        jSeparator20 = new javax.swing.JSeparator();
        jMenuItemMoveTop = new javax.swing.JMenuItem();
        jMenuItemMoveUp = new javax.swing.JMenuItem();
        jMenuItemMoveDown = new javax.swing.JMenuItem();
        jMenuItemMoveBottom = new javax.swing.JMenuItem();
        jMenuDelete = new javax.swing.JMenu();
        jMenuItemDelete = new javax.swing.JMenuItem();
        jSeparator8 = new javax.swing.JSeparator();
        jMenuItemDeleteHAtoms = new javax.swing.JMenuItem();
        jMenuItemZeroOccpAtoms = new javax.swing.JMenuItem();
        jMenuItemAltConfAtoms = new javax.swing.JMenuItem();
        jSeparator15 = new javax.swing.JSeparator();
        jMenuItemDeleteSelectedAnisoB = new javax.swing.JMenuItem();
        jMenuItemDeleteSelectedSigmaXYZ = new javax.swing.JMenuItem();
        jMenuItemDeleteSelectedSigmaU = new javax.swing.JMenuItem();
        jSeparator7 = new javax.swing.JSeparator();
        jMenuItemDeleteAllHAtoms = new javax.swing.JMenuItem();
        jMenuItemDeleteAllZeroOccpAtoms = new javax.swing.JMenuItem();
        jMenuItemDeleteAllAltConfAtoms = new javax.swing.JMenuItem();
        jSeparator16 = new javax.swing.JSeparator();
        jMenuItemDeleteAllAnisoB = new javax.swing.JMenuItem();
        jMenuItemDeleteAllSigmaXYZ = new javax.swing.JMenuItem();
        jMenuItemDeleteAllSigmaU = new javax.swing.JMenuItem();
        jMenuSelect = new javax.swing.JMenu();
        jMenuItemSelectSearch = new javax.swing.JMenuItem();
        jMenuItemInvertSelection = new javax.swing.JMenuItem();
        jSeparator6 = new javax.swing.JSeparator();
        jMenuItemSelectAll = new javax.swing.JMenuItem();
        jMenuItemSelectRow = new javax.swing.JMenuItem();
        jMenuItemSelectColumn = new javax.swing.JMenuItem();
        jMenuItemSelectChain = new javax.swing.JMenuItem();
        jMenuItemSelectResidue = new javax.swing.JMenuItem();
        jSeparator4 = new javax.swing.JSeparator();
        jMenuItemSelectAllProteinAtoms = new javax.swing.JMenuItem();
        jMenuItemSelectAllDNAAtoms = new javax.swing.JMenuItem();
        jMenuItemSelectAllRNAAtoms = new javax.swing.JMenuItem();
        jMenuItemSelectAllSolventAtoms = new javax.swing.JMenuItem();
        jMenuItemSelectAllUncategorizedAtoms = new javax.swing.JMenuItem();
        jMenuModify = new javax.swing.JMenu();
        jMenuItemEditSpacegroupUnitcell = new javax.swing.JMenuItem();
        jMenuItemEditResNumChainID = new javax.swing.JMenuItem();
        jMenuItemEditAtomConnectivity = new javax.swing.JMenuItem();
        jSeparator10 = new javax.swing.JSeparator();
        jMenuItemResetAtomNumber = new javax.swing.JMenuItem();
        jMenuItemFixElement = new javax.swing.JMenuItem();
        jMenuItemCorrectAtomOrdering = new javax.swing.JMenuItem();
        jSeparator19 = new javax.swing.JSeparator();
        jMenuItemSortAtoms = new javax.swing.JMenuItem();
        jMenuSortAscending = new javax.swing.JMenu();
        jMenuSortDescending = new javax.swing.JMenu();
        jMenuCalculate = new javax.swing.JMenu();
        jMenuItemGenerateSymmetryMates = new javax.swing.JMenuItem();
        jMenuItemRotateTranslateAtoms = new javax.swing.JMenuItem();
        jSeparator18 = new javax.swing.JSeparator();
        jMenuItemCalculateNumberStatistics = new javax.swing.JMenuItem();
        jMenuItemExtractSequence = new javax.swing.JMenuItem();
        jMenuItemFindClosestAtomDistances = new javax.swing.JMenuItem();
        jSeparator9 = new javax.swing.JSeparator();
        jMenuItemReduceToCa = new javax.swing.JMenuItem();
        jMenuItemReduceToPolyALA = new javax.swing.JMenuItem();
        jMenuOption = new javax.swing.JMenu();
        jMenuItemColumnDisplayed = new javax.swing.JMenuItem();
        jMenuItem1 = new javax.swing.JMenuItem();
        jSeparator13 = new javax.swing.JSeparator();
        jMenuItemAbout = new javax.swing.JMenuItem();

        jDialogAbout.setTitle("About PDB Editor by JL");
        jDialogAbout.setMinimumSize(new java.awt.Dimension(500, 500));
        jDialogAbout.setModal(true);
        jDialogAbout.setResizable(false);

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 14));
        jLabel1.setText("PDB Editor by JL");

        jLabel2.setFont(new java.awt.Font("Tahoma", 0, 14));
        jLabel2.setText("Fix : 080529");

        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setRows(5);
        jTextArea1.setText("    Protein Data Bank File Editor by JL\n    Copyright (C)   2008   Jonas Lee\n\n    This program is free software: you can redistribute it and/or modify\n    it under the terms of the GNU General Public License as published by\n    the Free Software Foundation, either version 3 of the License, or\n    (at your option) any later version.\n\n    This program is distributed in the hope that it will be useful,\n    but WITHOUT ANY WARRANTY; without even the implied warranty of\n    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n    GNU General Public License for more details.\n\n    You should have received a copy of the GNU General Public License\n    along with this program.  If not, see <http://www.gnu.org/licenses/>.\n\n\nAuthor : Jonas Lee\nUniversity of California - Berkeley\nDepartment of Chemistry\n\nAcknowledgments\n- Crystal Project : Icons\n- CCP4 : Scale matrix calc, Crystal symm library\n- RCSB PDB\n- wwPDB Format v2.3");
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setFocusable(false);
        jScrollPane1.setViewportView(jTextArea1);

        jButton1.setText("Close");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jDialogAboutLayout = new javax.swing.GroupLayout(jDialogAbout.getContentPane());
        jDialogAbout.getContentPane().setLayout(jDialogAboutLayout);
        jDialogAboutLayout.setHorizontalGroup(
            jDialogAboutLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jDialogAboutLayout.createSequentialGroup()
                .addGroup(jDialogAboutLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jDialogAboutLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jDialogAboutLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLabel2)))
                    .addGroup(jDialogAboutLayout.createSequentialGroup()
                        .addContainerGap(209, Short.MAX_VALUE)
                        .addComponent(jButton1))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jDialogAboutLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 258, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jDialogAboutLayout.setVerticalGroup(
            jDialogAboutLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jDialogAboutLayout.createSequentialGroup()
                .addGap(5, 5, 5)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 139, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addComponent(jButton1)
                .addGap(11, 11, 11))
        );

        jDialogEventLogger.setTitle("Data Change Event Log");
        jDialogEventLogger.setMinimumSize(new java.awt.Dimension(500, 500));

        jEventLoggerTextArea.setColumns(20);
        jEventLoggerTextArea.setRows(5);
        jScrollPane2.setViewportView(jEventLoggerTextArea);

        jEventLoggerButtonClose.setText("Close");
        jEventLoggerButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jEventLoggerButtonCloseActionPerformed(evt);
            }
        });

        jEventLoggerButtonClear.setText("Clear");
        jEventLoggerButtonClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jEventLoggerButtonClearActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jDialogEventLoggerLayout = new javax.swing.GroupLayout(jDialogEventLogger.getContentPane());
        jDialogEventLogger.getContentPane().setLayout(jDialogEventLoggerLayout);
        jDialogEventLoggerLayout.setHorizontalGroup(
            jDialogEventLoggerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jDialogEventLoggerLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jDialogEventLoggerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 499, Short.MAX_VALUE)
                    .addGroup(jDialogEventLoggerLayout.createSequentialGroup()
                        .addComponent(jEventLoggerButtonClear)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jEventLoggerButtonClose)))
                .addContainerGap())
        );
        jDialogEventLoggerLayout.setVerticalGroup(
            jDialogEventLoggerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jDialogEventLoggerLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 379, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jDialogEventLoggerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jEventLoggerButtonClose)
                    .addComponent(jEventLoggerButtonClear))
                .addContainerGap())
        );

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("PDB Editor by JL");
        setMinimumSize(new java.awt.Dimension(800, 800));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jToolBarMain.setRollover(true);
        jToolBarMain.setMaximumSize(new java.awt.Dimension(24, 24));
        jToolBarMain.setMinimumSize(new java.awt.Dimension(24, 24));

        jToolButtonNew.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/filenew.png"))); // NOI18N
        jToolButtonNew.setToolTipText("New Coordinate File");
        jToolButtonNew.setBorderPainted(false);
        jToolButtonNew.setContentAreaFilled(false);
        jToolButtonNew.setFocusable(false);
        jToolButtonNew.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonNew.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jToolButtonNew.setMaximumSize(new java.awt.Dimension(25, 25));
        jToolButtonNew.setMinimumSize(new java.awt.Dimension(25, 25));
        jToolButtonNew.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonNew.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonNewMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonNewMouseExited(evt);
            }
        });
        jToolButtonNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToolButtonNewActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonNew);

        jToolButtonOpen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/fileopen.png"))); // NOI18N
        jToolButtonOpen.setToolTipText("Open Coordinate File");
        jToolButtonOpen.setBorderPainted(false);
        jToolButtonOpen.setContentAreaFilled(false);
        jToolButtonOpen.setFocusable(false);
        jToolButtonOpen.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonOpen.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonOpen.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonOpenMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonOpenMouseExited(evt);
            }
        });
        jToolButtonOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToolButtonOpenActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonOpen);

        jToolButtonSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/filesave.png"))); // NOI18N
        jToolButtonSave.setToolTipText("Save Coordinate File");
        jToolButtonSave.setBorderPainted(false);
        jToolButtonSave.setContentAreaFilled(false);
        jToolButtonSave.setFocusable(false);
        jToolButtonSave.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonSave.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonSave.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonSaveMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonSaveMouseExited(evt);
            }
        });
        jToolButtonSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToolButtonSaveActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonSave);

        jToolButtonSaveAs.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/filesaveas.png"))); // NOI18N
        jToolButtonSaveAs.setToolTipText("Save Coordinate File As");
        jToolButtonSaveAs.setBorderPainted(false);
        jToolButtonSaveAs.setContentAreaFilled(false);
        jToolButtonSaveAs.setFocusable(false);
        jToolButtonSaveAs.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonSaveAs.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonSaveAs.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonSaveAsMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonSaveAsMouseExited(evt);
            }
        });
        jToolButtonSaveAs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToolButtonSaveAsActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonSaveAs);
        jToolBarMain.add(jSeparator5);

        jToolButtonCopy.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/editcopy24.png"))); // NOI18N
        jToolButtonCopy.setToolTipText("Copy cell data");
        jToolButtonCopy.setBorderPainted(false);
        jToolButtonCopy.setContentAreaFilled(false);
        jToolButtonCopy.setFocusable(false);
        jToolButtonCopy.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonCopy.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonCopy.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonCopyMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonCopyMouseExited(evt);
            }
        });
        jToolButtonCopy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCopyActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonCopy);

        jToolButtonCopyPDB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/editcopyPDB24.png"))); // NOI18N
        jToolButtonCopyPDB.setToolTipText("Copy atoms in PDB format");
        jToolButtonCopyPDB.setBorderPainted(false);
        jToolButtonCopyPDB.setContentAreaFilled(false);
        jToolButtonCopyPDB.setFocusable(false);
        jToolButtonCopyPDB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonCopyPDB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonCopyPDB.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonCopyPDBMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonCopyPDBMouseExited(evt);
            }
        });
        jToolButtonCopyPDB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCopyPDBActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonCopyPDB);

        jToolButtonCutPDB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/editcut24.png"))); // NOI18N
        jToolButtonCutPDB.setToolTipText("Cut atoms in PDB format");
        jToolButtonCutPDB.setBorderPainted(false);
        jToolButtonCutPDB.setContentAreaFilled(false);
        jToolButtonCutPDB.setFocusable(false);
        jToolButtonCutPDB.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonCutPDB.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonCutPDB.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonCutPDBMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonCutPDBMouseExited(evt);
            }
        });
        jToolButtonCutPDB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToolButtonCutPDBjMenuItemCopyPDBActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonCutPDB);

        jToolButtonPaste.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/editpaste24.png"))); // NOI18N
        jToolButtonPaste.setToolTipText("Paste data from clipboard");
        jToolButtonPaste.setBorderPainted(false);
        jToolButtonPaste.setContentAreaFilled(false);
        jToolButtonPaste.setFocusable(false);
        jToolButtonPaste.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonPaste.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonPaste.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonPasteMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonPasteMouseExited(evt);
            }
        });
        jToolButtonPaste.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemPasteActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonPaste);
        jToolBarMain.add(jSeparator11);

        jToolButtonSearchSelect.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/search24.png"))); // NOI18N
        jToolButtonSearchSelect.setToolTipText("Search and Select Coordinate");
        jToolButtonSearchSelect.setBorderPainted(false);
        jToolButtonSearchSelect.setContentAreaFilled(false);
        jToolButtonSearchSelect.setFocusable(false);
        jToolButtonSearchSelect.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonSearchSelect.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonSearchSelect.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonSearchSelectMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonSearchSelectMouseExited(evt);
            }
        });
        jToolButtonSearchSelect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToolButtonSearchSelectActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonSearchSelect);

        jToolButtonEditCoordinate.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/edit24.png"))); // NOI18N
        jToolButtonEditCoordinate.setToolTipText("Edit Selected Record");
        jToolButtonEditCoordinate.setBorderPainted(false);
        jToolButtonEditCoordinate.setContentAreaFilled(false);
        jToolButtonEditCoordinate.setFocusable(false);
        jToolButtonEditCoordinate.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonEditCoordinate.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonEditCoordinate.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonEditCoordinateMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonEditCoordinateMouseExited(evt);
            }
        });
        jToolButtonEditCoordinate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToolButtonEditCoordinateActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonEditCoordinate);

        jToolButtonCalculateStatistics.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/calc24.png"))); // NOI18N
        jToolButtonCalculateStatistics.setToolTipText("Calculate atom statistics");
        jToolButtonCalculateStatistics.setBorderPainted(false);
        jToolButtonCalculateStatistics.setContentAreaFilled(false);
        jToolButtonCalculateStatistics.setFocusable(false);
        jToolButtonCalculateStatistics.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonCalculateStatistics.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonCalculateStatistics.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonCalculateStatisticsMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonCalculateStatisticsMouseExited(evt);
            }
        });
        jToolButtonCalculateStatistics.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCalculateNumberStatisticsActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonCalculateStatistics);

        jToolButtonExtractSequence.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/view_text24.png"))); // NOI18N
        jToolButtonExtractSequence.setToolTipText("Extract sequence");
        jToolButtonExtractSequence.setBorderPainted(false);
        jToolButtonExtractSequence.setContentAreaFilled(false);
        jToolButtonExtractSequence.setFocusable(false);
        jToolButtonExtractSequence.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonExtractSequence.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonExtractSequence.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonExtractSequenceMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonExtractSequenceMouseExited(evt);
            }
        });
        jToolButtonExtractSequence.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemExtractSequenceActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonExtractSequence);
        jToolBarMain.add(jSeparator12);

        jToolButtonColumnDisplayed.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/table24.png"))); // NOI18N
        jToolButtonColumnDisplayed.setToolTipText("Change Column Displayed");
        jToolButtonColumnDisplayed.setBorderPainted(false);
        jToolButtonColumnDisplayed.setContentAreaFilled(false);
        jToolButtonColumnDisplayed.setFocusable(false);
        jToolButtonColumnDisplayed.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jToolButtonColumnDisplayed.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jToolButtonColumnDisplayed.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jToolButtonColumnDisplayedMouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jToolButtonColumnDisplayedMouseExited(evt);
            }
        });
        jToolButtonColumnDisplayed.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToolButtonColumnDisplayedActionPerformed(evt);
            }
        });
        jToolBarMain.add(jToolButtonColumnDisplayed);

        getContentPane().add(jToolBarMain, java.awt.BorderLayout.PAGE_START);

        jToolBarStatus.setFloatable(false);
        jToolBarStatus.setRollover(true);

        jStatusLabelIndent.setText("   ");
        jToolBarStatus.add(jStatusLabelIndent);
        jToolBarStatus.add(jStatusLabel);

        getContentPane().add(jToolBarStatus, java.awt.BorderLayout.PAGE_END);
        getContentPane().add(jTabbedPane, java.awt.BorderLayout.CENTER);

        jMenuFile.setText("File");

        jMenuItemNew.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_N, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemNew.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/filenew16.png"))); // NOI18N
        jMenuItemNew.setText("New Coordinate File");
        jMenuItemNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemNewActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuItemNew);

        jMenuItemOpen.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemOpen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/fileopen16.png"))); // NOI18N
        jMenuItemOpen.setText("Open Coordinate File");
        jMenuItemOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemOpenActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuItemOpen);
        jMenuFile.add(jSeparator1);

        jMenuItemSave.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/filesave16.png"))); // NOI18N
        jMenuItemSave.setText("Save Coordinate File");
        jMenuItemSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSaveActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuItemSave);

        jMenuItemSaveAs.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.SHIFT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSaveAs.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/filesaveas16.png"))); // NOI18N
        jMenuItemSaveAs.setText("Save Coordinate File As");
        jMenuItemSaveAs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSaveAsActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuItemSaveAs);
        jMenuFile.add(jSeparator2);

        jMenuItemExit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F4, java.awt.event.InputEvent.ALT_MASK));
        jMenuItemExit.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/exit16.png"))); // NOI18N
        jMenuItemExit.setText("Exit");
        jMenuItemExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemExitActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuItemExit);

        jMenuBar.add(jMenuFile);

        jMenuEdit.setText("Edit");

        jMenuItemUndo.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Z, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemUndo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/undo16.png"))); // NOI18N
        jMenuItemUndo.setText("Undo");
        jMenuItemUndo.setEnabled(false);
        jMenuItemUndo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemUndoActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemUndo);

        jMenuItemRedo.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Y, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemRedo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/redo16.png"))); // NOI18N
        jMenuItemRedo.setText("Redo");
        jMenuItemRedo.setEnabled(false);
        jMenuItemRedo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemRedoActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemRedo);
        jMenuEdit.add(jSeparator14);

        jMenuItemCopy.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemCopy.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/editcopy16.png"))); // NOI18N
        jMenuItemCopy.setText("Copy Selected Cells");
        jMenuItemCopy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCopyActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemCopy);

        jMenuItemCopyPDB.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.SHIFT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemCopyPDB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/editcopy16.png"))); // NOI18N
        jMenuItemCopyPDB.setText("Copy Selected Atoms in PDB Format");
        jMenuItemCopyPDB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCopyPDBActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemCopyPDB);

        jMenuItemCopySpacegroup.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.ALT_MASK | java.awt.event.InputEvent.SHIFT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemCopySpacegroup.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/editcopy16.png"))); // NOI18N
        jMenuItemCopySpacegroup.setText("Copy Spacegroup  in PDB Format");
        jMenuItemCopySpacegroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCopySpacegroupActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemCopySpacegroup);

        jMenuItemCutPDB.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_X, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemCutPDB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/editcut16.png"))); // NOI18N
        jMenuItemCutPDB.setText("Cut Selected Atoms in PDB Format");
        jMenuItemCutPDB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCutPDBActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemCutPDB);

        jMenuItemPaste.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_V, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemPaste.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/editpaste16.png"))); // NOI18N
        jMenuItemPaste.setText("Paste");
        jMenuItemPaste.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemPasteActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemPaste);
        jMenuEdit.add(jSeparator3);

        jMenuItemEdit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_E, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemEdit.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/edit16.png"))); // NOI18N
        jMenuItemEdit.setText("Edit Selected Atoms");
        jMenuItemEdit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemEditActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemEdit);
        jMenuEdit.add(jSeparator17);

        jMenuItemInsertEmptyAtom.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_I, java.awt.event.InputEvent.SHIFT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemInsertEmptyAtom.setText("Insert Empty Atom");
        jMenuItemInsertEmptyAtom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemInsertEmptyAtomActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemInsertEmptyAtom);
        jMenuEdit.add(jSeparator20);

        jMenuItemMoveTop.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_UP, java.awt.event.InputEvent.SHIFT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemMoveTop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/3uparrow16.png"))); // NOI18N
        jMenuItemMoveTop.setText("Move Selected Atoms to Top");
        jMenuItemMoveTop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemMoveTopActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemMoveTop);

        jMenuItemMoveUp.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_UP, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemMoveUp.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/1downarrow16.png"))); // NOI18N
        jMenuItemMoveUp.setText("Move Selected Atoms Up");
        jMenuItemMoveUp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemMoveUpActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemMoveUp);

        jMenuItemMoveDown.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_DOWN, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemMoveDown.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/1uparrow16.png"))); // NOI18N
        jMenuItemMoveDown.setText("Move Selected Atoms Down");
        jMenuItemMoveDown.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemMoveDownActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemMoveDown);

        jMenuItemMoveBottom.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_DOWN, java.awt.event.InputEvent.SHIFT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemMoveBottom.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/3downarrow16.png"))); // NOI18N
        jMenuItemMoveBottom.setText("Move Selected Atom to Bottom");
        jMenuItemMoveBottom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemMoveBottomActionPerformed(evt);
            }
        });
        jMenuEdit.add(jMenuItemMoveBottom);

        jMenuBar.add(jMenuEdit);

        jMenuDelete.setText("Delete");

        jMenuItemDelete.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_DELETE, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemDelete.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/delete_table_row16.png"))); // NOI18N
        jMenuItemDelete.setText("Delete Selected Records");
        jMenuItemDelete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemDelete);
        jMenuDelete.add(jSeparator8);

        jMenuItemDeleteHAtoms.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/delete_table_row16.png"))); // NOI18N
        jMenuItemDeleteHAtoms.setText("Delete Hydrogen Atoms from Selected");
        jMenuItemDeleteHAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteHAtomsActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemDeleteHAtoms);

        jMenuItemZeroOccpAtoms.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/delete_table_row16.png"))); // NOI18N
        jMenuItemZeroOccpAtoms.setText("Delete Zero Occupancy Atoms from Selected");
        jMenuItemZeroOccpAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemZeroOccpAtomsActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemZeroOccpAtoms);

        jMenuItemAltConfAtoms.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/delete_table_row16.png"))); // NOI18N
        jMenuItemAltConfAtoms.setText("Delete Alternate Conformation Atoms from Selected");
        jMenuItemAltConfAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemAltConfAtomsActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemAltConfAtoms);
        jMenuDelete.add(jSeparator15);

        jMenuItemDeleteSelectedAnisoB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/delete_table_col16.png"))); // NOI18N
        jMenuItemDeleteSelectedAnisoB.setText("Delete Anisotropic Temp Factor from Selected Atoms");
        jMenuItemDeleteSelectedAnisoB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteSelectedAnisoBActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemDeleteSelectedAnisoB);

        jMenuItemDeleteSelectedSigmaXYZ.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/delete_table_col16.png"))); // NOI18N
        jMenuItemDeleteSelectedSigmaXYZ.setText("Delete Sigma Coordinate from Selected Atoms");
        jMenuItemDeleteSelectedSigmaXYZ.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteSelectedSigmaXYZActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemDeleteSelectedSigmaXYZ);

        jMenuItemDeleteSelectedSigmaU.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/delete_table_col16.png"))); // NOI18N
        jMenuItemDeleteSelectedSigmaU.setText("Delete Sigma U from Selected Atoms");
        jMenuItemDeleteSelectedSigmaU.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteSelectedSigmaUActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemDeleteSelectedSigmaU);
        jMenuDelete.add(jSeparator7);

        jMenuItemDeleteAllHAtoms.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/delete16.png"))); // NOI18N
        jMenuItemDeleteAllHAtoms.setText("Delete All Hydrogen Atoms");
        jMenuItemDeleteAllHAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteAllHAtomsActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemDeleteAllHAtoms);

        jMenuItemDeleteAllZeroOccpAtoms.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/delete16.png"))); // NOI18N
        jMenuItemDeleteAllZeroOccpAtoms.setText("Delete All Zero Occupancy Atoms");
        jMenuItemDeleteAllZeroOccpAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteAllZeroOccpAtomsActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemDeleteAllZeroOccpAtoms);

        jMenuItemDeleteAllAltConfAtoms.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/delete16.png"))); // NOI18N
        jMenuItemDeleteAllAltConfAtoms.setText("Delete All Alternate Conformation Atoms");
        jMenuItemDeleteAllAltConfAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteAllAltConfAtomsActionPerformed(evt);
            }
        });
        jMenuItemDeleteAllAltConfAtoms.addAncestorListener(new javax.swing.event.AncestorListener() {
            public void ancestorMoved(javax.swing.event.AncestorEvent evt) {
            }
            public void ancestorAdded(javax.swing.event.AncestorEvent evt) {
                jMenuItemDeleteAllAltConfAtomsAncestorAdded(evt);
            }
            public void ancestorRemoved(javax.swing.event.AncestorEvent evt) {
            }
        });
        jMenuDelete.add(jMenuItemDeleteAllAltConfAtoms);
        jMenuDelete.add(jSeparator16);

        jMenuItemDeleteAllAnisoB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/removecell16.png"))); // NOI18N
        jMenuItemDeleteAllAnisoB.setText("Delete Anisotropic Temp Factor from All Atoms");
        jMenuItemDeleteAllAnisoB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteAllAnisoBActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemDeleteAllAnisoB);

        jMenuItemDeleteAllSigmaXYZ.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/removecell16.png"))); // NOI18N
        jMenuItemDeleteAllSigmaXYZ.setText("Delete Sigma Coordinate from All Atoms");
        jMenuItemDeleteAllSigmaXYZ.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteAllSigmaXYZActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemDeleteAllSigmaXYZ);

        jMenuItemDeleteAllSigmaU.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/removecell16.png"))); // NOI18N
        jMenuItemDeleteAllSigmaU.setText("Delete Sigma U from All Atoms");
        jMenuItemDeleteAllSigmaU.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteAllSigmaUActionPerformed(evt);
            }
        });
        jMenuDelete.add(jMenuItemDeleteAllSigmaU);

        jMenuBar.add(jMenuDelete);

        jMenuSelect.setText("Select");

        jMenuItemSelectSearch.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectSearch.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/search16.png"))); // NOI18N
        jMenuItemSelectSearch.setText("Search and Select");
        jMenuItemSelectSearch.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectSearchActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectSearch);

        jMenuItemInvertSelection.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_I, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemInvertSelection.setText("Invert Selected Rows");
        jMenuItemInvertSelection.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemInvertSelectionActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemInvertSelection);
        jMenuSelect.add(jSeparator6);

        jMenuItemSelectAll.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_A, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectAll.setText("Select All Cells");
        jMenuItemSelectAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectAllActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectAll);

        jMenuItemSelectRow.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_R, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectRow.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/show_table_column16.png"))); // NOI18N
        jMenuItemSelectRow.setText("Select All Rows in Selected Columns");
        jMenuItemSelectRow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectRowActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectRow);

        jMenuItemSelectColumn.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_T, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectColumn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/show_table_row16.png"))); // NOI18N
        jMenuItemSelectColumn.setText("Select All Columns in Selected Rows");
        jMenuItemSelectColumn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectColumnActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectColumn);

        jMenuItemSelectChain.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.ALT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectChain.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/select16.png"))); // NOI18N
        jMenuItemSelectChain.setText("Select All Atoms in Selected Chains");
        jMenuItemSelectChain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectChainActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectChain);

        jMenuItemSelectResidue.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_R, java.awt.event.InputEvent.ALT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectResidue.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/select16.png"))); // NOI18N
        jMenuItemSelectResidue.setText("Select All Atoms in Selected Residues");
        jMenuItemSelectResidue.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectResidueActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectResidue);
        jMenuSelect.add(jSeparator4);

        jMenuItemSelectAllProteinAtoms.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_P, java.awt.event.InputEvent.ALT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectAllProteinAtoms.setText("Select All Protein Atoms");
        jMenuItemSelectAllProteinAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectAllProteinAtomsActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectAllProteinAtoms);

        jMenuItemSelectAllDNAAtoms.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_D, java.awt.event.InputEvent.ALT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectAllDNAAtoms.setText("Select All DNA Atoms");
        jMenuItemSelectAllDNAAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectAllDNAAtomsActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectAllDNAAtoms);

        jMenuItemSelectAllRNAAtoms.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_N, java.awt.event.InputEvent.ALT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectAllRNAAtoms.setText("Select All RNA Atoms");
        jMenuItemSelectAllRNAAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectAllRNAAtomsActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectAllRNAAtoms);

        jMenuItemSelectAllSolventAtoms.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.ALT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectAllSolventAtoms.setText("Select All Solvent Atoms");
        jMenuItemSelectAllSolventAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectAllSolventAtomsActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectAllSolventAtoms);

        jMenuItemSelectAllUncategorizedAtoms.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_U, java.awt.event.InputEvent.ALT_MASK | java.awt.event.InputEvent.CTRL_MASK));
        jMenuItemSelectAllUncategorizedAtoms.setText("Select All Unrecognized Residue Atoms");
        jMenuItemSelectAllUncategorizedAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSelectAllUncategorizedAtomsActionPerformed(evt);
            }
        });
        jMenuSelect.add(jMenuItemSelectAllUncategorizedAtoms);

        jMenuBar.add(jMenuSelect);

        jMenuModify.setText("Modify");

        jMenuItemEditSpacegroupUnitcell.setText("Edit Spacegroup & Unit Cell");
        jMenuItemEditSpacegroupUnitcell.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemEditSpacegroupUnitcellActionPerformed(evt);
            }
        });
        jMenuModify.add(jMenuItemEditSpacegroupUnitcell);

        jMenuItemEditResNumChainID.setText("Edit Residue Number & Chain ID");
        jMenuItemEditResNumChainID.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemEditResNumChainIDActionPerformed(evt);
            }
        });
        jMenuModify.add(jMenuItemEditResNumChainID);

        jMenuItemEditAtomConnectivity.setText("Edit Atom Connectivity");
        jMenuItemEditAtomConnectivity.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemEditAtomConnectivityActionPerformed(evt);
            }
        });
        jMenuModify.add(jMenuItemEditAtomConnectivity);
        jMenuModify.add(jSeparator10);

        jMenuItemResetAtomNumber.setText("Reset Atom Nuimber");
        jMenuItemResetAtomNumber.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemResetAtomNumberActionPerformed(evt);
            }
        });
        jMenuModify.add(jMenuItemResetAtomNumber);

        jMenuItemFixElement.setText("Fix Element from Atom Name");
        jMenuItemFixElement.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemFixElementActionPerformed(evt);
            }
        });
        jMenuModify.add(jMenuItemFixElement);

        jMenuItemCorrectAtomOrdering.setText("Correct Atom Ordering");
        jMenuItemCorrectAtomOrdering.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCorrectAtomOrderingActionPerformed(evt);
            }
        });
        jMenuModify.add(jMenuItemCorrectAtomOrdering);
        jMenuModify.add(jSeparator19);

        jMenuItemSortAtoms.setText("Sort Atoms with Multiple Criteria");
        jMenuItemSortAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSortAtomsActionPerformed(evt);
            }
        });
        jMenuModify.add(jMenuItemSortAtoms);

        jMenuSortAscending.setText("Sort Atoms Ascending");
        jMenuModify.add(jMenuSortAscending);

        jMenuSortDescending.setText("Sort Atoms Descending");
        jMenuModify.add(jMenuSortDescending);

        jMenuBar.add(jMenuModify);

        jMenuCalculate.setText("Calculate");

        jMenuItemGenerateSymmetryMates.setText("Generate Symmetry Mates");
        jMenuItemGenerateSymmetryMates.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemGenerateSymmetryMatesActionPerformed(evt);
            }
        });
        jMenuCalculate.add(jMenuItemGenerateSymmetryMates);

        jMenuItemRotateTranslateAtoms.setText("Rotate / Translate Atoms");
        jMenuItemRotateTranslateAtoms.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemRotateTranslateAtomsActionPerformed(evt);
            }
        });
        jMenuCalculate.add(jMenuItemRotateTranslateAtoms);
        jMenuCalculate.add(jSeparator18);

        jMenuItemCalculateNumberStatistics.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/calc16.png"))); // NOI18N
        jMenuItemCalculateNumberStatistics.setText("Calculate Number Statistics");
        jMenuItemCalculateNumberStatistics.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCalculateNumberStatisticsActionPerformed(evt);
            }
        });
        jMenuCalculate.add(jMenuItemCalculateNumberStatistics);

        jMenuItemExtractSequence.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/view_text16.png"))); // NOI18N
        jMenuItemExtractSequence.setText("Extract Sequence");
        jMenuItemExtractSequence.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemExtractSequenceActionPerformed(evt);
            }
        });
        jMenuCalculate.add(jMenuItemExtractSequence);

        jMenuItemFindClosestAtomDistances.setText("Find Closest Atom Distances");
        jMenuItemFindClosestAtomDistances.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemFindClosestAtomDistancesActionPerformed(evt);
            }
        });
        jMenuCalculate.add(jMenuItemFindClosestAtomDistances);
        jMenuCalculate.add(jSeparator9);

        jMenuItemReduceToCa.setText("Reduce Protein to Ca");
        jMenuItemReduceToCa.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemReduceToCaActionPerformed(evt);
            }
        });
        jMenuCalculate.add(jMenuItemReduceToCa);

        jMenuItemReduceToPolyALA.setText("Reduce Protein to Poly Ala");
        jMenuItemReduceToPolyALA.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemReduceToPolyALAActionPerformed(evt);
            }
        });
        jMenuCalculate.add(jMenuItemReduceToPolyALA);

        jMenuBar.add(jMenuCalculate);

        jMenuOption.setText("Option");

        jMenuItemColumnDisplayed.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/table16.png"))); // NOI18N
        jMenuItemColumnDisplayed.setText("Change Columns Displayed");
        jMenuItemColumnDisplayed.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemColumnDisplayedActionPerformed(evt);
            }
        });
        jMenuOption.add(jMenuItemColumnDisplayed);

        jMenuItem1.setText("Event Logger");
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });
        jMenuOption.add(jMenuItem1);
        jMenuOption.add(jSeparator13);

        jMenuItemAbout.setText("About");
        jMenuItemAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemAboutActionPerformed(evt);
            }
        });
        jMenuOption.add(jMenuItemAbout);

        jMenuBar.add(jMenuOption);

        setJMenuBar(jMenuBar);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jMenuItemOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemOpenActionPerformed
        LoadCoordinateFile();
        if (coordinateTable != null) coordinateTable.editingCanceled(null);
}//GEN-LAST:event_jMenuItemOpenActionPerformed

    private void jMenuItemNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNewActionPerformed
        NewCoordinateFile();
        if (coordinateTable != null) coordinateTable.editingCanceled(null);
    }//GEN-LAST:event_jMenuItemNewActionPerformed

    private void jMenuItemSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSaveActionPerformed
        SaveCoordinateFile();
        if (coordinateTable != null) coordinateTable.editingCanceled(null);
    }//GEN-LAST:event_jMenuItemSaveActionPerformed

    private void jMenuItemSaveAsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSaveAsActionPerformed
        SaveCoordinateFileAs();
        if (coordinateTable != null) coordinateTable.editingCanceled(null);
    }//GEN-LAST:event_jMenuItemSaveAsActionPerformed

    private void jMenuItemExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemExitActionPerformed
	this.dispose();
    }//GEN-LAST:event_jMenuItemExitActionPerformed

    private void jToolButtonNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToolButtonNewActionPerformed
        NewCoordinateFile();
    }//GEN-LAST:event_jToolButtonNewActionPerformed

    private void jToolButtonOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToolButtonOpenActionPerformed
        LoadCoordinateFile();
    }//GEN-LAST:event_jToolButtonOpenActionPerformed

    private void jToolButtonSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToolButtonSaveActionPerformed
        SaveCoordinateFile();
    }//GEN-LAST:event_jToolButtonSaveActionPerformed

    private void jMenuItemSelectAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectAllActionPerformed
        SelectAllRecord();
}//GEN-LAST:event_jMenuItemSelectAllActionPerformed

    private void jMenuItemDeleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteActionPerformed
        DeleteRecord();
}//GEN-LAST:event_jMenuItemDeleteActionPerformed

    private void jMenuItemEditActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemEditActionPerformed
        if (coordinateTable != null)
        {
            EditCoordinateData();
            coordinateTable.editingCanceled(null);
        }
    }//GEN-LAST:event_jMenuItemEditActionPerformed

    private void jMenuItemSelectRowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectRowActionPerformed
       if (coordinateTable != null)
       {
           coordinateTable.addColumnSelectionInterval(0, coordinateTable.getColumnCount() -1);
           coordinateTable.editingCanceled(null);
       }
}//GEN-LAST:event_jMenuItemSelectRowActionPerformed

    private void jMenuItemSelectColumnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectColumnActionPerformed
        if (coordinateTable != null)
        {
            coordinateTable.addRowSelectionInterval(0, coordinateTable.getRowCount() - 1);
            coordinateTable.editingCanceled(null);
        }
    }//GEN-LAST:event_jMenuItemSelectColumnActionPerformed

    private void jMenuItemCopyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCopyActionPerformed
        if (coordinateTable != null)
        {
            setClipboardContent(Global.FormatTabbedTextFromSelected(coordinateTable));
            this.StatusLabelChange((coordinateTable.getSelectedColumnCount() * coordinateTable.getSelectedRowCount()) + " cells copied onto the clipboard");
        }
    }//GEN-LAST:event_jMenuItemCopyActionPerformed

    private void jMenuItemCopyPDBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCopyPDBActionPerformed
        if (coordinateTable != null)
        {
           setClipboardContent(coordinateTable.GetPDBTextFromSelectedRows());
           this.StatusLabelChange(coordinateTable.getSelectedRowCount() + " atoms copied onto the clipboard in PDB format");
            coordinateTable.editingCanceled(null);
        }
    }//GEN-LAST:event_jMenuItemCopyPDBActionPerformed

    private void jMenuItemResetAtomNumberActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemResetAtomNumberActionPerformed
        if (coordinateTable != null)
        {
            this.listenForUndoStart("Reset atom numbers");
            maindata.ResetAtomNumbers();
            this.listenForUndoStop();
            coordinateTable.clearSelection();
            coordinateTable.addColumnSelectionInterval(coordinateTable.GetColumnIndex(Atom.ATOMNUMBER_INDEX), coordinateTable.GetColumnIndex(Atom.ATOMNUMBER_INDEX));
            coordinateTable.addRowSelectionInterval(0, coordinateTable.getRowCount() - 1);
        }
    }//GEN-LAST:event_jMenuItemResetAtomNumberActionPerformed

    private void jMenuItemColumnDisplayedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemColumnDisplayedActionPerformed
        if (maindata != null)
        {
            EditColumnListDialog ecd = new EditColumnListDialog(this, true, Atom.DataToolTip, coordinateTable.ListColumnDisplayed());
            ecd.show();
            if (ecd.returnValue() == 1) 
            {
                int[] newcolumnlist = ecd.selectedColumnIndicies();
                coordinateTable.setColumnIndex(newcolumnlist);
            }
            ecd.dispose();
        }
}//GEN-LAST:event_jMenuItemColumnDisplayedActionPerformed

    private void jToolButtonColumnDisplayedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToolButtonColumnDisplayedActionPerformed
        jMenuItemColumnDisplayedActionPerformed(null);
}//GEN-LAST:event_jToolButtonColumnDisplayedActionPerformed

    private void jMenuItemPasteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemPasteActionPerformed
        if (maindata != null)
        {
            PasteToCoordinateTable();
        }
}//GEN-LAST:event_jMenuItemPasteActionPerformed

    private void jMenuItemSelectChainActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectChainActionPerformed
        if (coordinateTable != null)
        {
            if (coordinateTable.getSelectedRowCount() != 0)
            {
                int[] rows = coordinateTable.getSelectedRows();
                HashMap<Character, Object> m  = new HashMap<Character, Object> ();
                for (int i=0; i<rows.length; i++)
                    m.put(maindata.Atoms().get(rows[i]).ChainID(), null);
                
                char[] chains = new char[m.keySet().size()];
                Iterator<Character> it = m.keySet().iterator();
                int j = 0;
                while (it.hasNext())
                    chains[j++] = it.next();
                
                for (int i=0; i<maindata.Atoms().size(); i++)
                {
                    if (Global.CharArrayContains(chains, maindata.Atoms().get(i).ChainID()))
                        coordinateTable.addRowSelectionInterval(i, i);
                }

                coordinateTable.editingCanceled(null);
            }
        }
    }//GEN-LAST:event_jMenuItemSelectChainActionPerformed

    private void jMenuItemSelectResidueActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectResidueActionPerformed
        if (coordinateTable != null)
        {
            if (coordinateTable.getSelectedRowCount() != 0)
            {
                int[] rows = coordinateTable.getSelectedRows();
                //String[] list = new String[rows.length];
                TreeSet<String> list = new TreeSet<String> ();
                for (int i=0; i<rows.length; i++)
                    list.add(((Integer)maindata.Atoms().get(rows[i]).ResidueNumber()).toString() + ' ' + ((Character)maindata.Atoms().get(rows[i]).ChainID()).toString()); 
                
                Atom a = null;
                String s = null;
                for (int i=0; i<maindata.Atoms().size(); i++)
                {
                    a = maindata.Atoms().get(i);
                    s = ((Integer)a.ResidueNumber()).toString() + ' ' + ((Character)a.ChainID()).toString();
                    //if (Global.StringArrayContains(list, s))
                    if (list.contains(s))
                        coordinateTable.addRowSelectionInterval(i, i);
                }
                coordinateTable.editingCanceled(null);
            }
        }
    }//GEN-LAST:event_jMenuItemSelectResidueActionPerformed

    private void jToolButtonEditCoordinateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToolButtonEditCoordinateActionPerformed
        if (coordinateTable != null)
                EditCoordinateData();
}//GEN-LAST:event_jToolButtonEditCoordinateActionPerformed

    private void jMenuItemSelectSearchActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectSearchActionPerformed
        if (coordinateTable != null)
        {
            SearchSelectDialog ssd = new SearchSelectDialog(this, false, coordinateTable);
            ssd.show();
            coordinateTable.editingCanceled(null);
        }
}//GEN-LAST:event_jMenuItemSelectSearchActionPerformed

    private void jToolButtonSearchSelectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToolButtonSearchSelectActionPerformed
        jMenuItemSelectSearchActionPerformed(null);
}//GEN-LAST:event_jToolButtonSearchSelectActionPerformed

    private void jMenuItemDeleteHAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteHAtomsActionPerformed
        if (coordinateTable != null)
        {
        this.listenForUndoStart("Delete selected H atoms");
        CoordinateTypeSelectedDelete(new AtomSelector() {
            public boolean selectAtom(Atom a) {
                 if (a.Element().equals("H"))
                     return true;
                 return false;
            }
            public boolean selectAtom(Atom a, Object Value) {
                return false;
            }
        });
        this.listenForUndoStop();
        }
    }//GEN-LAST:event_jMenuItemDeleteHAtomsActionPerformed

    private void jMenuItemZeroOccpAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemZeroOccpAtomsActionPerformed
        if (coordinateTable != null)
        {
        this.listenForUndoStart("Delete selected zero occupancies");
        CoordinateTypeSelectedDelete(new AtomSelector() {
            public boolean selectAtom(Atom a) {
                 if (a.Occupancy() == 0)
                     return true;
                 return false;
            }
            public boolean selectAtom(Atom a, Object Value) {
                return false;
            }
        });
        this.listenForUndoStop();
        }
    }//GEN-LAST:event_jMenuItemZeroOccpAtomsActionPerformed

    private void jMenuItemDeleteAllAltConfAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteAllAltConfAtomsActionPerformed
        if (coordinateTable != null)
        {
            this.listenForUndoStart("Delete all alternate conformation");
            int count = maindata.deleteAlternateConformation();
            this.listenForUndoStop();
            coordinateTable.fireTableDataChanged();
            this.StatusLabelChange(count + " coordinates deleted");
        }
}//GEN-LAST:event_jMenuItemDeleteAllAltConfAtomsActionPerformed

    private void jMenuItemDeleteAllHAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteAllHAtomsActionPerformed
        if (coordinateTable != null)
        {
        this.listenForUndoStart("Delete all H atoms");
        CoordinateTypeDelete(new AtomSelector() {
            public boolean selectAtom(Atom a) {
                 if (a.Element().equals("H"))
                     return true;
                 return false;
            }
            public boolean selectAtom(Atom a, Object Value) {
                return false;
            }
        });
        this.listenForUndoStop();
        }
    }//GEN-LAST:event_jMenuItemDeleteAllHAtomsActionPerformed

    private void jMenuItemDeleteAllZeroOccpAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteAllZeroOccpAtomsActionPerformed
        if (coordinateTable != null)
        {
            this.listenForUndoStart("Delete all zero occupancies");
            CoordinateTypeDelete(new AtomSelector() {
            public boolean selectAtom(Atom a) {
                 if (a.Occupancy() == 0)
                     return true;
                 return false;
            }
            public boolean selectAtom(Atom a, Object Value) {
                return false;
            }
        });
        this.listenForUndoStop();
        }
    }//GEN-LAST:event_jMenuItemDeleteAllZeroOccpAtomsActionPerformed

    private void jMenuItemAltConfAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAltConfAtomsActionPerformed
        if (coordinateTable != null)
        {
            this.listenForUndoStart("Delete selected alternate conformation");
            maindata.deleteAlternateConformation(coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            coordinateTable.fireTableDataChanged();
        }
    }//GEN-LAST:event_jMenuItemAltConfAtomsActionPerformed

    private void jMenuItemDeleteAllAltConfAtomsAncestorAdded(javax.swing.event.AncestorEvent evt) {//GEN-FIRST:event_jMenuItemDeleteAllAltConfAtomsAncestorAdded

    }//GEN-LAST:event_jMenuItemDeleteAllAltConfAtomsAncestorAdded

    private void jMenuItemFixElementActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemFixElementActionPerformed
        if (coordinateTable != null)
        {
            this.listenForUndoStart("Fix element from atom name");
            Integer[] list = maindata.fixElementInformation();
            this.listenForUndoStop();
            if (list != null)
            {
                coordinateTable.clearSelection();
                coordinateTable.addColumnSelectionInterval(coordinateTable.GetColumnIndex(Atom.ELEMENT_INDEX), coordinateTable.GetColumnIndex(Atom.ELEMENT_INDEX));
                for (int i=0; i<list.length; i++)
                {
                    coordinateTable.fireTableRowUpdated(list[i], list[i]);
                    coordinateTable.addRowSelectionInterval(list[i], list[i]);
                }
            }
        }  
    }//GEN-LAST:event_jMenuItemFixElementActionPerformed

    private void jMenuItemCalculateNumberStatisticsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCalculateNumberStatisticsActionPerformed
       if (coordinateTable != null)
       {
           CalculateNumberStatisticsDialog d = new CalculateNumberStatisticsDialog(this, true, maindata.calculateStatistics(), maindata.calculateStatistics(coordinateTable.getSelectedRows()));
           d.show();
       }
    }//GEN-LAST:event_jMenuItemCalculateNumberStatisticsActionPerformed

    private void jMenuItemSelectAllProteinAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectAllProteinAtomsActionPerformed
       if (coordinateTable != null)
           selectCoordinateTableRows(maindata.getIndicesOfResidueType("Protein"));
    }//GEN-LAST:event_jMenuItemSelectAllProteinAtomsActionPerformed

    private void jMenuItemSelectAllDNAAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectAllDNAAtomsActionPerformed
       if (coordinateTable != null)
           selectCoordinateTableRows(maindata.getIndicesOfResidueType("DNA"));
    }//GEN-LAST:event_jMenuItemSelectAllDNAAtomsActionPerformed

    private void jMenuItemSelectAllRNAAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectAllRNAAtomsActionPerformed
       if (coordinateTable != null)
           selectCoordinateTableRows(maindata.getIndicesOfResidueType("RNA"));
    }//GEN-LAST:event_jMenuItemSelectAllRNAAtomsActionPerformed

    private void jMenuItemSelectAllSolventAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectAllSolventAtomsActionPerformed
       if (coordinateTable != null)
           selectCoordinateTableRows(maindata.getIndicesOfResidueType("Solvent"));
    }//GEN-LAST:event_jMenuItemSelectAllSolventAtomsActionPerformed

    private void jMenuItemSelectAllUncategorizedAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSelectAllUncategorizedAtomsActionPerformed
       if (coordinateTable != null)
           selectCoordinateTableRows(maindata.getIndicesOfUnclassifiedType());
    }//GEN-LAST:event_jMenuItemSelectAllUncategorizedAtomsActionPerformed

    private void jMenuItemRotateTranslateAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemRotateTranslateAtomsActionPerformed
      if (coordinateTable != null)
      {
          RotateTranslateAtomsDialog rtad = new RotateTranslateAtomsDialog(this, false, coordinateTable);
          rtad.show();
      }
      
    }//GEN-LAST:event_jMenuItemRotateTranslateAtomsActionPerformed

    private void jMenuItemEditSpacegroupUnitcellActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemEditSpacegroupUnitcellActionPerformed
      if (coordinateTable != null)
      {
          EditSpacegroupDialog esd = new EditSpacegroupDialog(this, true, maindata);
          esd.show();
          coordinateTable.fireTableDataChanged();
      }
}//GEN-LAST:event_jMenuItemEditSpacegroupUnitcellActionPerformed

    private void jMenuItemGenerateSymmetryMatesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemGenerateSymmetryMatesActionPerformed
      if (coordinateTable != null)
      {
          if (maindata.Spacegroup().symmetryOperators() != null)
          {
              GenerateSymmetryMateDialog gsmd = new GenerateSymmetryMateDialog(this, false, coordinateTable);
              gsmd.show();
          }
          else
          {
              JOptionPane.showMessageDialog(this, "No spacegroup information available\nDo Edit Spacegroup Unit Cell first", "Error", JOptionPane.ERROR_MESSAGE);
          }
      }
    }//GEN-LAST:event_jMenuItemGenerateSymmetryMatesActionPerformed

    private void jToolButtonNewMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonNewMouseEntered
        this.StatusLabelTemporary("Create new coordinate file");
    }//GEN-LAST:event_jToolButtonNewMouseEntered

    private void jToolButtonNewMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonNewMouseExited
       this.StatusLabelTemporaryEnd();
    }//GEN-LAST:event_jToolButtonNewMouseExited

    private void jToolButtonOpenMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonOpenMouseEntered
        this.StatusLabelTemporary("Open coordinate file");
    }//GEN-LAST:event_jToolButtonOpenMouseEntered

    private void jToolButtonOpenMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonOpenMouseExited
       this.StatusLabelTemporaryEnd();
    }//GEN-LAST:event_jToolButtonOpenMouseExited

    private void jToolButtonSaveMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonSaveMouseEntered
        this.StatusLabelTemporary("Save coordinate file");
    }//GEN-LAST:event_jToolButtonSaveMouseEntered

    private void jToolButtonSaveMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonSaveMouseExited
        this.StatusLabelTemporaryEnd();
    }//GEN-LAST:event_jToolButtonSaveMouseExited

    private void jToolButtonSearchSelectMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonSearchSelectMouseEntered
        this.StatusLabelTemporary("Search and select atoms");
    }//GEN-LAST:event_jToolButtonSearchSelectMouseEntered

    private void jToolButtonSearchSelectMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonSearchSelectMouseExited
        this.StatusLabelTemporaryEnd();
    }//GEN-LAST:event_jToolButtonSearchSelectMouseExited

    private void jToolButtonEditCoordinateMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonEditCoordinateMouseEntered
        this.StatusLabelTemporary("Edit selected atoms");
    }//GEN-LAST:event_jToolButtonEditCoordinateMouseEntered

    private void jToolButtonEditCoordinateMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonEditCoordinateMouseExited
        this.StatusLabelTemporaryEnd();
    }//GEN-LAST:event_jToolButtonEditCoordinateMouseExited

    private void jToolButtonColumnDisplayedMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonColumnDisplayedMouseEntered
        this.StatusLabelTemporary("Change columns displayed");
    }//GEN-LAST:event_jToolButtonColumnDisplayedMouseEntered

    private void jToolButtonColumnDisplayedMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonColumnDisplayedMouseExited
        this.StatusLabelTemporaryEnd();
    }//GEN-LAST:event_jToolButtonColumnDisplayedMouseExited

    private void jMenuItemFindClosestAtomDistancesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemFindClosestAtomDistancesActionPerformed
        if (this.coordinateTable != null)
        {
            FindClosestAtomDistancesDialog fcad = new FindClosestAtomDistancesDialog(this, false, coordinateTable);
            fcad.show();
        }
    }//GEN-LAST:event_jMenuItemFindClosestAtomDistancesActionPerformed

    private void jMenuItemExtractSequenceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemExtractSequenceActionPerformed
       if (this.coordinateTable != null)
        {
            ExtractSequenceDialog ESD = new ExtractSequenceDialog(this, false, coordinateTable);
            ESD.show();
        }
    }//GEN-LAST:event_jMenuItemExtractSequenceActionPerformed

    private void jToolButtonCopyMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonCopyMouseEntered
        this.StatusLabelTemporary("Copy selected cell entries in line/tab delimited format");
}//GEN-LAST:event_jToolButtonCopyMouseEntered

    private void jToolButtonCopyMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonCopyMouseExited
        this.StatusLabelTemporaryEnd();
}//GEN-LAST:event_jToolButtonCopyMouseExited

    private void jToolButtonCopyPDBMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonCopyPDBMouseEntered
        this.StatusLabelTemporary("Copy selected atoms in PDB text format");
}//GEN-LAST:event_jToolButtonCopyPDBMouseEntered

    private void jToolButtonCopyPDBMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonCopyPDBMouseExited
        this.StatusLabelTemporaryEnd();
}//GEN-LAST:event_jToolButtonCopyPDBMouseExited

    private void jToolButtonPasteMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonPasteMouseEntered
        this.StatusLabelTemporary("Paste data from the clipboard - line/tab delimited or PDB text");
}//GEN-LAST:event_jToolButtonPasteMouseEntered

    private void jToolButtonPasteMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonPasteMouseExited
        this.StatusLabelTemporaryEnd();
}//GEN-LAST:event_jToolButtonPasteMouseExited

    private void jToolButtonCalculateStatisticsMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonCalculateStatisticsMouseEntered
        this.StatusLabelTemporary("Calculate average/standard deviation of numerical data");
}//GEN-LAST:event_jToolButtonCalculateStatisticsMouseEntered

    private void jToolButtonCalculateStatisticsMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonCalculateStatisticsMouseExited
        this.StatusLabelTemporaryEnd();
}//GEN-LAST:event_jToolButtonCalculateStatisticsMouseExited

    private void jToolButtonExtractSequenceMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonExtractSequenceMouseEntered
        this.StatusLabelTemporary("Extract and display residue sequence");
}//GEN-LAST:event_jToolButtonExtractSequenceMouseEntered

    private void jToolButtonExtractSequenceMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonExtractSequenceMouseExited
        this.StatusLabelTemporaryEnd();
}//GEN-LAST:event_jToolButtonExtractSequenceMouseExited

    private void jMenuItemAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAboutActionPerformed
        this.jDialogAbout.show(true);
    }//GEN-LAST:event_jMenuItemAboutActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        this.jDialogAbout.hide();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        this.setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        if (dataChangeNotSaved)
        {
            Object[] options = {"Yes", "No", "Cancel"};
            int n = JOptionPane.showOptionDialog(this,
                "Save changes before closing?",
                "Changes have not been saved",
                JOptionPane.YES_NO_CANCEL_OPTION,
                JOptionPane.QUESTION_MESSAGE,
                null,
                options,
                options[2]);
            switch (n)
            {
                case 0 : this.SaveCoordinateFile(); break;
                case 2 : this.setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
            }
        }
    }//GEN-LAST:event_formWindowClosing

    private void jEventLoggerButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jEventLoggerButtonCloseActionPerformed
        this.maindata.removeDataChangeListener(eventLoggerListener);
        this.jDialogEventLogger.hide();
    }//GEN-LAST:event_jEventLoggerButtonCloseActionPerformed

    private void jEventLoggerButtonClearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jEventLoggerButtonClearActionPerformed
        this.jEventLoggerTextArea.setText("");
    }//GEN-LAST:event_jEventLoggerButtonClearActionPerformed

    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
        if (coordinateTable != null)
        {
            this.jDialogEventLogger.show();
            this.maindata.addDataChangeListener(eventLoggerListener);
        }
    }//GEN-LAST:event_jMenuItem1ActionPerformed

    private void jMenuItemUndoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemUndoActionPerformed
        if (coordinateTable != null)
        {
            undoPerform();
            coordinateTable.editingCanceled(null);
        }
    }//GEN-LAST:event_jMenuItemUndoActionPerformed

    private void jMenuItemRedoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemRedoActionPerformed
        if (coordinateTable != null)
        {
            redoPerform();
            coordinateTable.editingCanceled(null);
        }
    }//GEN-LAST:event_jMenuItemRedoActionPerformed

    private void jMenuItemDeleteSelectedAnisoBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteSelectedAnisoBActionPerformed
        this.setColumnValueToNull(Atom.U11_INDEX, "Delete selected anisotropic temp factor", false);
    }//GEN-LAST:event_jMenuItemDeleteSelectedAnisoBActionPerformed

    private void jMenuItemDeleteSelectedSigmaXYZActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteSelectedSigmaXYZActionPerformed
        this.setColumnValueToNull(Atom.SIGMAX_INDEX, "Delete selected sigma coordinates", false);
    }//GEN-LAST:event_jMenuItemDeleteSelectedSigmaXYZActionPerformed

    private void jMenuItemDeleteSelectedSigmaUActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteSelectedSigmaUActionPerformed
        this.setColumnValueToNull(Atom.SIGMAU11_INDEX, "Delete selected sigma U", false);
    }//GEN-LAST:event_jMenuItemDeleteSelectedSigmaUActionPerformed

    private void jMenuItemDeleteAllAnisoBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteAllAnisoBActionPerformed
        this.setColumnValueToNull(Atom.U11_INDEX, "Delete all anisotropic temp factor", true);
    }//GEN-LAST:event_jMenuItemDeleteAllAnisoBActionPerformed

    private void jMenuItemDeleteAllSigmaXYZActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteAllSigmaXYZActionPerformed
        this.setColumnValueToNull(Atom.SIGMAX_INDEX, "Delete all sigma coordinates", true);
    }//GEN-LAST:event_jMenuItemDeleteAllSigmaXYZActionPerformed

    private void jMenuItemDeleteAllSigmaUActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteAllSigmaUActionPerformed
        this.setColumnValueToNull(Atom.SIGMAU11_INDEX, "Delete all sigma U", true);
    }//GEN-LAST:event_jMenuItemDeleteAllSigmaUActionPerformed

    private void jMenuItemMoveUpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemMoveUpActionPerformed
        MoveUpSelectedAtoms();
    }//GEN-LAST:event_jMenuItemMoveUpActionPerformed

    public void MoveUpSelectedAtoms()
    {
        if (coordinateTable != null)
        {
            int[] columnselection = coordinateTable.getSelectedColumns();
            this.listenForUndoStart("Move atoms up");
            int[] rowselection = maindata.MoveUpIndex(coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            coordinateTable.fireTableDataChanged();
            coordinateTable.addRowSelectionIndicies(rowselection);
            coordinateTable.addColumnSelectionIndicies(columnselection);
        }
    }
    
    private void jMenuItemMoveDownActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemMoveDownActionPerformed
        MoveDownSelectedAtoms();
    }//GEN-LAST:event_jMenuItemMoveDownActionPerformed

    public void MoveDownSelectedAtoms()
    {
        if (coordinateTable != null)
        {
            int[] columnselection = coordinateTable.getSelectedColumns();
            this.listenForUndoStart("Move atoms down");
            int[] rowselection = maindata.MoveDownIndex(coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            coordinateTable.fireTableDataChanged();
            coordinateTable.addRowSelectionIndicies(rowselection);
            coordinateTable.addColumnSelectionIndicies(columnselection);
        }
    }
    
    private void jMenuItemMoveTopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemMoveTopActionPerformed
        MoveTopSelectedAtoms();
    }//GEN-LAST:event_jMenuItemMoveTopActionPerformed

    public void MoveTopSelectedAtoms()
    {
        if (coordinateTable != null)
        {
            int[] columnselection = coordinateTable.getSelectedColumns();
            this.listenForUndoStart("Move atoms to top");
            int[] rowselection = maindata.MoveTopIndex(coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            coordinateTable.fireTableDataChanged();
            coordinateTable.addRowSelectionIndicies(rowselection);
            coordinateTable.addColumnSelectionIndicies(columnselection);
        }        
    }
    
    private void jMenuItemMoveBottomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemMoveBottomActionPerformed
        MoveBottomSelectedAtoms();
    }//GEN-LAST:event_jMenuItemMoveBottomActionPerformed

    public void MoveBottomSelectedAtoms()
    {
        if (coordinateTable != null)
        {
            int[] columnselection = coordinateTable.getSelectedColumns();
            this.listenForUndoStart("Move atoms to bottom");
            int[] rowselection = maindata.MoveBottomIndex(coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            coordinateTable.fireTableDataChanged();
            coordinateTable.addRowSelectionIndicies(rowselection);
            coordinateTable.addColumnSelectionIndicies(columnselection);
        }        
    }
    
    private void jToolButtonCutPDBMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonCutPDBMouseEntered
        this.StatusLabelTemporary("Cut selected atoms in PDB text format");
}//GEN-LAST:event_jToolButtonCutPDBMouseEntered

    private void jToolButtonCutPDBMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonCutPDBMouseExited
        this.StatusLabelTemporaryEnd();
}//GEN-LAST:event_jToolButtonCutPDBMouseExited

    private void jToolButtonCutPDBjMenuItemCopyPDBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToolButtonCutPDBjMenuItemCopyPDBActionPerformed
        jMenuItemCutPDBActionPerformed(null);
}//GEN-LAST:event_jToolButtonCutPDBjMenuItemCopyPDBActionPerformed
    
    public void CutAsPDBAtom()
    {
        if (coordinateTable != null)
        {
            this.listenForUndoStart("Cut as PDB");
            this.jMenuItemCopyPDBActionPerformed(null);
            maindata.DeleteAtoms(coordinateTable.getSelectedRows());
            this.listenForUndoStop();
            coordinateTable.fireTableDataChanged();
            
        }        
    }
    
    private void jMenuItemCutPDBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCutPDBActionPerformed
        CutAsPDBAtom();
    }//GEN-LAST:event_jMenuItemCutPDBActionPerformed

    private void jMenuItemSortAtomsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSortAtomsActionPerformed
        if (coordinateTable != null)
        {
            SortAtomsDialog SAD = new SortAtomsDialog(this, false, coordinateTable);
            SAD.show();
        }
    }//GEN-LAST:event_jMenuItemSortAtomsActionPerformed

    private void jMenuItemCorrectAtomOrderingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCorrectAtomOrderingActionPerformed
        if (coordinateTable != null)
        {
            this.listenForUndoStart("Correct atom ordering");
            maindata.Sort(new int[] {
                Atom.CHAINID_INDEX,
                Atom.RESIDUENUMBER_INDEX,
                Atom.RESIDUETYPE_INDEX,
                Atom.ATOMNAME_INDEX,
                Atom.ALTERNATELOCATION_INDEX
            }, new boolean[] {
                false,
                false,
                false,
                false,
                false
            });
            maindata.ResetAtomNumbers();
            this.listenForUndoStop();
            coordinateTable.fireTableDataChanged();
        }
}//GEN-LAST:event_jMenuItemCorrectAtomOrderingActionPerformed

private void jMenuItemEditResNumChainIDActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemEditResNumChainIDActionPerformed
        if (coordinateTable != null)
        {
            EditResidueNumberDialog ERND = new EditResidueNumberDialog(this, false, coordinateTable);
            ERND.show();
        }
}//GEN-LAST:event_jMenuItemEditResNumChainIDActionPerformed

private void jMenuItemReduceToCaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemReduceToCaActionPerformed
    if (coordinateTable != null)
    {
        int[] value = RunAtomSelectorDialogGetIndicies("Reduce Protein to Ca", AtomSelectorDialog.ALL_ATOMS);
        if (value != null)
        {
            this.listenForUndoStart("Reduce protein to Ca");
            maindata.ReduceProteinResiduesToCa(value);
            this.listenForUndoStop();
            coordinateTable.fireTableDataChanged();
            this.StatusLabelChange("Reduced protein to Ca");
        }
        else
        {
            this.StatusLabelChange("Cancelled - Reduce protein to Ca");
        }
    }
}//GEN-LAST:event_jMenuItemReduceToCaActionPerformed

private void jMenuItemReduceToPolyALAActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemReduceToPolyALAActionPerformed
    if (coordinateTable != null)
    {
        int[] value = RunAtomSelectorDialogGetIndicies("Reduce protein to poly Ala", AtomSelectorDialog.ALL_ATOMS);
        if (value != null)
        {
            this.listenForUndoStart("Reduce protein to poly Ala");
            maindata.ReduceProteinResiduesToPolyALA(value);
            this.listenForUndoStop();
            coordinateTable.fireTableDataChanged();
            this.StatusLabelChange("Reduced protein to poly Ala");
        }
        else
        {
            this.StatusLabelChange("Cancelled - Reduce protein to poly Ala");
        }
    }
}//GEN-LAST:event_jMenuItemReduceToPolyALAActionPerformed

private void jMenuItemInvertSelectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemInvertSelectionActionPerformed
    if (coordinateTable != null)
    {
        coordinateTable.invertSelectedRows();
        coordinateTable.editingCanceled(null);
    }
}//GEN-LAST:event_jMenuItemInvertSelectionActionPerformed

private void jMenuItemCopySpacegroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCopySpacegroupActionPerformed
    if (coordinateTable != null)
    {
        if (maindata.Spacegroup() != null)
        {
            setClipboardContent(maindata.Spacegroup().WritePDBSpaceGroupLines());
            this.StatusLabelChange("Copied spacegroup information in PDB format to clipboard");
            coordinateTable.editingCanceled(null);
        }
    }
}//GEN-LAST:event_jMenuItemCopySpacegroupActionPerformed

private void jMenuItemInsertEmptyAtomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemInsertEmptyAtomActionPerformed
    if (maindata != null)
    {
        int[] selcols = coordinateTable.getSelectedColumns();
        int row = coordinateTable.getSelectedRow();
        if (row < 0) row = 0;
        maindata.InsertEmptyAtom(row);
        coordinateTable.fireTableDataChanged();
        coordinateTable.addColumnSelectionIndicies(selcols);
        coordinateTable.addRowSelectionInterval(row, row);
        coordinateTable.editingCanceled(null);
    }
}//GEN-LAST:event_jMenuItemInsertEmptyAtomActionPerformed

private void jToolButtonSaveAsMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonSaveAsMouseEntered
        this.StatusLabelTemporary("Save coordinate file as...");
}//GEN-LAST:event_jToolButtonSaveAsMouseEntered

private void jToolButtonSaveAsMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jToolButtonSaveAsMouseExited
    this.StatusLabelTemporaryEnd();
}//GEN-LAST:event_jToolButtonSaveAsMouseExited

private void jToolButtonSaveAsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToolButtonSaveAsActionPerformed
    this.jMenuItemSaveAsActionPerformed(evt);
}//GEN-LAST:event_jToolButtonSaveAsActionPerformed

private void jMenuItemEditAtomConnectivityActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemEditAtomConnectivityActionPerformed
    if (coordinateTable != null)
    {
        EditConnectivityDialog ECD = new EditConnectivityDialog(this, false, coordinateTable);
        ECD.show();
    }
}//GEN-LAST:event_jMenuItemEditAtomConnectivityActionPerformed
    
private int RunAtomSelectorDialog(String WindowTitle, int DefaultValue)
{
    AtomSelectorDialog ASD = new AtomSelectorDialog(this, true, WindowTitle, DefaultValue);
    ASD.show();
    int value = ASD.Value;
    ASD.dispose();
    return value;
}

private int[] RunAtomSelectorDialogGetIndicies(String WindowTitle, int DefaultValue)
{
    int value = RunAtomSelectorDialog(WindowTitle, DefaultValue);
    int[] selrows = coordinateTable.getSelectedRows();
    switch (value)
    {
        case AtomSelectorDialog.CANCELLED : return null;
        case AtomSelectorDialog.ALL_ATOMS : return Global.GenerateIntegerIndiciesArray(maindata.Atoms().size());
        case AtomSelectorDialog.SELECTED_ATOMS : return selrows;
        case AtomSelectorDialog.SELECTED_CHAINS : return maindata.getChainIndicies(selrows);
        case AtomSelectorDialog.SELECTED_RESIDUES : return maindata.getResiduesIndicies(selrows);
    }
    return null;
}

    
    private DataSetDataChangeEventListener dataChangeNotSavedListener = new DataSetDataChangeEventListener() {
        public void dataChanged(DataSetDataChangeEvent e) {
            dataChangeNotSaved = true;
        }
    };
    private DataSetDataChangeEventListener eventLoggerListener = new DataSetDataChangeEventListener() {
        public void dataChanged(DataSetDataChangeEvent e) {
            StringBuilder output = new StringBuilder();
            output.append((new java.util.Date ()).toString());
            output.append(" : ");
            switch (e.eventCode)
            {
                case DataSetDataChangeEvent.ADD_EVENT : 
                    output.append("Added Atom#" + e.atomChanged.AtomNumber()); 
                    break;
                case DataSetDataChangeEvent.DELETE_EVENT : 
                    output.append("Deleted Atom#" + e.atomChanged.AtomNumber()); 
                    break;
                case DataSetDataChangeEvent.CHANGE_EVENT : 
                    output.append("Changed Atom#" + e.atomChanged.AtomNumber()); 
                    output.append(' ' + Atom.DataToolTip[e.atomChangeEvent.dataEntryAffected] + " from " + e.atomChangeEvent.oldValue);
                    break;
            }
            output.append('\n');
            jEventLoggerTextArea.append(output.toString());
        }
    };  
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JDialog jDialogAbout;
    private javax.swing.JDialog jDialogEventLogger;
    private javax.swing.JButton jEventLoggerButtonClear;
    private javax.swing.JButton jEventLoggerButtonClose;
    private javax.swing.JTextArea jEventLoggerTextArea;
    private javax.swing.JFileChooser jFileChooser;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JMenuBar jMenuBar;
    private javax.swing.JMenu jMenuCalculate;
    private javax.swing.JMenu jMenuDelete;
    private javax.swing.JMenu jMenuEdit;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItemAbout;
    private javax.swing.JMenuItem jMenuItemAltConfAtoms;
    private javax.swing.JMenuItem jMenuItemCalculateNumberStatistics;
    private javax.swing.JMenuItem jMenuItemColumnDisplayed;
    private javax.swing.JMenuItem jMenuItemCopy;
    private javax.swing.JMenuItem jMenuItemCopyPDB;
    private javax.swing.JMenuItem jMenuItemCopySpacegroup;
    private javax.swing.JMenuItem jMenuItemCorrectAtomOrdering;
    private javax.swing.JMenuItem jMenuItemCutPDB;
    private javax.swing.JMenuItem jMenuItemDelete;
    private javax.swing.JMenuItem jMenuItemDeleteAllAltConfAtoms;
    private javax.swing.JMenuItem jMenuItemDeleteAllAnisoB;
    private javax.swing.JMenuItem jMenuItemDeleteAllHAtoms;
    private javax.swing.JMenuItem jMenuItemDeleteAllSigmaU;
    private javax.swing.JMenuItem jMenuItemDeleteAllSigmaXYZ;
    private javax.swing.JMenuItem jMenuItemDeleteAllZeroOccpAtoms;
    private javax.swing.JMenuItem jMenuItemDeleteHAtoms;
    private javax.swing.JMenuItem jMenuItemDeleteSelectedAnisoB;
    private javax.swing.JMenuItem jMenuItemDeleteSelectedSigmaU;
    private javax.swing.JMenuItem jMenuItemDeleteSelectedSigmaXYZ;
    private javax.swing.JMenuItem jMenuItemEdit;
    private javax.swing.JMenuItem jMenuItemEditAtomConnectivity;
    private javax.swing.JMenuItem jMenuItemEditResNumChainID;
    private javax.swing.JMenuItem jMenuItemEditSpacegroupUnitcell;
    private javax.swing.JMenuItem jMenuItemExit;
    private javax.swing.JMenuItem jMenuItemExtractSequence;
    private javax.swing.JMenuItem jMenuItemFindClosestAtomDistances;
    private javax.swing.JMenuItem jMenuItemFixElement;
    private javax.swing.JMenuItem jMenuItemGenerateSymmetryMates;
    private javax.swing.JMenuItem jMenuItemInsertEmptyAtom;
    private javax.swing.JMenuItem jMenuItemInvertSelection;
    private javax.swing.JMenuItem jMenuItemMoveBottom;
    private javax.swing.JMenuItem jMenuItemMoveDown;
    private javax.swing.JMenuItem jMenuItemMoveTop;
    private javax.swing.JMenuItem jMenuItemMoveUp;
    private javax.swing.JMenuItem jMenuItemNew;
    private javax.swing.JMenuItem jMenuItemOpen;
    private javax.swing.JMenuItem jMenuItemPaste;
    private javax.swing.JMenuItem jMenuItemRedo;
    private javax.swing.JMenuItem jMenuItemReduceToCa;
    private javax.swing.JMenuItem jMenuItemReduceToPolyALA;
    private javax.swing.JMenuItem jMenuItemResetAtomNumber;
    private javax.swing.JMenuItem jMenuItemRotateTranslateAtoms;
    private javax.swing.JMenuItem jMenuItemSave;
    private javax.swing.JMenuItem jMenuItemSaveAs;
    private javax.swing.JMenuItem jMenuItemSelectAll;
    private javax.swing.JMenuItem jMenuItemSelectAllDNAAtoms;
    private javax.swing.JMenuItem jMenuItemSelectAllProteinAtoms;
    private javax.swing.JMenuItem jMenuItemSelectAllRNAAtoms;
    private javax.swing.JMenuItem jMenuItemSelectAllSolventAtoms;
    private javax.swing.JMenuItem jMenuItemSelectAllUncategorizedAtoms;
    private javax.swing.JMenuItem jMenuItemSelectChain;
    private javax.swing.JMenuItem jMenuItemSelectColumn;
    private javax.swing.JMenuItem jMenuItemSelectResidue;
    private javax.swing.JMenuItem jMenuItemSelectRow;
    private javax.swing.JMenuItem jMenuItemSelectSearch;
    private javax.swing.JMenuItem jMenuItemSortAtoms;
    private javax.swing.JMenuItem jMenuItemUndo;
    private javax.swing.JMenuItem jMenuItemZeroOccpAtoms;
    private javax.swing.JMenu jMenuModify;
    private javax.swing.JMenu jMenuOption;
    private javax.swing.JMenu jMenuSelect;
    private javax.swing.JMenu jMenuSortAscending;
    private javax.swing.JMenu jMenuSortDescending;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator10;
    private javax.swing.JToolBar.Separator jSeparator11;
    private javax.swing.JToolBar.Separator jSeparator12;
    private javax.swing.JSeparator jSeparator13;
    private javax.swing.JSeparator jSeparator14;
    private javax.swing.JSeparator jSeparator15;
    private javax.swing.JSeparator jSeparator16;
    private javax.swing.JSeparator jSeparator17;
    private javax.swing.JSeparator jSeparator18;
    private javax.swing.JSeparator jSeparator19;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator20;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JToolBar.Separator jSeparator5;
    private javax.swing.JSeparator jSeparator6;
    private javax.swing.JSeparator jSeparator7;
    private javax.swing.JSeparator jSeparator8;
    private javax.swing.JSeparator jSeparator9;
    private javax.swing.JLabel jStatusLabel;
    private javax.swing.JLabel jStatusLabelIndent;
    private javax.swing.JTabbedPane jTabbedPane;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JToolBar jToolBarMain;
    private javax.swing.JToolBar jToolBarStatus;
    private javax.swing.JButton jToolButtonCalculateStatistics;
    private javax.swing.JButton jToolButtonColumnDisplayed;
    private javax.swing.JButton jToolButtonCopy;
    private javax.swing.JButton jToolButtonCopyPDB;
    private javax.swing.JButton jToolButtonCutPDB;
    private javax.swing.JButton jToolButtonEditCoordinate;
    private javax.swing.JButton jToolButtonExtractSequence;
    private javax.swing.JButton jToolButtonNew;
    private javax.swing.JButton jToolButtonOpen;
    private javax.swing.JButton jToolButtonPaste;
    private javax.swing.JButton jToolButtonSave;
    private javax.swing.JButton jToolButtonSaveAs;
    private javax.swing.JButton jToolButtonSearchSelect;
    // End of variables declaration//GEN-END:variables

    
}
