/*
 * CalculateNumberStatisticsDialog.java
 *
 * Created on March 16, 2008, 9:14 AM
 */

package pdb_editor.dialogs;

import java.util.Iterator;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import pdb_reader.Global;

/**
 *
 * @author  Owner
 */
public class CalculateNumberStatisticsDialog extends javax.swing.JDialog {
    
    Map<String, double[]> allatomdata = null;
    Map<String, double[]> selectedatomdata = null;
    
    datamodel AllModel = null;
    datamodel SelectedModel = null;
    
    /** Creates new form CalculateNumberStatisticsDialog */
    public CalculateNumberStatisticsDialog(java.awt.Frame parent, boolean modal, Map<String, double[]> AllAtomData, Map<String, double[]> SelectedAtomData) {
        super(parent, modal);
        allatomdata = AllAtomData;
        selectedatomdata = SelectedAtomData;
        AllModel = new datamodel(allatomdata);
        SelectedModel = new datamodel(selectedatomdata);
        initComponents();
    }

    class datamodel extends AbstractTableModel {

        Map<String, double[]> rawdata = null;
        String[][] data = null;
        
        public datamodel(Map<String, double[]> Rawdata)
        {
            rawdata = Rawdata;
            data = new String[rawdata.size()][];
            int row = 0;
            Iterator<String> i = rawdata.keySet().iterator();
            Iterator<double[]> v = rawdata.values().iterator();
            while (i.hasNext())
            {
                String key = i.next();
                double[] value = v.next();
                data[row] = new String[Global.calculateAvgSDMaxMin_Headers.length + 1];
                data[row][0] = key;
                for (int j=0; j<value.length; j++)
                {
                    if (Global.IntegerArrayContains(Global.calculateAvgSDMaxMin_IntegerColumns, j))
                    {
                        int val = (int)value[j];
                        data[row][j+1] = ((Integer)val).toString();
                    }
                    else 
                        data[row][j+1] = String.format("%.2f", (Double)value[j]);
                }
                row++;
            }
            int lp=0;
        }
        
        public int getRowCount() {
            return data.length;
        }

        public int getColumnCount() {
            return Global.calculateAvgSDMaxMin_Headers.length + 1;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return data[rowIndex][columnIndex];
        }
     
        public String getColumnName(int col) 
	{
	    if (col == 0) return "";
            return Global.calculateAvgSDMaxMin_Headers[col-1];
	}
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTableAllAtoms = new javax.swing.JTable();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTableSekectedAtoms = new javax.swing.JTable();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Number Statistics Result");

        jTableAllAtoms.setModel(SelectedModel);
        jTableAllAtoms.setColumnSelectionAllowed(true);
        jScrollPane1.setViewportView(jTableAllAtoms);

        jTableSekectedAtoms.setModel(AllModel);
        jTableSekectedAtoms.setColumnSelectionAllowed(true);
        jScrollPane2.setViewportView(jTableSekectedAtoms);

        jLabel1.setText("All Atoms");

        jLabel2.setText("Selected Atoms");

        jButton1.setText("Close");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 564, Short.MAX_VALUE)
                    .addComponent(jLabel2)
                    .addComponent(jButton1, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 564, Short.MAX_VALUE)
                    .addComponent(jLabel1))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(5, 5, 5)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 312, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 313, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButton1)
                .addGap(11, 11, 11))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        this.dispose();
    }//GEN-LAST:event_jButton1ActionPerformed
    

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTable jTableAllAtoms;
    private javax.swing.JTable jTableSekectedAtoms;
    // End of variables declaration//GEN-END:variables
    
}
