/*
 * EditResidueNumber.java
 *
 * Created on May 15, 2008, 8:30 PM
 */

package pdb_editor.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.Sequence;

/**
 *
 * @author  Owner
 */
public class EditResidueNumberDialog extends javax.swing.JDialog {

    private EditorFrame Parent = null;
    private CoordinateTable cTable = null;
    private DataSet maindata = null;
    private Sequence sequence = null;
    
    private ArrayList<ArrayList<Atom>> residuelist = null;
    private Object[][] changelist = null;
    private TableData tabledata = null;
    private TableRenderer tablecellrenderer = new TableRenderer();
    
    /** Creates new form EditResidueNumber */
    public EditResidueNumberDialog(java.awt.Frame parent, boolean modal, CoordinateTable ctable) {
        super(parent, modal);
        try {Parent = (EditorFrame)parent;} catch (Exception e) {}
        cTable = ctable;
        maindata = cTable.getMainData();
        initData();
        initComponents();
        
        this.buttonGroupOptChainID.add(this.jRadioButtonChainIgnore);
        this.buttonGroupOptChainID.add(this.jRadioButtonChainMove);
        this.buttonGroupOptChainID.add(this.jRadioButtonChainShift);
        this.buttonGroupOptResNum.add(this.jRadioButtonNumberIgnoreConflict);
        this.buttonGroupOptResNum.add(this.jRadioButtonNumberResolveAutomatic);
        this.buttonGroupOptResNum.add(this.jRadioButtonNumberSynchronize);
    }
    
    private void initData()
    {
        sequence = new Sequence(maindata.Atoms());
        residuelist = sequence.getLinearList();
        changelist = new Object[residuelist.size()][4];
        tabledata = new TableData();
        if (this.jTable != null) jTable.setModel(tabledata);
    }
    
    
    private class TableData extends AbstractTableModel {

        public int getRowCount() {
            return residuelist.size();
        }

        public int getColumnCount() {
            return 5;
        }

       	public String getColumnName(int col) 
	{
	    switch (col)
            {
                case 0 : return Atom.DataToolTip[Atom.CHAINID_INDEX];
                case 1 : return Atom.DataToolTip[Atom.RESIDUENUMBER_INDEX];
                case 2 : return Atom.DataToolTip[Atom.RESIDUETYPE_INDEX];
                case 3 : return "New " + Atom.DataToolTip[Atom.CHAINID_INDEX];        
                case 4 : return "New " + Atom.DataToolTip[Atom.RESIDUENUMBER_INDEX];
            }
            return "";
	}

        public Class getColumnClass(int col) {
            switch (col)
            {
                case 0 : return Global.stringclass.getClass();    //return Atom.DataClass[Atom.CHAINID_INDEX];
                case 1 : return Global.stringclass.getClass();    //return Atom.DataClass[Atom.RESIDUENUMBER_INDEX];
                case 2 : return Global.stringclass.getClass();    //return Atom.DataClass[Atom.RESIDUETYPE_INDEX];
                case 3 : return Global.stringclass.getClass();    
                case 4 : return Atom.DataClass[Atom.RESIDUENUMBER_INDEX];
            }
            return null;
        }
        
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex)
            {
                case 0 : return residuelist.get(rowIndex).get(0).ChainID();
                case 1 : return residuelist.get(rowIndex).get(0).ResidueNumber();
                case 2 : return residuelist.get(rowIndex).get(0).ResidueType();
                case 3 : return changelist[rowIndex][0];
                case 4 : return changelist[rowIndex][1];
            }
            return null;
        }
        
        public boolean isCellEditable(int row, int col) 
	{
            switch (col)
            {
                case 3 : return true;
                case 4 : return true;
            }
            return false;
        }
        
        public void setValueAt(Object value, int row, int col) 
	{
            int selrows[] = jTable.getSelectedRows();
            
            if (col == 3) 
            {
                String s = ((String)value);
                if (s != null) 
                {
                    if (s.length() > 0) value = s.charAt(0);
                    else value = null;
                }
            }
            if ((col == 4) && (value != null))
            {
                int index = Global.IntegerArrayFindIndex(selrows, row);
                value = (Integer)value - index;
            }
            for (int i=0; i<selrows.length; i++)
            {
                Atom a = residuelist.get(selrows[i]).get(0);
                if (value != null) {
                    if ((col == 3) && (value.equals(a.ChainID()))) value  = null;
                    if ((col == 4) && (value.equals(a.ResidueNumber()))) value = null;
                }
                changelist[selrows[i]][col-3] = value;
                if (value != null) changelist[selrows[i]][col-1] = true;
                else changelist[selrows[i]][col-1] = null;
                this.fireTableCellUpdated(selrows[i], col);
                if (col == 4) if (value != null) value = ((Integer)value) + 1;
            }
            UpdateDataChange();
        }
    }
    
    private class TableRenderer extends DefaultTableCellRenderer  
    {
        public Component getTableCellRendererComponent(JTable jTable, Object value,boolean isSelected, boolean hasFocus, int row,int col)
        {
            super.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, col);
            if ((col == 3) || (col == 4))
            {
                if (changelist[row][col-3] != null)
                 {
                     if (changelist[row][col-1] == null) {
                         if (isSelected) setBackground(Color.GREEN);
                         else setBackground(Color.ORANGE);
                         return this;
                     }
                     else return IsSelectedDefault(isSelected);
                 }
                 else return IsSelectedDefault(isSelected);
            }
            return IsSelectedDefault(isSelected);
        }
        
        private Component IsSelectedDefault(boolean isit)
        {
            if (isit) return this;
            else setBackground(Color.WHITE);
            return this;
        }
    }
    
    private void ApplyChanges()
    {
        if (Parent != null) Parent.listenForUndoStart("Edit ResNum / ChainID");
        int row  = 0;
        Iterator<ArrayList<Atom>> i = this.residuelist.iterator();
        while (i.hasNext())
        {
            Iterator<Atom> j = i.next().iterator();
            while (j.hasNext())
            {
                Atom a = j.next();
                if (changelist[row][0] != null)
                    a.ChainID((Character)changelist[row][0]);
                if (changelist[row][1] != null)
                    a.ResidueNumber((Integer)changelist[row][1]);
            }
            row++;
        }
        if (Parent != null) Parent.listenForUndoStop();
        cTable.fireTableDataChanged();
        initData();
    }
    
    
    
    private void UpdateDataChange()
    {
        ResetPreviousOptionChanges();
        ApplyResidueNumberOptions();
        ApplyChainIDOptions();
        tabledata.fireTableDataChanged();
        
    }

    
    private void ResetPreviousOptionChanges()
    {
        for (int i=0; i<changelist.length; i++)
        {
            if (changelist[i][2] == null) changelist[i][0] = null;
            if (changelist[i][3] == null) changelist[i][1] = null;
        }
    }
    
    private void ApplyChainIDOptions()
    {
        if (this.jRadioButtonChainMove.isSelected()) ResolveByChainMove();
        if (this.jRadioButtonChainShift.isSelected()) ResolveByChainShift();
        if (this.jCheckBoxChainIDSynchronize.isSelected()) SynchronizeChainIDChange();
    }
    
    private void ResolveByChainMove()
    {
        TreeSet<Character> targets = FindConflictingChain();
        
        TreeSet<Character> used = new TreeSet<Character> (sequence.data().keySet());
        TreeMap<Character, Character> correction = new TreeMap<Character, Character> ();
        Iterator<Character> i = targets.iterator();
        while (i.hasNext())
        {
            char c = i.next();
            char original = c;
            while (used.contains(c))
                c++;
            correction.put(original, c);
            used.add(c);
        }
        
        RecordChainCorrection(correction);
    }
    
    private void RecordChainCorrection(TreeMap<Character, Character> input)
    {
        for (int i=0; i<changelist.length; i++)
        {
            Atom a = residuelist.get(i).get(0);
            char c = a.ChainID();
            if (input.containsKey(c))
                if (changelist[i][2] == null)
                    changelist[i][0] = input.get(c);
        }
    }
    
    private TreeSet<Character> FindConflictingChain()
    {
        TreeSet<Character> result = new TreeSet<Character> ();
        for (int i=0; i<changelist.length; i++)
        {
            if (changelist[i][2] != null)
            {
                Atom a = residuelist.get(i).get(0);
                char chain = (Character)changelist[i][0];
                int resnum = a.ResidueNumber();
                if (changelist[i][1] != null) resnum = (Integer)changelist[i][1];
                if (sequence.checkResidueExist(chain, resnum)) result.add(chain);
            }
        }
        return result;
    }

    private TreeSet<Character> FindForbiddenChain()
    {
        TreeSet<Character> result = new TreeSet<Character> ();
        for (int i=0; i<changelist.length; i++)
        {
            if (changelist[i][2] != null)
            {
                Atom a = residuelist.get(i).get(0);
                char chain = (Character)changelist[i][0];
                int resnum = a.ResidueNumber();
                if (changelist[i][1] != null) resnum = (Integer)changelist[i][1];
                result.add(a.ChainID());
                result.add(chain);
            }
        }
        return result;
    }
    
    private void ResolveByChainShift()
    {
        TreeSet<Character> targets = FindConflictingChain();
        TreeSet<Character> used = new TreeSet<Character> (sequence.data().keySet());
        TreeMap<Character, Character> correction = new TreeMap<Character, Character> ();
        
        TreeSet<Character> forbidden = FindForbiddenChain();
        used.removeAll(forbidden);
        used.addAll(targets);
        Iterator<Character> i = used.iterator();
        while (i.hasNext())
        {
            char c = i.next();
            char original = c;
            while (forbidden.contains(c))
                c++;
            if (original != c) correction.put(original, c);
            forbidden.add(c);
            /*while (used.contains(c))
            {
                char ori = c;
                while (forbidden.contains(c))
                    c++;
                if (ori != c) correction.put(ori, c);
                forbidden.add(c);
            }*/
            //used.add(c);        
        }
        
        /*Iterator<Character> i = targets.iterator();
        while (i.hasNext())
        {
            char c = i.next();
            char original = c;
            while (forbidden.contains(c))
                c++;
            correction.put(original, c);
            forbidden.add(c);
            while (used.contains(c))
            {
                char ori = c;
                while (forbidden.contains(c))
                    c++;
                correction.put(ori, c);
                forbidden.add(c);
            }
            used.add(c);
        }*/
        
        RecordChainCorrection(correction);
    }
    
    
    
    private void SynchronizeChainIDChange()
    {
        TreeSet<Character> changed = new TreeSet<Character> ();
        for (int i=0; i<changelist.length; i++)
        {
            if (changelist[i][2] != null)
            {
                char targetchain = residuelist.get(i).get(0).ChainID();
                
                if (!changed.contains(targetchain))
                {
                    char newchainid = (Character)changelist[i][0];
                
                    Iterator<ArrayList<Atom>> j = residuelist.iterator();
                    int counter = 0;
                    while (j.hasNext())
                    {
                        Atom a = j.next().get(0);
                        if (a.ChainID() == targetchain)
                             if (changelist[counter][2] == null)
                                 changelist[counter][0] = newchainid;
                        counter++;
                    }
                    changed.add(targetchain);
                }
            }
        }
    }
    
    private void ApplyResidueNumberOptions()
    {
        if (this.jRadioButtonNumberResolveAutomatic.isSelected()) ResolveResNumAutomatically();
        if (this.jRadioButtonNumberSynchronize.isSelected()) SynchronizeResNumChange();
        if (this.jCheckBoxNumberSynchronizeChains.isSelected()) SynchronizeResidueNumberChangeBetweenChains();
    }
    
    private void ResolveResNumAutomatically()
    {
        TreeMap<Character, TreeMap<Integer, Integer[]>> usedlist = new TreeMap<Character, TreeMap<Integer, Integer[]>> ();
        
        for (int i=0; i<residuelist.size(); i++)
        {
            Atom a = residuelist.get(i).get(0);
            char c = a.ChainID();
            int n = a.ResidueNumber();
            if (changelist[i][3] != null)
                n = -i;
            
            if (!usedlist.containsKey(c)) usedlist.put(c, new TreeMap<Integer, Integer[]> ());
            usedlist.get(c).put(n, new Integer[] {n, i, null});
        }
        
        for (int i=0; i<changelist.length; i++)
        {
            if (changelist[i][3] != null)
            {
                Atom a = residuelist.get(i).get(0);
                char c = a.ChainID();
                /*int oldn = a.ResidueNumber();
                Iterator<Integer> it = usedlist.get(c).keySet().iterator();
                while (it.hasNext())
                {
                    int key = it.next();
                    Integer[] d = usedlist.get(c).get(key);
                    //if (d != null)
                    //    if (d[0] != null)
                    if (d[0] == oldn)
                    {
                        oldn = key;
                        break;
                    }
                }*/
                int newn = (Integer)changelist[i][1];
                usedlist.get(c).get(-i)[2] = 1;
                
                CorrectResNumConflict(usedlist, c, -i, newn);
            }
        }
        
        Iterator i = usedlist.values().iterator();
        while (i.hasNext())
        {
            TreeMap<Integer, Integer[]> d = (TreeMap<Integer, Integer[]>)i.next();
            Iterator<Integer> j = d.keySet().iterator();
            while (j.hasNext())
            {
                int value = j.next();
                Integer[] data = d.get(value);
                //if (data != null)
                if (value != d.get(value)[0])
                {
                    int index = d.get(value)[1];
                    changelist[index][1] = value;
                }
            }
        }
        
        /* TreeMap<Character, TreeMap<Integer, Integer[]>> usedlist = new TreeMap<Character, TreeMap<Integer, Integer[]>> ();
        for (int i=0; i<residuelist.size(); i++)
        {
            Atom a = residuelist.get(i).get(0);
            char c = a.ChainID();
            int n = a.ResidueNumber();
            if (!usedlist.containsKey(c)) usedlist.put(c, new TreeMap<Integer, Integer[]> ());
            usedlist.get(c).put(n, new Integer[] {i, null, null});
        }
        
        for (int i=0; i<changelist.length; i++)
        {
            if (changelist[i][3] != null)
            {
                Atom a = residuelist.get(i).get(0);
                char c = a.ChainID();
                int oldn = a.ResidueNumber();
                int newn = (Integer)changelist[i][1];
                
                usedlist.get(c).get(oldn)[1] = newn;
                usedlist.get(c).get(oldn)[2] = 1;
                
                CorrectResNumConflict(usedlist, c, newn);
            }
        }*/
    }
    
    private void CorrectResNumConflict(TreeMap<Character, TreeMap<Integer, Integer[]>> usedlist, char c, int oldn, int newn)
    {
        if (usedlist.get(c).containsKey(newn))
        {
            int nextnum = newn;
            TreeMap<Integer, Integer[]> map = usedlist.get(c);
            boolean cont = true;
            while (cont)
            {
                nextnum++;
                cont = false;
                if (map.containsKey(nextnum))
                    if (map.get(nextnum)[2] != null)
                        cont = true;
            }
            CorrectResNumConflict(usedlist, c, newn, nextnum);
        }
        
        TreeMap<Integer, Integer[]> map = usedlist.get(c);
        Integer[] data = map.get(oldn);
        boolean cont = false;
        if (data[2] == null) cont = true;
        if (data[2] != null) if (data[2] != 2) cont = true;
        if (cont)
        {    
            if (data[2] != null) if (data[2] == 1) data[2] = 2;
            map.remove(oldn);
            map.put(newn, data);
        }
    }
    
    /*
    private void CorrectResNumConflict(TreeMap<Character, TreeMap<Integer, Integer[]>> usedlist, char c, int num)
    {
        if (usedlist.get(c).containsKey(num))
        {
            Integer[] val = usedlist.get(c).get(num);
            if (val[2] == null)
            {
                if (val[1] == null) val[1] = num;
                val[1]++;
                changelist[val[0]][1] = val[1];
                CorrectResNumConflict(usedlist, c, val[1]);
            }

        }
    }*/
    
    private void SynchronizeResNumChange()
    {
        TreeSet<Character> changed = new TreeSet<Character> ();
        for (int i=0; i<changelist.length; i++)
        {
            if (changelist[i][3] != null)
            {
                Atom a = residuelist.get(i).get(0);
                if (!changed.contains(a.ChainID()))
                {
                    int diff = (Integer)changelist[i][1] - a.ResidueNumber();
                    for (int j=0; j<residuelist.size(); j++)
                    {
                        Atom b = residuelist.get(j).get(0);
                        if (b.ChainID() == a.ChainID())
                        {
                            if ((b.ResidueNumber() + diff) < 0) break;
                            if (changelist[j][3] == null)
                                changelist[j][1] = b.ResidueNumber() + diff;
                        }
                    }
                    changed.add(a.ChainID());
                }
            }
        }
    }
    
    private void SynchronizeResidueNumberChangeBetweenChains()
    {
        TreeMap<Integer, Object[]> changemap = new TreeMap<Integer, Object[]> ();
        for (int i=0; i<changelist.length; i++)
            if (changelist[i][1] != null)
            {
                Atom a = residuelist.get(i).get(0);
                changemap.put(a.ResidueNumber(), new Object[] {a.ResidueType(), changelist[i][1]});
            }
        
        for (int i=0; i<changelist.length; i++)
        {
            Atom a = residuelist.get(i).get(0);
            if (changemap.containsKey(a.ResidueNumber()))
                if (a.ResidueType().equals(changemap.get(a.ResidueNumber())[0]))
                    if (changelist[i][3] == null)
                        changelist[i][1] = changemap.get(a.ResidueNumber())[1];
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroupOptChainID = new javax.swing.ButtonGroup();
        buttonGroupOptResNum = new javax.swing.ButtonGroup();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable = new javax.swing.JTable () {
            public TableCellRenderer getCellRenderer(int row, int column) {
                return tablecellrenderer;
            }
        };
        jPanel1 = new javax.swing.JPanel();
        jRadioButtonNumberResolveAutomatic = new javax.swing.JRadioButton();
        jRadioButtonNumberSynchronize = new javax.swing.JRadioButton();
        jRadioButtonNumberIgnoreConflict = new javax.swing.JRadioButton();
        jCheckBoxNumberSynchronizeChains = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        jCheckBoxChainIDSynchronize = new javax.swing.JCheckBox();
        jRadioButtonChainIgnore = new javax.swing.JRadioButton();
        jRadioButtonChainMove = new javax.swing.JRadioButton();
        jRadioButtonChainShift = new javax.swing.JRadioButton();
        jButtonClose = new javax.swing.JButton();
        jButtonApply = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Edit Residue Number");

        jTable.setModel(tabledata);
        jTable.setCellSelectionEnabled(true);
        jScrollPane1.setViewportView(jTable);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Residue Number Edit Option"));

        jRadioButtonNumberResolveAutomatic.setSelected(true);
        jRadioButtonNumberResolveAutomatic.setText("Resolve conflicts by increasing residue numbers");
        jRadioButtonNumberResolveAutomatic.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });

        jRadioButtonNumberSynchronize.setText("Synchronize change in the chain (1 to 5 will make all residues change by +4)");
        jRadioButtonNumberSynchronize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });

        jRadioButtonNumberIgnoreConflict.setText("Change one residue at a time (Ignore conflicts)");
        jRadioButtonNumberIgnoreConflict.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });

        jCheckBoxNumberSynchronizeChains.setText("Synchronize residue number change to other chains if residue is same");
        jCheckBoxNumberSynchronizeChains.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jRadioButtonNumberResolveAutomatic)
                    .addComponent(jRadioButtonNumberIgnoreConflict)
                    .addComponent(jRadioButtonNumberSynchronize)
                    .addComponent(jCheckBoxNumberSynchronizeChains))
                .addContainerGap(47, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(jRadioButtonNumberResolveAutomatic)
                .addGap(3, 3, 3)
                .addComponent(jRadioButtonNumberSynchronize, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioButtonNumberIgnoreConflict)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxNumberSynchronizeChains))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Chain ID Edit Option"));

        jCheckBoxChainIDSynchronize.setSelected(true);
        jCheckBoxChainIDSynchronize.setText("Synchronize chain ID change to all residues in the chain");
        jCheckBoxChainIDSynchronize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });

        jRadioButtonChainIgnore.setSelected(true);
        jRadioButtonChainIgnore.setText("Ignore conflicts");
        jRadioButtonChainIgnore.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });

        jRadioButtonChainMove.setText("Resolve conflicts by changing affected chain ID automatically to available one");
        jRadioButtonChainMove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });

        jRadioButtonChainShift.setText("Resolve conflicts by shifting all affected chain IDs");
        jRadioButtonChainShift.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonNumberResolveAutomaticActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jRadioButtonChainIgnore)
                    .addComponent(jRadioButtonChainMove)
                    .addComponent(jRadioButtonChainShift)
                    .addComponent(jCheckBoxChainIDSynchronize))
                .addContainerGap(39, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jRadioButtonChainIgnore)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioButtonChainMove)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jRadioButtonChainShift)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxChainIDSynchronize, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jButtonApply.setText("Apply Changes");
        jButtonApply.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonApplyActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 458, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButtonApply)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonClose)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 295, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonApply)
                    .addComponent(jButtonClose))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
    this.dispose();
}//GEN-LAST:event_jButtonCloseActionPerformed

    private void jButtonApplyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonApplyActionPerformed
    ApplyChanges();
}//GEN-LAST:event_jButtonApplyActionPerformed

private void jRadioButtonNumberResolveAutomaticActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonNumberResolveAutomaticActionPerformed
    UpdateDataChange();
}//GEN-LAST:event_jRadioButtonNumberResolveAutomaticActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupOptChainID;
    private javax.swing.ButtonGroup buttonGroupOptResNum;
    private javax.swing.JButton jButtonApply;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JCheckBox jCheckBoxChainIDSynchronize;
    private javax.swing.JCheckBox jCheckBoxNumberSynchronizeChains;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JRadioButton jRadioButtonChainIgnore;
    private javax.swing.JRadioButton jRadioButtonChainMove;
    private javax.swing.JRadioButton jRadioButtonChainShift;
    private javax.swing.JRadioButton jRadioButtonNumberIgnoreConflict;
    private javax.swing.JRadioButton jRadioButtonNumberResolveAutomatic;
    private javax.swing.JRadioButton jRadioButtonNumberSynchronize;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable;
    // End of variables declaration//GEN-END:variables
    
}
