/*
 * FindClosestAtomDistancesDialog.java
 *
 * Created on April 3, 2008, 8:25 PM
 */

package pdb_editor.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.table.AbstractTableModel;
import pdb_editor.coordinate.CoordinateTable;
import pdb_editor.coordinate.SearchSelectDialog;
import pdb_reader.DataSet;
import pdb_reader.FormulaEvaluator;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.Coordinate;

/**
 *
 * @author  Owner
 */
public class FindClosestAtomDistancesDialog extends javax.swing.JDialog {
    
    private final String ExcludeLabelBase = "Number of Atoms To Be Excluded : ";
    private final String SelectedLabelBase = "Number of Atoms Selected To Be Used : ";
    
    private CoordinateTable maintable = null;
    private DataSet maindata = null;
    
    private SearchSelectDialog selectedDialog = null;
    private SearchSelectDialog excludedDialog = null;
    
    private double distanceMax = 10;
    private double distanceMin = 0;

    private Coordinate OriginMaxCoord = null;
    private Coordinate OriginMinCoord = null;
    private Coordinate OriginMaxFracCoord = null;
    private Coordinate OriginMinFracCoord = null;
    private Coordinate OriginSearchMaxCoord = null;
    private Coordinate OriginSearchMinCoord = null;
    private Coordinate OriginSearchMaxFracCoord = null;    
    private Coordinate OriginSearchMinFracCoord = null;    
    
    private int excludeRangeAfter = 3;
    private int excludeRangeBefore = 3;

    private HashMap<Object, Coordinate> searchOrigin = null;
    private HashMap<Atom, Coordinate[]> searchPoints = null;
    private HashMap<Object, ResultData[]> searchResult = null;
    private ResultData[] searchResultAll = null;
    
    private JCheckBoxMenuItem[] OriginColumnMenu = null;
    private JCheckBoxMenuItem[] TargetColumnMenu = null;
    int[] ColumnDisplayed = null;    
    
    class ResultTableData extends AbstractTableModel {
        public int getRowCount() {
            return searchResultAll.length;
        }
        
        public Class getColumnClass(int cI) {
	    if (ColumnDisplayed[cI] == Atom.TOTAL_NUMBER_OF_INDEX * 2 + 1) return Global.doubleclass.getClass();
            if (ColumnDisplayed[cI] == Atom.TOTAL_NUMBER_OF_INDEX * 2) return Global.integerclass.getClass();
            if (ColumnDisplayed[cI] < Atom.TOTAL_NUMBER_OF_INDEX) return Atom.DataClass[ColumnDisplayed[cI]];
            else return Atom.DataClass[ColumnDisplayed[cI] - Atom.TOTAL_NUMBER_OF_INDEX];
        }
        
        public int getColumnCount() {
            //return Atom.TOTAL_NUMBER_OF_INDEX * 2 + 2;
            return ColumnDisplayed.length;
        }

        public String getColumnName(int cI) 
	{
	    if (ColumnDisplayed[cI] == Atom.TOTAL_NUMBER_OF_INDEX * 2 + 1) return "Distance";
            if (ColumnDisplayed[cI] == Atom.TOTAL_NUMBER_OF_INDEX * 2) return "Symm";
            if (ColumnDisplayed[cI] < Atom.TOTAL_NUMBER_OF_INDEX) return "Origin " + Atom.DataList[ColumnDisplayed[cI]];
            else return "Found " + Atom.DataList[ColumnDisplayed[cI] - Atom.TOTAL_NUMBER_OF_INDEX];
	}
        
        public Object getValueAt(int rI, int cI) {
            if (ColumnDisplayed[cI] == Atom.TOTAL_NUMBER_OF_INDEX * 2 + 1) return searchResultAll[rI].Distance;
            if (ColumnDisplayed[cI] == Atom.TOTAL_NUMBER_OF_INDEX * 2) return searchResultAll[rI].Symmop;
            if (ColumnDisplayed[cI] < Atom.TOTAL_NUMBER_OF_INDEX)
            {
                if (searchResultAll[rI].Origin.getClass().equals(Global.stringclass.getClass()))
                {
                    String s = (String)searchResultAll[rI].Origin;
                    
                    switch (ColumnDisplayed[cI]) {
                        case Atom.ATOMNUMBER_INDEX : return s;
                        case Atom.X_INDEX : return searchOrigin.get(s).x();
                        case Atom.Y_INDEX : return searchOrigin.get(s).y();
                        case Atom.Z_INDEX : return searchOrigin.get(s).z();
                    }
                    return null;
                }
                else 
                {
                    return ((Atom)searchResultAll[rI].Origin).TableData(ColumnDisplayed[cI]);
                }
            }
            if (ColumnDisplayed[cI] >= Atom.TOTAL_NUMBER_OF_INDEX)
            {
                int i = ColumnDisplayed[cI] - Atom.TOTAL_NUMBER_OF_INDEX;
                return searchResultAll[rI].Target.TableData(i);
            }
            
            return null;
        }
    }
    
    /** Creates new form FindClosestAtomDistancesDialog */
    public FindClosestAtomDistancesDialog(java.awt.Frame parent, boolean modal, CoordinateTable tablein) {
        super(parent, modal);
        maintable = tablein;
        maindata = tablein.getMainData();
        initComponents();
        initButtonGroup();
        this.jLabelNumberAtomExcluded.setText(ExcludeLabelBase);
        this.jLabelNumberAtomSelected.setText(SelectedLabelBase);
        selectedDialog = new SearchSelectDialog(null, true, "Select", maintable, true);
        excludedDialog = new SearchSelectDialog(null, true, "Exclude", maintable, true);
        initResultColumnCheckMenu();
    }
    
    private void initResultColumnCheckMenu()
    {
        OriginColumnMenu = new JCheckBoxMenuItem[Atom.TOTAL_NUMBER_OF_INDEX];
        TargetColumnMenu = new JCheckBoxMenuItem[Atom.TOTAL_NUMBER_OF_INDEX];
        
        int[] OriginSelected = {Atom.ATOMNUMBER_INDEX, Atom.CHAINID_INDEX, Atom.RESIDUENUMBER_INDEX, Atom.ATOMNAME_INDEX};
        int[] TargetSelected = {Atom.ATOMNUMBER_INDEX, Atom.CHAINID_INDEX, Atom.RESIDUENUMBER_INDEX, Atom.ATOMNAME_INDEX};
        
        for (int i=0; i<OriginColumnMenu.length; i++)
        {
            OriginColumnMenu[i] = new JCheckBoxMenuItem();
            TargetColumnMenu[i] = new JCheckBoxMenuItem();
          
            OriginColumnMenu[i].setSelected(Global.IntegerArrayContains(OriginSelected, i));
            TargetColumnMenu[i].setSelected(Global.IntegerArrayContains(TargetSelected, i));

            OriginColumnMenu[i].setText(Atom.DataToolTip[i]);
            TargetColumnMenu[i].setText(Atom.DataToolTip[i]);
            
            ActionListener al = new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    initColumnDisplayed();
                    jTableResult.setModel(new ResultTableData());
               }};
            
            OriginColumnMenu[i].addActionListener(al);
            TargetColumnMenu[i].addActionListener(al);
            
            jMenuOrigin.add(OriginColumnMenu[i]);
            jMenuFound.add(TargetColumnMenu[i]);
        }
    }
    
    private void initButtonGroup()
    {
        this.buttonGroupSelectAtom.add(this.jRadioButtonAtoms);
        this.buttonGroupSelectAtom.add(this.jRadioButtonChains);
        this.buttonGroupSelectAtom.add(this.jRadioButtonResidues);
        
        this.buttonGroupSelectCoordinate.add(this.jRadioButtonFractional);
        this.buttonGroupSelectCoordinate.add(this.jRadioButtonOrthogonal);
    }

    private void initColumnDisplayed()
    {
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (int i=0; i<OriginColumnMenu.length; i++)
            if (OriginColumnMenu[i].isSelected()) r.add(i);
        for (int i=0; i<TargetColumnMenu.length; i++)
            if (TargetColumnMenu[i].isSelected()) r.add(i + Atom.TOTAL_NUMBER_OF_INDEX);
        r.add(Atom.TOTAL_NUMBER_OF_INDEX * 2);
        r.add(Atom.TOTAL_NUMBER_OF_INDEX * 2 + 1);
        ColumnDisplayed = Global.ConvertIntegerArrayToIntArray(r.toArray(new Integer[r.size()]));
        
    }
    
    private void Run()
    {
        getSearchOptionValues();
        generateSearchOrigin();
        if (searchOrigin.size() > 0)
        {
            generateSearchPoints();
            calculateDistance();
            showResult();
        }
    }

    private void showResult()
    {
        initColumnDisplayed();
        this.jTableResult.setModel(new ResultTableData());
        this.jTableResult.setAutoCreateRowSorter(true);
        this.jDialogResult.show();
    }
    
    private void generateSearchPoints()
    {
        searchPoints = new HashMap<Atom, Coordinate[]> ();
        
        sortAtomsBySelectExcludeOption();
        generateSearchPointCoordinateList();
    }
    
    private void calculateDistance()
    {
        searchResult = new HashMap<Object, ResultData[]> ();
        ArrayList<ResultData> foundall = new ArrayList<ResultData>();
        
        Iterator<Object> i = searchOrigin.keySet().iterator();
        while (i.hasNext())
        {
            Object current = i.next();
            Coordinate c = searchOrigin.get(current);
            Iterator<Atom> j = searchPoints.keySet().iterator();
            while (j.hasNext())
            {
                Atom target = j.next();
                Coordinate[] list = searchPoints.get(target);
                
                ArrayList<ResultData> found = new ArrayList<ResultData>();
                for (int k=0; k<list.length; k++)
                    if (list[k] != null)
                    {
                        double d = list[k].CalculateDistance(c);
                        if ((d <= distanceMax) && (d >= distanceMin))
                        {
                            if (targetSatisfiesCriteria(current, target, k))
                            {
                                ResultData rd = new ResultData(current, target, k, d);
                                found.add(rd);
                                foundall.add(rd);
                            }
                        }
                    }
                searchResult.put(current, found.toArray(new ResultData[found.size()]));
            }
        }
        searchResultAll = foundall.toArray(new ResultData[foundall.size()]);
    }
    
    private boolean targetSatisfiesCriteria(Object current, Atom target, int symop)
    {
        if (symop > 0) return true;
        if (current.getClass().equals(Global.stringclass.getClass())) return true;
        
        Atom c = (Atom)current;
        if (c.equals(target)) return false;
        if (c.ChainID() != target.ChainID()) return true;
        int cresnum = c.ResidueNumber(), tresnum = target.ResidueNumber();
        if (this.jCheckBoxExcludeWithin.isSelected()) if (cresnum == tresnum) return false;
        if (this.jCheckBoxExcludeAfter.isSelected()) if ((tresnum > cresnum) && (tresnum <= cresnum + excludeRangeAfter)) return false;
        if (this.jCheckBoxExcludeBefore.isSelected()) if ((tresnum < cresnum) && (tresnum >= cresnum - excludeRangeBefore)) return false;
        return true;
    }
    
    private void generateSearchPointCoordinateList()
    {
        Iterator<Atom> i = searchPoints.keySet().iterator();
        while (i.hasNext())
        {
            Atom key = i.next();
            ArrayList<Coordinate> list = new ArrayList<Coordinate> ();
            
            if (this.isInOriginBoundary(key.OrthogonalCoordinate())) list.add(key.OrthogonalCoordinate());
            else list.add(null);
            if (this.jCheckBoxCheckSymmetry.isSelected())
            {
                FormulaEvaluator[][] ops = generateSymmOpFormulas();
                Coordinate[] fcs = generateSymmetryMates(ops, key.FractionalCoordinate());
                Coordinate[] ocs = adjustFractionalCoordinatesAndTransformToOrthogonal(fcs);
                for (int j=0; j<ocs.length; j++)
                    if (isInOriginBoundary(ocs[j])) list.add(ocs[j]);
                    else list.add(null);
                
            }
            searchPoints.put(key, list.toArray(new Coordinate[list.size()]));
        }
    }

    private Coordinate[] adjustFractionalCoordinatesAndTransformToOrthogonal(Coordinate[] fcs)
    {
        Coordinate[] r = new Coordinate[fcs.length];
        for (int i=0; i<fcs.length; i++)
            r[i] = Global.TransformCoordinates(maindata.Spacegroup().scaleInverse(), findClosestFractionalCoordinate(fcs[i]));
        return r;
    }
    
    private Coordinate findClosestFractionalCoordinate(Coordinate c)
    {
        Coordinate[] max = findClosestFractionalCoordinateAndDifference(this.OriginMaxFracCoord, c);
        Coordinate[] min = findClosestFractionalCoordinateAndDifference(this.OriginMinFracCoord, c);
        
        double xbest = max[0].x(), ybest = max[0].y(), zbest = max[0].z();
        if (max[1].x() > min[1].x()) xbest = min[0].x();
        if (max[1].y() > min[1].y()) ybest = min[0].y();
        if (max[1].z() > min[1].z()) zbest = min[0].z();
        
        return new Coordinate(xbest, ybest, zbest);
    }
    
    private Coordinate[] findClosestFractionalCoordinateAndDifference(Coordinate base, Coordinate adj)
    {
        double[] dx = findClosestFractionalAndDifferenece(base.x(), adj.x());
        double[] dy = findClosestFractionalAndDifferenece(base.y(), adj.y());
        double[] dz = findClosestFractionalAndDifferenece(base.z(), adj.z());
        
        return new Coordinate[] {
          new Coordinate(dx[0], dy[0], dz[0]),
          new Coordinate(dx[1], dy[1], dz[1])
        };
    }
    
    private double[] findClosestFractionalAndDifferenece(double n1, double n2)
    {
        double corrx = n2 + Math.floor(n1) - Math.floor(n2);
        double dx = n1 - corrx;
        if (dx < -0.5) { corrx--; dx++; }
        if (dx > 0.5) { corrx++; dx--; }
        /*if (dx < 0) {
            if (Math.abs(dx) > dx + 1) { corrx--; dx++; }
        }
        else if (dx > Math.abs(dx - 1)) { corrx++; dx--; }*/
        return new double[] {corrx, Math.abs(dx)};
    }
    
    private Coordinate[] generateSymmetryMates(FormulaEvaluator[][] f, Coordinate list)
    {
        Coordinate[] r = new Coordinate[f.length];
        
        for (int i=0; i<f.length; i++)
        {
            HashMap<String, Double> vars = getFormulaVariables(list);
            r[i] = new Coordinate(f[i][0].evaluateExpression(vars), f[i][1].evaluateExpression(vars), f[i][2].evaluateExpression(vars));
        }
        
        return r;
    }
    
    private HashMap<String, Double> getFormulaVariables(Coordinate a)
    {
        HashMap<String, Double> r = new HashMap<String, Double> ();
        
        r.put("X", a.x());
        r.put("Y", a.y());
        r.put("Z", a.z());
        
        return r;
    }
    
    private FormulaEvaluator[][] generateSymmOpFormulas()
    {
        String[][] ops = maindata.Spacegroup().symmetryOperators(); 
        FormulaEvaluator[][] f = new FormulaEvaluator[ops.length - 1][3];
         
         for (int i = 1; i<ops.length; i++)
             for (int j=0; j<3; j++)
                f[i-1][j] = new FormulaEvaluator(ops[i][j]);
         
         return f;
    }

    
    private void sortAtomsBySelectExcludeOption()
    {
        if (this.jCheckBoxConditionSelect.isSelected())
        {
            Integer[] list = this.selectedDialog.getFoundCoordinateIndicies();
            for (int i=0; i<list.length; i++)
            {
                Atom a = maindata.Atoms().get(list[i]);
                searchPoints.put(a, null);
            }
        }
        else
        {
            for (int i=0; i<maindata.Atoms().size(); i++)
            {
                Atom a = maindata.Atoms().get(i);
                searchPoints.put(a, null);
            }
        }
        
        if (this.jCheckBoxConditionExclude.isSelected())
        {
            Integer[] list = this.excludedDialog.getFoundCoordinateIndicies();
            for (int i=0; i<list.length; i++)
            {
                Atom a = maindata.Atoms().get(list[i]);
                searchPoints.remove(a);
            }
        }
    }
    
    private void getSearchOptionValues()
    {
        distanceMax = Double.parseDouble(this.jTextFieldDistanceMax.getText());
        distanceMin = Double.parseDouble(this.jTextFieldDistanceMin.getText());
        excludeRangeAfter = Integer.parseInt(this.jTextFieldExcludeAfterNumber.getText());
        excludeRangeBefore = Integer.parseInt(this.jTextFieldExcludeBeforeNumber.getText());
    }
    
    private void generateSearchBoundary()
    {
        Coordinate c = OriginMaxCoord;
        Coordinate d = OriginMinCoord;
        if (c != null) {
        OriginSearchMaxCoord = new Coordinate(c.x() + distanceMax, c.y() + distanceMax, c.z() + distanceMax);
        OriginSearchMinCoord = new Coordinate(d.x() - distanceMax, d.y() - distanceMax, d.z() - distanceMax);
        
        if (maindata.Spacegroup().scale() != null)
        {
            double[][] m = maindata.Spacegroup().scale();
            this.OriginMaxFracCoord = Global.TransformCoordinates(m, OriginMaxCoord);
            this.OriginMinFracCoord = Global.TransformCoordinates(m, OriginMinCoord);
            this.OriginSearchMaxFracCoord = Global.TransformCoordinates(m, OriginSearchMaxCoord);
            this.OriginSearchMinFracCoord = Global.TransformCoordinates(m, OriginSearchMinCoord);
        }}
    }
    
    private boolean isInOriginBoundary(Coordinate c)
    {
        if (c.x() > this.OriginSearchMaxCoord.x()) return false;
        if (c.y() > this.OriginSearchMaxCoord.y()) return false;
        if (c.z() > this.OriginSearchMaxCoord.z()) return false;
        
        if (c.x() < this.OriginSearchMinCoord.x()) return false;
        if (c.y() < this.OriginSearchMinCoord.y()) return false;
        if (c.z() < this.OriginSearchMinCoord.z()) return false;
        
        return true;
    }
    
    private void updateOriginMaxMin(Coordinate c)
    {
        if (this.OriginMaxCoord == null) OriginMaxCoord = c.clone();
        if (this.OriginMinCoord == null) OriginMinCoord = c.clone();
        
        if (c.x() > OriginMaxCoord.x()) OriginMaxCoord.x(c.x());
        if (c.y() > OriginMaxCoord.y()) OriginMaxCoord.y(c.y());
        if (c.z() > OriginMaxCoord.z()) OriginMaxCoord.z(c.z());
    
        if (c.x() < OriginMinCoord.x()) OriginMinCoord.x(c.x());
        if (c.y() < OriginMinCoord.y()) OriginMinCoord.y(c.y());
        if (c.z() < OriginMinCoord.z()) OriginMinCoord.z(c.z());
    }
    
    private void generateSearchOrigin()
    {
        searchOrigin = new HashMap<Object, Coordinate> ();
        
        OriginMaxCoord = null;
        OriginMinCoord = null;
        
        if (this.jCheckBoxIncludeSelected.isSelected())
        {
            int[] indicies = null;
            if (this.jRadioButtonAtoms.isSelected()) indicies = maintable.getSelectedRows();
            if (this.jRadioButtonResidues.isSelected()) indicies = maindata.getResiduesIndicies(maintable.getSelectedRows());
            if (this.jRadioButtonChains.isSelected()) indicies = maindata.getChainIndicies(maintable.getSelectedRows());
            
            if (indicies != null)
            {
                for (int i=0; i<indicies.length; i++)
                {
                    Atom a = maindata.Atoms().get(indicies[i]);
                    updateOriginMaxMin(a.OrthogonalCoordinate());
                    searchOrigin.put(a, a.OrthogonalCoordinate());
                }
            }
        }
        if (this.jCheckBoxCoordinatePoints.isSelected())
        {
            String NamePreText = "Point";
            Coordinate[] coords = getCoordinatesFromText(this.jTextAreaCoordinateInput.getText(), this.jRadioButtonFractional.isSelected());
            for (int i=0; i<coords.length; i++)
            {
                updateOriginMaxMin(coords[i]);
                int index = i+1;
                searchOrigin.put(NamePreText+' '+index, coords[i]);
            }
        }
        
        generateSearchBoundary();
    }
    
    private Coordinate[] getCoordinatesFromText(String textin, boolean fractional)
    {
        double[] nums = Global.ExtractAllNumbers(textin);
        Coordinate[] r = new Coordinate[nums.length / 3];
        for (int i=0; i<r.length; i++)
        {
            r[i] = new Coordinate(nums[i*3], nums[i*3+1], nums[i*3+2]);
            if (fractional) r[i] = Global.TransformCoordinates(maindata.Spacegroup().scaleInverse(), r[i]);
        }
        return r;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroupSelectAtom = new javax.swing.ButtonGroup();
        buttonGroupSelectCoordinate = new javax.swing.ButtonGroup();
        jDialogResult = new javax.swing.JDialog();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTableResult = new javax.swing.JTable();
        jMenuBar = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuItemSaveAs = new javax.swing.JMenuItem();
        jMenuItemExit = new javax.swing.JMenuItem();
        jMenuOrigin = new javax.swing.JMenu();
        jMenuFound = new javax.swing.JMenu();
        jFileChooser = new javax.swing.JFileChooser();
        jPanel1 = new javax.swing.JPanel();
        jCheckBoxIncludeSelected = new javax.swing.JCheckBox();
        jRadioButtonChains = new javax.swing.JRadioButton();
        jRadioButtonResidues = new javax.swing.JRadioButton();
        jRadioButtonAtoms = new javax.swing.JRadioButton();
        jCheckBoxCoordinatePoints = new javax.swing.JCheckBox();
        jScrollPaneCoordinateList = new javax.swing.JScrollPane();
        jTextAreaCoordinateInput = new javax.swing.JTextArea();
        jRadioButtonOrthogonal = new javax.swing.JRadioButton();
        jRadioButtonFractional = new javax.swing.JRadioButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldDistanceMax = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jTextFieldDistanceMin = new javax.swing.JTextField();
        jCheckBoxExcludeWithin = new javax.swing.JCheckBox();
        jCheckBoxExcludeAfter = new javax.swing.JCheckBox();
        jCheckBoxExcludeBefore = new javax.swing.JCheckBox();
        jCheckBoxCheckSymmetry = new javax.swing.JCheckBox();
        jCheckBoxConditionSelect = new javax.swing.JCheckBox();
        jCheckBoxConditionExclude = new javax.swing.JCheckBox();
        jTextFieldExcludeAfterNumber = new javax.swing.JTextField();
        jTextFieldExcludeBeforeNumber = new javax.swing.JTextField();
        jLabelNumberAtomSelected = new javax.swing.JLabel();
        jLabelNumberAtomExcluded = new javax.swing.JLabel();
        jButtonSearchSelect = new javax.swing.JButton();
        jButtonSearchExclude = new javax.swing.JButton();
        jButtonClose = new javax.swing.JButton();
        jButtonCalculate = new javax.swing.JButton();

        jDialogResult.setTitle("Atom Distance Result");
        jDialogResult.setMinimumSize(new java.awt.Dimension(800, 600));

        jTableResult.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jTableResult.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        jTableResult.setCellSelectionEnabled(true);
        jScrollPane1.setViewportView(jTableResult);

        jMenuFile.setText("File");

        jMenuItemSaveAs.setText("Save As Text File");
        jMenuItemSaveAs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSaveAsActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuItemSaveAs);

        jMenuItemExit.setText("Close");
        jMenuItemExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemExitActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuItemExit);

        jMenuBar.add(jMenuFile);

        jMenuOrigin.setText("Origin Columns");
        jMenuBar.add(jMenuOrigin);

        jMenuFound.setText("Found Columns");
        jMenuBar.add(jMenuFound);

        javax.swing.GroupLayout jDialogResultLayout = new javax.swing.GroupLayout(jDialogResult.getContentPane());
        jDialogResult.getContentPane().setLayout(jDialogResultLayout);
        jDialogResultLayout.setHorizontalGroup(
            jDialogResultLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 452, Short.MAX_VALUE)
            .addGroup(jDialogResultLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jDialogResultLayout.createSequentialGroup()
                    .addGap(0, 0, 0)
                    .addComponent(jScrollPane1)
                    .addGap(0, 0, 0)))
        );
        jDialogResultLayout.setVerticalGroup(
            jDialogResultLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 424, Short.MAX_VALUE)
            .addGroup(jDialogResultLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jDialogResultLayout.createSequentialGroup()
                    .addGap(0, 0, 0)
                    .addComponent(jScrollPane1)
                    .addGap(1, 1, 1)))
        );

        jFileChooser.setDialogTitle("Save Result as Tab Delimited Text");
        jFileChooser.setDialogType(javax.swing.JFileChooser.SAVE_DIALOG);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Find Closest Atom Distances");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Origination Atoms / Coordinate"));

        jCheckBoxIncludeSelected.setSelected(true);
        jCheckBoxIncludeSelected.setText("Include selected");

        jRadioButtonChains.setText("Chains");

        jRadioButtonResidues.setSelected(true);
        jRadioButtonResidues.setText("Residues");

        jRadioButtonAtoms.setText("Atoms");

        jCheckBoxCoordinatePoints.setText("Coordinate points");

        jTextAreaCoordinateInput.setColumns(20);
        jTextAreaCoordinateInput.setRows(5);
        jScrollPaneCoordinateList.setViewportView(jTextAreaCoordinateInput);

        jRadioButtonOrthogonal.setSelected(true);
        jRadioButtonOrthogonal.setText("Orthogonal");

        jRadioButtonFractional.setText("Fractional");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPaneCoordinateList, javax.swing.GroupLayout.DEFAULT_SIZE, 406, Short.MAX_VALUE)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jCheckBoxIncludeSelected)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonChains)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonResidues)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonAtoms))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jCheckBoxCoordinatePoints)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonOrthogonal)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonFractional)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxIncludeSelected)
                    .addComponent(jRadioButtonChains)
                    .addComponent(jRadioButtonResidues)
                    .addComponent(jRadioButtonAtoms))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxCoordinatePoints)
                    .addComponent(jRadioButtonOrthogonal)
                    .addComponent(jRadioButtonFractional))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPaneCoordinateList, javax.swing.GroupLayout.DEFAULT_SIZE, 98, Short.MAX_VALUE)
                .addContainerGap())
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Search Options"));

        jLabel1.setText("Search limit maximum distance (in Angstroms)");

        jTextFieldDistanceMax.setText("10.00");

        jLabel2.setText("Search limit minimum distance (in Angstroms)");

        jTextFieldDistanceMin.setText("0.00");

        jCheckBoxExcludeWithin.setSelected(true);
        jCheckBoxExcludeWithin.setText("Exclude distance between atoms within the same residue");

        jCheckBoxExcludeAfter.setSelected(true);
        jCheckBoxExcludeAfter.setText("Exclude distance between atoms within residue number range plus");

        jCheckBoxExcludeBefore.setSelected(true);
        jCheckBoxExcludeBefore.setText("Exclude distance between atoms within residue number range minus");

        jCheckBoxCheckSymmetry.setSelected(true);
        jCheckBoxCheckSymmetry.setText("Check all symmetry mates");

        jCheckBoxConditionSelect.setText("Search only within atoms satisfying following conditions");

        jCheckBoxConditionExclude.setText("Exclude atoms satisfying following conditions");

        jTextFieldExcludeAfterNumber.setText("3");

        jTextFieldExcludeBeforeNumber.setText("3");

        jLabelNumberAtomSelected.setText("# of Atoms Selected :");

        jLabelNumberAtomExcluded.setText("# of Atoms Excluded :");

        jButtonSearchSelect.setText("Search & Select");
        jButtonSearchSelect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSearchSelectActionPerformed(evt);
            }
        });

        jButtonSearchExclude.setText("Search & Exclude");
        jButtonSearchExclude.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSearchExcludeActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                                .addComponent(jCheckBoxConditionSelect)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jButtonSearchSelect))
                            .addComponent(jCheckBoxExcludeWithin, javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                                .addComponent(jCheckBoxExcludeAfter)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jTextFieldExcludeAfterNumber, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE))
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                                .addComponent(jCheckBoxExcludeBefore)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jTextFieldExcludeBeforeNumber, javax.swing.GroupLayout.DEFAULT_SIZE, 53, Short.MAX_VALUE))
                            .addComponent(jCheckBoxCheckSymmetry, javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel1)
                                    .addComponent(jLabel2))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(jTextFieldDistanceMax)
                                    .addComponent(jTextFieldDistanceMin, javax.swing.GroupLayout.DEFAULT_SIZE, 49, Short.MAX_VALUE)))
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel2Layout.createSequentialGroup()
                                .addComponent(jCheckBoxConditionExclude)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonSearchExclude))))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(40, 40, 40)
                        .addComponent(jLabelNumberAtomSelected))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(39, 39, 39)
                        .addComponent(jLabelNumberAtomExcluded)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jTextFieldDistanceMax, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jTextFieldDistanceMin, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxCheckSymmetry)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxExcludeWithin)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxExcludeAfter)
                    .addComponent(jTextFieldExcludeAfterNumber, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxExcludeBefore)
                    .addComponent(jTextFieldExcludeBeforeNumber, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jCheckBoxConditionSelect)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabelNumberAtomSelected)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jCheckBoxConditionExclude)
                            .addComponent(jButtonSearchExclude))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabelNumberAtomExcluded))
                    .addComponent(jButtonSearchSelect))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jButtonCalculate.setText("Calculate");
        jButtonCalculate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCalculateActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addContainerGap())
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButtonCalculate)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonClose)
                        .addGap(14, 14, 14))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonCalculate)
                    .addComponent(jButtonClose))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        this.dispose();
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void jButtonSearchSelectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSearchSelectActionPerformed
        selectedDialog.show(true);
        this.jLabelNumberAtomSelected.setText(SelectedLabelBase + selectedDialog.getFoundCoordinateIndicies().length);
    }//GEN-LAST:event_jButtonSearchSelectActionPerformed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing

    }//GEN-LAST:event_formWindowClosing

    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
       selectedDialog.dispose();
       excludedDialog.dispose();
       jDialogResult.dispose();
    }//GEN-LAST:event_formWindowClosed

    private void jButtonSearchExcludeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSearchExcludeActionPerformed
        excludedDialog.show(true);
        this.jLabelNumberAtomExcluded.setText(ExcludeLabelBase + excludedDialog.getFoundCoordinateIndicies().length);
    }//GEN-LAST:event_jButtonSearchExcludeActionPerformed

    private void jButtonCalculateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCalculateActionPerformed
        Run();
    }//GEN-LAST:event_jButtonCalculateActionPerformed

    private void jMenuItemExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemExitActionPerformed
        this.jDialogResult.hide();
    }//GEN-LAST:event_jMenuItemExitActionPerformed

    private void jMenuItemSaveAsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSaveAsActionPerformed
        if (this.jFileChooser.showSaveDialog(this) == javax.swing.JFileChooser.APPROVE_OPTION)
        {
            java.io.File file = this.jFileChooser.getSelectedFile();
            Global.SaveTextFile(file.getPath(), Global.FormatTabbedTextFromTable(jTableResult, true));
        }
    }//GEN-LAST:event_jMenuItemSaveAsActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupSelectAtom;
    private javax.swing.ButtonGroup buttonGroupSelectCoordinate;
    private javax.swing.JButton jButtonCalculate;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonSearchExclude;
    private javax.swing.JButton jButtonSearchSelect;
    private javax.swing.JCheckBox jCheckBoxCheckSymmetry;
    private javax.swing.JCheckBox jCheckBoxConditionExclude;
    private javax.swing.JCheckBox jCheckBoxConditionSelect;
    private javax.swing.JCheckBox jCheckBoxCoordinatePoints;
    private javax.swing.JCheckBox jCheckBoxExcludeAfter;
    private javax.swing.JCheckBox jCheckBoxExcludeBefore;
    private javax.swing.JCheckBox jCheckBoxExcludeWithin;
    private javax.swing.JCheckBox jCheckBoxIncludeSelected;
    private javax.swing.JDialog jDialogResult;
    private javax.swing.JFileChooser jFileChooser;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabelNumberAtomExcluded;
    private javax.swing.JLabel jLabelNumberAtomSelected;
    private javax.swing.JMenuBar jMenuBar;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenu jMenuFound;
    private javax.swing.JMenuItem jMenuItemExit;
    private javax.swing.JMenuItem jMenuItemSaveAs;
    private javax.swing.JMenu jMenuOrigin;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JRadioButton jRadioButtonAtoms;
    private javax.swing.JRadioButton jRadioButtonChains;
    private javax.swing.JRadioButton jRadioButtonFractional;
    private javax.swing.JRadioButton jRadioButtonOrthogonal;
    private javax.swing.JRadioButton jRadioButtonResidues;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPaneCoordinateList;
    private javax.swing.JTable jTableResult;
    private javax.swing.JTextArea jTextAreaCoordinateInput;
    private javax.swing.JTextField jTextFieldDistanceMax;
    private javax.swing.JTextField jTextFieldDistanceMin;
    private javax.swing.JTextField jTextFieldExcludeAfterNumber;
    private javax.swing.JTextField jTextFieldExcludeBeforeNumber;
    // End of variables declaration//GEN-END:variables
}

    
class ResultData
{
    public Object Origin = null;
    public Atom Target = null;
    public int Symmop = 0;
    public double Distance = 0;
    
    public ResultData(Object origin, Atom target, int symmop, double distance)
    {
        Origin = origin;
        Target = target;
        Symmop = symmop;
        Distance = distance;
    }
}
