/*
 * GenerateSymmetryMateDialog.java
 *
 * Created on April 1, 2008, 6:32 PM
 */

package pdb_editor.dialogs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.FormulaEvaluator;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.Coordinate;

/**
 *
 * @author  Owner
 */
public class GenerateSymmetryMateDialog extends javax.swing.JDialog {

    private EditorFrame Parent  = null;    
    private DataModel tabledata = null;
    private CoordinateTable maintable = null;
    private DataSet maindata = null;
    private String[][] symmops = null;
    private boolean[] selectedops = null;
    private String[] selectedChains = null;
    private char[][] newchainid = null;
    private TreeSet<Character> allChainID = null;
    
    /** Creates new form GenerateSymmetryMateDialog */
    public GenerateSymmetryMateDialog(java.awt.Frame parent, boolean modal, CoordinateTable ctable) {
        super(parent, modal);
        try { Parent = (EditorFrame)parent; } catch (Exception e) {}
        maintable = ctable;
        maindata = maintable.getMainData();
        symmops = maindata.Spacegroup().symmetryOperators().clone();
        selectedops = new boolean[symmops.length];
        selectedops[0] = false;
        for (int i=1; i<selectedops.length; i++) selectedops[i] = true;
        getAllChains();
        makeNewChainID();
        tabledata = new DataModel();
        initComponents();
        setColumnWidth();
        initButtonGroup();
    }

    class DataModel extends AbstractTableModel {

      	public String getColumnName(int col) {
            switch (col)
            {
                case 0 : return "";
                case 1 : return "x";
                case 2 : return "y";
                case 3 : return "z";
            }
            return selectedChains[col-4];
        }

        public int getRowCount() {
            return symmops.length;
        }

        public int getColumnCount() {
            return selectedChains.length + 4;
        }

        public Object getValueAt(int ri, int ci) {
            switch (ci)
            {
                case 0 : return selectedops[ri];
                case 1 : return symmops[ri][0];
                case 2 : return symmops[ri][1];
                case 3 : return symmops[ri][2];
            }
            return "" + newchainid[ri][ci-4];
        }

        public void setValueAt(Object v, int r, int c) {
            switch (c)
            {
                case 0 : setOperators((Boolean)v, r); break;
                case 1 : symmops[r][0] = (String)v; break;
                case 2 : symmops[r][1] = (String)v; break;
                case 3 : symmops[r][2] = (String)v; break;
            }
            if (c > 3)
            {
                String s = (String)v;
                char id = ' ';
                if (s.length() > 0) id= s.charAt(s.length() - 1);
                int[] rows = jTable.getSelectedRows();
                int[] cols = jTable.getSelectedColumns();
                for (int i=0; i<rows.length; i++)
                    for (int j=0; j<cols.length; j++)
                        if (cols[j] > 3)
                            newchainid[rows[i]][cols[j] - 4] = id;
            }
        }
        
        public void setOperators(boolean v, int r)
        {
            if (jCheckBoxMoveExisting.isSelected())
            {
                selectedops[r] = true;
                for (int i=0; i<selectedops.length; i++)
                    if (i != r) 
                    {
                        selectedops[i] = false;
                        this.fireTableRowsUpdated(i, i);
                    }
            }
            else selectedops[r] = v;
        }
        
       	public Class getColumnClass(int col) {
            if (col == 0) return Global.booleanclass.getClass();
            return Global.stringclass.getClass();
        }
        
        public boolean isCellEditable(int row, int col) {
            return true;
        }
    }
    
    private void setColumnWidth()
    {
        TableColumn column = null;
	
        for (int i=0; i<this.tabledata.getColumnCount(); i++)
        {
            column = jTable.getColumnModel().getColumn(i);
            switch (i)
            {
                case 0 : column.setPreferredWidth(25); break;
                case 1 : column.setPreferredWidth(60); break;
                case 2 : column.setPreferredWidth(60); break;
                case 3 : column.setPreferredWidth(60); break;
                default : column.setPreferredWidth(25); break;
            }
        }
    }
    
    private void initButtonGroup()
    {
        this.buttonGroupAtomSelection.add(this.jRadioButtonAllAtoms);
        this.buttonGroupAtomSelection.add(this.jRadioButtonSelectedAtoms);
        this.buttonGroupAtomSelection.add(this.jRadioButtonSelectedChains);
        
        this.jRadioButtonAllAtoms.setSelected(true);
    }
    
    private void makeNewChainID()
    {
        char[] temp = new char[selectedChains.length];
        for (int i=0; i<temp.length; i++) temp[i] = selectedChains[i].charAt(0);
        
        TreeSet<Character> usedChainID = (TreeSet<Character>)allChainID.clone();
        
        newchainid = new char[this.symmops.length][this.selectedChains.length];
        for (int i=0; i<newchainid.length; i++)
            for (int j=0; j<newchainid[i].length; j++)
            {
                while (usedChainID.contains(temp[j])) temp[j]++;
                newchainid[i][j] = temp[j];
                usedChainID.add(temp[j]);
            }
    }
    
    private void getAllChains()
    {
        TreeSet<String> list = new TreeSet<String> ();
        allChainID = new TreeSet<Character> ();
        Iterator<Atom> i = maindata.Atoms().iterator();
        while (i.hasNext())
        {
            Atom a = i.next();
            allChainID.add(a.ChainID());
            list.add("" + a.ChainID());
        }
        selectedChains = list.toArray(new String[list.size()]);
    }
    
    private void Run()
    {
        if (Parent != null) Parent.listenForUndoStart("Generate symmetry");
        int[] indicies = getAtomIndicies();
        for (int i=0; i<selectedops.length; i++)
            if (selectedops[i])
            {
                Atom[] list = getSelectedAtoms(indicies, i);
                doSymmetryOperation(i, list);
             }
        if (Parent != null) Parent.listenForUndoStop();
        maintable.fireTableDataChanged();
    }
    
    private void doSymmetryOperation(int OpNum, Atom[] list)
    {
        FormulaEvaluator[] f = getSymmOpFormula(OpNum);
        for (int i=0; i<list.length; i++)
        {
            Atom a = list[i];
            HashMap<String, Double> vars = getFormulaVariables(a);
            Coordinate c = new Coordinate(f[0].evaluateExpression(vars), f[1].evaluateExpression(vars), f[2].evaluateExpression(vars));
            if (this.jCheckBoxForceBoundary.isSelected()) forceFractional(c);
            a.FractionalCoordinate(c);
        }
    }
    
    private void forceFractional(Coordinate c)
    {
        c.x(Global.ForceFractionalNumber(c.x(), 0, 1));
        c.y(Global.ForceFractionalNumber(c.y(), 0, 1));
        c.z(Global.ForceFractionalNumber(c.z(), 0, 1));
    }
    
    private HashMap<String, Double> getFormulaVariables(Atom a)
    {
        HashMap<String, Double> r = new HashMap<String, Double> ();
        
        r.put("X", a.x());
        r.put("Y", a.y());
        r.put("Z", a.z());
        
        return r;
    }
    
    private FormulaEvaluator[] getSymmOpFormula(int OpNum)
    {
         FormulaEvaluator[] f = new FormulaEvaluator[3];
         
         for (int i = 0; i<f.length; i++)
             f[i] = new FormulaEvaluator(this.symmops[OpNum][i]);
         
         return f;
    }
    
    private Atom[] getSelectedAtoms(int[] indicies, int SymmOpNum)
    {
        if (this.jCheckBoxMoveExisting.isSelected())
        {
            return maindata.getAtoms(indicies);
        }
        else
        {
            TreeMap<Character, Character> changeID = getChainIDChange(SymmOpNum);
            Atom[] list = maindata.CopyAtoms(true, indicies);
            for (int i=0; i<list.length; i++)
            {
                if (changeID.containsKey(list[i].ChainID()))
                    list[i].ChainID(changeID.get(list[i].ChainID()));
            }
            return list;
        }
    }
    
    private TreeMap<Character, Character> getChainIDChange(int SymmOpNum)
    {
        TreeMap<Character, Character> r = new TreeMap<Character, Character> ();
        
        int j=0;
        Iterator<Character> i = allChainID.iterator();
        while (i.hasNext())
        {
            char c = i.next();
            r.put(c, newchainid[SymmOpNum][j++]);
        }
        
        return r;
    }
    
    private int[] getAtomIndicies()
    {
        if (this.jRadioButtonAllAtoms.isSelected()) return Global.GenerateIntegerIndiciesArray(maindata.Atoms().size());
        if (this.jRadioButtonSelectedAtoms.isSelected()) return maintable.getSelectedRows();
        if (this.jRadioButtonSelectedChains.isSelected()) return maindata.getChainIndicies(maintable.getSelectedRows());
        return null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroupAtomSelection = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable = new javax.swing.JTable();
        jButtonSelectAll = new javax.swing.JButton();
        jButtonSelectNone = new javax.swing.JButton();
        jButtonResetAll = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jRadioButtonAllAtoms = new javax.swing.JRadioButton();
        jRadioButtonSelectedChains = new javax.swing.JRadioButton();
        jRadioButtonSelectedAtoms = new javax.swing.JRadioButton();
        jCheckBoxMoveExisting = new javax.swing.JCheckBox();
        jCheckBoxForceBoundary = new javax.swing.JCheckBox();
        jButtonClose = new javax.swing.JButton();
        jButtonGenerate = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Generate Symmetry Mate");

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Symmetry Operations"));

        jTable.setModel(this.tabledata);
        jTable.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        jTable.setCellSelectionEnabled(true);
        jScrollPane1.setViewportView(jTable);

        jButtonSelectAll.setText("Select All");
        jButtonSelectAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSelectAllActionPerformed(evt);
            }
        });

        jButtonSelectNone.setText("Deselect All");
        jButtonSelectNone.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSelectNoneActionPerformed(evt);
            }
        });

        jButtonResetAll.setText("Default ChainID");
        jButtonResetAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonResetAllActionPerformed(evt);
            }
        });

        jLabel1.setText("x = x op;  y = y op;  z = z op;  All other columns = New chain ID");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jButtonSelectAll)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonSelectNone)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 56, Short.MAX_VALUE)
                .addComponent(jButtonResetAll))
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addContainerGap(24, Short.MAX_VALUE))
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 343, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 239, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonResetAll)
                    .addComponent(jButtonSelectAll)
                    .addComponent(jButtonSelectNone)))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Atom Selection"));

        jRadioButtonAllAtoms.setText("All Atoms");

        jRadioButtonSelectedChains.setText("Selected Chains");

        jRadioButtonSelectedAtoms.setText("Selected Atoms");

        jCheckBoxMoveExisting.setText("Do not generate new atoms / Move existing atoms");
        jCheckBoxMoveExisting.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxMoveExistingActionPerformed(evt);
            }
        });

        jCheckBoxForceBoundary.setText("Force fractional coordinate boundary from 0 to 1");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jRadioButtonAllAtoms)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonSelectedChains)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonSelectedAtoms))
                    .addComponent(jCheckBoxMoveExisting)
                    .addComponent(jCheckBoxForceBoundary))
                .addContainerGap(68, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioButtonAllAtoms)
                    .addComponent(jRadioButtonSelectedChains)
                    .addComponent(jRadioButtonSelectedAtoms))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxMoveExisting)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxForceBoundary)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jButtonGenerate.setText("Generate");
        jButtonGenerate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGenerateActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButtonGenerate)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonClose)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(17, 17, 17)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonClose)
                    .addComponent(jButtonGenerate))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        this.dispose();
}//GEN-LAST:event_jButtonCloseActionPerformed

    private void jButtonSelectAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSelectAllActionPerformed
        for (int i=0; i<selectedops.length; i++) selectedops[i] = true;
        tabledata.fireTableDataChanged();
    }//GEN-LAST:event_jButtonSelectAllActionPerformed

    private void jButtonSelectNoneActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSelectNoneActionPerformed
         for (int i=0; i<selectedops.length; i++) selectedops[i] = false;
        tabledata.fireTableDataChanged();
    }//GEN-LAST:event_jButtonSelectNoneActionPerformed

    private void jButtonResetAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonResetAllActionPerformed
        makeNewChainID();
        tabledata.fireTableDataChanged();
    }//GEN-LAST:event_jButtonResetAllActionPerformed

    private void jCheckBoxMoveExistingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxMoveExistingActionPerformed
        jButtonSelectNoneActionPerformed(null);
        if (selectedops.length > 1) selectedops[1] = true;
        tabledata.fireTableDataChanged();
    }//GEN-LAST:event_jCheckBoxMoveExistingActionPerformed

    private void jButtonGenerateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonGenerateActionPerformed
        Run();
    }//GEN-LAST:event_jButtonGenerateActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupAtomSelection;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonGenerate;
    private javax.swing.JButton jButtonResetAll;
    private javax.swing.JButton jButtonSelectAll;
    private javax.swing.JButton jButtonSelectNone;
    private javax.swing.JCheckBox jCheckBoxForceBoundary;
    private javax.swing.JCheckBox jCheckBoxMoveExisting;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JRadioButton jRadioButtonAllAtoms;
    private javax.swing.JRadioButton jRadioButtonSelectedAtoms;
    private javax.swing.JRadioButton jRadioButtonSelectedChains;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable;
    // End of variables declaration//GEN-END:variables
    
}
