/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package pdb_reader;

import java.util.ArrayList;
import java.util.EventObject;
import pdb_reader.data.Atom;
import pdb_reader.data.AtomDataChangeEvent;

/**
 *
 * @author Owner
 */
public class DataSetDataChangeEvent extends EventObject{
    
    public static final int NOT_SPECIFIED_EVENT = -1;
    public static final int CHANGE_EVENT = 0;
    public static final int ADD_EVENT = 1;
    public static final int DELETE_EVENT = 2;
    public static final int SORT_EVENT = 3;
    
    public int eventCode = NOT_SPECIFIED_EVENT;
    public Atom atomChanged = null;
    public int lastIndex = 0;
    public ArrayList<Atom> oldData = null;
    public AtomDataChangeEvent atomChangeEvent = null;
    
    public DataSetDataChangeEvent(Object sender, int EventCode, Atom AtomChanged)
    {
        super(sender);
        eventCode = EventCode;
        atomChanged = AtomChanged;
    }
    
    public DataSetDataChangeEvent(Object sender, int EventCode, Atom AtomChanged, int LastIndex)
    {
        this(sender, EventCode, AtomChanged);
        lastIndex = LastIndex;
    }
    
    public DataSetDataChangeEvent(Object sender, AtomDataChangeEvent e)
    {
        super(sender);
        eventCode = CHANGE_EVENT;
        atomChanged = e.atomChanged;
        atomChangeEvent = e;
    }
    
    public DataSetDataChangeEvent(Object sender, int EventCode)
    {
        super(sender);
        DataSet ds = (DataSet)sender;
        eventCode = EventCode;
        oldData = (ArrayList<Atom>)ds.Atoms().clone();
    }
}
