package pdb_reader;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.TreeMap;
import pdb_reader.data.Coordinate;

public class Global {
        static public Boolean booleanclass = false;
	static public Integer integerclass = 0;
	static public Double doubleclass = 0.1;
	static public String stringclass = "";
	static public Character charclass = ' ';
	
        static public double DegreeToRadian = 0.0174532925;
        
        static public int compareObjects(Object a1, Object a2)
        {
            int dataType = -1;
            if ((dataType == -1) && (a1.getClass().equals(Global.booleanclass.getClass()))) dataType = 0;
            if ((dataType == -1) && (a1.getClass().equals(Global.charclass.getClass()))) dataType = 1;
            if ((dataType == -1) && (a1.getClass().equals(Global.integerclass.getClass()))) dataType = 2;
            if ((dataType == -1) && (a1.getClass().equals(Global.doubleclass.getClass()))) dataType = 3;
            if ((dataType == -1) && (a1.getClass().equals(Global.stringclass.getClass()))) dataType = 4;
            
            switch (dataType)
            {
                case 0 : 
                    int i1 = ((Boolean)a1) ? 1 : 0;
                    int i2 = ((Boolean)a2) ? 1 : 0;
                    return i1 - i2;                    
                case 1 : return (Character)a1 - (Character)a2;
                case 2 : return (Integer)a1 - (Integer)a2;
                case 3 : 
                    double d = ((Double)a1 - (Double)a2);
                    if (d > 0) return 1;
                    if (d < 0) return -1;
                    return 0;
                case 4 : return ((String)a1).compareTo((String)a2);
            }
            return 0;
        }
        
        static public String AddFileExtension(String filename, String extension)
        {
            extension = '.' + extension;
            boolean append = false; 
            if (filename.length() > extension.length())
            {   
                if (!filename.substring(filename.length() - extension.length()).equals(extension))
                    append = true;
            }
            else append = true;
            if (append) filename += extension;
            return filename;
        }
        
        
        static public String GetSubstring(String s, int startindex, int endindex)
        {
            if (s.length() > startindex)
            {
                if (s.length() <= endindex) return s.substring(startindex);
                else return s.substring(startindex, endindex);
            }
            return null;
        }
        
	static public double CorrectRange(double Value, double Maximum, double Minimum)
	{
		if (Value > Maximum) return Maximum;
		if (Value < Minimum) return Minimum;
		return Value;
	}
	
	static public int CorrectRange(int Value, int Maximum, int Minimum)
	{
		if (Value > Maximum) return Maximum;
		if (Value < Minimum) return Minimum;
		return Value;
	}
	
	static public void SaveTextFile(String Filename, String TextLines)
	{
		try
		{
			BufferedWriter bw = new BufferedWriter(new FileWriter(Filename));
			bw.write(TextLines);
			bw.close();
		}
		catch (Exception e)
		{
                    javax.swing.JOptionPane.showMessageDialog(null, "Error saving " + Filename + '\n' + e.getMessage(), "Error saving file", javax.swing.JOptionPane.ERROR_MESSAGE);
		}
	}
	
	static public String[] ReadTextFile(String Filename)
	{
		ArrayList<String> al = new ArrayList<String>();
		try
		{
			BufferedReader br = new BufferedReader(new FileReader(Filename));
			String s;
			while ((s = br.readLine()) != null) 
				al.add(s);
			br.close();
		}
		catch (Exception e)
		{
		}
		String [] result = new String[al.size()];
		al.toArray(result);
		return result;
	}

        static public String[] ReadTextResource(String ResourceName)
	{
		ArrayList<String> al = new ArrayList<String>();
                java.net.URL u = DataSet.class.getResource(ResourceName);

                try {
                     InputStream is = (InputStream)u.getContent();
                     BufferedReader br = new BufferedReader(new InputStreamReader(is));
                     			String s;
			while ((s = br.readLine()) != null) 
				al.add(s);
			br.close();
                }
                catch (Exception e) {}
                
		String [] result = new String[al.size()];
		al.toArray(result);
		return result;
	}
	
	static public Object ConvertString(String In, Class c)
	{
		if (c.equals(Global.booleanclass.getClass())) return Boolean.parseBoolean(In);
		if (c.equals(Global.integerclass.getClass())) return Integer.parseInt(In);
		if (c.equals(Global.doubleclass.getClass())) return Double.parseDouble(In);
		if (c.equals(Global.charclass.getClass())) return In.charAt(0);
		if (c.equals(In.getClass())) return In;
		return null;
	}
	
        static public int[] ConvertIntegerArrayToIntArray(Integer[] arrayin)
        {
            int[] r = new int[arrayin.length];
            
            for (int i=0; i<arrayin.length; i++)
                r[i] = arrayin[i];
            
            return r;
        }
        
	/*static public Boolean StringToBoolean(String In)
	{
		String i = In.toUpperCase().trim();
		if ((i.equals("TRUE")) ||
				(i.equals("1")) ||
				(i.equals("T"))) return true;
		if ((i.equals("FALSE")) ||
				(i.equals("0")) ||
				(i.equals("F"))) return false;
		return null;
	}
	
	/**
	 * Converts number in string format to integer
	 * 
	 * @param String
	 * @return int
	 */
	/*static public int StringToInt(String In)
	{
		boolean negative = false;
		int result = 0;
		if (FindDigit(In.charAt(0)) == -1) negative = true;
		for (int i =0; i < In.length(); i++)
		{
			result *= 10;
			int curnum = FindDigit(In.charAt(i));
			if (curnum > 0) result += curnum; 
		}
		if (negative == true) result *= -1;
		return result;
	}
	
	/**
	 * Converts number in string format to double
	 * 
	 * @param String
	 * @return double
	 */
	/*static public double StringToDouble(String In)
	{
		boolean negative = false, decimal = false;
		double result = 0;
		int decimalpts = 0;
		if (FindDigit(In.charAt(0)) == -1) negative = true;
		for (int i =0; i < In.length(); i++)
		{
			if (decimal == true) decimalpts++;
			int curnum = FindDigit(In.charAt(i));
			if (curnum >= 0) { result *= 10; result += curnum; }
			else if (curnum == -2) decimal = true;
		}
		if (negative == true) result *= -1;
		if (decimal == true) result /= Math.pow(10, decimalpts);
		return result;
	}
	
	static private int FindDigit(char c)
	{
		int result = -3;
		switch (c)
		{
		case '0' : return 0;
		case '1' : return 1;
		case '2' : return 2;
		case '3' : return 3;
		case '4' : return 4;
		case '5' : return 5;
		case '6' : return 6;
		case '7' : return 7;
		case '8' : return 8;
		case '9' : return 9;
		case '-' : return -1;
		case '.' : return -2;
		}
		return result ;
	}*/
	
	/**
	 * Checks String array contains the target string
	 * 
	 * @param String[] ArrayToBeSearched, String StringToBeFound
	 * @return boolean
	 */
	static public boolean StringArrayContains(String[] arrayin, String target)
	{
		target = target.trim();
		for (int i=0; i < arrayin.length; i++)
			if (target.equals(arrayin[i])) return true;
		return false;
	}
	
        static public int StringArrayFindIndex(String[] arrayin, String target)
        {
            for (int i=0; i<arrayin.length; i++)
                if (target.equals(arrayin[i]))
                    return i;
            return -1;
        }

        static public int StringArrayFindIndexForSubstring(String[] arrayin, String target)
        {
            for (int i=0; i<arrayin.length; i++)
                if (arrayin[i].length() >= target.length())
                    if (arrayin[i].substring(0, target.length()).equals(target))
                        return i;
            return -1;
        }

        static public int StringArrayFindIndexForSubstring(String[] arrayin, String target, int startindex)
        {
            for (int i=startindex; i<arrayin.length; i++)
                if (arrayin[i].length() >= target.length())
                    if (arrayin[i].substring(0, target.length()).equals(target))
                        return i;
            return -1;
        }
        
        static public boolean IntegerArrayContains(int[] arrayin, int target)
        {
            for (int i=0; i<arrayin.length; i++)
                if (arrayin[i] == target)
                    return true;
            return false;
        }
        
        static public int IntegerArrayFindIndex(int[] array, int target)
        {
            for (int i=0; i<array.length; i++)
                if (array[i] == target) return i;
            return -1;
        }
        
        static public String[][] TabulateStringByLineTab(String source)
        {
            return TabulateStringByDelimiters(source, "\\n", "\\t");
        }
        
        static public String[][] TabulateStringByDelimiters(String source, String regex1, String regex2)
        {
            String[][] result = null;
            
            String[] split = source.split(regex1);
            result = new String[split.length][];
            
            for (int i=0; i<result.length; i++)
            {
                String[] sub = split[i].split(regex2);
                result[i] = sub;
            }
            
            return result;
        }
	
	/**
	 * Returns the capitalized extension of the file
	 * by splitting filename with "."
	 * and returning the last split
	 * @param File f
	 * @return String or null (if it doesn't split)
	 */
	static public String GetFileExtension(File f)
	{
		String fn = f.getAbsolutePath();
		
		int index = -1;
		boolean stop = false;
		for (int i=fn.length() - 2; i >=0; i--)
		{
			switch (fn.charAt(i))
			{
			case '.' : index = i; stop = true; break;
			case '\\' : stop = true; break;
			case '/' : stop = true; break;
			}
			if (stop == true) break;
		}
		
		if (index != -1) return fn.substring(index + 1).toUpperCase();
		
		/*String[] parts = f.getName().split("\\.");
		if (parts.length >= 2) 
		{
				return parts[parts.length - 1].toUpperCase();
		}*/
		return null;
	}
	
	static public String TrimFileName(String fileName, int parentlevel)
	{
		String[] parts = null;
		boolean backslash = false;
		if (fileName.charAt(0) == '/') 
		{
			backslash = false;
			parts = fileName.split("/");
		}
		else
		{
			parts = fileName.split("\\\\");
			backslash = true;
		}
		
		StringBuilder sb = new StringBuilder();
		
		if (parts.length <= parentlevel + 1) return fileName;
		
		if (backslash == true) 
			sb.append(parts[0] + '\\');
		
		int i = parts.length - parentlevel - 1;
		if (i < 0) i = 0;
		if ((i > 0) && (backslash == false)) sb.append("/.../");
		if ((i < 1) && (backslash == true)) i = 1;
		if ((i > 1) && (backslash == true)) sb.append("...\\");
		
		for (; i<parts.length; i++)
		{
			sb.append(parts[i]);
			if (i != parts.length - 1)
			{
				if (backslash == true) sb.append('\\');
				else sb.append('/');
			}
		}
		
		return sb.toString();
	}
	
	
	 static public boolean IsIdentityMatrix(double[][] m)
	 {
	  for (int i=0; i<m.length; i++)
	  {
	   if (m[i].length != m.length) return false;
	   for (int j=0; j<m[i].length; j++)
	   {
	    if ((i == j) && (m[i][j] != 1)) return false;
	    if ((i != j) && (m[i][j] != 0)) return false;
	   }
	  }
	  return true;
	 }
	 
	 static public double Determinant4x4Matrix(double[][] m)
	    {
	        double value;
	        value =
	        m[0][3] * m[1][2] * m[2][1] * m[3][0] - m[0][2] * m[1][3] * m[2][1] * m[3][0] - m[0][3] * m[1][1] * m[2][2] * m[3][0] + m[0][1] * m[1][3] * m[2][2] * m[3][0] +
	        m[0][2] * m[1][1] * m[2][3] * m[3][0] - m[0][1] * m[1][2] * m[2][3] * m[3][0] - m[0][3] * m[1][2] * m[2][0] * m[3][1] + m[0][2] * m[1][3] * m[2][0] * m[3][1] +
	        m[0][3] * m[1][0] * m[2][2] * m[3][1] - m[0][0] * m[1][3] * m[2][2] * m[3][1] - m[0][2] * m[1][0] * m[2][3] * m[3][1] + m[0][0] * m[1][2] * m[2][3] * m[3][1] +
	        m[0][3] * m[1][1] * m[2][0] * m[3][2] - m[0][1] * m[1][3] * m[2][0] * m[3][2] - m[0][3] * m[1][0] * m[2][1] * m[3][2] + m[0][0] * m[1][3] * m[2][1] * m[3][2] +
	        m[0][1] * m[1][0] * m[2][3] * m[3][2] - m[0][0] * m[1][1] * m[2][3] * m[3][2] - m[0][2] * m[1][1] * m[2][0] * m[3][3] + m[0][1] * m[1][2] * m[2][0] * m[3][3] +
	        m[0][2] * m[1][0] * m[2][1] * m[3][3] - m[0][0] * m[1][2] * m[2][1] * m[3][3] - m[0][1] * m[1][0] * m[2][2] * m[3][3] + m[0][0] * m[1][1] * m[2][2] * m[3][3];
	        return value;
	    }

	 static public double[][] Inverse4x4Matrix(double[][] m)
	 {
	  double[][] n = new double[4][4];
	  
	        n[0][0] = m[1][2] * m[2][3] * m[3][1] - m[1][3] * m[2][2] * m[3][1] + m[1][3] * m[2][1] * m[3][2] - m[1][1] * m[2][3] * m[3][2] - m[1][2] * m[2][1] * m[3][3] + m[1][1] * m[2][2] * m[3][3];
	        n[0][1] = m[0][3] * m[2][2] * m[3][1] - m[0][2] * m[2][3] * m[3][1] - m[0][3] * m[2][1] * m[3][2] + m[0][1] * m[2][3] * m[3][2] + m[0][2] * m[2][1] * m[3][3] - m[0][1] * m[2][2] * m[3][3];
	        n[0][2] = m[0][2] * m[1][3] * m[3][1] - m[0][3] * m[1][2] * m[3][1] + m[0][3] * m[1][1] * m[3][2] - m[0][1] * m[1][3] * m[3][2] - m[0][2] * m[1][1] * m[3][3] + m[0][1] * m[1][2] * m[3][3];
	        n[0][3] = m[0][3] * m[1][2] * m[2][1] - m[0][2] * m[1][3] * m[2][1] - m[0][3] * m[1][1] * m[2][2] + m[0][1] * m[1][3] * m[2][2] + m[0][2] * m[1][1] * m[2][3] - m[0][1] * m[1][2] * m[2][3];
	        n[1][0] = m[1][3] * m[2][2] * m[3][0] - m[1][2] * m[2][3] * m[3][0] - m[1][3] * m[2][0] * m[3][2] + m[1][0] * m[2][3] * m[3][2] + m[1][2] * m[2][0] * m[3][3] - m[1][0] * m[2][2] * m[3][3];
	        n[1][1] = m[0][2] * m[2][3] * m[3][0] - m[0][3] * m[2][2] * m[3][0] + m[0][3] * m[2][0] * m[3][2] - m[0][0] * m[2][3] * m[3][2] - m[0][2] * m[2][0] * m[3][3] + m[0][0] * m[2][2] * m[3][3];
	        n[1][2] = m[0][3] * m[1][2] * m[3][0] - m[0][2] * m[1][3] * m[3][0] - m[0][3] * m[1][0] * m[3][2] + m[0][0] * m[1][3] * m[3][2] + m[0][2] * m[1][0] * m[3][3] - m[0][0] * m[1][2] * m[3][3];
	        n[1][3] = m[0][2] * m[1][3] * m[2][0] - m[0][3] * m[1][2] * m[2][0] + m[0][3] * m[1][0] * m[2][2] - m[0][0] * m[1][3] * m[2][2] - m[0][2] * m[1][0] * m[2][3] + m[0][0] * m[1][2] * m[2][3];
	        n[2][0] = m[1][1] * m[2][3] * m[3][0] - m[1][3] * m[2][1] * m[3][0] + m[1][3] * m[2][0] * m[3][1] - m[1][0] * m[2][3] * m[3][1] - m[1][1] * m[2][0] * m[3][3] + m[1][0] * m[2][1] * m[3][3];
	        n[2][1] = m[0][3] * m[2][1] * m[3][0] - m[0][1] * m[2][3] * m[3][0] - m[0][3] * m[2][0] * m[3][1] + m[0][0] * m[2][3] * m[3][1] + m[0][1] * m[2][0] * m[3][3] - m[0][0] * m[2][1] * m[3][3];
	        n[2][2] = m[0][1] * m[1][3] * m[3][0] - m[0][3] * m[1][1] * m[3][0] + m[0][3] * m[1][0] * m[3][1] - m[0][0] * m[1][3] * m[3][1] - m[0][1] * m[1][0] * m[3][3] + m[0][0] * m[1][1] * m[3][3];
	        n[2][3] = m[0][3] * m[1][1] * m[2][0] - m[0][1] * m[1][3] * m[2][0] - m[0][3] * m[1][0] * m[2][1] + m[0][0] * m[1][3] * m[2][1] + m[0][1] * m[1][0] * m[2][3] - m[0][0] * m[1][1] * m[2][3];
	        n[3][0] = m[1][2] * m[2][1] * m[3][0] - m[1][1] * m[2][2] * m[3][0] - m[1][2] * m[2][0] * m[3][1] + m[1][0] * m[2][2] * m[3][1] + m[1][1] * m[2][0] * m[3][2] - m[1][0] * m[2][1] * m[3][2];
	        n[3][1] = m[0][1] * m[2][2] * m[3][0] - m[0][2] * m[2][1] * m[3][0] + m[0][2] * m[2][0] * m[3][1] - m[0][0] * m[2][2] * m[3][1] - m[0][1] * m[2][0] * m[3][2] + m[0][0] * m[2][1] * m[3][2];
	        n[3][2] = m[0][2] * m[1][1] * m[3][0] - m[0][1] * m[1][2] * m[3][0] - m[0][2] * m[1][0] * m[3][1] + m[0][0] * m[1][2] * m[3][1] + m[0][1] * m[1][0] * m[3][2] - m[0][0] * m[1][1] * m[3][2];
	        n[3][3] = m[0][1] * m[1][2] * m[2][0] - m[0][2] * m[1][1] * m[2][0] + m[0][2] * m[1][0] * m[2][1] - m[0][0] * m[1][2] * m[2][1] - m[0][1] * m[1][0] * m[2][2] + m[0][0] * m[1][1] * m[2][2];

	        double scale = 1 / Determinant4x4Matrix(m);
	        for (int i = 0; i < 4; i++)
	            for (int j = 0; j < 4; j++)
	                n[i][j] *= scale;

	        return n;
	 }
         
         static public double[][] GenerateTransformationMatrix(double[] d12Elements)
         {
             double[][] r = new double[4][4];
             
             for (int i=0; i<4; i++)
                 for (int j=0; j<4; j++)
                 {
                     int index = i*4 + j;
                     if (index < 12) r[i][j] = d12Elements[index];
                     else 
                     {
                         if (index < 15) r[i][j] = 0;
                         else r[i][j] = 1;
                     }
                 }
             
             return r;
         }

         static public double[][] GenerateTransformationFromRotationMatrix(double[] d9Elements)
         {
             double[][] r = new double[4][4];
             
             int  k=0;
             for (int i=0; i<4; i++)
                 for (int j=0; j<4; j++)
                 {
                     if ((j < 3) & (i < 3)) r[i][j] = d9Elements[k++];
                     else 
                     {
                         if ((i*4 + j) < 15) r[i][j] = 0;
                         else r[i][j] = 1;
                     }
                 }
             
             return r;
         }

         static public double[][] GenerateSymmetricMatrix(double[] elements)
         {
             int size = (int)Math.sqrt(elements.length);
             
             double[][] r = new double[size][size];
             
             int  k=0;
             for (int i=0; i<size; i++)
                 for (int j=0; j<size; j++)
                     r[i][j] = elements[k++];
             
             return r;
         }
         
         static public double[][] GenerateTranformationMatrixFromEulerAngles(double[] angles)
         {
             double alpha = angles[0];
             double beta = angles[1];
             double gamma = angles[2];
             
             double degtorad = 0.0174532925;
             
             double c1 = Math.cos(alpha * degtorad);
             double c2 = Math.cos(beta * degtorad);
             double c3 = Math.cos(gamma * degtorad);

             double s1 = Math.sin(alpha * degtorad);
             double s2 = Math.sin(beta * degtorad);
             double s3 = Math.sin(gamma * degtorad);
             
             /* zxz
             return GenerateTransformationFromRotationMatrix(new double[] {
                c1*c3 - c2*s1*s3, -c3*s1 -c1*c2*s3, s2*s3,
                c2*c3*s1 + c1*s3, c1*c2*c3- s1*s3, -c3*s2,
                s1*s2, c1*s2, c2
             });
              */ 
             
             /* zyz
             return GenerateTransformationFromRotationMatrix(new double[] {
                c1*c2*c3-s1*s3, -c2*c3*s1-c1*s3, c3*s2,
                c3*s1+c1*c2*s3, c1*c3-c2*s1*s3, s2*s3,
                -c1*s2, s1*s2, c2
             });
              */
             
             // CCP4
             return GenerateTransformationFromRotationMatrix(new double[] {
                c1*c2*c3- s1*s3, -c3*s1 -c1*c2*s3, c1*s2,
                c2*c3*s1 + c1*s3, c1*c3 - c2*s1*s3, s1*s2,
                -c3*s2, s2*s3, c2
             });
             
         }

         static public double[][] GenerateTranformationMatrixFromPolarAngles(double[] angles)
         {
             double omega = angles[0];
             double phi = angles[1];
             double kappa = angles[2];
             
             double degtorad = 0.0174532925;
             
             double c1 = Math.cos(omega * degtorad);
             double c2 = Math.cos(phi * degtorad);
             double c3 = Math.cos(kappa * degtorad);

             double s1 = Math.sin(omega * degtorad);
             double s2 = Math.sin(phi * degtorad);
             double s3 = Math.sin(kappa * degtorad);

             double[] dircos = new double[4];
             
             dircos[1]=s1*c2;
             dircos[2]=s1*s2;
             dircos[3]=c1;
      
             double[][] rotn = new double[4][4];
      
             for (int i=1; i<4; i++)
                 for (int j=1; j<4; j++)
                 {
                     int k1 = 6-i-j;
                     int k = k1;
                     if ((k1 < 1) | (k1 > 3)) k=3;
                     double epsijk= ((double)((i-j)*(j-k)*(k-i)))/2;
                     rotn[i][j] = dircos[i]*dircos[j]* (1.0-c3)-epsijk*dircos[k]*s3;
                     if (i == j) rotn[i][j]=rotn[i][j]+c3;
                 }
                    
             return GenerateTransformationFromRotationMatrix(new double[] {
                rotn[1][1], rotn[1][2], rotn[1][3],
                rotn[2][1], rotn[2][2], rotn[2][3],
                rotn[3][1], rotn[3][2], rotn[3][3]
             });
         }
         
         static public double[][] GenerateTranformationMatrixFromTranslation(double[] xyz)
         {
             double[][] r = IdentityMatrix(4);
             
             r[0][3] = xyz[0];
             r[1][3] = xyz[1];
             r[2][3] = xyz[2];
             
             return r;
         }
        
         static public double[][] IdentityMatrix(int one_dimension)
         {
             int d = one_dimension;
             
             double[][] r = new double[d][d];
             
             for (int i=0; i<d; i++)
                 for (int j=0; j<d; j++)
                     if (i == j) r[i][j] = 1;
                     else r[i][j] = 0;
             
             return r;
         }
         
         
         static public double[][] MultiplyMatrix(double[][] M1, double[][] M2)
         {
             double[][] r = new double[M1.length][M2[0].length];

             for (int i=0; i < r.length; i++)
             {
                for (int j=0; j < r[0].length; j++)
                {
                    double s = 0;
                    for (int k=0; k<M2.length; k++)
                        s += M1[i][k] * M2[k][j];
                    r[i][j] = s;
                }
             }
             
             return r;
         }
         
         static public Coordinate TransformCoordinates(double[][] m, Coordinate c)
         {
            double[] om = {c.x(), c.y(), c.z(), 1};
            double[] r = new double[4];

            for (int i = 0; i < 4; i++)
                for (int j = 0; j < 4; j++) 
                    r[i] += m[i][j] * om[j];

             return new Coordinate(r[0], r[1], r[2]);
         }
         
         /**
          * Returns tab spaced between row data
          * and line feed spaced between column data
          * formatted string from all selected rows and columns
          * @param JTable
          * @return String
          */
         static public String FormatTabbedTextFromSelected(javax.swing.JTable tablein)
         {
            StringBuilder sb = new StringBuilder();
            
            int[] cols = tablein.getSelectedColumns();
            int[] rows = tablein.getSelectedRows();
 
            for (int r=0; r<rows.length; r++)
            {
             for (int c=0; c<cols.length; c++)
                {
                    sb.append(tablein.getModel().getValueAt(rows[r], cols[c]).toString());
                    if (c != cols.length - 1) sb.append('\t');
                }
                if (r != rows.length - 1) sb.append('\n');
            }
            
            return sb.toString();
         }

         static public String FormatTabbedTextFromTable(javax.swing.JTable tablein, boolean ColumnLabel)
         {
            StringBuilder sb = new StringBuilder();
            
            int rows = tablein.getModel().getRowCount();
            int cols = tablein.getModel().getColumnCount();
            
            if (ColumnLabel)
            {
                for (int c=0; c<cols; c++)
                {
                    sb.append(tablein.getModel().getColumnName(c));
                    if (c != cols - 1) sb.append('\t');
                }
                sb.append('\n');
            }
            
            for (int r=0; r<rows; r++)
            {
             for (int c=0; c<cols; c++)
                {
                    sb.append(tablein.getModel().getValueAt(r, c).toString());
                    if (c != cols - 1) sb.append('\t');
                }
                if (r != rows - 1) sb.append('\n');
            }
            
            return sb.toString();
         }
         
         static public String[] SubtractArray(String[] Array1, String[] Array2)
         {
             ArrayList<String> r = new ArrayList<String> ();
             
             for (int i=0; i<Array1.length; i++)
                 if (!Global.StringArrayContains(Array2, Array1[i]))
                     r.add(Array1[i]);
             
             return r.toArray(new String[r.size()]);
         }
         
    static public int CharArrayFindIndex(char[] Array, char Target)
    {
        for (int i=0; i<Array.length; i++)
            if (Array[i] == Target)
                return i;
        return -1;
    }
    
    static public boolean CharArrayContains(char[] Array, char Target)
    {
        for (int i=0; i<Array.length; i++)
            if (Array[i] == Target)
                return true;
        return false;
    }
    
    static public String[] calculateAvgSDMaxMin_Headers = {
      "Count",
      "Average",
      "Std Dev",
      "Max Atom",
      "Max Value",
      "Min Atom",
      "Min Value"
    };
    
    static public int calculateAvgSDMaxMin_CountIndex = 0;
    static public int calculateAvgSDMaxMin_AvgIndex = 1;
    static public int calculateAvgSDMaxMin_SDIndex = 2;
    static public int calculateAvgSDMaxMin_MaxRowIndex = 3;
    static public int calculateAvgSDMaxMin_MaxValueIndex = 4;
    static public int calculateAvgSDMaxMin_MinRowIndex = 5;
    static public int calculateAvgSDMaxMin_MinValueIndex = 6;
    
    static public int[] calculateAvgSDMaxMin_IntegerColumns = {
        calculateAvgSDMaxMin_CountIndex, 
        calculateAvgSDMaxMin_MaxRowIndex, 
        calculateAvgSDMaxMin_MinRowIndex
    };
    
    /**
     * Calculate average, standard deviation, maximum and minium of the list of values
     * @param double[] = list of values
     * @return double[] = { 0=AVG, 1=SD, 2=MaxIndex, 3=MaxValue, 4=MinIndex, 5= MinValue }
     */
    static public double[] calculateAvgSDMaxMin(Double[] list)
    {
        double[] r = new double[7];
        
        r[calculateAvgSDMaxMin_CountIndex] = list.length;
        r[calculateAvgSDMaxMin_AvgIndex] = 0;
        r[calculateAvgSDMaxMin_MaxRowIndex] = 0;
        r[calculateAvgSDMaxMin_MaxValueIndex] = list[0];
        r[calculateAvgSDMaxMin_MinRowIndex] = 0;
        r[calculateAvgSDMaxMin_MinValueIndex] = list[0];
        
        for (int i=0; i<list.length; i++)
        {
            r[calculateAvgSDMaxMin_AvgIndex] += list[i];
            if (list[i] > r[calculateAvgSDMaxMin_MaxValueIndex])
            {
                r[calculateAvgSDMaxMin_MaxRowIndex] = i;
                r[calculateAvgSDMaxMin_MaxValueIndex] = list[i];
            }
            if (list[i] < r[calculateAvgSDMaxMin_MinValueIndex])
            {
                r[calculateAvgSDMaxMin_MinRowIndex] = i;
                r[calculateAvgSDMaxMin_MinValueIndex] = list[i];
            }
        }
        r[calculateAvgSDMaxMin_AvgIndex] /= list.length;
        
        r[calculateAvgSDMaxMin_SDIndex] = calculateSD(list, r[calculateAvgSDMaxMin_AvgIndex]);
        
        return r;
    }
        
    static public double[] calculateAvgSDMaxMin(double[] list)
    {
        double[] r = new double[7];
        
        r[calculateAvgSDMaxMin_CountIndex] = list.length;
        r[calculateAvgSDMaxMin_AvgIndex] = 0;
        r[calculateAvgSDMaxMin_MaxRowIndex] = 0;
        r[calculateAvgSDMaxMin_MaxValueIndex] = list[0];
        r[calculateAvgSDMaxMin_MinRowIndex] = 0;
        r[calculateAvgSDMaxMin_MinValueIndex] = list[0];
        
        for (int i=0; i<list.length; i++)
        {
            r[calculateAvgSDMaxMin_AvgIndex] += list[i];
            if (list[i] > r[calculateAvgSDMaxMin_MaxValueIndex])
            {
                r[calculateAvgSDMaxMin_MaxRowIndex] = i;
                r[calculateAvgSDMaxMin_MaxValueIndex] = list[i];
            }
            if (list[i] < r[calculateAvgSDMaxMin_MinValueIndex])
            {
                r[calculateAvgSDMaxMin_MinRowIndex] = i;
                r[calculateAvgSDMaxMin_MinValueIndex] = list[i];
            }
        }
        r[calculateAvgSDMaxMin_AvgIndex] /= list.length;
        
        r[calculateAvgSDMaxMin_SDIndex] = calculateSD(list, r[calculateAvgSDMaxMin_AvgIndex]);
        
        return r;
    }
    
    static public double calculateSD(Double[] list, double avg)
    {
        double r = 0;
        
        for (int i=0; i <list.length; i++)
            r += Math.pow(list[i] - avg, 2);
        
        return Math.sqrt(r / (list.length - 1));
    }
    
    static public double calculateSD(double[] list, double avg)
    {
        double r = 0;
        
        for (int i=0; i <list.length; i++)
            r += Math.pow(list[i] - avg, 2);
        
        return Math.sqrt(r / (list.length - 1));
    }
    
    static public TreeMap<Object, Integer> getCount(Object[] list)
    {
        TreeMap<Object, Integer> r = new TreeMap<Object, Integer> ();
        for (int i=0; i<list.length; i++)
        {
            if (!r.containsKey(list[i]))
                r.put(list[i], new Integer(0));
            else
            {
                int v = r.get(list[i]);
                r.put(list[i], v++);
            }
        }
        return r;
    }
    
    static public double[] ExtractAllNumbers(String s)
    {
        ArrayList<Double> r = new ArrayList<Double> ();
        
        String[] spl = s.split("[^0-9.-]");
        for (int i=0; i<spl.length; i++)
            if (!spl[i].trim().equals(""))
                try {
                r.add(Double.parseDouble(spl[i]));
                } catch (Exception e) {return null; }
        
        double[] ret = new double[r.size()];
        for (int i=0; i<r.size(); i++)
            ret[i] = r.get(i);
        return ret;
    }
    
    static public int[] GenerateIntegerIndiciesArray(int size)
    {
        if (size == 0) return null;
        int[] r = new int[size];
        for (int i=0; i<size; i++)
            r[i] = i;
        return r;
    }
    
    /**
     * Calculates unit cell volume
     * @param unitcellparameters = {a, b, c, alpha, beta, gamma}
     * @return
     */
    static public double CalculateUnitcellVolume(double[] unitcellparameters)
    {
        double a = unitcellparameters[0];
        double b = unitcellparameters[1];
        double c = unitcellparameters[2];
        
        double cos_a = Math.cos(unitcellparameters[3] * DegreeToRadian);
        double cos_b = Math.cos(unitcellparameters[4] * DegreeToRadian);
        double cos_g = Math.cos(unitcellparameters[5] * DegreeToRadian);
        
        double anglefactor = 
                (1 - cos_a*cos_a - cos_b*cos_b - cos_g*cos_g)
                + 2 * Math.sqrt(cos_a * cos_b * cos_g);
        
        return a * b * c * anglefactor;
    }
 
     /**
     * Generates 4x4 orthogonalization matrix
     * @param unitcellparameters = {a, b, c, alpha, beta, gamma}
     * @return
     */
    static public double[][] GenerateOrthogonalizationMatrix(double[] unitcellparameters)
    {
        double a = unitcellparameters[0];
        double b = unitcellparameters[1];
        double c = unitcellparameters[2];
        
        double alpha = unitcellparameters[3];
        double beta = unitcellparameters[4];
        double gamma = unitcellparameters[5];
        
        double cos_a = Math.cos(alpha * DegreeToRadian);
        double cos_b = Math.cos(beta * DegreeToRadian);
        double cos_g = Math.cos(gamma * DegreeToRadian);
        
        double sin_a = Math.sin(alpha * DegreeToRadian);
        double sin_b = Math.sin(beta * DegreeToRadian);
        double sin_g = Math.sin(gamma * DegreeToRadian);
        
        double cos_as = (cos_g*cos_b-cos_a)/ (sin_b*sin_g);
        double sin_as = Math.sqrt(1.0-cos_as*cos_as);

        
        return Global.GenerateTransformationFromRotationMatrix(new double[] {
            a, b*cos_g, c*cos_b,
            0, b*sin_g, -c*sin_b*cos_as,
            0, 0, c*sin_b*sin_as 
        });
    }
    
     /**
     * Generates 4x4 Fractionalization matrix
     * @param unitcellparameters = {a, b, c, alpha, beta, gamma}
     * @return
     */
    static public double[][] GenerateScaleMatrix(double[] unitcellparameters)
    {
        double[][] r = Global.Inverse4x4Matrix(Global.GenerateOrthogonalizationMatrix(unitcellparameters));
        for (int i=0; i<4; i++)
            for (int j=0; j<4; j++)
                if ((r[i][j] < 0) && (r[i][j] > -0.00000001)) r[i][j] = 0;
        return r;
    }
    
    static public double ForceFractionalNumber(double value, int lowerbound, int upperbound)
    {
        if (upperbound <= lowerbound) return value;
        
        while (value > upperbound)
            value--;
        while (value < lowerbound)
            value++;
        return value;
    }
    
    static public String ExtendStringLength(String s, int newlength, char fillcharacter)
    {
        StringBuilder sb = new StringBuilder(s);
        for (int i=s.length(); i<newlength; i++)
            sb.append(fillcharacter);
        return sb.toString();
    }
}
