/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package pdb_reader.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

/**
 *
 * @author Owner
 */
public class Sequence {
    private TreeMap<Character, TreeMap<Integer, TreeMap<String, ArrayList<Atom>>>> data = new TreeMap<Character, TreeMap<Integer, TreeMap<String, ArrayList<Atom>>>> ();
    
    public Sequence()
    {
    }
    
    public Sequence(List<Atom> listin)
    {
        processList(listin);
    }

    public TreeMap<Character, TreeMap<Integer, TreeMap<String, ArrayList<Atom>>>> data() { return data; }
    
    public void processList(List<Atom> listin)
    {
        Iterator<Atom> i = listin.iterator();
        while (i.hasNext())
        {
            Atom a = i.next();
            addAtom(a);
        }
    }
    
    public void addAtom(Atom a)
    {
        char c = a.ChainID();
        if (!data.containsKey(c)) data.put(c, new TreeMap<Integer, TreeMap<String, ArrayList<Atom>>> ());
        
        TreeMap<Integer, TreeMap<String, ArrayList<Atom>>> subdata = data.get(c);
        int n = a.ResidueNumber();
        if (!subdata.containsKey(n)) subdata.put(n, new TreeMap<String, ArrayList<Atom>> ());
        
        TreeMap<String, ArrayList<Atom>> subsubdata = subdata.get(n);
        String s = a.ResidueType();
        if (!subsubdata.containsKey(s)) subsubdata.put(s, new ArrayList<Atom> ());
        
        subsubdata.get(s).add(a);
    }
    
    public void removeAtom(Atom a)
    {
        char c = a.ChainID();
        if (data.containsKey(c))
        {
            TreeMap<Integer, TreeMap<String, ArrayList<Atom>>> subdata = data.get(c);
            int n = a.ResidueNumber();
            if (subdata.containsKey(n))
            {
                TreeMap<String, ArrayList<Atom>> subsubdata = subdata.get(n);
                String s = a.ResidueType();
                if (subsubdata.containsKey(s))
                {
                    ArrayList list = subsubdata.get(s);
                    if (list.contains(a)) 
                    {
                        list.remove(a);
                        if (list.size() == 0) subsubdata.remove(s);
                        if (subsubdata.size() == 0) subdata.remove(n);
                        if (subdata.size() == 0) data.remove(c);
                    }
                }
            }
        }
    }
    
    public ArrayList<ArrayList<Atom>> getLinearList()
    {
        ArrayList<ArrayList<Atom>> linearlist = new ArrayList<ArrayList<Atom>> ();
        Iterator<TreeMap<Integer, TreeMap<String, ArrayList<Atom>>>> i = data().values().iterator();
        while (i.hasNext())
        {
            TreeMap<Integer, TreeMap<String, ArrayList<Atom>>> d = i.next();
            Iterator<TreeMap<String, ArrayList<Atom>>> j = d.values().iterator();
            while (j.hasNext())
            {
                TreeMap<String, ArrayList<Atom>> d2 = j.next();
                Iterator<ArrayList<Atom>> k = d2.values().iterator();
                while (k.hasNext())
                {
                    ArrayList<Atom> d3 = k.next();
                    linearlist.add(d3);
                }
            }
        }
        return linearlist;
    }
    
    public boolean checkResidueExist(char chain, int resnum)
    {
        if (data.containsKey(chain))
            if (data.get(chain).containsKey(resnum))
                return true;
        return false;
    }
}
