/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package pdb_reader.data.spacegroup;

/**
 *
 * @author Owner
 */
public class CrystalSystemChecker {
    
    static public CrystalSystemChecker GetChecker(String System)
    {
        if (System.equals("TRICLINIC")) return TRICLINIC();
        if (System.equals("MONOCLINIC")) return MONOCLINIC();
        if (System.equals("ORTHORHOMBIC")) return ORTHORHOMBIC();
        if (System.equals("TETRAGONAL")) return TETRAGONAL();
        if (System.equals("TRIGONAL")) return TRIGONAL();
        if (System.equals("CUBIC")) return CUBIC();
        if (System.equals("HEXAGONAL")) return HEXAGONAL();
        return null;
    }
    
    static public CrystalSystemChecker TRICLINIC()
    {
        return new CrystalSystemChecker() {
           public String InformationText()
           {
                return "Triclinic : No restriction";
           }
           public boolean CheckCell(SpaceGroup sg)
           {
                return true;
           }
           public SpaceGroup Correct(SpaceGroup sg)
           {
               return sg;
           }
        };
    }
    
    static public CrystalSystemChecker MONOCLINIC()
    {
        return new CrystalSystemChecker() {
           public String InformationText()
           {
                return "Monoclinic : alpha = gamma = 90";
           }
           public boolean CheckCell(SpaceGroup sg)
           {
                if (sg.alpha() != 90) return false;
                if (sg.gamma() != 90) return false;
                return true;
           }
           public SpaceGroup Correct(SpaceGroup sg)
           {
               sg.alpha(90);
               sg.gamma(90);
               return sg;
           }
        };
    }
    
    static public CrystalSystemChecker ORTHORHOMBIC()
    {
        return new CrystalSystemChecker() {
           public String InformationText()
           {
                return "Orthorhombic : alpha = beta = gamma = 90";
           }
           public boolean CheckCell(SpaceGroup sg)
           {
                if (sg.alpha() != 90) return false;
                if (sg.beta() != 90) return false;
                if (sg.gamma() != 90) return false;
                return true;
           }
           public SpaceGroup Correct(SpaceGroup sg)
           {
               sg.alpha(90);
               sg.beta(90);
               sg.gamma(90);
               return sg;
           }
        };
    }

    static public CrystalSystemChecker TETRAGONAL()
    {
        return new CrystalSystemChecker() {
           public String InformationText()
           {
                return "Trigonal : a = b\n  alpha = beta = gamma = 90";
           }
           public boolean CheckCell(SpaceGroup sg)
           {
                if (sg.a() != sg.b()) return false;
                if (sg.alpha() != 90) return false;
                if (sg.beta() != 90) return false;
                if (sg.gamma() != 90) return false;
                return true;
           }
           public SpaceGroup Correct(SpaceGroup sg)
           {
               sg.b(sg.a());
               sg.alpha(90);
               sg.beta(90);
               sg.gamma(90);
               return sg;
           }
        };
    }

    static public CrystalSystemChecker CUBIC()
    {
        return new CrystalSystemChecker() {
           public String InformationText()
           {
                return "Cubic : a = b = c\n  alpha = beta = gamma = 90";
           }
           public boolean CheckCell(SpaceGroup sg)
           {
                if ((sg.a() != sg.b()) & (sg.a()!= sg.c())) return false;
                if (sg.alpha() != 90) return false;
                if (sg.beta() != 90) return false;
                if (sg.gamma() != 90) return false;
                return true;
           }
           public SpaceGroup Correct(SpaceGroup sg)
           {
               sg.b(sg.a());
               sg.c(sg.a());
               sg.alpha(90);
               sg.beta(90);
               sg.gamma(90);
               return sg;
           }
        };
    }    
    
    static public CrystalSystemChecker HEXAGONAL()
    {
        return new CrystalSystemChecker() {
           public String InformationText()
           {
                return "Hexagonal : a = b\n  alpha = beta = 90\n  gamma = 120";
           }
           public boolean CheckCell(SpaceGroup sg)
           {
                if (sg.a() != sg.b()) return false;
                if (sg.alpha() != 90) return false;
                if (sg.beta() != 90) return false;
                if (sg.gamma() != 120) return false;
                return true;
           }
           public SpaceGroup Correct(SpaceGroup sg)
           {
               sg.b(sg.a());
               sg.alpha(90);
               sg.beta(90);
               sg.gamma(120);
               return sg;
           }
        };
    }    

    static public CrystalSystemChecker TRIGONAL()
    {
        return new CrystalSystemChecker() {
           public String InformationText()
           {
               String text = "Hexagonal : a = b\n";
               text += "  alpha = beta = 90; gamma = 120\n";
               text += "Rhombohedral : a = b = c\n";
               text += "  alpha = beta = gamma";
               return text;
           }
           public boolean CheckCell(SpaceGroup sg)
           {
               boolean hexagonal = true;
               if (sg.name().charAt(0) == 'R') hexagonal = false;
               
               if (hexagonal)
               {
                    if (sg.a() != sg.b()) return false;
                    if (sg.alpha() != 90) return false;
                    if (sg.beta() != 90) return false;
                    if (sg.gamma() != 120) return false;
               }
               else
               {
                    if ((sg.a() != sg.b()) & (sg.a()!= sg.c())) return false;
                    if ((sg.alpha() != sg.beta()) & (sg.alpha()!= sg.gamma())) return false;
               }
               return true;
           }
           public SpaceGroup Correct(SpaceGroup sg)
           {
               boolean hexagonal = true;
               if (sg.name().charAt(0) == 'R') hexagonal = false;
               
               if (hexagonal)
               {               
                   sg.b(sg.a());
                   sg.alpha(90);
                   sg.beta(90);
                   sg.gamma(120);
               }
               else
               {
                   sg.b(sg.a());
                   sg.c(sg.a());
                   sg.beta(sg.alpha());
                   sg.gamma(sg.alpha());
               }
               return sg;
           }
        };
    }    
    
    
    public String InformationText()
    {
        return null;
    }
    public boolean CheckCell(SpaceGroup sg)
    {
        return true;
    }
    public SpaceGroup Correct(SpaceGroup sg)
    {
        return sg;
    }
}

