package pdb_editor.coordinate;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.*;
import javax.swing.event.*;
import pdb_editor.EditorFrame;
import pdb_reader.data.*;
import pdb_reader.DataSet;
import pdb_reader.Global;
import java.awt.Rectangle;
import java.util.TreeSet;

public class CoordinateTable extends JTable{
	/**
	 * 
	 */
	
    
    private static final long serialVersionUID = 1L;
        
        private EditorFrame parent = null;
	private DataSet maindata = null;
	private DataModel tabledata = null;
	private int[] columnWidth = Atom.DataTextSize.clone();

       class CommonKeyListener implements KeyListener {
        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (parent != null)
            {
                if (e.isControlDown())
                {
                    if (e.getKeyCode() == KeyEvent.VK_DELETE)
                    {
                        parent.DeleteRecord();
                        clearSelection();
                        fireTableDataChanged();
                    }

                    if (e.getKeyCode() == KeyEvent.VK_V)
                    {
                        parent.PasteToCoordinateTable();
                    }
                
                    if (e.getKeyCode() == KeyEvent.VK_X)
                    {
                        parent.CutAsPDBAtom();
                    }
                
                    if (e.getKeyCode() == KeyEvent.VK_UP)
                    {
                        parent.MoveUpSelectedAtoms();
                    }
                    
                    if (e.getKeyCode() == KeyEvent.VK_DOWN)
                    {
                        parent.MoveDownSelectedAtoms();
                    }
                }
                
                if ((e.isControlDown()) && (e.isShiftDown()))
                {
                    if (e.getKeyCode() == KeyEvent.VK_UP)
                    {
                        parent.MoveTopSelectedAtoms();
                    }
                    
                    if (e.getKeyCode() == KeyEvent.VK_DOWN)
                    {
                        parent.MoveBottomSelectedAtoms();
                    }
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

        
	// Constructors
	public CoordinateTable(EditorFrame Parent, DataSet MainData)
	{
		maindata = MainData;
                parent = Parent;
		InitializeCommon();
		SetColumnWidth();
                maindata.TableLinked(this);
	}
	private void InitializeCommon()
	{
            tabledata = new DataModel(maindata, this);
            this.addKeyListener(new CommonKeyListener());
            this.setModel(tabledata);
            this.setColumnSelectionAllowed(true);
            this.setRowSelectionAllowed(true);
            this.getColumnModel().addColumnModelListener(new TableColumnModelListener() {
            public void columnSelectionChanged(ListSelectionEvent e) {
                    if (parent != null)
                        parent.StatusLabelReportCellSelectionChange();
            }

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }
        });
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
                public void valueChanged(ListSelectionEvent e) {
                    if (parent != null)
                        parent.StatusLabelReportCellSelectionChange();
                }
            });
        }
	
        
        
        public void fireTableDataChanged()
        {
            tabledata.fireTableDataChanged();
        }
	
        public void addRowSelectionIndicies(int[] indicies)
        {
            for (int i=0; i<indicies.length; i++)
            {
                this.addRowSelectionInterval(indicies[i], indicies[i]);
            }
        }
	
        public void addColumnSelectionIndicies(int[] indicies)
        {
            for (int i=0; i<indicies.length; i++)
            {
                this.addColumnSelectionInterval(indicies[i], indicies[i]);
            }
        }
	
        
        public DataSet getMainData() { return maindata; }
        
	// Table Control Functions
	//    For displaying tooltips on column headers   
	protected JTableHeader createDefaultTableHeader() {
		return new JTableHeader(columnModel) {
			public String getToolTipText(MouseEvent e) {
				java.awt.Point p = e.getPoint();
				int index = columnModel.getColumnIndexAtX(p.x);
				int realIndex = columnModel.getColumn(index).getModelIndex();
				return Atom.DataToolTip[tabledata.getColumnIndex()[realIndex]];
			}
		};
	}
	
	private void SetColumnWidth()
	{
		TableColumn column = null;
		for (int i=0; i<tabledata.getColumnCount(); i++)
		{
			column = this.getColumnModel().getColumn(i);
			column.setPreferredWidth(columnWidth[tabledata.getColumnIndex()[i]]);
		}
	}
        
        public void scrollToCenterOnFirstSelectedCell()
        {
            if ((this.getSelectedRowCount() > 0) && (this.getSelectedColumnCount() > 0))
                scrollToCenterOnCell(this.getSelectedRow(), this.getSelectedColumn());
        }
        
          public void scrollToCenterOnCell(int rowIndex, int vColIndex) {
            JTable table = this;
              if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
    
        // This rectangle is relative to the table where the
        // northwest corner of cell (0,0) is always (0,0).
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
    
        // The location of the view relative to the table
        Rectangle viewRect = viewport.getViewRect();
    
        // Translate the cell location so that it is relative
        // to the view, assuming the northwest corner of the
        // view is (0,0).
        int dx = rect.x-viewRect.x;
        int dy = rect.y-viewRect.y;
        rect.setLocation(dx, dy);
        
        
        // Calculate location of rect if it were at the center of view
        int centerX = (viewRect.width-rect.width)/2;
        int centerY = (viewRect.height-rect.height)/2;
    
        // Fake the location of the cell so that scrollRectToVisible
        // will move the cell to the center
        if (rect.x < centerX) {
            centerX = -centerX;
        }
        if (rect.y < centerY) {
            centerY = -centerY;
        }
        rect.translate(centerX, centerY);
    
        // Scroll the area into view.
        viewport.scrollRectToVisible(rect);
    }

        
        
        public String GetPDBTextFromSelectedRows()
        {
            int[] rows = this.getSelectedRows();
            StringBuilder sb = new StringBuilder();
            
            for (int i=0; i<rows.length; i++)
            {
                AtomPDB a = maindata.Atoms().get(rows[i]).GetPDBAtomOfThis();
                sb.append(a.WritePDBLine());
            }
            
            return sb.toString();
        }
        
        public int GetColumnIndex(int ColumnTypeNumber)
        {
            return tabledata.getColumnIndex()[ColumnTypeNumber];
        }
        
        public int GetAtomTableIndexOfColumn(int ColumnNumber)
        {
            int[] data = tabledata.getColumnIndex();
            for (int i=0; i<data.length; i++)
                if (data[i] == ColumnNumber)
                    return i;
            return -1;
        }
        
        public String[] ListColumnDisplayed()
        {
            int[] inds = tabledata.getColumnIndex();
            ArrayList<String> r = new ArrayList<String> ();
            
            for (int i=0; i<inds.length; i++)
                if (inds[i] >= 0)
                    r.add(Atom.DataToolTip[inds[i]]);
            
            return r.toArray(new String[r.size()]);
        }
        
        public void setColumnIndex(int[] ColumnIndicies)
        {
            UpdateTableWidth();
            tabledata = new DataModel(maindata, this, ColumnIndicies);
            this.setModel(tabledata);
            SetColumnWidth();
            //tabledata.setColumnIndex(ColumnIndicies);
            //tabledata.fireTableDataChanged();
        }
        
        private void UpdateTableWidth()
        {
 		TableColumn column = null;
		for (int i=0; i<tabledata.getColumnCount(); i++)
		{
			column = this.getColumnModel().getColumn(i);
			columnWidth[tabledata.getColumnIndex()[i]] = column.getWidth();
		}
        }
        
        public int[] getColumnWidths()
        {
            UpdateTableWidth();
            return columnWidth;
        }
        
        public void PasteText(String s)
        {
            String[][] in = Global.TabulateStringByLineTab(s);
            
            int[] selcols = this.getSelectedColumns();
            int[] selrows = this.getSelectedRows();
            
            this.clearSelection();
            
            int row = 0, col = 0, rowos = 1;
            for (int i=0; i<in.length; i++)
            {
                if (i < selrows.length) row = selrows[i];
                else row = selrows[selrows.length - 1] + rowos++;
                if (row < maindata.Atoms().size())
                {
                    int colos = 1;
                    for (int j=0; j<in[i].length; j++)
                    {
                        if (j < selcols.length) col = selcols[j];
                        else col = selcols[selcols.length - 1] + colos++;
                        
                        if (col < tabledata.getColumnCount())
                        {
                            try {
                                Object o = Global.ConvertString(in[i][j], Atom.DataClass[GetColumnIndex(col)]);
                                if (o != null)
                                {
                                    maindata.Atoms().get(row).TableData(GetColumnIndex(col), o);
                                    this.addColumnSelectionInterval(col, col);
                                    this.addRowSelectionInterval(row, row);
                                }
                            }
                            catch (Exception e) {}
                            tabledata.fireTableRowsUpdated(row, row);
                        }
                    }
                }
            }
        }
        
        public void fireTableRowUpdated(int rowstart, int rowend)
        {
            tabledata.fireTableRowsUpdated(rowstart, rowend);
        }
        
        public void invertSelectedRows()
        {
            int[] selrows = this.getSelectedRows();
            int[] selcols = this.getSelectedColumns();
            
            TreeSet<Integer> list = new TreeSet<Integer> ();
            for (int i=0; i<this.getRowCount(); i++) list.add(i);
            for (int i=0; i<selrows.length; i++) list.remove(selrows[i]);
            
            this.clearSelection();
            this.addRowSelectionIndicies(Global.ConvertIntegerArrayToIntArray(list.toArray(new Integer[list.size()])));
            this.addColumnSelectionIndicies(selcols);
        }
        
class DataModel extends AbstractTableModel {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private int[] ColumnIndex = null;
	private DataSet maindata = null;
	
	private JTable table = null;
	
	class TML implements TableModelListener {
		public void tableChanged(TableModelEvent e)
		{
			
		}
	}
	
	// Constructors
	public DataModel(DataSet MainData, JTable Table)
	{
		maindata = MainData;
		table = Table;
		InitializeDefault();
		//this.addTableModelListener(new TML());
	}
        public DataModel(DataSet MainData, JTable Table, int[] columnIndex)
        {
                ColumnIndex = columnIndex;
                maindata = MainData;
		table = Table;
        }
        
	private void InitializeDefault()
	{
		ColumnIndex = new int[Atom.DataList.length];
		int Limit = Atom.DataList.length;
		for (int i=0; i < Limit; i++) 
		{
			ColumnIndex[i] = i;
		}
		for (int i=Limit; i < Atom.DataList.length; i++) 
		{	
			ColumnIndex[i] = -1;
		}

	}
	
		
	// Data interface functions
	public int[] getColumnIndex() { return ColumnIndex; }
	public void setColumnIndex(int[] columnIndex) { ColumnIndex = columnIndex; } 
	
	
	// DataModel Control functions
	public int getColumnCount() 
	{
        //return ColumnDisplayedCount();
            return ColumnIndex.length;
    }

    public int getRowCount() 
    {
     	return maindata.Atoms().size();
    }

	public String getColumnName(int col) 
	{
	    return Atom.DataList[ColumnIndex[col]];
	}

	public Object getValueAt(int row, int col) 
	{
	     Object Value = maindata.Atoms().get(row).TableData(ColumnIndex[col]);
	     return Value;
	}
        
        public void setValueAt(Object value, int row, int col) 
	{
		//maindata.Atoms().get(row).TableData(ColumnIndex[col], value);
		//fireTableCellUpdated(row, col);
		parent.listenForUndoStart("Cell value edit");
                int[] selrows = table.getSelectedRows();
		for (int i=0; i<selrows.length; i++)
		{
			maindata.Atoms().get(selrows[i]).TableData(ColumnIndex[col], value);
			fireTableCellUpdated(selrows[i], col);
		}
                parent.listenForUndoStop();
	}
	
	public Class getColumnClass(int col) {
        Class c = Atom.DataClass[ColumnIndex[col]];
        if (c == Global.charclass.getClass()) c = Global.stringclass.getClass();
        return c;
    }

	public boolean isCellEditable(int row, int col) 
	{
          return true;
         }

	
	
	// Private Functions
	private int ColumnDisplayedCount()
	{
		int result = 0;
		for (int i=0; i < ColumnIndex.length; i++) 
			if (ColumnIndex[i] >= 0) result++;
		return result;
	}
	
	
}
}


