/*
 * EditCoordinateDialog.java
 *
 * Created on February 12, 2008, 2:19 PM
 */

package pdb_editor.coordinate;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.FormulaEvaluator;
import pdb_reader.Global;
import pdb_reader.DataSet;
import pdb_reader.data.Atom;

/**
 *
 * @author  JYLee
 */
public class EditCoordinateDialog extends javax.swing.JDialog {
    
    private DataSet maindata = null;   //  @jve:decl-index=0:
    private CoordinateTable coordinateTable = null;
    private EditorFrame Parent = null;
    
    private JCheckBox[] checkBoxes = null;
    private JTextField[] valueFields = null;
    
    private JButton buttonOk = null;
    private JButton buttonCancel = null;
    private JButton buttonHelp = null;
    
    private CommonKeyListener commonKeyListener = new CommonKeyListener();
    
    /** Creates new form EditCoordinateDialog */
    public EditCoordinateDialog(EditorFrame parent, boolean modal, CoordinateTable cTable ) {
        super(parent, modal);
        Parent = parent;
        coordinateTable = cTable;
        maindata = cTable.getMainData();
        this.addKeyListener(commonKeyListener);
        initComponents();
        GenerateEntryFields();
    }
    
    class CommonKeyListener implements KeyListener {
        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
                EditCoordinateDialog.this.dispose();
            if (e.getKeyCode() == KeyEvent.VK_ENTER)
                EditCoordinateDialog.this.ProcessChange();
        }

        public void keyReleased(KeyEvent e) {
        }
    }
    
    private void ProcessChange()
    {
        String[] Inputs = getUserInputs();
        Object[] processedInputs = processInputs(Inputs);
        if (processedInputs != null)
        {
            Parent.listenForUndoStart("Edit selected cells");
            changeValues(processedInputs);
            Parent.listenForUndoStop();
        }
    }
    
    private void changeValues(Object[] inputs)
    {
        // Get all variables
        //Double Current = null, Last = null, Next = null;
        //boolean numbercolumn = false;
        //FormulaEvaluator f = null;

        int[] rows = coordinateTable.getSelectedRows();
        Object[][] outputs = null;
        boolean cont = true;
        
        try {
            outputs = generateOutputs(inputs);
        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog(this, "Error in user input",
                "Error Editing", JOptionPane.ERROR_MESSAGE);
            cont = false;
        }
        if (cont)
        {
            for (int i=0; i<outputs.length; i++)
            {
                if (outputs[i][0] != null)
                {
                    for (int j=0; j<rows.length; j++)
                    {
                        maindata.Atoms().get(rows[j]).TableData(i, outputs[i][j]);
                    }
                }
            }
            for (int j=0; j<rows.length; j++)
            {
                coordinateTable.fireTableRowUpdated(rows[j], rows[j]);
            }
        }
        
        /*
        try {
        for (int i=0; i<inputs.length; i++)
        {
            if (inputs[i] != null)
            {
                if ((Atom.DataClass[i].equals(Global.doubleclass.getClass())) || (Atom.DataClass[i].equals(Global.integerclass.getClass())))
                {
                    numbercolumn = true;
                    f = (FormulaEvaluator)inputs[i];
                    //getVariables(f);
                }
                for (int j=0; j<rows.length; j++)
                {
                    if (numbercolumn == true)
                    {
                        
                        /*if (Atom.DataClass[i].equals(Global.integerclass.getClass()))
                        {
                            Current = (double)(Integer)maindata.Atoms().get(rows[j]).TableData(i);
                            if (rows[j] != 0)
                                Last = (double)(Integer)maindata.Atoms().get(rows[j] - 1).TableData(i);
                            else 
                                Last = Current;
                            if (rows[j] != maindata.Atoms().size() - 1)
                                Next = (double)(Integer)maindata.Atoms().get(rows[j] + 1).TableData(i);
                            else
                                Next = Current;
                        }
                        else
                        {
                            Current = (Double)maindata.Atoms().get(rows[j]).TableData(i);
                            if (rows[j] != 0)
                                Last = (Double)maindata.Atoms().get(rows[j] - 1).TableData(i);
                            else 
                                Last = Current;
                            if (rows[j] != maindata.Atoms().size() - 1)
                                Next = (Double)maindata.Atoms().get(rows[j] + 1).TableData(i);
                            else
                                Next = Current;
                        }
                        
                        f.getVariables().put("Current", Current);
                        f.getVariables().put("Last", Last);
                        f.getVariables().put("Next", Next);
                        
                        getVariables(f, rows[j], i);
                        
                        double value = f.evaluateExpression();
                        if (Atom.DataClass[i].equals(Global.integerclass.getClass()))
                            maindata.Atoms().get(rows[j]).TableData(i, (int)value);
                        else
                            maindata.Atoms().get(rows[j]).TableData(i, value);
                    }
                    else
                    {
                        maindata.Atoms().get(rows[j]).TableData(i, inputs[i]);
                    }
                }
            }
        }
        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog(this, "Error in user input",
                "Error Editing", JOptionPane.ERROR_MESSAGE);
        }*/
        

    }
    
    private void getVariables(FormulaEvaluator f, int row, int column)
    {
        HashMap<String, Double> v = f.getVariables();
        String[] vlist = v.keySet().toArray(new String[v.keySet().size()]);
        for (int i=0; i<vlist.length; i++)
        {
            v.put(vlist[i], getVariable(vlist[i], row, column, v));
        }
     }
    
    private Double getVariable(String name, int row, int column, HashMap<String, Double> v)
    {
        String[] comp = name.split(":");
        
        for (int i=0; i<comp.length; i++)
        {
            if (comp[i].equals("L")) 
                if (--row < 0) row = 0;
            if (comp[i].equals("N"))
                if (++row >= maindata.Atoms().size()) row = maindata.Atoms().size() - 1;
            
            if (comp[i].equals("X")) column = Atom.X_INDEX;
            if (comp[i].equals("Y")) column = Atom.Y_INDEX;
            if (comp[i].equals("Z")) column = Atom.Z_INDEX;
            if (comp[i].equals("x")) column = Atom.FRACX_INDEX;
            if (comp[i].equals("y")) column = Atom.FRACY_INDEX;
            if (comp[i].equals("z")) column = Atom.FRACZ_INDEX;
            if (comp[i].equals("B")) column = Atom.B_INDEX;
            if (comp[i].equals("O")) column = Atom.OCCUPANCY_INDEX;
            if (comp[i].equals("U11")) column = Atom.U11_INDEX;
            if (comp[i].equals("U12")) column = Atom.U12_INDEX;
            if (comp[i].equals("U13")) column = Atom.U13_INDEX;
            if (comp[i].equals("U22")) column = Atom.U22_INDEX;
            if (comp[i].equals("U23")) column = Atom.U23_INDEX;
            if (comp[i].equals("U33")) column = Atom.U33_INDEX;
            
            if (comp[i].equals("sX")) column = Atom.SIGMAX_INDEX;
            if (comp[i].equals("sY")) column = Atom.SIGMAY_INDEX;
            if (comp[i].equals("sZ")) column = Atom.SIGMAZ_INDEX;
            if (comp[i].equals("sB")) column = Atom.SIGMAB_INDEX;
            if (comp[i].equals("sO")) column = Atom.SIGMAOCCUPANCY_INDEX;
            if (comp[i].equals("sU11")) column = Atom.SIGMAU11_INDEX;
            if (comp[i].equals("sU12")) column = Atom.SIGMAU12_INDEX;
            if (comp[i].equals("sU13")) column = Atom.SIGMAU13_INDEX;
            if (comp[i].equals("sU22")) column = Atom.SIGMAU22_INDEX;
            if (comp[i].equals("sU23")) column = Atom.SIGMAU23_INDEX;
            if (comp[i].equals("sU33")) column = Atom.SIGMAU33_INDEX;
            
            if (comp[i].charAt(0) == 'A')
            {
                if (v.get(name) == null) 
                    row = maindata.findIndex(Integer.parseInt(comp[i].substring(1)));
                else return (Double)v.get(name);
            }
        }
        
        return getVariable(row, column);
    }
    
    private Object[][] generateOutputs(Object[] inputs)
    {
        int[] rows = coordinateTable.getSelectedRows();
        Object[][] r = new Object[inputs.length][rows.length];

        // Get all variables
        boolean numbercolumn = false;
        FormulaEvaluator f = null;
        
        for (int i=0; i<inputs.length; i++)
        {
            if (inputs[i] != null)
            {
                if ((Atom.DataClass[i].equals(Global.doubleclass.getClass())) || (Atom.DataClass[i].equals(Global.integerclass.getClass())))
                {
                    numbercolumn = true;
                    f = (FormulaEvaluator)inputs[i];
                    //getVariables(f);
                }
                for (int j=0; j<rows.length; j++)
                {
                    if (numbercolumn == true)
                    {
                        getVariables(f, rows[j], i);
                        
                        double value = f.evaluateExpression();
                        if (Atom.DataClass[i].equals(Global.integerclass.getClass()))
                             r[i][j] = (int)value;
                        else
                            r[i][j] = value;
                    }
                    else
                    {
                        r[i][j] = inputs[i];
                    }
                }
            }
        }
        
        return r;
    }
    
    
    private Double getVariable(int row, int column)
    {
        if (Atom.DataClass[column].equals(Global.integerclass.getClass()))
            return (double)(Integer)maindata.Atoms().get(row).TableData(column);
        else
            return (Double)maindata.Atoms().get(row).TableData(column);
    }
    
    
    private Object[] processInputs(String[] Inputs)
    {
        Object[] result = new Object[Inputs.length];
        
        for (int i=0; i<Inputs.length; i++)
        {
            if (Inputs[i] != null)
            {
                Class c = Atom.DataClass[i];
                try {
                    if ((c.equals(Global.integerclass.getClass())) || (c.equals(Global.doubleclass.getClass())))
                    {
                        result[i] = new FormulaEvaluator(Inputs[i]);
                    }
                    else
                    {
                        result[i] = Global.ConvertString(Inputs[i], c);
                    }
                    if (result[i] == null)
                        throw new Exception(Inputs[i] + " is not in " + Atom.DataClass[i].getName() + " format");
                }    
                catch (Exception e) {
                    String ErrorMessage = "Error Processing " + Atom.DataToolTip[i] + " text:\n" + e.getMessage();
                    JOptionPane.showMessageDialog(this, ErrorMessage, "Error Processing Inputs", JOptionPane.ERROR_MESSAGE);
                    return null;
                }
            }
            else result[i] = null;
        }

        return result;
    }
    
    private String[] getUserInputs()
    {
        String[] result = new String[checkBoxes.length];
        
        for (int i=0; i<result.length; i++)
        {
            if (checkBoxes[i].isSelected() == true)
                result[i] = valueFields[i].getText();
            else result[i] = null;
        }
        
        return result;
    }
    
    private void GenerateHelpText()
    {

        StringBuilder sb = new StringBuilder();
        
        sb.append("This is used to change values of all the selected rows in column checked to edit\n");
        sb.append("Text columns can only chnage to a value you input\n");
        sb.append("\n");                
        sb.append("Number columns allow following arithmetic operations : +, -, *, /, (, ) \n");
        sb.append("Number columns can extract numbers from other rows and columns\n");
        sb.append("  Example : \"L:x + 1/3\" is equivalent as set the all the selected rows to last row's fractional coordinate x of current row plus 1/3   \n");
        sb.append("\n");
        sb.append("Row selection Keywords\n");
        sb.append("L = Go to last row\n");
        sb.append("N = Go to next row\n");
        sb.append("A#### = Go to atom number ####\n");
        sb.append("\n");
        sb.append("Data selection Keywords\n");
        sb.append("X, Y, Z = Orthogonal coordinate X, Y, Z respectively\n");
        sb.append("x, y, z = Fractional coordinate x, y, z respectively\n");
        sb.append("B = Temperature factor\n");
        sb.append("O = Occupancy\n");
        sb.append("U11, U12, U13, U22, U23, U33 = Anisotropic temperature factors\n");
        sb.append("sX, sY, sZ = Sigma orthogonal coordinate X, Y, Z respectively\n");
        sb.append("sx, sy, sz = Sigma fractional coordinate x, y, z respectively\n");
        sb.append("sB = Sigma temperature factor\n");
        sb.append("sO = Sigma occupancy\n");
        sb.append("sU11, sU12, sU13, sU22, sU23, sU33 = Sigma anisotropic temperature factors\n");
        
        
        this.jTextAreaHelp.setText(sb.toString());     
    }
    
    private void GenerateEntryFields()
    {
        class inputListener implements DocumentListener  {
            private JCheckBox associatedCB = null;
            public inputListener(JCheckBox in) { associatedCB = in; }
            public void insertUpdate(DocumentEvent e) {
                associatedCB.setSelected(true);
            }
            public void removeUpdate(DocumentEvent e) {
                if (e.getDocument().getLength() == 0) associatedCB.setSelected(false);
            }
            public void changedUpdate(DocumentEvent e) {
                associatedCB.setSelected(true);
                if (e.getDocument().getLength() == 0) associatedCB.setSelected(false);
            }
        }
        
        checkBoxes = new JCheckBox[Atom.DataList.length];
        valueFields = new JTextField[Atom.DataList.length];
  
        java.awt.GridBagConstraints gridBagConstraints;
        int splitpoint = Atom.DataToolTip.length / 2;
        int j = 0;
        for (int i=0; i<checkBoxes.length; i++)
        {
            checkBoxes[i] = new JCheckBox();
            checkBoxes[i].setText(Atom.DataToolTip[i]);
            checkBoxes[i].addKeyListener(commonKeyListener);
            gridBagConstraints = new java.awt.GridBagConstraints();
            if (i <= splitpoint) gridBagConstraints.gridx = 0;
            else gridBagConstraints.gridx = 12;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridy = j+1;
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
            gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
            getContentPane().add(checkBoxes[i], gridBagConstraints);

            valueFields[i] = new JTextField();
            valueFields[i].setPreferredSize(new java.awt.Dimension(100, 20));
            valueFields[i].getDocument().addDocumentListener(new inputListener(checkBoxes[i]));
            valueFields[i].addKeyListener(commonKeyListener);
            //valueFields[i].addInputMethodListener(new inputListener(checkBoxes[i]));
            gridBagConstraints = new java.awt.GridBagConstraints();
            if (i <= splitpoint) gridBagConstraints.gridx = 5;
            else gridBagConstraints.gridx = 17;
            gridBagConstraints.gridy = j+1;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
            getContentPane().add(valueFields[i], gridBagConstraints);
            j++;
            if ((i != checkBoxes.length - 1) && (j > splitpoint)) j = 0;
        }
        
        buttonOk = new JButton();
        buttonOk.setText("Apply");
        buttonOk.setPreferredSize(new Dimension(90,25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = splitpoint + 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        getContentPane().add(buttonOk, gridBagConstraints);
        buttonOk.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                ProcessChange();
            }
        });

        buttonCancel = new JButton();
        buttonCancel.setText("Close");
        buttonCancel.setPreferredSize(new Dimension(90,25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 17;
        gridBagConstraints.gridy = splitpoint + 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        getContentPane().add(buttonCancel, gridBagConstraints);
        buttonCancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                EditCoordinateDialog.this.dispose();
            }
        });
        
        buttonHelp = new JButton();
        buttonHelp.setText("Help");
        buttonHelp.setPreferredSize(new Dimension(90,25));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = splitpoint + 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 12);
        getContentPane().add(buttonHelp, gridBagConstraints);
        this.jDialogHelp.setSize(new Dimension(500, 400));
        GenerateHelpText();
        buttonHelp.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                EditCoordinateDialog.this.jDialogHelp.show();
            }
        });
       
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jDialogHelp = new javax.swing.JDialog();
        jButtonHelpClose = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaHelp = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();

        jDialogHelp.setTitle("Edit Coordinate Help");
        jDialogHelp.setResizable(false);

        jButtonHelpClose.setText("Close");
        jButtonHelpClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonHelpCloseActionPerformed(evt);
            }
        });

        jTextAreaHelp.setColumns(20);
        jTextAreaHelp.setLineWrap(true);
        jTextAreaHelp.setRows(5);
        jScrollPane1.setViewportView(jTextAreaHelp);

        javax.swing.GroupLayout jDialogHelpLayout = new javax.swing.GroupLayout(jDialogHelp.getContentPane());
        jDialogHelp.getContentPane().setLayout(jDialogHelpLayout);
        jDialogHelpLayout.setHorizontalGroup(
            jDialogHelpLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jDialogHelpLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jDialogHelpLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 466, Short.MAX_VALUE)
                    .addComponent(jButtonHelpClose, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 127, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        jDialogHelpLayout.setVerticalGroup(
            jDialogHelpLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jDialogHelpLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 287, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonHelpClose)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Edit Coordinates");
        setMinimumSize(new java.awt.Dimension(540, 530));
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jLabel2.setText("Column");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.ipady = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        getContentPane().add(jLabel2, gridBagConstraints);

        jLabel3.setText("New Value");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        getContentPane().add(jLabel3, gridBagConstraints);

        jLabel4.setText("Column");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel4, gridBagConstraints);

        jLabel5.setText("New Value");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(jLabel5, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonHelpCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonHelpCloseActionPerformed
        jDialogHelp.hide();
}//GEN-LAST:event_jButtonHelpCloseActionPerformed

    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        EditCoordinateDialog.this.jDialogHelp.dispose();
    }//GEN-LAST:event_formWindowClosed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
              // TODO add your handling code here:
    }//GEN-LAST:event_formWindowClosing
    
    /**
     * @param args the command line arguments
     */

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonHelpClose;
    private javax.swing.JDialog jDialogHelp;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextAreaHelp;
    // End of variables declaration//GEN-END:variables
    
}
