/*
 * EditConnectivityDialog.java
 *
 * Created on May 21, 2008, 7:48 PM
 */

package pdb_editor.dialogs;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.data.Atom;
import pdb_reader.data.Connectivity;

/**
 *
 * @author  Owner
 */
public class EditConnectivityDialog extends javax.swing.JDialog {
    
    private Stack<Map<Atom, Connectivity>> UndoStack = new Stack<Map<Atom, Connectivity>> ();
    private Stack<Map<Atom, Connectivity>> RedoStack = new Stack<Map<Atom, Connectivity>> ();
    
    private EditorFrame Parent = null;
    private CoordinateTable ctable = null;
    private DataSet dataset = null;
    private List<Connectivity> maindata = null;
    private TableModel tablemodel = null;
    private Map<Atom, Connectivity> mainset = null;

    private KeyListener CommonKeyListener = new KeyListener () {
        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            
            if (e.isControlDown())
            {
                switch (key)
                {
                    case KeyEvent.VK_I : ImportEntry(); break;
                    case KeyEvent.VK_DELETE : DeleteEntry(); break;
                    case KeyEvent.VK_Z : PerformUndo(); break;
                    case KeyEvent.VK_Y : PerformRedo(); break;
                }
            }
            else
            {
                switch (key)
                {
                    case KeyEvent.VK_I : ImportBonds(); break;
                    case KeyEvent.VK_DELETE : DeleteBranch(); break;
                    case KeyEvent.VK_C : SetCenter(); break;
                }
            }
            
            switch (key)
            {
                case KeyEvent.VK_ESCAPE : CloseWindow(); break;
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };

    /** Creates new form EditConnectivityDialog */
    public EditConnectivityDialog(java.awt.Frame parent, boolean modal, CoordinateTable cTable) {
        super(parent, modal);
        try { Parent = (EditorFrame)parent; } catch (Exception e) {}
        ctable = cTable;
        dataset = ctable.getMainData();
        initData();
        tablemodel = new TableModel();
        initComponents();
        this.addKeyListener(CommonKeyListener);
        jTable.addKeyListener(CommonKeyListener);
    }
   
    private void initData()
    {
        dataset.UpdateConnectivityTable();
        mainset = dataset.ConnectList();
        maindata = new ArrayList<Connectivity> (mainset.values());
    }
    
    
    private class TableModel extends AbstractTableModel {
        
        public int getRowCount() {
            return maindata.size();
        }

        public int getColumnCount() {
            int max = 5;
            for (Connectivity c : mainset.values())
                if ((c.Branch.size() + 1) > max) max = c.Branch.size() + 1;
            return max;
        }

        public Object getValueAt(int row, int col) {
            Connectivity c = maindata.get(row);
            if (col == 0) return GenerateAtomLabel(c.Base);
            col--;
            Atom[] list = c.Branch.toArray(new Atom[c.Branch.size()]);
            if (col < list.length)
                return GenerateAtomLabel(list[col]);
            return null;
        }
        
        public String getColumnName(int col)
        {
            if (col == 0) return "Center";
            return "Bond " + col;
        }
        
        private String GenerateAtomLabel(Atom a)
        {
            StringBuilder sb = new StringBuilder();
            
            sb.append('(');
            sb.append(a.AtomNumber());
            sb.append(")  ");
            if (a.ChainID() != ' ') sb.append(a.ChainID());
            sb.append(a.ResidueNumber());
            sb.append(" - ");
            sb.append(a.AtomType());
            
            return sb.toString();
        }
    }

    private void CloseWindow()
    {
        this.dispose();
    }
    
    private void SaveUndoData()
    {
        TreeMap<Atom, Connectivity> r = new TreeMap<Atom, Connectivity> ();
        
        for (Atom a : mainset.keySet())
            r.put(a, mainset.get(a).clone());
        
        this.UndoStack.push(r);
        this.jButtonUndo.setEnabled(true);
        this.RedoStack.clear();
        this.jButtonRedo.setEnabled(false);
        
        if (Parent != null) Parent.dataChangeNotSaved = true;
    }
    
    private void PerformUndo()
    {
        if (UndoStack.size() > 0)
        {
            this.RedoStack.push(mainset);
            this.jButtonRedo.setEnabled(true);
            dataset.ConnectList((TreeMap<Atom, Connectivity>)UndoStack.pop());
            UpdateTable();
            if (UndoStack.size() == 0) this.jButtonUndo.setEnabled(false);
        }
    }
    
    private void PerformRedo()
    {
        if (RedoStack.size() > 0)
        {
            this.UndoStack.push(mainset);
            this.jButtonUndo.setEnabled(true);
            dataset.ConnectList((TreeMap<Atom, Connectivity>)RedoStack.pop());
            UpdateTable();
            if (RedoStack.size() == 0) this.jButtonRedo.setEnabled(false);
        }
    }
    
    private void UpdateTable()
    {
        initData();
        tablemodel.fireTableStructureChanged();        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable = new javax.swing.JTable();
        jButtonClose = new javax.swing.JButton();
        jToolBar1 = new javax.swing.JToolBar();
        jButtonAddEntry = new javax.swing.JButton();
        jButtonAddBonds = new javax.swing.JButton();
        jSeparator2 = new javax.swing.JToolBar.Separator();
        jButtonSetAsCenter = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JToolBar.Separator();
        jButtonDeleteEntry = new javax.swing.JButton();
        jButtonDeleteBonds = new javax.swing.JButton();
        jSeparator3 = new javax.swing.JToolBar.Separator();
        jButtonUndo = new javax.swing.JButton();
        jButtonRedo = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Edit Atom Connectivity");

        jTable.setModel(tablemodel);
        jTable.setCellSelectionEnabled(true);
        jScrollPane1.setViewportView(jTable);

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jToolBar1.setRollover(true);
        jToolBar1.setMinimumSize(new java.awt.Dimension(448, 40));

        jButtonAddEntry.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/edit_add24.png"))); // NOI18N
        jButtonAddEntry.setText("Entry");
        jButtonAddEntry.setToolTipText("Import Selected Atoms from Main Window as Entry (Ctrl + I)");
        jButtonAddEntry.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jButtonAddEntry.setBorderPainted(false);
        jButtonAddEntry.setFocusable(false);
        jButtonAddEntry.setPreferredSize(new java.awt.Dimension(61, 40));
        jButtonAddEntry.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButtonAddEntry.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddEntryActionPerformed(evt);
            }
        });
        jToolBar1.add(jButtonAddEntry);

        jButtonAddBonds.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/edit_add24.png"))); // NOI18N
        jButtonAddBonds.setText("Bonds");
        jButtonAddBonds.setToolTipText("Import Selected Atoms from Main Window as Bonds to Selected Entry (I)");
        jButtonAddBonds.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jButtonAddBonds.setBorderPainted(false);
        jButtonAddBonds.setFocusable(false);
        jButtonAddBonds.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButtonAddBonds.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddBondsActionPerformed(evt);
            }
        });
        jToolBar1.add(jButtonAddBonds);
        jToolBar1.add(jSeparator2);

        jButtonSetAsCenter.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/ok24.png"))); // NOI18N
        jButtonSetAsCenter.setText("Set as Center");
        jButtonSetAsCenter.setToolTipText("Set Selected Bond as Center of the Bond (Ctrl + Del)");
        jButtonSetAsCenter.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jButtonSetAsCenter.setBorderPainted(false);
        jButtonSetAsCenter.setFocusable(false);
        jButtonSetAsCenter.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButtonSetAsCenter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSetAsCenterActionPerformed(evt);
            }
        });
        jToolBar1.add(jButtonSetAsCenter);
        jToolBar1.add(jSeparator1);

        jButtonDeleteEntry.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/edit_remove24.png"))); // NOI18N
        jButtonDeleteEntry.setText("Entry");
        jButtonDeleteEntry.setToolTipText("Delete Selected Entry Including All Bonds (Ctrl + Del)");
        jButtonDeleteEntry.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jButtonDeleteEntry.setBorderPainted(false);
        jButtonDeleteEntry.setFocusable(false);
        jButtonDeleteEntry.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButtonDeleteEntry.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteEntryActionPerformed(evt);
            }
        });
        jToolBar1.add(jButtonDeleteEntry);

        jButtonDeleteBonds.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/edit_remove24.png"))); // NOI18N
        jButtonDeleteBonds.setText("Bonds");
        jButtonDeleteBonds.setToolTipText("Delete Selected Bonds (Del)");
        jButtonDeleteBonds.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jButtonDeleteBonds.setBorderPainted(false);
        jButtonDeleteBonds.setFocusable(false);
        jButtonDeleteBonds.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButtonDeleteBonds.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteBondsActionPerformed(evt);
            }
        });
        jToolBar1.add(jButtonDeleteBonds);
        jToolBar1.add(jSeparator3);

        jButtonUndo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/undo24.png"))); // NOI18N
        jButtonUndo.setText("Undo");
        jButtonUndo.setToolTipText("Undo Last Action (Ctrl + Z)");
        jButtonUndo.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jButtonUndo.setBorderPainted(false);
        jButtonUndo.setEnabled(false);
        jButtonUndo.setFocusable(false);
        jButtonUndo.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButtonUndo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonUndoActionPerformed(evt);
            }
        });
        jToolBar1.add(jButtonUndo);

        jButtonRedo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/redo24.png"))); // NOI18N
        jButtonRedo.setText("Redo");
        jButtonRedo.setToolTipText("Redo Last Undo (Ctrl + Y)");
        jButtonRedo.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jButtonRedo.setBorderPainted(false);
        jButtonRedo.setEnabled(false);
        jButtonRedo.setFocusable(false);
        jButtonRedo.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButtonRedo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRedoActionPerformed(evt);
            }
        });
        jToolBar1.add(jButtonRedo);

        jLabel1.setText("Atoms are labeled as : ( AtomNumber ) ChainID ResidueNumber - AtomName");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 741, Short.MAX_VALUE)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 721, Short.MAX_VALUE)
                    .addComponent(jButtonClose))
                .addContainerGap())
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addContainerGap(364, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonClose)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        this.dispose();
}//GEN-LAST:event_jButtonCloseActionPerformed

private void SetCenter()
{
        
    int row = jTable.getSelectedRow();
    int col = jTable.getSelectedColumn();
        
    if (col != 0)
    {
        Connectivity c1 = maindata.get(row);
        col--;
        if (col < c1.Branch.size())
        {
            SaveUndoData();
            
            Atom b1 = c1.Base;
            Set<Atom> s1 = c1.Branch;
            
            Atom b2 = s1.toArray(new Atom[s1.size()])[col];
            Connectivity c2 = mainset.get(b2);
            if (c2 == null) { c2 = new Connectivity(b2, b1); mainset.put(b2, c2); }
            Set<Atom> s2 = c2.Branch;
            
            s2.addAll(s1);
            s2.remove(b2);
            for (Atom a : s2) {
                Connectivity br = mainset.get(a);
                if (br != null) { br.Branch.add(b2); br.Branch.remove(b1); }
                else { br = new Connectivity(a, b2); mainset.put(a, br); }
                s1.remove(a);
            }

            initData();
            tablemodel.fireTableStructureChanged();
        }
    }
            
}

private void DeleteBranch()
{
    
    int rows[] = jTable.getSelectedRows();
    int cols[] = jTable.getSelectedColumns();
        
    ArrayList<Connectivity> clist = new ArrayList<Connectivity> ();
    ArrayList<ArrayList<Atom>> tlist = new ArrayList<ArrayList<Atom>> ();
    for (int r : rows)
    {
        Connectivity conn = maindata.get(r);
        Atom[] branchlist = conn.Branch.toArray(new Atom[conn.Branch.size()]);
        ArrayList<Atom> list = new ArrayList<Atom> ();
        for (int c : cols)
        {
            if (c != 0)
            {
                int index = c-1;
                if (index < branchlist.length) list.add(branchlist[index]);
            }
        }
        if (list.size() > 0)
        {
            clist.add(conn);
            tlist.add(list);
        }
    }
    
    if (clist.size() > 0) SaveUndoData();
    for (int i=0; i<clist.size(); i++)
    {
        Connectivity c = clist.get(i);
        ArrayList<Atom> targets = tlist.get(i);
        
        Atom base = c.Base;
        Set<Atom> s = c.Branch;
        
        for (Atom target : targets)
        {
            Connectivity c2 = mainset.get(target);
            
            s.remove(target);
            if (s.size() == 0) mainset.remove(base);
            
            if (c2 != null) {
                c2.Branch.remove(base);
                if (c2.Branch.size() == 0) mainset.remove(target);
            }
        }
    }
    
    initData();
    tablemodel.fireTableStructureChanged();

    /*
    int row = jTable.getSelectedRow();
    int col = jTable.getSelectedColumn();
        
    if (col != 0)
    {
        Connectivity c = maindata.get(row);
        col--;
        if (col < c.Branch.size())
        {
            Atom base = c.Base;
            Set<Atom> s = c.Branch;
            Atom target = s.toArray(new Atom[s.size()])[col];
            Connectivity c2 = mainset.get(target);
            
            s.remove(target);
            if (s.size() == 0) mainset.remove(base);

            if (c2 != null) {
                c2.Branch.remove(base);
                if (c2.Branch.size() == 0) mainset.remove(target);
            }
            
            initData();
            tablemodel.fireTableStructureChanged();
        }        
    }
     */    
}

private void DeleteEntry()
{
    int[] rows = jTable.getSelectedRows();
    
    Atom[] bases = new Atom[rows.length];
    for (int i=0; i<rows.length; i++) bases[i] = maindata.get(rows[i]).Base;
    
    if (bases.length > 0) SaveUndoData();
    
    for (Atom base : bases)
    {
        if (mainset.containsKey(base))
        {
            Set<Atom> set = mainset.get(base).Branch;
            
            for (Atom br : set)
            {
                if (mainset.containsKey(br))
                {
                    Set<Atom> branches = mainset.get(br).Branch;
                    branches.remove(base);
                    if (branches.size() == 0) mainset.remove(br);
                }
            }
            
            mainset.remove(base);
        }
    }

    initData();
    tablemodel.fireTableStructureChanged();
}

private void ImportBonds()
{
    int[] selrows = ctable.getSelectedRows();
    if (selrows != null)
        if (selrows.length > 0)
        {
            Atom[] selatoms = dataset.getAtoms(selrows);
            
            int[] selconnrows = jTable.getSelectedRows();
            Connectivity[] conns = new Connectivity[selconnrows.length];
            for (int i=0; i<conns.length; i++) conns[i] = maindata.get(selconnrows[i]);
    
            if (conns.length > 0) SaveUndoData();
            
            for (Connectivity c : conns)
            {
                Atom base = c.Base;
                for (Atom a : selatoms) 
                {
                    c.Branch.add(a);
                    if (!mainset.containsKey(a)) mainset.put(a, new Connectivity(a, base));
                    else mainset.get(a).Branch.add(base);
                }
            }
            
            initData();
            tablemodel.fireTableStructureChanged();
        }
}

private void jButtonAddEntryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddEntryActionPerformed
    ImportEntry();
}//GEN-LAST:event_jButtonAddEntryActionPerformed

private void jButtonAddBondsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddBondsActionPerformed
    ImportBonds();
}//GEN-LAST:event_jButtonAddBondsActionPerformed

private void jButtonSetAsCenterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSetAsCenterActionPerformed
    SetCenter();
}//GEN-LAST:event_jButtonSetAsCenterActionPerformed

private void jButtonDeleteEntryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteEntryActionPerformed
    this.DeleteEntry();
}//GEN-LAST:event_jButtonDeleteEntryActionPerformed

private void jButtonDeleteBondsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeleteBondsActionPerformed
    this.DeleteBranch();
}//GEN-LAST:event_jButtonDeleteBondsActionPerformed

private void jButtonUndoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonUndoActionPerformed
    this.PerformUndo();
}//GEN-LAST:event_jButtonUndoActionPerformed

private void jButtonRedoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRedoActionPerformed
    this.PerformRedo();
}//GEN-LAST:event_jButtonRedoActionPerformed

private void ImportEntry()
{
    int[] selrows = ctable.getSelectedRows();
    if (selrows != null)
        if (selrows.length > 1)
        {
            Atom[] selatoms = dataset.getAtoms(selrows);
            
            SaveUndoData();
            
            mainset.put(selatoms[0], new Connectivity(selatoms));
            boolean first = true;
            for (Atom a : selatoms)
            {
                if (!first)
                {
                    if (mainset.containsKey(a)) mainset.get(a).Branch.add(selatoms[0]);
                    else mainset.put(a, new Connectivity(a, selatoms[0]));
                }
                first = false;
            }
            
            initData();
            tablemodel.fireTableStructureChanged();            
        }            

}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAddBonds;
    private javax.swing.JButton jButtonAddEntry;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonDeleteBonds;
    private javax.swing.JButton jButtonDeleteEntry;
    private javax.swing.JButton jButtonRedo;
    private javax.swing.JButton jButtonSetAsCenter;
    private javax.swing.JButton jButtonUndo;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JToolBar.Separator jSeparator1;
    private javax.swing.JToolBar.Separator jSeparator2;
    private javax.swing.JToolBar.Separator jSeparator3;
    private javax.swing.JTable jTable;
    private javax.swing.JToolBar jToolBar1;
    // End of variables declaration//GEN-END:variables
    
}
