/*
 * EditSpacegroupDialog.java
 *
 * Created on March 25, 2008, 7:54 PM
 */

package pdb_editor.dialogs;

import java.awt.Color;
import java.util.Locale;
import javax.swing.JOptionPane;
import pdb_editor.EditorFrame;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.spacegroup.SpaceGroup;
import pdb_reader.data.spacegroup.SpaceGroupInformation;

/**
 *
 * @author  Owner
 */
public class EditSpacegroupDialog extends javax.swing.JDialog {
    
    private DataSet maindata = null;
    private SpaceGroup sg = null;
    private EditorFrame Parent = null;
    
    /** Creates new form EditSpacegroupDialog */
    public EditSpacegroupDialog(java.awt.Frame parent, boolean modal, DataSet MainData) {
        super(parent, modal);
        try { Parent = (EditorFrame)parent; } catch (Exception e) {}
        initComponents();
        maindata = MainData;
        if (maindata.Spacegroup() != null) sg = maindata.Spacegroup().clone();
        else 
        {
            sg = new SpaceGroup();
            sg.scale(new double[4][4]);
        }
        initTextFields();
    }

    public EditSpacegroupDialog(java.awt.Frame parent, boolean modal, DataSet MainData, SpaceGroup newsg) {
        super(parent, modal);
        initComponents();
        maindata = MainData;
        sg = newsg;
        initTextFields();
    }
    
    private void initTextFields()
    {
        if (sg != null)
        {
            this.jTextFieldSpacegroup.setText(sg.name());
            this.jTextFieldNumber.setText("" + sg.number());
            this.jTextFielda.setText("" + sg.a());
            this.jTextFieldb.setText("" + sg.b());
            this.jTextFieldc.setText("" + sg.c());
            this.jTextFieldalpha.setText("" + sg.alpha());
            this.jTextFieldbeta.setText("" + sg.beta());
            this.jTextFieldgamma.setText("" + sg.gamma());
            initScaleMatrix();
            
            this.jTextAreaSpaceGroupInformation.setText(sg.SpaceGroupInformation());
        }
        else
        {
            this.jButtonRevertScale.setEnabled(false);
            this.jButtonRevertAll.setEnabled(false);
        }
    }
    
    private void initScaleMatrix()
    {
        double[][] scale = null;
        scale = sg.scale();
        if (scale == null) scale = sg.scale(Global.GenerateScaleMatrix(GetCurrentUnitcellParameters()));
        DisplayFormattedMatrix(scale);
    }
    
    private void DisplayFormattedMatrix(double[][] matrix4x4)
    {
        StringBuilder sb = new StringBuilder();
        for (int i=0; i<3; i++)
        {
            sb.append("[ ");
            for (int j=0; j<4; j++)
            {
                sb.append(String.format("%-16.9f", matrix4x4[i][j]));
                sb.append(' ');
            }
            if (i != 2) sb.append("]\n");
            else sb.append(']');
        }
        
        this.jTextAreaScale.setText(sb.toString());
    }
    
    private boolean UpdateInformation()
    {
        try {
            sg.name(this.jTextFieldSpacegroup.getText());
            sg.number(Integer.parseInt(this.jTextFieldNumber.getText()));

            sg.a(Double.parseDouble(this.jTextFielda.getText()));
            sg.b(Double.parseDouble(this.jTextFieldb.getText()));
            sg.c(Double.parseDouble(this.jTextFieldc.getText()));
            
            sg.alpha(Double.parseDouble(this.jTextFieldalpha.getText()));
            sg.beta(Double.parseDouble(this.jTextFieldbeta.getText()));
            sg.gamma(Double.parseDouble(this.jTextFieldgamma.getText()));
            
            
        }
        catch (Exception e)
        {
            return false;
        }
        try {
            sg.scale(Global.GenerateTransformationMatrix(Global.ExtractAllNumbers(this.jTextAreaScale.getText())));
        }
        catch (Exception e)
        {
            sg.scale(Global.GenerateScaleMatrix(GetCurrentUnitcellParameters()));
        }
        return true;
    }
    
    private void WriteFinalInformation()
    {
        //maindata.Spacegroup(sg);
        
        if (maindata.Spacegroup() == null) maindata.Spacegroup(new SpaceGroup());
        
        SpaceGroup d = maindata.Spacegroup();
        
        d.name(sg.name());
        d.number(sg.number());

        d.a(sg.a());
        d.b(sg.b());
        d.c(sg.c());
        
        d.alpha(sg.alpha());
        d.beta(sg.beta());
        d.gamma(sg.gamma());
        
        d.scale(sg.scale());
        
        maindata.UpdateScaleMatrixChange();
    }
    
    private double[] GetCurrentUnitcellParameters()
    {
        return new double[] {
           Double.parseDouble(this.jTextFielda.getText()),
           Double.parseDouble(this.jTextFieldb.getText()),
           Double.parseDouble(this.jTextFieldc.getText()),
            
           Double.parseDouble(this.jTextFieldalpha.getText()),
           Double.parseDouble(this.jTextFieldbeta.getText()),
           Double.parseDouble(this.jTextFieldgamma.getText())
        };
    }
    
    private void CheckCellParametersUpdateMatrix()
    {
        if (UpdateInformation()) 
        {
            ReportCellParameterError(!sg.isfCellParametersCorrect());
            sg.scale(Global.GenerateScaleMatrix(GetCurrentUnitcellParameters()));
            DisplayFormattedMatrix(sg.scale());   
        }
        else ReportCellParameterError(true);
    }
    
    private void CheckCellParameters()
    {
        if (UpdateInformation()) 
        {
            ReportCellParameterError(!sg.isfCellParametersCorrect());
        }
        else ReportCellParameterError(true);
    }
    
    private void ReportCellParameterError(boolean error)
    {
        if (error)
        {
            this.jLabela.setForeground(Color.RED);
            this.jLabelb.setForeground(Color.RED);
            this.jLabelc.setForeground(Color.RED);
            this.jLabelalpha.setForeground(Color.RED);
            this.jLabelbeta.setForeground(Color.RED);
            this.jLabelgamma.setForeground(Color.RED);
        }
        else
        {
            this.jLabela.setForeground(Color.BLACK);
            this.jLabelb.setForeground(Color.BLACK);
            this.jLabelc.setForeground(Color.BLACK);
            this.jLabelalpha.setForeground(Color.BLACK);
            this.jLabelbeta.setForeground(Color.BLACK);
            this.jLabelgamma.setForeground(Color.BLACK);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldSpacegroup = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jTextFieldNumber = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaScale = new javax.swing.JTextArea();
        jButtonRevertScale = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jLabela = new javax.swing.JLabel();
        jLabelalpha = new javax.swing.JLabel();
        jLabelbeta = new javax.swing.JLabel();
        jLabelb = new javax.swing.JLabel();
        jLabelc = new javax.swing.JLabel();
        jLabelgamma = new javax.swing.JLabel();
        jTextFielda = new javax.swing.JTextField();
        jTextFieldc = new javax.swing.JTextField();
        jTextFieldb = new javax.swing.JTextField();
        jTextFieldgamma = new javax.swing.JTextField();
        jTextFieldalpha = new javax.swing.JTextField();
        jTextFieldbeta = new javax.swing.JTextField();
        jButtonCancel = new javax.swing.JButton();
        jButtonOK = new javax.swing.JButton();
        jButtonRevertAll = new javax.swing.JButton();
        jPanel4 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTextAreaSpaceGroupInformation = new javax.swing.JTextArea();
        jButtonCorrectCellParameters = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Edit Spacegroup & Unit Cell");
        setResizable(false);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Space Group"));

        jLabel1.setText("Spacegroup :");

        jTextFieldSpacegroup.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldSpacegroupFocusLost(evt);
            }
        });

        jLabel2.setText("Number :");

        jTextFieldNumber.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                jTextFieldNumberFocusLost(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldSpacegroup, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(28, 28, 28)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextFieldNumber, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(86, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldSpacegroup, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(jTextFieldNumber, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Scale Matrix"));

        jTextAreaScale.setColumns(20);
        jTextAreaScale.setRows(4);
        jScrollPane1.setViewportView(jTextAreaScale);

        jButtonRevertScale.setText("Revert Matrix");
        jButtonRevertScale.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRevertScaleActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jButtonRevertScale)
                .addContainerGap(277, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 77, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonRevertScale))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Unitcell Parameters"));
        jPanel3.setPreferredSize(new java.awt.Dimension(80, 20));
        jPanel3.setLayout(new java.awt.GridBagLayout());

        jLabela.setText("a ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 7, 8);
        jPanel3.add(jLabela, gridBagConstraints);

        jLabelalpha.setText("alpha");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 8);
        jPanel3.add(jLabelalpha, gridBagConstraints);

        jLabelbeta.setText("beta");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 8);
        jPanel3.add(jLabelbeta, gridBagConstraints);

        jLabelb.setText("b");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 7, 8);
        jPanel3.add(jLabelb, gridBagConstraints);

        jLabelc.setText("c");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 7, 8);
        jPanel3.add(jLabelc, gridBagConstraints);

        jLabelgamma.setText("gamma");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 8);
        jPanel3.add(jLabelgamma, gridBagConstraints);

        jTextFielda.setPreferredSize(new java.awt.Dimension(80, 20));
        jTextFielda.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTextFieldaKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 7, 0);
        jPanel3.add(jTextFielda, gridBagConstraints);

        jTextFieldc.setPreferredSize(new java.awt.Dimension(80, 20));
        jTextFieldc.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTextFieldcKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 7, 0);
        jPanel3.add(jTextFieldc, gridBagConstraints);

        jTextFieldb.setPreferredSize(new java.awt.Dimension(80, 20));
        jTextFieldb.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTextFieldbKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 7, 0);
        jPanel3.add(jTextFieldb, gridBagConstraints);

        jTextFieldgamma.setPreferredSize(new java.awt.Dimension(80, 20));
        jTextFieldgamma.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTextFieldgammaKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel3.add(jTextFieldgamma, gridBagConstraints);

        jTextFieldalpha.setPreferredSize(new java.awt.Dimension(80, 20));
        jTextFieldalpha.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTextFieldalphaKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel3.add(jTextFieldalpha, gridBagConstraints);

        jTextFieldbeta.setPreferredSize(new java.awt.Dimension(80, 20));
        jTextFieldbeta.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTextFieldbetaKeyReleased(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel3.add(jTextFieldbeta, gridBagConstraints);

        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jButtonRevertAll.setText("Revert All");
        jButtonRevertAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRevertAllActionPerformed(evt);
            }
        });

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Space Group Information"));

        jTextAreaSpaceGroupInformation.setColumns(20);
        jTextAreaSpaceGroupInformation.setEditable(false);
        jTextAreaSpaceGroupInformation.setRows(5);
        jScrollPane2.setViewportView(jTextAreaSpaceGroupInformation);

        jButtonCorrectCellParameters.setText("Correct Cell Parameters");
        jButtonCorrectCellParameters.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCorrectCellParametersActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jButtonCorrectCellParameters))
            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 376, Short.MAX_VALUE)
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 161, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonCorrectCellParameters))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel4, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 392, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createSequentialGroup()
                        .addComponent(jButtonRevertAll)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 171, Short.MAX_VALUE)
                        .addComponent(jButtonOK, javax.swing.GroupLayout.PREFERRED_SIZE, 69, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonCancel)
                        .addGap(2, 2, 2)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, 80, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(3, 3, 3)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonRevertAll)
                    .addComponent(jButtonOK)
                    .addComponent(jButtonCancel))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        this.dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        if (UpdateInformation()) 
        {
            WriteFinalInformation();
            maindata.UpdateScaleMatrixChange();
            if (Parent != null) Parent.dataChangeNotSaved = true;
            this.dispose();
        }
        else
        {
             JOptionPane.showMessageDialog(this, "Error in input", "Error", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_jButtonOKActionPerformed

    private void jButtonRevertScaleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRevertScaleActionPerformed
        //sg.scale(maindata.Spacegroup().scale().clone());
        initScaleMatrix();
    }//GEN-LAST:event_jButtonRevertScaleActionPerformed

    private void jButtonRevertAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRevertAllActionPerformed
        sg = maindata.Spacegroup().clone();
        initTextFields();
    }//GEN-LAST:event_jButtonRevertAllActionPerformed

    private void jButtonCorrectCellParametersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCorrectCellParametersActionPerformed
        UpdateInformation();
        sg.CorrectCellParameters();
        initTextFields();
        CheckCellParametersUpdateMatrix();
    }//GEN-LAST:event_jButtonCorrectCellParametersActionPerformed

    private void jTextFieldSpacegroupFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextFieldSpacegroupFocusLost
        String sgname = this.jTextFieldSpacegroup.getText().trim();
        if (sgname != null)
            if (sgname.length() > 1)
            {
                sgname = Character.toUpperCase(sgname.charAt(0)) + sgname.substring(1);
                this.jTextFieldSpacegroup.setText(sgname);
            }
        if (SpaceGroup.SpaceGroupTableByName.containsKey(sgname))
        {
            this.jTextFieldNumber.setText("" + SpaceGroup.SpaceGroupTableByName.get(sgname).CCP4Number);
            UpdateInformation();
            initTextFields();
            CheckCellParameters();
        }
        else
        {
            JOptionPane.showMessageDialog(this, "Unrecognized space group", "Error", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_jTextFieldSpacegroupFocusLost

    private void jTextFieldaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextFieldaKeyReleased
        CheckCellParameters();
    }//GEN-LAST:event_jTextFieldaKeyReleased

    private void jTextFieldNumberFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_jTextFieldNumberFocusLost
        int sgnum = Integer.parseInt(this.jTextFieldNumber.getText());
        if (SpaceGroup.SpaceGroupTableByNumber.containsKey(sgnum))
        {
            this.jTextFieldSpacegroup.setText(SpaceGroup.SpaceGroupTableByNumber.get(sgnum).Name);
            UpdateInformation();
            initTextFields();
            CheckCellParameters();
        }
        else
        {
            JOptionPane.showMessageDialog(this, "Unrecognized space group", "Error", JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_jTextFieldNumberFocusLost

    private void jTextFieldbKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextFieldbKeyReleased
        CheckCellParametersUpdateMatrix();
    }//GEN-LAST:event_jTextFieldbKeyReleased

    private void jTextFieldcKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextFieldcKeyReleased
        CheckCellParametersUpdateMatrix();
    }//GEN-LAST:event_jTextFieldcKeyReleased

    private void jTextFieldalphaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextFieldalphaKeyReleased
        CheckCellParametersUpdateMatrix();
    }//GEN-LAST:event_jTextFieldalphaKeyReleased

    private void jTextFieldbetaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextFieldbetaKeyReleased
        CheckCellParametersUpdateMatrix();
    }//GEN-LAST:event_jTextFieldbetaKeyReleased

    private void jTextFieldgammaKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextFieldgammaKeyReleased
        CheckCellParametersUpdateMatrix();
    }//GEN-LAST:event_jTextFieldgammaKeyReleased
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonCorrectCellParameters;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JButton jButtonRevertAll;
    private javax.swing.JButton jButtonRevertScale;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabela;
    private javax.swing.JLabel jLabelalpha;
    private javax.swing.JLabel jLabelb;
    private javax.swing.JLabel jLabelbeta;
    private javax.swing.JLabel jLabelc;
    private javax.swing.JLabel jLabelgamma;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextArea jTextAreaScale;
    private javax.swing.JTextArea jTextAreaSpaceGroupInformation;
    private javax.swing.JTextField jTextFieldNumber;
    private javax.swing.JTextField jTextFieldSpacegroup;
    private javax.swing.JTextField jTextFielda;
    private javax.swing.JTextField jTextFieldalpha;
    private javax.swing.JTextField jTextFieldb;
    private javax.swing.JTextField jTextFieldbeta;
    private javax.swing.JTextField jTextFieldc;
    private javax.swing.JTextField jTextFieldgamma;
    // End of variables declaration//GEN-END:variables
    
}
