/*
 * RotateTranslateAtomsDialog.java
 *
 * Created on March 22, 2008, 8:46 AM
 */

package pdb_editor.dialogs;

import java.awt.Color;
import javax.swing.JOptionPane;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.Coordinate;

/**
 *
 * @author  Owner
 */
public class RotateTranslateAtomsDialog extends javax.swing.JDialog {
    
    static private String DeterminantLabelText = "Determinant of Transformation Matrix = ";
    
    CoordinateTable ctable = null;
    DataSet maindata = null;
    EditorFrame Parent = null;
    
    /** Creates new form RotateTranslateAtomsDialog */
    public RotateTranslateAtomsDialog(java.awt.Frame parent, boolean modal, CoordinateTable tablein) {
        super(parent, modal);
        try { Parent = (EditorFrame)parent; } catch (Exception e) {}
        initComponents();
        initButtonGroups();
        ctable = tablein;
        maindata = tablein.getMainData();
        this.jCheckBoxFractionalCoordinate.setEnabled(false);
        if (maindata.Spacegroup() != null)
            if (maindata.Spacegroup().scale() != null)
                this.jCheckBoxFractionalCoordinate.setEnabled(true);
    }
    
    private void initButtonGroups()
    {
        buttonGroupAngleSelection.add(this.jRadioButtonEulerAngle);
        buttonGroupAngleSelection.add(this.jRadioButtonPolarAngle);
        buttonGroupAngleSelection.add(this.jRadioButtonTranslationOnly);
        
        buttonGroupAtomSelection.add(this.jRadioButtonSelectedAll);
        buttonGroupAtomSelection.add(this.jRadioButtonSelectedAtoms);
        buttonGroupAtomSelection.add(this.jRadioButtonSelectedChain);
        
        this.jRadioButtonEulerAngle.setSelected(true);
        this.jRadioButtonSelectedAll.setSelected(true);
    }
    
    private void Run()
    {
        if (Parent != null) Parent.listenForUndoStart("Rotate / translate atom");
        double[][] matrix = GetTransformationMatrix();
        int[] selectedrows = GetSelectedAtomIndicies();
        if (selectedrows != null)
        {
            if (!this.jCheckBoxGenerateNewAtoms.isSelected()){
                maindata.TransformAtoms(selectedrows, matrix);
                ctable.fireTableDataChanged();
            }
            else {
                maindata.TransformAtoms(selectedrows, matrix, GetNewChainID());
                ctable.fireTableDataChanged();
            }
        }
        if (Parent != null) Parent.listenForUndoStop();
        
    }
    
    private double[][] GetInput()
    {
        double[] input = Global.ExtractAllNumbers(this.jTextAreaInput.getText());
        if ((input.length == 12) | (input.length == 16)) {
            HighlightTypeInput(0);
            return Global.GenerateTransformationMatrix(input);
        }
        if (input.length == 9) {
            HighlightTypeInput(1);
            return Global.GenerateTransformationFromRotationMatrix(input);
        }
        if (input.length == 6) {
            HighlightTypeInput(2);
            
            double[][] m1 = GetRotationMatrix(input);
            double[][] m2 = GetTranslationMatrix(
                    new double[] {input[3], input[4], input[5]});
            
            return Global.MultiplyMatrix(m2, m1);
        }
        if (input.length == 3) {
            HighlightTypeInput(3);
            return GetRotationMatrix(input);
        }
        
        HighlightTypeInput(-1);
        return null;
    }
    
    private double[][] GetTranslationMatrix(double[] input)
    {
        if (this.jCheckBoxFractionalCoordinate.isSelected())
        {
            Coordinate c = new Coordinate(input[0], input[1], input[2]);
            Coordinate d = Global.TransformCoordinates(maindata.Spacegroup().scaleInverse(), c);
            input[0] = d.x();
            input[1] = d.y();
            input[2] = d.z();
        }
        return Global.GenerateTranformationMatrixFromTranslation(input);
    }
    
    private double[][] GetRotationMatrix(double[] input)
    {
            if (this.jRadioButtonEulerAngle.isSelected())
                return Global.GenerateTranformationMatrixFromEulerAngles(input);
            if (this.jRadioButtonPolarAngle.isSelected())
                return Global.GenerateTranformationMatrixFromPolarAngles(input);
            if (this.jRadioButtonTranslationOnly.isSelected())
                return GetTranslationMatrix(input);

            return null;
    }
    
    private void HighlightTypeInput(int type)
    {
        this.jLabel12Numbers.setForeground(Color.BLACK);
        this.jLabel9Numbers.setForeground(Color.BLACK);
        this.jLabel6Numbers.setForeground(Color.BLACK);
        this.jLabel3Numbers.setForeground(Color.BLACK);
        switch (type)
        {
            case 0 : this.jLabel12Numbers.setForeground(Color.RED); break;
            case 1 : this.jLabel9Numbers.setForeground(Color.RED); break;
            case 2 : this.jLabel6Numbers.setForeground(Color.RED); break;
            case 3 : this.jLabel3Numbers.setForeground(Color.RED); break;
        }
    }
    
    private void DisplayFormattedMatrix(double[][] matrix4x4)
    {
        StringBuilder sb = new StringBuilder();
        for (int i=0; i<4; i++)
        {
            sb.append("[ ");
            for (int j=0; j<4; j++)
            {
                sb.append(String.format("%-16.9f", matrix4x4[i][j]));
                sb.append(' ');
            }
            if (i != 3) sb.append("]\n");
            else sb.append(']');
        }
        this.jTextAreaMatrixOutput.setText(sb.toString());
        this.jLabelDeterminant.setText(DeterminantLabelText + Global.Determinant4x4Matrix(matrix4x4));
    }
    
    private char GetNewChainID()
    {
        String s = this.jTextFieldNewChainID.getText().trim();
        if (s.equals("")) return ' ';
        return s.charAt(0);
    }
    
    private int[] GetSelectedAtomIndicies()
    {
        if (jRadioButtonSelectedAll.isSelected())
            return Global.GenerateIntegerIndiciesArray(maindata.Atoms().size());
        if (jRadioButtonSelectedChain.isSelected())
            return maindata.getChainIndicies(ctable.getSelectedRows());
        if (jRadioButtonSelectedAtoms.isSelected())
            return ctable.getSelectedRows();
        return null;
    }
    
    private double[][] GetTransformationMatrix()
    {
        try {
            return Global.GenerateTransformationMatrix(Global.ExtractAllNumbers(this.jTextAreaMatrixOutput.getText()));
        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog(this, "Error reading transformation matrix", "Error Transofmration", JOptionPane.ERROR_MESSAGE);
            return null;
        }
    }
    
    private void UpdateCalculatedTransformationMatrix()
    {
          double[][] m = GetInput();
          if (m != null) DisplayFormattedMatrix(m);      
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroupAtomSelection = new javax.swing.ButtonGroup();
        buttonGroupAngleSelection = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jRadioButtonSelectedAtoms = new javax.swing.JRadioButton();
        jRadioButtonSelectedChain = new javax.swing.JRadioButton();
        jRadioButtonSelectedAll = new javax.swing.JRadioButton();
        jCheckBoxGenerateNewAtoms = new javax.swing.JCheckBox();
        jTextFieldNewChainID = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jRadioButtonEulerAngle = new javax.swing.JRadioButton();
        jRadioButtonPolarAngle = new javax.swing.JRadioButton();
        jRadioButtonTranslationOnly = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel12Numbers = new javax.swing.JLabel();
        jLabel9Numbers = new javax.swing.JLabel();
        jLabel6Numbers = new javax.swing.JLabel();
        jLabel3Numbers = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jCheckBoxFractionalCoordinate = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaInput = new javax.swing.JTextArea();
        jPanel3 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTextAreaMatrixOutput = new javax.swing.JTextArea();
        jCheckBoxInvert = new javax.swing.JCheckBox();
        jLabelDeterminant = new javax.swing.JLabel();
        jButtonClose = new javax.swing.JButton();
        jButtonTransform = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Rotate / Translate Atoms");

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Atoms to be Transformed"));

        jRadioButtonSelectedAtoms.setText("Selected Atoms");

        jRadioButtonSelectedChain.setText("Selected Chain");

        jRadioButtonSelectedAll.setText("All Atoms");

        jCheckBoxGenerateNewAtoms.setText("Generate new atoms into chain :");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jRadioButtonSelectedAll)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonSelectedChain)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonSelectedAtoms))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jCheckBoxGenerateNewAtoms)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldNewChainID, javax.swing.GroupLayout.PREFERRED_SIZE, 32, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(142, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioButtonSelectedAll)
                    .addComponent(jRadioButtonSelectedChain)
                    .addComponent(jRadioButtonSelectedAtoms))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxGenerateNewAtoms)
                    .addComponent(jTextFieldNewChainID, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(23, 23, 23))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Rotation / Translation Setting"));

        jRadioButtonEulerAngle.setSelected(true);
        jRadioButtonEulerAngle.setText("Euler Angle");
        jRadioButtonEulerAngle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonEulerAngleActionPerformed(evt);
            }
        });

        jRadioButtonPolarAngle.setText("Polar Angles");
        jRadioButtonPolarAngle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonPolarAngleActionPerformed(evt);
            }
        });

        jRadioButtonTranslationOnly.setText("Translation Only");
        jRadioButtonTranslationOnly.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonTranslationOnlyActionPerformed(evt);
            }
        });

        jLabel1.setText("Type in transformation matrix, or angles + translation, or angles");

        jLabel12Numbers.setText("Inputting 12 numbers will assumed as 4 x 3 transformation matrix");

        jLabel9Numbers.setText("Inputting 9 numbers will be assumed as 3 x 3 rotation matrix");

        jLabel6Numbers.setText("Inputting 6 numbers will be assumed as 3 angles followed by 3 translation");

        jLabel3Numbers.setText("Inputting 3 numbers will be assumed as 3 angles or translation by option");

        jLabel6.setText("Euler : Alpha, Beta, Gamma, X, Y, Z");

        jLabel7.setText("Polar : Omega, Phi, Kappa, X, Y, Z");

        jLabel8.setText("Numbers do not have to be formatted but least separated by a space");

        jCheckBoxFractionalCoordinate.setText("Translations in Fractional Coordinate");
        jCheckBoxFractionalCoordinate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxFractionalCoordinateActionPerformed(evt);
            }
        });

        jTextAreaInput.setColumns(20);
        jTextAreaInput.setRows(4);
        jTextAreaInput.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jTextAreaInputKeyPressed(evt);
            }
            public void keyReleased(java.awt.event.KeyEvent evt) {
                jTextAreaInputKeyReleased(evt);
            }
        });
        jScrollPane1.setViewportView(jTextAreaInput);

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jCheckBoxFractionalCoordinate)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addComponent(jLabel8))
                    .addComponent(jLabel1)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jRadioButtonEulerAngle)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonPolarAngle)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jRadioButtonTranslationOnly))
                    .addComponent(jLabel12Numbers)
                    .addComponent(jLabel9Numbers)
                    .addComponent(jLabel6Numbers, javax.swing.GroupLayout.DEFAULT_SIZE, 387, Short.MAX_VALUE)
                    .addComponent(jLabel3Numbers)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(10, 10, 10)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel7)
                            .addComponent(jLabel6)))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 387, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel8)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel12Numbers)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel9Numbers)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel6Numbers)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel6)
                .addGap(5, 5, 5)
                .addComponent(jLabel7)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel3Numbers)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioButtonEulerAngle)
                    .addComponent(jRadioButtonPolarAngle)
                    .addComponent(jRadioButtonTranslationOnly))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxFractionalCoordinate)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1)
                .addGap(23, 23, 23))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Calculated Transformation Matrix"));

        jTextAreaMatrixOutput.setColumns(20);
        jTextAreaMatrixOutput.setRows(4);
        jScrollPane2.setViewportView(jTextAreaMatrixOutput);

        jCheckBoxInvert.setText("Invert Transformation Matrix");
        jCheckBoxInvert.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxInvertActionPerformed(evt);
            }
        });

        jLabelDeterminant.setText("Determinant of Transformation Matrix = ");

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jCheckBoxInvert)
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 387, Short.MAX_VALUE)
                    .addComponent(jLabelDeterminant))
                .addContainerGap())
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 81, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabelDeterminant, javax.swing.GroupLayout.DEFAULT_SIZE, 14, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxInvert)
                .addGap(12, 12, 12))
        );

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jButtonTransform.setText("Transform");
        jButtonTransform.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonTransformActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel3, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addContainerGap())
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButtonTransform)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonClose)
                        .addGap(12, 12, 12))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 79, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButtonClose)
                    .addComponent(jButtonTransform))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        this.dispose();
}//GEN-LAST:event_jButtonCloseActionPerformed

    private void jButtonTransformActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonTransformActionPerformed
        Run();
    }//GEN-LAST:event_jButtonTransformActionPerformed

    private void jCheckBoxInvertActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxInvertActionPerformed
        double[][] m = GetTransformationMatrix();
        if (m != null) DisplayFormattedMatrix(Global.Inverse4x4Matrix(m));
        else this.jCheckBoxInvert.setSelected(!this.jCheckBoxInvert.isSelected());
    }//GEN-LAST:event_jCheckBoxInvertActionPerformed

    private void jTextAreaInputKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextAreaInputKeyPressed

    }//GEN-LAST:event_jTextAreaInputKeyPressed

    private void jTextAreaInputKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTextAreaInputKeyReleased
        UpdateCalculatedTransformationMatrix();
    }//GEN-LAST:event_jTextAreaInputKeyReleased

    private void jRadioButtonEulerAngleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonEulerAngleActionPerformed
        UpdateCalculatedTransformationMatrix();
    }//GEN-LAST:event_jRadioButtonEulerAngleActionPerformed

    private void jRadioButtonPolarAngleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonPolarAngleActionPerformed
        UpdateCalculatedTransformationMatrix();
    }//GEN-LAST:event_jRadioButtonPolarAngleActionPerformed

    private void jRadioButtonTranslationOnlyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonTranslationOnlyActionPerformed
        UpdateCalculatedTransformationMatrix();
    }//GEN-LAST:event_jRadioButtonTranslationOnlyActionPerformed

    private void jCheckBoxFractionalCoordinateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxFractionalCoordinateActionPerformed
        UpdateCalculatedTransformationMatrix();
    }//GEN-LAST:event_jCheckBoxFractionalCoordinateActionPerformed
    
   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroupAngleSelection;
    private javax.swing.ButtonGroup buttonGroupAtomSelection;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonTransform;
    private javax.swing.JCheckBox jCheckBoxFractionalCoordinate;
    private javax.swing.JCheckBox jCheckBoxGenerateNewAtoms;
    private javax.swing.JCheckBox jCheckBoxInvert;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel12Numbers;
    private javax.swing.JLabel jLabel3Numbers;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel6Numbers;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9Numbers;
    private javax.swing.JLabel jLabelDeterminant;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JRadioButton jRadioButtonEulerAngle;
    private javax.swing.JRadioButton jRadioButtonPolarAngle;
    private javax.swing.JRadioButton jRadioButtonSelectedAll;
    private javax.swing.JRadioButton jRadioButtonSelectedAtoms;
    private javax.swing.JRadioButton jRadioButtonSelectedChain;
    private javax.swing.JRadioButton jRadioButtonTranslationOnly;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextArea jTextAreaInput;
    private javax.swing.JTextArea jTextAreaMatrixOutput;
    private javax.swing.JTextField jTextFieldNewChainID;
    // End of variables declaration//GEN-END:variables
    
}
