/*
 * SortAtomsDialog.java
 *
 * Created on May 13, 2008, 7:27 PM
 */

package pdb_editor.dialogs;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import pdb_editor.EditorFrame;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.data.Atom;

/**
 *
 * @author  Owner
 */
public class SortAtomsDialog extends javax.swing.JDialog {
    
    private DataSet maindata = null;
    private CoordinateTable cTable = null;
    private EditorFrame Parent = null;
    private ArrayList<Criteria> criterias = new ArrayList<Criteria> ();
    
    private ItemListener criteriaChangeListener = new ItemListener() {
        public void itemStateChanged(ItemEvent e) {
            boolean cont = true;
            for (int i=0; i<criterias.size(); i++)
                if (criterias.get(i).type.getSelectedIndex() == Atom.TOTAL_NUMBER_OF_INDEX)
                    cont = false;
            if (cont)
                addNewCriteria();
        }
    };
    
    private class Criteria {
        public JLabel name = new JLabel();
        public JComboBox type = new JComboBox();
        public JRadioButton ascending = new JRadioButton();
        public JRadioButton descending = new JRadioButton();
        private ButtonGroup bgroup = new ButtonGroup();
        
        public Criteria()
        {
            for (int i=0; i<Atom.TOTAL_NUMBER_OF_INDEX; i++)
                type.addItem(Atom.DataToolTip[i]);
            type.setSelectedIndex(0);
            
            if (criterias.size() == 0)
                name.setText("Main criteria : ");
            else
            {
                name.setText("Subcriteria " + criterias.size() + " : ");
                type.addItem("IGNORE");
                type.setSelectedIndex(Atom.TOTAL_NUMBER_OF_INDEX);
            }
            
            
            ascending.setText("Ascending");
            descending.setText("Descending");
            bgroup.add(ascending);
            bgroup.add(descending);
            ascending.setSelected(true);
        }
    }
    
    /** Creates new form SortAtomsDialog */
    public SortAtomsDialog(java.awt.Frame parent, boolean modal, CoordinateTable ctable) {
        super(parent, modal);
        initComponents();
        try { Parent = (EditorFrame)parent; } catch (Exception e) {}
        cTable = ctable;
        maindata = ctable.getMainData();
        addNewCriteria();
        addNewCriteria();
        addNewCriteria();
    }
    
    private void Run()
    {
        int[] indicies = getCriteriaIndicies();
        boolean[] descending = getCriteriaDescending();
        if (Parent != null) Parent.listenForUndoStart("Sort atoms with multiple criterias");
        maindata.Sort(indicies, descending);
        if (Parent != null) Parent.listenForUndoStop();
        cTable.fireTableDataChanged();
    }
    
    private int[] getCriteriaIndicies()
    {
        int[] indicies = new int[criterias.size()];
        for (int i=0; i<criterias.size(); i++)
        {
            Criteria c = criterias.get(i);
            indicies[i] = c.type.getSelectedIndex();
        }
        return indicies;
    }
    
    private boolean[] getCriteriaDescending()
    {
        boolean[] descending = new boolean[criterias.size()];
        for (int i=0; i<criterias.size(); i++)
        {
            Criteria c = criterias.get(i);
            descending[i] = c.descending.isSelected();
        }
        return descending;
    }
    
    
    private void addNewCriteria()
    {
        int RIGHTINSETSPACE = 5;
        int DOWNINSETSPACE = 3;
        int GRIDY = criterias.size();
        
        Criteria c = new Criteria();
        c.type.addItemListener(criteriaChangeListener);
        criterias.add(c);
        
        java.awt.GridBagConstraints gridBagConstraints;
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = GRIDY;
        gridBagConstraints.insets = new java.awt.Insets(DOWNINSETSPACE, 0, DOWNINSETSPACE, RIGHTINSETSPACE);
        jPanel1.add(c.name, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = GRIDY;
        gridBagConstraints.insets = new java.awt.Insets(DOWNINSETSPACE, 0, DOWNINSETSPACE, RIGHTINSETSPACE);
        jPanel1.add(c.type, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = GRIDY;
        gridBagConstraints.insets = new java.awt.Insets(DOWNINSETSPACE, 0, DOWNINSETSPACE, RIGHTINSETSPACE);
        jPanel1.add(c.ascending, gridBagConstraints);
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = GRIDY;
        gridBagConstraints.insets = new java.awt.Insets(DOWNINSETSPACE, 0, DOWNINSETSPACE, RIGHTINSETSPACE);
        jPanel1.add(c.descending, gridBagConstraints);
        
        pack();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Sort Atoms");
        setResizable(false);

        jScrollPane1.setHorizontalScrollBar(null);

        jPanel1.setLayout(new java.awt.GridBagLayout());
        jScrollPane1.setViewportView(jPanel1);

        jButton1.setText("Close");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton2.setText("Sort");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButton2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton1))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 455, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 130, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton1)
                    .addComponent(jButton2))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        this.dispose();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        Run();
    }//GEN-LAST:event_jButton2ActionPerformed
    

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
}


