/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package pdb_reader;

/**
 *
 * @author Owner
 */
import java.util.HashMap;
import java.util.LinkedList;

/**
 *
 * @author Owner
 */
public class FormulaEvaluator {
    
    private static char[] AllowedInstructions = {'(', ')', '^', '*', '/', '+', '-' };
    private static char[] AllowedNumbers = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static String[] AllowedFunctions = { "ABS", "SIN", "COS", "TAN", "LOG", "EXP", "ASIN", "ACOS", "ATAN", "LOG10", "SQRT" };
    
    
    private String Formula = null;
    private LinkedList Instructions = null;
    private HashMap<String, Double> Variables = null;
    private Double LastResult = null;        

    public FormulaEvaluator(String formula)
    {
        setFormula(formula);
        generateInstructions();
    }
    public FormulaEvaluator(String formula, HashMap<String, Double> variables)
    {
        setFormula(formula);
        generateInstructions();
        evaluateExpression(variables);
    }
    
    public double evaluateExpression()
    {
        LinkedList Ins = (LinkedList)Instructions.clone();
        substituteVariables(Ins);
        return LastResult = evaluateExpression(Ins);
    }
    
    public double evaluateExpression(HashMap<String, Double> Vars)
    {
        Variables = Vars;
        return evaluateExpression();
    }
    
    // Interface functions
    public String getFormula() { return Formula; }
    public String setFormula(String Value) { return Formula = Value; }
    public HashMap<String, Double> getVariables() { return Variables; }
    public HashMap<String, Double> setVariables(HashMap<String, Double> Value) { return Variables = Value; }
    public Double getLastResult() { return LastResult; }
    
    private void generateInstructions()
    {
        Instructions = new LinkedList();
        Variables = new HashMap<String, Double> ();
        
        boolean readingNumber = false;
        boolean readingName = false;
        StringBuilder Current = null;
        
        for (int i=0; i<Formula.length(); i++)
        {
            char c = Formula.charAt(i);
            
            if (c == ' ') 
            {
                if (readingNumber)
                    Instructions.addLast(Double.parseDouble(Current.toString()));
                if (readingName)
                    processName(Current.toString());
                readingNumber = false;
                readingName = false;
                continue;
            }
            
            int FunctionIndex = Global.CharArrayFindIndex(AllowedInstructions, c);
            if (FunctionIndex != -1)
            {
                if (readingNumber)
                    Instructions.addLast(Double.parseDouble(Current.toString()));
                if (readingName)
                    processName(Current.toString());
                readingNumber = false;
                readingName = false;
                if (FunctionIndex == 6)
                {
                    if (((Instructions.size() == 0) || (Instructions.getLast().getClass().equals(Global.integerclass.getClass())))
                        && (Global.CharArrayContains(AllowedNumbers, Formula.charAt(i+1))))
                    {
                        readingNumber = true;
                        Current = new StringBuilder();
                        Current.append(c);
                        continue;
                    }
                    if ((Instructions.size() == 0) || (Instructions.getLast().getClass().equals(Global.integerclass.getClass())))
                    {
                        Instructions.addLast(-1.000);
                        Instructions.addLast(3);
                        continue;
                    }
                }
                Instructions.addLast(FunctionIndex);
                continue;
            }
            
            if ((readingNumber) || (readingName))
            {
                Current.append(c);
                continue;
            }

            if (Global.CharArrayContains(AllowedNumbers, c))
            {
                readingNumber = true;
                readingName = false;
                Current = new StringBuilder();
                Current.append(c);
                continue;
            }
    
            if (!readingName)
            {
                readingName = true;
                Current = new StringBuilder();
                Current.append(c);
            }
        }
        if (readingNumber)
            Instructions.addLast(Double.parseDouble(Current.toString()));
        if (readingName)
            processName(Current.toString());
    }
    
    private void processName(String Value)
    {
        int functionIndex = Global.StringArrayFindIndex(AllowedFunctions, Value.toUpperCase());
        if (functionIndex != -1)
        {
            Instructions.addLast((functionIndex + 1) * -1);
        }
        else
        {
            Variables.put(Value, null);
            Instructions.addLast(Value);
        }
    }
    
    private double evaluateExpression(LinkedList Ins)
    {
        processParanthesis(Ins);
        processFunctions(Ins);
        processMathOperations(Ins);
        return (Double)Ins.get(0);
    }
    
    private void processFunctions(LinkedList Ins)
    {
        for (int i=0; i<Ins.size(); i++)
        {
            Object o = Ins.get(i);
            
            if (o.getClass() == Global.integerclass.getClass())
            {
                int fcode = (Integer)o;
                if (fcode < 0)
                {
                    evluateFunction(Ins, i, fcode);
                    i = 0;
                }
            }
        }
    }
    
    private void evluateFunction(LinkedList Ins, int index, int funccode)
    {
        double d = (Double)Ins.get(index + 1);
        Ins.remove(index);
        Ins.remove(index);
        double eval = 0;
        switch (funccode)
        {
            case -1 : eval = Math.abs(d); break;
            case -2 : eval = Math.sin(Math.toRadians(d)); break;
            case -3 : eval = Math.cos(Math.toRadians(d)); break;
            case -4 : eval = Math.tan(Math.toRadians(d)); break;
            case -5 : eval = Math.log(d); break;
            case -6 : eval = Math.exp(d); break;
            case -7 : eval = Math.toDegrees(Math.asin(d)); break;
            case -8 : eval = Math.toDegrees(Math.acos(d)); break;
            case -9 : eval = Math.toDegrees(Math.atan(d)); break;
            case -10 : eval = Math.log10(d); break;
            case -11 : eval = Math.sqrt(d); break;
        }
        Ins.add(index, eval);
    }
    
    private void substituteVariables(LinkedList Ins)
    {
        for (int i=0; i<Ins.size(); i++)
        {
            Object o = Ins.get(i);
            
            if (o.getClass() == Global.stringclass.getClass())
            {
                if (Variables.containsKey((String)o))
                {
                    Ins.remove(i);
                    Ins.add(i, Variables.get((String)o));
                }
            }
        }
    }
    
    private void processParanthesis(LinkedList Ins)
    {
        int parenthesisCount = 0;
        LinkedList innerFormula = new LinkedList();
        for (int i=0; i<Ins.size(); i++)
        {
            Object o = Ins.get(i);
        
            if (parenthesisCount > 0)
            {
                if (o.getClass() == Global.integerclass.getClass())
                {
                    int inst = (Integer)o;
                    switch (inst)
                    {
                        case 0 : parenthesisCount++; break;
                        case 1 : parenthesisCount--; break;
                    }
                }
                if (parenthesisCount == 0)
                {
                    Ins.remove(i);
                    Ins.add(i, evaluateExpression(innerFormula));
                    innerFormula = new LinkedList();
                }
                else
                {
                    innerFormula.addLast(o);
                    Ins.remove(i--);
                }
            }
            else
            {
                if (o.getClass() == Global.integerclass.getClass())
                {
                    int inst = (Integer)o;
                    if (inst == 0) 
                    {
                        parenthesisCount = 1; Ins.remove(i--); continue;
                    }
                }
                
            }
        }
    }
    
    private void processMathOperations(LinkedList Ins)    
    {
        for (int j = 2; j<AllowedInstructions.length; j++)
        {
            for (int i=0; i<Ins.size(); i++)
            {
                Object o = Ins.get(i);
                if (o.getClass() == Global.integerclass.getClass())
                {
                    int inst = (Integer)o;
                    if (inst == j)
                    {
                        evaluteMathOperation(Ins, i, inst);
                        i=0;
                        continue;
                    }
                }
            }
        }
    }
    
    private void evaluteMathOperation(LinkedList Ins, int i, int op)
    {
        double d1 = (Double)Ins.get(i-1);
        Ins.remove(i-- - 1);
        double d2 = (Double)Ins.get(i+1);
        Ins.remove(i);
        Ins.remove(i);
        switch (op)
        {
            case 2 : Ins.add(i, Math.pow(d1, d2)); break;
            case 3 : Ins.add(i, d1 * d2); break;
            case 4 : Ins.add(i, d1 / d2); break;
            case 5 : Ins.add(i, d1 + d2); break;
            case 6 : Ins.add(i, d1 - d2); break;
        }
    }
}
