/*
 * EditColumnListDialog.java
 *
 * Created on February 14, 2008, 8:24 PM
 */

package pdb_editor.coordinate;

import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JScrollPane;
import pdb_reader.Global;

/**
 *
 * @author  Owner
 */
public class EditColumnListDialog extends javax.swing.JDialog {
   
    class ListModel extends javax.swing.AbstractListModel {
        private LinkedList<String> list = new LinkedList<String> ();
        
        public void AddElements(String[] elements) {
            for (int i=0; i<elements.length; i++) 
            {
                list.addLast(elements[i]);
            }
        }
        
        public int getSize() {
            return list.size();
        }

        public Object getElementAt(int index) {
            return list.get(index);
        }
        
        public String getAt(int index) {
            return list.get(index);
        }
        
        public void Add(String s) {
            list.addLast(s);
        }
        
        public void RemoveAt(int index) {
            list.remove(index);
        }
        
        public void MoveTop(int index) {
            String s = list.get(index);
            list.remove(index);
            list.addFirst(s);
        }
        
        public void MoveBottom(int index) {
            String s = list.get(index);
            list.remove(index);
            list.addLast(s);
        }
        
        public void MoveBottom(int[] in) {
            String[] s = new String[in.length];
            //for (int i=0; i<in.length; i++)         
            for (int i=in.length - 1; i>=0; i--)
            {
                s[i] = getAt(in[i]);
                list.remove(in[i]);
            }
            for (int i=0; i<in.length; i++)
                list.addLast(s[i]);
        }
        
        public void MoveUp(int index) {
            if (index != 0)
            {
                String s = list.get(index);
                list.remove(index);
                list.add(index - 1, s);
            }
        }
  
        public void MoveUp(int[] in) {
            for (int i=0; i<in.length; i++)
            {
                if (in[i] != 0)
                {
                    String s = list.get(in[i]);
                    list.remove(in[i]);
                    list.add(in[i] - 1, s);
                }
            }
        }

        public void MoveTop(int[] in) {
            String[] s = new String[in.length];
            //for (int i=0; i<in.length; i++)         
            for (int i=in.length - 1; i>=0; i--)
            {
                s[i] = getAt(in[i]);
                list.remove(in[i]);
            }
            for (int i=in.length-1; i>=0; i--)
                list.addFirst(s[i]);
        }
        
        public void MoveDown(int index) {
            if (index != list.size() - 1)
            {
                String s = list.get(index);
                list.remove(index);
                list.add(index + 1, s); 
            }
        }
        
        public void MoveDown(int[] in) {
            for (int i=in.length - 1; i>=0; i--)
            {
                if (in[i] != getSize() - 1)
                {
                    String s = list.get(in[i]);
                    list.remove(in[i]);
                    list.add(in[i] + 1, s);
                }
            }
        }
        
        public String[] ExtractElements(int[] in) {
            String[] result = new String[in.length];
            for (int i=0; i<in.length; i++) result[i] = list.get(in[i]);
            
            for (int i=in.length-1; i>=0; i--) list.remove(in[i]);
            this.fireContentsChanged(list, in[0], in[in.length - 1]);
            
            return result;
        }
        
        public void InsertElements(String[] s) {
            for (int i=0; i<s.length; i++)
            {
                list.addLast(s[i]);
            }
            this.fireContentsChanged(list, 0, list.size() - 1);
        }
        
        public String[] returnList()
        {
            return list.toArray(new String[list.size()]);
        }
    }
    
    class FixedListModel extends javax.swing.AbstractListModel {

        private String[] TotalList = null;
        private boolean[] SwitchList = null;
        private String[] DisplayedList = null;
        
        public FixedListModel(String[] total, String[] displayed)
        {
            TotalList = total;
            DisplayedList = displayed;
            InitializeSwitchList();
        }
        
        public String[] totalList() { return TotalList; }
        
        public int getSize() {
            return DisplayedList.length;
        }

        public Object getElementAt(int index) {
            return DisplayedList[index];
        }
        
        public void insertElements(String[] s)
        {
            for (int i=0; i<s.length; i++)
            {
                SwitchList[Global.StringArrayFindIndex(TotalList, s[i])] = true;
            }
            GenerateDisplayedList();
        }

        private void InitializeSwitchList()
        {
            SwitchList = new boolean[TotalList.length];
            for (int i=0; i<SwitchList.length; i++) SwitchList[i] = false;
            if (DisplayedList != null)
            {
                for (int i=0; i<DisplayedList.length; i++)
                {
                    SwitchList[Global.StringArrayFindIndex(TotalList, DisplayedList[i])] = true;
                }
            }
        }
        
        private void GenerateDisplayedList()
        {
            ArrayList<String> res = new ArrayList<String> ();
            
            for (int i=0; i<SwitchList.length; i++)
            {
                if (SwitchList[i]) res.add(TotalList[i]);
            }
            
            DisplayedList = res.toArray(new String[res.size()]);
            this.fireContentsChanged(DisplayedList, 0, DisplayedList.length - 1);
        }
        
        public String[] ExtractElements(int[] in) {
            String[] res = new String[in.length];
            for (int i=0; i<in.length; i++) 
            {
                res[i] = DisplayedList[in[i]];
                SwitchList[Global.StringArrayFindIndex(TotalList, res[i])] = false;
            }
            GenerateDisplayedList();
            return res;
        }
    }
    
    private FixedListModel list1 = null;
    private ListModel list2 = new ListModel();
    private int ReturnValue = 0;
    
    /** Creates new form EditColumnListDialog */
    public EditColumnListDialog(java.awt.Frame parent, boolean modal, String[] totallist, String[] displayedlist) {
        super(parent, modal);
        list1 = new FixedListModel(totallist, Global.SubtractArray(totallist, displayedlist));
        list2.AddElements(displayedlist);
        initComponents();
    }
    
    public int returnValue() {return ReturnValue; }
   
    public int[] selectedColumnIndicies()
    {
        /*int[] result = new int[list1.totalList().length];
        
        String[] list2data = list2.returnList();
        
        for (int i=0; i<result.length; i++)
        {
            result[i] = Global.StringArrayFindIndex(list2data, list1.TotalList[i]);
        }*/
        
        int[] result = new int[list2.getSize()];
        
        
        for (int i=0; i<result.length; i++)
        {
            result[i] = Global.StringArrayFindIndex(list1.TotalList, list2.getAt(i));
        }
        
        return result;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane2 = new javax.swing.JScrollPane();
        jList2 = new javax.swing.JList();
        jButtonMoveUp = new javax.swing.JButton();
        jButtonMoveDown = new javax.swing.JButton();
        jButtonMoveRight = new javax.swing.JButton();
        jButtonMoveLeft = new javax.swing.JButton();
        jButtonMoveTop = new javax.swing.JButton();
        jButtonMoveBottom = new javax.swing.JButton();
        jList1Label = new javax.swing.JLabel();
        jList2Label = new javax.swing.JLabel();
        jButtonMoveLeftAll = new javax.swing.JButton();
        jButtonMoveRightAll = new javax.swing.JButton();
        jButtonOk = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Change Coordinates Column Displayed");
        setResizable(false);

        jList2.setModel(list2);
        jScrollPane2.setViewportView(jList2);

        jButtonMoveUp.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/1downarrow24.png"))); // NOI18N
        jButtonMoveUp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMoveUpActionPerformed(evt);
            }
        });

        jButtonMoveDown.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/1downarrow124.png"))); // NOI18N
        jButtonMoveDown.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMoveDownActionPerformed(evt);
            }
        });

        jButtonMoveRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/1rightarrow24.png"))); // NOI18N
        jButtonMoveRight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMoveRightActionPerformed(evt);
            }
        });

        jButtonMoveLeft.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/1leftarrow24.png"))); // NOI18N
        jButtonMoveLeft.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMoveLeftActionPerformed(evt);
            }
        });

        jButtonMoveTop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/2uparrow24.png"))); // NOI18N
        jButtonMoveTop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMoveTopActionPerformed(evt);
            }
        });

        jButtonMoveBottom.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/2dowarrow24.png"))); // NOI18N
        jButtonMoveBottom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMoveBottomActionPerformed(evt);
            }
        });

        jList1Label.setFont(new java.awt.Font("Tahoma", 1, 12));
        jList1Label.setText("Inactive Columns");

        jList2Label.setFont(new java.awt.Font("Tahoma", 1, 12));
        jList2Label.setText("Columns Displayed");

        jButtonMoveLeftAll.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/2leftarrow24.png"))); // NOI18N
        jButtonMoveLeftAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMoveLeftAllActionPerformed(evt);
            }
        });

        jButtonMoveRightAll.setIcon(new javax.swing.ImageIcon(getClass().getResource("/pdb_editor/icons/2rightarrow24.png"))); // NOI18N
        jButtonMoveRightAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonMoveRightAllActionPerformed(evt);
            }
        });

        jButtonOk.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonOk.setText("OK");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        jButtonCancel.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jList1.setModel(list1);
        jScrollPane3.setViewportView(jList1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jList1Label)
                        .addGap(128, 128, 128))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 224, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jButtonMoveLeftAll)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonMoveRightAll))
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                            .addComponent(jButtonMoveLeft)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(jButtonMoveRight))
                        .addGroup(layout.createSequentialGroup()
                            .addGap(32, 32, 32)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(jButtonMoveTop)
                                .addComponent(jButtonMoveUp)))
                        .addGroup(layout.createSequentialGroup()
                            .addGap(33, 33, 33)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(jButtonMoveBottom)
                                .addComponent(jButtonMoveDown)))))
                .addGap(8, 8, 8)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jList2Label, javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                        .addGroup(layout.createSequentialGroup()
                            .addComponent(jButtonOk, javax.swing.GroupLayout.PREFERRED_SIZE, 68, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                            .addComponent(jButtonCancel))
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 224, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jList1Label)
                            .addComponent(jList2Label))
                        .addGap(2, 2, 2)
                        .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 312, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(28, 28, 28)
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 312, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(55, 55, 55)
                        .addComponent(jButtonMoveTop)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonMoveUp)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jButtonMoveRight)
                            .addComponent(jButtonMoveLeft))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonMoveDown)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonMoveBottom)
                        .addGap(38, 38, 38)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jButtonMoveLeftAll)
                            .addComponent(jButtonMoveRightAll))
                        .addGap(24, 24, 24)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonCancel, javax.swing.GroupLayout.DEFAULT_SIZE, 32, Short.MAX_VALUE)
                    .addComponent(jButtonOk, javax.swing.GroupLayout.PREFERRED_SIZE, 33, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(11, 11, 11))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
      this.hide();
}//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonMoveTopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonMoveTopActionPerformed
        int[] list = jList2.getSelectedIndices();
        list2.MoveTop(list);
        jList2.clearSelection();
        jList2.addSelectionInterval(0, list.length - 1);
    }//GEN-LAST:event_jButtonMoveTopActionPerformed

    private void jButtonMoveBottomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonMoveBottomActionPerformed
        int[] list = jList2.getSelectedIndices();
        list2.MoveBottom(list);
        jList2.clearSelection();
        jList2.addSelectionInterval(list2.getSize() - list.length, list2.getSize()- 1);
    }//GEN-LAST:event_jButtonMoveBottomActionPerformed

    private void jButtonMoveDownActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonMoveDownActionPerformed
        int[] list = jList2.getSelectedIndices();
        list2.MoveDown(list);
        jList2.clearSelection();
        for (int i=0; i<list.length; i++)
        {
            if (list[i] != list2.getSize() - 1)
                jList2.addSelectionInterval(list[i]+ 1 , list[i] + 1);
        }
    }//GEN-LAST:event_jButtonMoveDownActionPerformed

    private void jButtonMoveUpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonMoveUpActionPerformed
        int[] list = jList2.getSelectedIndices();
        list2.MoveUp(list);
        jList2.clearSelection();
        for (int i=0; i<list.length; i++)
        {
            if (list[i] != 0) jList2.addSelectionInterval(list[i] - 1, list[i] - 1);
        }

    }//GEN-LAST:event_jButtonMoveUpActionPerformed

    private void jButtonMoveLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonMoveLeftActionPerformed
        if ((list2.getSize() != 0) && (jList2.getSelectedIndices().length != 0))
        {
            list1.insertElements(list2.ExtractElements(jList2.getSelectedIndices()));
            jList1.clearSelection();
            jList2.clearSelection();
        }
    }//GEN-LAST:event_jButtonMoveLeftActionPerformed

    private void jButtonMoveRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonMoveRightActionPerformed
        if ((list1.getSize() != 0) && (jList1.getSelectedIndices().length != 0))
        {
            list2.InsertElements(list1.ExtractElements(jList1.getSelectedIndices()));
            jList1.clearSelection();
            jList2.clearSelection();
        }
    }//GEN-LAST:event_jButtonMoveRightActionPerformed

    private void jButtonMoveLeftAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonMoveLeftAllActionPerformed
        if (list2.getSize() != 0)
        {
            jList2.addSelectionInterval(0, list2.getSize() - 1);
            jButtonMoveLeftActionPerformed(null);
        }
    }//GEN-LAST:event_jButtonMoveLeftAllActionPerformed

    private void jButtonMoveRightAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonMoveRightAllActionPerformed
        if (list1.getSize() != 0)
        {
            jList1.addSelectionInterval(0, list1.getSize() - 1);
            jButtonMoveRightActionPerformed(null);
        }
    }//GEN-LAST:event_jButtonMoveRightAllActionPerformed

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed
        ReturnValue = 1;
        this.hide();
    }//GEN-LAST:event_jButtonOkActionPerformed
    

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonMoveBottom;
    private javax.swing.JButton jButtonMoveDown;
    private javax.swing.JButton jButtonMoveLeft;
    private javax.swing.JButton jButtonMoveLeftAll;
    private javax.swing.JButton jButtonMoveRight;
    private javax.swing.JButton jButtonMoveRightAll;
    private javax.swing.JButton jButtonMoveTop;
    private javax.swing.JButton jButtonMoveUp;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JList jList1;
    private javax.swing.JLabel jList1Label;
    private javax.swing.JList jList2;
    private javax.swing.JLabel jList2Label;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    // End of variables declaration//GEN-END:variables
    
}