/*
 * FindReplaceDialog.java
 *
 * Created on February 27, 2008, 8:04 PM
 */

package pdb_editor.coordinate;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pdb_editor.EditorFrame;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.Atom;

/**
 *
 * @author  Owner
 */
public class SearchSelectDialog extends javax.swing.JDialog {
    
    static private char[] operators = {'|', '&', '^', '(', ')', '=', '!', '>', '<' };
    
    private EditorFrame Parent = null;
    
    private CommonKeyListener commonKeyListener = new CommonKeyListener();
    private DefaultComboBoxModel dataTypeCombo = new DefaultComboBoxModel (Atom.DataToolTip);
    private String[] CondTypes = new String[] { "OR", "AND", "XOR" };
    
    private JCheckBox[] selectColumnCheckboxes = null;
    private ArrayList<JComboBox> searchCondCombos = new ArrayList<JComboBox> ();
    private ArrayList<JComboBox> searchTypeCombos = new ArrayList<JComboBox> ();
    private ArrayList<JTextField> searchFields = new ArrayList<JTextField> ();
    
    private DataModel fCTData = new DataModel();
    private Integer[] foundCoordinateIndicies = new Integer[] {};
    public Integer[] getFoundCoordinateIndicies() { return foundCoordinateIndicies; }

    private Integer[] usedColumnsIndicies = null;
    
    private CoordinateTable cTable = null;
    private DataSet maindata = null;
    
    private boolean searchOnly = false;
    
    private int focusIndex = 0;
    
    /** Creates new form FindReplaceDialog */
    public SearchSelectDialog(java.awt.Frame parent, boolean modal, CoordinateTable TableIn) {
        super(parent, modal);
        try { Parent = (EditorFrame)parent; } catch (Exception e) {}
        initComponents();
        this.jTextFieldMain.getDocument().addDocumentListener(new inputListener());
        cTable = TableIn;
        maindata = cTable.getMainData();
        jTextFieldMain.addKeyListener(commonKeyListener);
        initSelectColumns();
        this.setFocusButtonVisibility(false);
    }
    
    public SearchSelectDialog(java.awt.Frame parent, boolean modal, String Name, CoordinateTable TableIn, boolean SearchOnly) {
        super(parent, modal);
        initComponents();
        this.jTextFieldMain.getDocument().addDocumentListener(new inputListener());
        cTable = TableIn;
        maindata = cTable.getMainData();
        jTextFieldMain.addKeyListener(commonKeyListener);
        initSelectColumns();
        searchOnly = SearchOnly;
        this.setTitle("Search and " + Name);
        for (int i=0; i<selectColumnCheckboxes.length; i++) selectColumnCheckboxes[i].setEnabled(false);
        this.jTabbedPane1.setTitleAt(1, "Coordinate " + Name);
        this.setFocusButtonVisibility(false);
    }
    
    class DataModel extends AbstractTableModel {
        
        private int[] columnWidth = null;
        
        public DataModel()
        {
            if (cTable != null)
            {
                columnWidth = cTable.getColumnWidths();
            }
        }
        
        public int getRowCount() {
            if (foundCoordinateIndicies != null)
                return foundCoordinateIndicies.length;
            else return 0;
        }

        public int getColumnCount() {
            if (usedColumnsIndicies != null)
                return usedColumnsIndicies.length;
            else return 0;
        }

        public String getColumnName(int col) 
	{
	    return Atom.DataList[usedColumnsIndicies[col]];
	}
        
        public Object getValueAt(int rowIndex, int columnIndex) {
            return maindata.Atoms().get(foundCoordinateIndicies[rowIndex]).TableData(usedColumnsIndicies[columnIndex]);
        }
        
     	public Class getColumnClass(int col) {
            return Atom.DataClass[usedColumnsIndicies[col]];
        }
        
        public void setValueAt(Object value, int row, int col) 
	{
		//maindata.Atoms().get(row).TableData(ColumnIndex[col], value);
		//fireTableCellUpdated(row, col);
		if (Parent != null) Parent.listenForUndoStart("Select dialog edit");
                int[] selrows = jTableFound.getSelectedRows();
		for (int i=0; i<selrows.length; i++)
		{
			
                    maindata.Atoms().get(foundCoordinateIndicies[selrows[i]]).TableData(usedColumnsIndicies[col], value);
                    fireTableCellUpdated(foundCoordinateIndicies[selrows[i]], col);
                    cTable.fireTableRowUpdated(foundCoordinateIndicies[selrows[i]], foundCoordinateIndicies[selrows[i]]);
		}
                if (Parent != null) Parent.listenForUndoStop();
	}
        
        public boolean isCellEditable(int row, int col) 
	{
              if (searchOnly) return false;
              else return true;
        }
                
        public void SetColumnWidth()
	{
		TableColumn column = null;
		for (int i=0; i<this.getColumnCount(); i++)
		{
			column = jTableFound.getColumnModel().getColumn(i);
			column.setPreferredWidth(columnWidth[usedColumnsIndicies[i]]);
		}
	}
    }
    
    class inputListener implements DocumentListener  {
            private boolean addnew = false;
            
            public void insertUpdate(DocumentEvent e) {
                if (!addnew) addSearchField();
                addnew = true;
            }

            public void removeUpdate(DocumentEvent e) {
            }

            public void changedUpdate(DocumentEvent e) {
            }
    }

    
    class CommonKeyListener implements KeyListener {
        public void keyTyped(KeyEvent e) {
        }
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
                SearchSelectDialog.this.dispose();
            if (e.getKeyCode() == KeyEvent.VK_ENTER)
                SearchSelectDialog.this.Run();
        }
        public void keyReleased(KeyEvent e) {
        }
    }
    
    private void setFocusButtonVisibility(boolean setting)
    {
        this.jButtonNext.setVisible(setting);
        this.jButtonPrev.setVisible(setting);
        this.jButtonGoto.setVisible(setting);
    }
    
    private void addSearchField()
    {
        int gridy = searchCondCombos.size() + 2;
        
        java.awt.GridBagConstraints gridBagConstraints;
        
        JComboBox ccb = new JComboBox();
        ccb.setModel(new DefaultComboBoxModel (CondTypes));
        ccb.setPreferredSize(new java.awt.Dimension(60, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 1, 5);
        jPanelSearch.add(ccb, gridBagConstraints);
        searchCondCombos.add(ccb);
        
        JComboBox tcb = new JComboBox();
        tcb.setModel(new DefaultComboBoxModel (Atom.DataToolTip));
        tcb.setPreferredSize(new java.awt.Dimension(135, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 1, 5);
        jPanelSearch.add(tcb, gridBagConstraints);
        searchTypeCombos.add(tcb);
        
        JTextField tf = new JTextField();
        tf.setPreferredSize(new java.awt.Dimension(270, 20));
        tf.getDocument().addDocumentListener(new inputListener());
        tf.addKeyListener(commonKeyListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 1, 0);
        jPanelSearch.add(tf, gridBagConstraints);
        searchFields.add(tf);
        
        pack();
    }
    
    private void initSelectColumns()
    {
        selectColumnCheckboxes = new JCheckBox[Atom.TOTAL_NUMBER_OF_INDEX];
        for (int i=0; i<selectColumnCheckboxes.length; i++)
        {
            selectColumnCheckboxes[i] = new JCheckBox(Atom.DataList[i], true);
            selectColumnCheckboxes[i].setToolTipText(Atom.DataToolTip[i]);
            this.jPanelSelectColumns.add(selectColumnCheckboxes[i]);
        }
    }
    
    private void checkSelectColumnCheckBoxes(boolean value)
    {
        for (int i=0; i<selectColumnCheckboxes.length; i++)
        {
            selectColumnCheckboxes[i].setSelected(value);
        }

    }
    
    private void selectSelectedColumns()
    {
        for (int i=0; i<selectColumnCheckboxes.length; i++)
        {
            if (selectColumnCheckboxes[i].isSelected())
                if (cTable.GetAtomTableIndexOfColumn(i) != - 1)
                cTable.addColumnSelectionInterval(cTable.GetAtomTableIndexOfColumn(i), cTable.GetAtomTableIndexOfColumn(i));
        }
    }
    
    private void selectSelectedRows(Integer[] indicies)
    {
        for (int i=0; i<indicies.length; i++)
        {
            cTable.addRowSelectionInterval(indicies[i], indicies[i]);
        }
    }
    
    private void Run()
    {
        if ((searchFields.size() != 0) | (!jTextFieldMain.getText().trim().equals("")))
            searchCoordinates();
    }
    
    private void searchCoordinates()
    {
        foundCoordinateIndicies = null;
        usedColumnsIndicies = null;
        
        ArrayList<String> texts = new ArrayList<String> ();
        ArrayList<Integer> types = new ArrayList<Integer> ();
        ArrayList<Integer> conds = new ArrayList<Integer> ();
        getSearchCriteria(types, conds, texts);
        interpretSearchCondition(types, conds, texts);
        updateCoordinateFoundTable();
        
        if (this.searchOnly) 
        {
            this.jTabbedPane1.setSelectedIndex(1);
        }
        else
        {
            highlightCoordinateTable();
        }
    }
    
    private void updateCoordinateFoundTable()
    {
        fCTData = new DataModel();
        this.jTableFound.setModel(fCTData);
        fCTData.SetColumnWidth();
        if ((!this.searchOnly) && (fCTData.getRowCount() > 0))
        {
            //cTable.scrollToCenterOnFirstSelectedCell();                
            this.focusIndex = 0;
            setFocusOnParent(focusIndex);
            this.setFocusButtonVisibility(true);
        }
    }
    
    private void setFocusOnParent(int selectedCFTrow)
    {
        cTable.scrollToCenterOnCell(foundCoordinateIndicies[selectedCFTrow], getFocusableParentColumnIndex());
    }
    
    private int getFocusableParentColumnIndex()
    {
        int first = cTable.GetColumnIndex(this.usedColumnsIndicies[0]);
        if (first != -1) return first;
        else return 0;
    }
    
    private void highlightCoordinateTable()
    {
        cTable.clearSelection();
        selectSelectedColumns();
        selectSelectedRows(foundCoordinateIndicies);       
    }
    
    private void interpretSearchCondition(ArrayList<Integer> cols, ArrayList<Integer> conds, ArrayList<String> texts)
    {
        LinkedList s = new LinkedList ();
        
        for (int i=0; i<texts.size(); i++)
            generateSearchCondition(s, conds.get(i), cols.get(i), texts.get(i));
        foundCoordinateIndicies = searchCoordinates(s);
    }
    
    private Integer[] searchCoordinates(LinkedList s)
    {
        ArrayList<Integer> matches = new ArrayList<Integer> ();
        
        DataSet dataset = maindata;
        try {
            for (int i=0; i<dataset.Atoms().size(); i++)
                if (searchCoordinate((Atom)dataset.Atoms().get(i), (LinkedList)s.clone()))
                    matches.add(i);
        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error searching", JOptionPane.ERROR_MESSAGE);
        }
        return matches.toArray(new Integer[matches.size()]);
    }
    
    private boolean searchCoordinate(Atom a, LinkedList s) throws Exception
    {
        try {
            getVariables(a,s);
            return evaluateExpression(s); 
        }
        catch (Exception e) 
        {
            throw e;
        }
    }
    
    private boolean evaluateExpression(LinkedList s) throws Exception
    {
        try {
        processParanthesis(s);
        evaluateComparisons(s);
        boolean value =  evaluateConditions(s);
        return value;
        }
        catch (Exception e) {throw e;}
    }
    
    private void evaluateComparisons(LinkedList s) throws Exception
    {
        Object compvalue = null;
        boolean readingc = false;
        LinkedList compf = new LinkedList();
        for (int i =0; i<s.size(); i++)
        {
            Object o = s.get(i);
            
            if (o.getClass().equals(Global.stringclass.getClass()))
            {
                 String str = (String)o;
                 String corrected = str.substring(1, str.length() - 1);
                 if (!readingc) compvalue = corrected;
                 else 
                 {
                     compf.addFirst(compvalue);
                     compf.addLast(corrected);
                     readingc = false;
                     boolean value = evaluateComparison(compf);
                     s.add(i+1, value);
                     compf = new LinkedList();
                 }
                 s.remove(i--);
                 continue;
            }
                
            if (o.getClass().equals(Global.doubleclass.getClass()))
            {
                 if (!readingc) compvalue = o;
                 else 
                 {
                     compf.addFirst(compvalue);
                     compf.addLast(o);
                     readingc = false;
                     boolean value = evaluateComparison(compf);
                     s.add(i+1, value);
                     compf = new LinkedList();
                 }
                 s.remove(i--);
                 continue;
            }
            
            if (o.getClass().equals(Global.integerclass.getClass()))
            {
                int opindex = (Integer)o;

                if ((opindex >= 0) && (opindex <= 2))
                {
                    if (readingc) throw new Exception("Syntax error");
                    continue;
                }
                
                /*switch (opindex)
                {
                    case 5 : compf.add(opindex); break;
                    case 6 : compf.add(opindex); break;
                    case 7 : compf.add(opindex); break;
                    case 8 : compf.add(opindex); break;
                }*/
                
                compf.add(opindex);
                readingc = true;
                s.remove(i--);
                continue;
            }
        }
    }
    
    private boolean evaluateComparison(LinkedList s) throws Exception
    {
        Object lead =  s.pollFirst();
        Object tail = s.pollLast();
        
        if (lead.getClass().equals(tail.getClass()))
        {
            boolean strings = false;
            if (lead.getClass().equals(Global.stringclass.getClass())) strings = true;
            for (int i=0; i<s.size(); i++) 
            {
                int opindex = (Integer)s.get(i);
                
                boolean value = false;
                if (strings)
                {
                    switch (opindex)
                    {
                        case 5 : value = (((String)lead).equals((String)tail)); break;
                        case 6 : value = (!((String)lead).equals((String)tail)); break;
                        case 7 : throw new Exception ("> cannot be used to compare strings");
                        case 8 : throw new Exception ("< cannot be used to compare strings");
                    }
                }
                else
                {
                   double d1 = (Double)lead;
                   double d2 = (Double)tail;
                   switch (opindex)
                    {
                        case 5 : value = (d1 == d2); break;
                        case 6 : value = (d1 != d2); break; 
                        case 7 : value = (d1 > d2); break;
                        case 8 : value = (d1 < d2); break;
                    }
                }
                if (value) return true;
            }
        }
        else
        {
            throw new Exception (lead.toString() + " cannot be compared with " + tail.toString());
        }
        return false;
    }
    
    private boolean evaluateConditions(LinkedList s)
    {
        boolean value = (Boolean)s.pollFirst();
        while (!s.isEmpty())
        {
            Object o = s.pollFirst();
            if (o.getClass().equals(Global.integerclass.getClass()))
            {
                int opindex = (Integer)o;
                boolean comp = (Boolean)s.pollFirst();
                switch (opindex)
                {
                   case 0 : value = (value | comp); break;
                   case 1 : value = (value & comp); break; 
                   case 2 : value = (value ^ comp); break;
                }
            }
        }
        
        return value;
    }
    
    
    private void processParanthesis(LinkedList Ins)
    {
        int parenthesisCount = 0;
        LinkedList innerFormula = new LinkedList();
        for (int i=0; i<Ins.size(); i++)
        {
            Object o = Ins.get(i);
        
            if (parenthesisCount > 0)
            {
                if (o.getClass() == Global.integerclass.getClass())
                {
                    int inst = (Integer)o;
                    switch (inst)
                    {
                        case 3 : parenthesisCount++; break;
                        case 4 : parenthesisCount--; break;
                    }
                }
                if (parenthesisCount == 0)
                {
                    Ins.remove(i);
                    try {
                        Ins.add(i, evaluateExpression(innerFormula));
                    }    catch (Exception e) {}
                    innerFormula = new LinkedList();
                }
                else
                {
                    innerFormula.addLast(o);
                    Ins.remove(i--);
                }
            }
            else
            {
                if (o.getClass() == Global.integerclass.getClass())
                {
                    int inst = (Integer)o;
                    if (inst == 3) 
                    {
                        parenthesisCount = 1; Ins.remove(i--); continue;
                    }
                }
                
            }
        }
    }
    
    private void getVariables(Atom a, LinkedList s) throws Exception
    {
        boolean error = false;
        String errornames = "";
        TreeSet<Integer> searchedColumnIndicies = null;
        if (usedColumnsIndicies == null) 
        {
            searchedColumnIndicies = new TreeSet<Integer> ();
            searchedColumnIndicies.add(Atom.ATOMNUMBER_INDEX);
            searchedColumnIndicies.add(Atom.ATOMNAME_INDEX);
            searchedColumnIndicies.add(Atom.CHAINID_INDEX);
            searchedColumnIndicies.add(Atom.RESIDUENUMBER_INDEX);
            searchedColumnIndicies.add(Atom.RESIDUETYPE_INDEX);
        }
        
        for (int i=0; i<s.size(); i++)
        {
            Object o = s.get(i);
            if (o.getClass().equals(Global.stringclass.getClass()))
            {
                int dataindex = Global.StringArrayFindIndex(Atom.DataList, (String)o);
                if (dataindex != - 1)
                {
                    s.remove(o);
                    s.add(i, formatVariables(a.TableData(dataindex)));
                    if (searchedColumnIndicies != null) searchedColumnIndicies.add(dataindex);
                }
                else
                {
                    String name = (String)o;
                    if ((name.charAt(0) != '\"') | (name.charAt(name.length() - 1) != '\"'))
                    {
                        error = true;
                        errornames += name + " ";
                    }
                }
            }
        }
        if (error)
        {
            Exception e =  new Exception("Unrecognized column name : " + errornames);
            throw e;
        }
        
        if (searchedColumnIndicies != null) usedColumnsIndicies = searchedColumnIndicies.toArray(new Integer[searchedColumnIndicies.size()]);
    }
    
    private Object formatVariables(Object input)
    {
        if (input.getClass().equals(Global.stringclass.getClass()))
        {
            String str = '\"' + (String)input + '\"';
            return str;
        }
        
        if (input.getClass().equals(Global.charclass.getClass()))
        {
            String str = '\"' + input.toString() + '\"';
            return str;
        }
        
        if (input.getClass().equals(Global.integerclass.getClass()))
        {
            int i = (Integer)input;
            return (double)i;
        }
        
        if (input.getClass().equals(Global.doubleclass.getClass()))
        {
            return (Double)input;
        }
        
        if (input.getClass().equals(Global.booleanclass.getClass()))
        {
            boolean b = (Boolean)input;
            if (b) return "\"TRUE\"";
            else return "\"FALSE\"";
        }
        
        return null;
    }
    
    private void generateSearchCondition(LinkedList s, int condcode, int maintype, String text)
    {
        if (condcode != -1) s.add(condcode);
        s.add(new Integer(3));
        s.add(Atom.DataList[maintype]);
        boolean readingnumber = false;
        boolean readingtext = false;
        boolean readingname = false;
        String currentread = "";
        for (int i=0; i<text.length(); i++)
        {
            char c = text.charAt(i);
            if (c == '"')
            {
                if (readingtext) {
                    currentread += c;
                    s.add(currentread);
                    readingtext = false;
                }
                else {
                    readingtext = true;
                    currentread = "\"";
                }
                continue;
            }
            
            if (readingtext) { currentread += c; continue; }
            
            if ((c == ' ') && (!readingtext))
            {
                if (readingnumber) {readingnumber = false; s.add(Double.parseDouble(currentread)); }
                if (readingname) { readingname = false; s.add(currentread); }
                continue;
            }
            
            int opindex = Global.CharArrayFindIndex(operators, c);
            if (opindex != -1) 
            {
                if (readingnumber) {readingnumber = false; s.add(Double.parseDouble(currentread)); }
                if (readingname) { readingname = false; s.add(currentread); }
                s.add(opindex); 
                if (opindex == 3) s.add(Atom.DataList[maintype]);
                continue;
            }
            
            if ((Character.isDigit(c))
                    || ((readingnumber) && (c == '.'))
                    || ((!readingnumber) && (c == '-')))
            {
                if (!readingnumber)
                {
                    readingnumber = true;
                    currentread = "";
                }
                currentread += c;
                continue;
            }
            
            if (!readingname) { readingname = true; currentread = ""; }
            currentread += c;
        }
        if (readingnumber) s.add(Double.parseDouble(currentread));
        
        s.add(new Integer(4));
    }
    
    private void getSearchCriteria(ArrayList<Integer> cols, ArrayList<Integer> conds, ArrayList<String> texts)
    {
        if (!this.jTextFieldMain.getText().trim().equals(""))
        {
            texts.add(jTextFieldMain.getText().trim());
            cols.add(this.jComboBoxMain.getSelectedIndex());
            conds.add(-1);
        }
        for (int i=0; i<searchCondCombos.size(); i++)
            if (!this.searchFields.get(i).getText().trim().equals(""))
            {
                texts.add(this.searchFields.get(i).getText().trim());
                cols.add(this.searchTypeCombos.get(i).getSelectedIndex());
                conds.add(this.searchCondCombos.get(i).getSelectedIndex());
            }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jDialog1 = new javax.swing.JDialog();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jButton2 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jPanelSearch = new javax.swing.JPanel();
        jComboBoxMain = new javax.swing.JComboBox();
        jTextFieldMain = new javax.swing.JTextField();
        jButtonSearch = new javax.swing.JButton();
        jButtonClose = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel2 = new javax.swing.JPanel();
        jPanelSelectColumns = new javax.swing.JPanel();
        jButtonAllColumns = new javax.swing.JButton();
        jButtonNoColumns = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTableFound = new javax.swing.JTable();
        jButtonHelp = new javax.swing.JButton();
        jButtonNext = new javax.swing.JButton();
        jButtonPrev = new javax.swing.JButton();
        jButtonGoto = new javax.swing.JButton();

        jDialog1.setTitle("Search and Select Help");
        jDialog1.setMinimumSize(new java.awt.Dimension(400, 600));

        jTextArea1.setColumns(20);
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(5);
        jTextArea1.setText("Search Select Conditions\n\nParanthesis are allowed (, )\n\n= : Equal\n! : Not equal\n> : Less than (Only applies to numbers)\n< : Greater than (Only applies to numbers)\n\n| : OR\n& : AND\n^ : XOR\n\n\"TRUE\" : checked for HeteroAtom\n\"FALSE\" : not checked for HeteroAtom\n\nExample,\nSelecting HeteroAtom\nand typing \n=\"TRUE\"\nwill search and select all atoms checked with hetero atom\n\nAll the names written residue names can be used for making conditions\nExample,\nEven if HeteroAtom is selected\nTyping\nResNum =255 | =257 & ChainID = \"A\"\nwill search and select all atom with residue number 255 and 257 in Chain A");
        jTextArea1.setWrapStyleWord(true);
        jScrollPane3.setViewportView(jTextArea1);

        jButton2.setText("Close");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jDialog1Layout = new javax.swing.GroupLayout(jDialog1.getContentPane());
        jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jDialog1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jScrollPane3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE)
                    .addComponent(jButton2))
                .addContainerGap())
        );
        jDialog1Layout.setVerticalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jDialog1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane3, javax.swing.GroupLayout.DEFAULT_SIZE, 252, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButton2)
                .addContainerGap())
        );

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Search and Select ...");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Search Parameters"));

        jScrollPane1.setBorder(null);
        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);

        jPanelSearch.setLayout(new java.awt.GridBagLayout());

        jComboBoxMain.setModel(dataTypeCombo);
        jComboBoxMain.setPreferredSize(new java.awt.Dimension(200, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 1, 5);
        jPanelSearch.add(jComboBoxMain, gridBagConstraints);

        jTextFieldMain.setPreferredSize(new java.awt.Dimension(270, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
        jPanelSearch.add(jTextFieldMain, gridBagConstraints);

        jScrollPane1.setViewportView(jPanelSearch);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 487, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 100, Short.MAX_VALUE)
        );

        jButtonSearch.setText("Search & Select");
        jButtonSearch.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSearchActionPerformed(evt);
            }
        });

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jPanelSelectColumns.setBorder(javax.swing.BorderFactory.createTitledBorder("Select Columns"));
        jPanelSelectColumns.setLayout(new java.awt.GridLayout(7, 1));

        jButtonAllColumns.setText("All Columns");
        jButtonAllColumns.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAllColumnsActionPerformed(evt);
            }
        });

        jButtonNoColumns.setText("No Columns");
        jButtonNoColumns.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNoColumnsActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanelSelectColumns, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 478, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                        .addComponent(jButtonAllColumns)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonNoColumns)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jPanelSelectColumns, javax.swing.GroupLayout.PREFERRED_SIZE, 226, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonNoColumns)
                    .addComponent(jButtonAllColumns))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab("Select Columns", null, jPanel2, "Choose columns to be selected when coordinates are found");

        jTableFound.setModel(fCTData);
        jTableFound.setAutoResizeMode(javax.swing.JTable.AUTO_RESIZE_OFF);
        jTableFound.setColumnSelectionAllowed(true);
        jScrollPane2.setViewportView(jTableFound);

        jTabbedPane1.addTab("Coordinates Found", jScrollPane2);

        jButtonHelp.setText("Help");
        jButtonHelp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonHelpActionPerformed(evt);
            }
        });

        jButtonNext.setText("Next");
        jButtonNext.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNextActionPerformed(evt);
            }
        });

        jButtonPrev.setText("Prev");
        jButtonPrev.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonPrevActionPerformed(evt);
            }
        });

        jButtonGoto.setText("Goto");
        jButtonGoto.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGotoActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jButtonHelp)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonNext)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonPrev)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonGoto)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 91, Short.MAX_VALUE)
                        .addComponent(jButtonSearch)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButtonClose)
                        .addGap(4, 4, 4))
                    .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 503, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(11, 11, 11)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 291, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonSearch)
                    .addComponent(jButtonClose)
                    .addComponent(jButtonHelp)
                    .addComponent(jButtonNext)
                    .addComponent(jButtonPrev)
                    .addComponent(jButtonGoto))
                .addContainerGap())
        );

        jTabbedPane1.getAccessibleContext().setAccessibleName("Select Columns");

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        this.dispose();
}//GEN-LAST:event_jButtonCloseActionPerformed

    private void jButtonAllColumnsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAllColumnsActionPerformed
        checkSelectColumnCheckBoxes(true);
}//GEN-LAST:event_jButtonAllColumnsActionPerformed

    private void jButtonNoColumnsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNoColumnsActionPerformed
       checkSelectColumnCheckBoxes(false);
    }//GEN-LAST:event_jButtonNoColumnsActionPerformed

    private void jButtonSearchActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSearchActionPerformed
       Run();
    }//GEN-LAST:event_jButtonSearchActionPerformed

    private void jButtonHelpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonHelpActionPerformed
        this.jDialog1.show();
}//GEN-LAST:event_jButtonHelpActionPerformed

    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        this.jDialog1.dispose();
    }//GEN-LAST:event_formWindowClosed

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        
    }//GEN-LAST:event_formWindowClosing

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        this.jDialog1.hide();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButtonNextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNextActionPerformed
        if (focusIndex < this.foundCoordinateIndicies.length - 1) this.focusIndex++;
        this.setFocusOnParent(focusIndex);
    }//GEN-LAST:event_jButtonNextActionPerformed

    private void jButtonPrevActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPrevActionPerformed
        if (focusIndex > 0) focusIndex--;
        this.setFocusOnParent(focusIndex);
    }//GEN-LAST:event_jButtonPrevActionPerformed

    private void jButtonGotoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonGotoActionPerformed
        if (this.jTableFound.getSelectedRow() != -1)
        {
            focusIndex = jTableFound.getSelectedRow();
            this.setFocusOnParent(focusIndex);
        }
    }//GEN-LAST:event_jButtonGotoActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButtonAllColumns;
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonGoto;
    private javax.swing.JButton jButtonHelp;
    private javax.swing.JButton jButtonNext;
    private javax.swing.JButton jButtonNoColumns;
    private javax.swing.JButton jButtonPrev;
    private javax.swing.JButton jButtonSearch;
    private javax.swing.JComboBox jComboBoxMain;
    private javax.swing.JDialog jDialog1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanelSearch;
    private javax.swing.JPanel jPanelSelectColumns;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTable jTableFound;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextField jTextFieldMain;
    // End of variables declaration//GEN-END:variables
    
}
