/*
 * ExtractSequenceDialog.java
 *
 * Created on March 20, 2008, 9:19 PM
 */

package pdb_editor.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import pdb_editor.coordinate.CoordinateTable;
import pdb_reader.DataSet;
import pdb_reader.Global;
import pdb_reader.data.Atom;
import pdb_reader.data.Sequence;

/**
 *
 * @author  Owner
 */
public class ExtractSequenceDialog extends javax.swing.JDialog {
    
    private CoordinateTable maintable = null;
    private DataSet maindata = null;
    private Sequence sequence = null;
    
    private boolean OPTskipline = false;
    private int OPTskiplinenumber = 50;
    private boolean OPTskipspace = false;
    private int OPTskipspacenumber = 5;
    private boolean OPTfillskip = false;
    private String OPTfillskipcode = "---";
    private boolean OPTdisplayresnum = false;
    private boolean OPTnotconvertsingle = false;
    private boolean OPTrangelimit = false;
    private int OPTrangestart = 0;
    private int OPTrangeend = 0;
    
    public ExtractSequenceDialog(java.awt.Frame parent, boolean modal, CoordinateTable ctable) {
        super(parent, modal);
        initComponents();
        
        maintable = ctable;
        maindata = maintable.getMainData();
        sequence = new Sequence(maindata.Atoms());
        
        updateDisplay();
    }
    
    private void updateDisplay()
    {
        getOptions();
        this.jTextArea.setText(GetAllSequence());
    }
    
    private void getOptions()
    {
        try { this.OPTskiplinenumber = Integer.parseInt(this.jTextFieldSkipLine.getText()); }
        catch (Exception e) { this.jCheckBoxSkipLine.setSelected(false); }
        
        try { this.OPTskipspacenumber = Integer.parseInt(this.jTextFieldSkipSpace.getText()); }
        catch (Exception e) { this.jCheckBoxSkipSpace.setSelected(false); }
        
        try { this.OPTrangestart = Integer.parseInt(this.jTextFieldRangeStart.getText()); }
        catch (Exception e) { this.jCheckBoxRange.setSelected(false); }
       
        try { this.OPTrangeend = Integer.parseInt(this.jTextFieldRangeEnd.getText()); }
        catch (Exception e) { this.jCheckBoxRange.setSelected(false); }
        
        if (OPTrangestart > OPTrangeend)
        {
            int i = OPTrangeend;
            OPTrangeend = OPTrangestart;
            OPTrangestart = i;
        }
        
        
        this.OPTfillskipcode = this.jTextFieldFillCode.getText();
        if (OPTfillskipcode.length() > 3) OPTfillskipcode = OPTfillskipcode.substring(0,3);
        
        this.OPTdisplayresnum = this.jCheckBoxShowResidueNumber.isSelected();
        this.OPTfillskip = this.jCheckBoxFillResidue.isSelected();
        this.OPTnotconvertsingle = this.jCheckBoxProteinThreeLetterCode.isSelected();
        this.OPTskipline = this.jCheckBoxSkipLine.isSelected();
        this.OPTskipspace = this.jCheckBoxSkipSpace.isSelected();
        this.OPTrangelimit = this.jCheckBoxRange.isSelected();
        
    }
    
    private String GetAllSequence()
    {
        StringBuilder sb = new StringBuilder();
        
        //private TreeMap<Character, TreeMap<Integer, TreeMap<String, ArrayList<Atom>>>>
        
        TreeMap<Character, TreeMap<Integer, TreeMap<String, ArrayList<Atom>>>> d = sequence.data();
        
        Iterator<Character> l1c = d.keySet().iterator();
        while (l1c.hasNext()) {sb.append(GetChainSequence(l1c.next())); sb.append('\n');}
        
       return sb.toString();
    }
    
    private String GetChainSequence(char index)
    {
       StringBuilder sb = new StringBuilder();
       
       TreeMap<Integer, TreeMap<String, ArrayList<Atom>>> d = sequence.data().get(index);
       
       int writecount = 0;
       int resnum = d.firstKey();
       int endres = d.lastKey();
       
       if (this.OPTrangelimit) 
       { 
           resnum = this.OPTrangestart; 
           if (this.OPTrangeend < endres) endres = this.OPTrangeend;
       }
       
       boolean writenum = true;
       int maxnumberlength = (int) Math.log10(d.lastKey()) + 1;
       
       sb.append(">Chain_"+index+'\n');
       
       for (; resnum <= endres; resnum++)
       {
           boolean wrote = false;
           
           if (this.OPTdisplayresnum)
               if ((writenum) && ((d.containsKey(resnum)) || (this.OPTfillskip))) { sb.append(Global.ExtendStringLength(""+resnum, maxnumberlength, ' ') + " - "); writenum = false; }
           
           if (d.containsKey(resnum)) { sb.append(getResidue(d.get(resnum))); wrote = true; }
           else if (this.OPTfillskip) { sb.append(getResidue(this.OPTfillskipcode)); wrote = true; }
           if (wrote)
           {
           writecount++;
           
           if (this.OPTskipspace)
               if ((writecount % this.OPTskipspacenumber) == 0)
                   sb.append(' ');
           if (this.OPTskipline)
               if ((writecount % this.OPTskiplinenumber) == 0)
                { sb.append('\n'); writenum = true; }
           }
       }
       sb.append('\n');
       
       if (writecount > 0) return sb.toString();
       else return "";
    }
    
    private String getResidue(TreeMap<String, ArrayList<Atom>> d)
    {
        return getResidue(d.firstKey());
    }
    
    private String getResidue(String s)
    {
        if (this.OPTnotconvertsingle)
        {
            if (s.length() == 3) return s + ' ';
            else return Global.ExtendStringLength(s, 4, ' ');
        }
        
        if (s.equals(this.OPTfillskipcode)) return "" + this.OPTfillskipcode.charAt(0);
        if (DataSet.ResidueSingleLetterCodeDatabase.containsKey(s)) return ""+DataSet.ResidueSingleLetterCodeDatabase.get(s);
        else return "*";
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();
        jCheckBoxFillResidue = new javax.swing.JCheckBox();
        jCheckBoxSkipSpace = new javax.swing.JCheckBox();
        jCheckBoxSkipLine = new javax.swing.JCheckBox();
        jCheckBoxShowResidueNumber = new javax.swing.JCheckBox();
        jTextFieldSkipSpace = new javax.swing.JTextField();
        jTextFieldSkipLine = new javax.swing.JTextField();
        jCheckBoxProteinThreeLetterCode = new javax.swing.JCheckBox();
        jTextFieldFillCode = new javax.swing.JTextField();
        jCheckBoxRange = new javax.swing.JCheckBox();
        jTextFieldRangeStart = new javax.swing.JTextField();
        jTextFieldRangeEnd = new javax.swing.JTextField();
        jButtonClose = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Extract Sequence Result");

        jTextArea.setColumns(20);
        jTextArea.setFont(new java.awt.Font("Courier New", 0, 11));
        jTextArea.setRows(5);
        jScrollPane1.setViewportView(jTextArea);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Options"));

        jCheckBoxFillResidue.setText("Fill residue number skips with");
        jCheckBoxFillResidue.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSkipLineActionPerformed(evt);
            }
        });

        jCheckBoxSkipSpace.setText("Skip space on every");
        jCheckBoxSkipSpace.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSkipLineActionPerformed(evt);
            }
        });

        jCheckBoxSkipLine.setSelected(true);
        jCheckBoxSkipLine.setText("Skip line on every");
        jCheckBoxSkipLine.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSkipLineActionPerformed(evt);
            }
        });

        jCheckBoxShowResidueNumber.setText("Display residue number for first residue on each line");
        jCheckBoxShowResidueNumber.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSkipLineActionPerformed(evt);
            }
        });

        jTextFieldSkipSpace.setText("5");

        jTextFieldSkipLine.setText("50");

        jCheckBoxProteinThreeLetterCode.setText("Do not convert PDB three letter codes into single letter codes");
        jCheckBoxProteinThreeLetterCode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSkipLineActionPerformed(evt);
            }
        });

        jTextFieldFillCode.setText("---");

        jCheckBoxRange.setText("Extract only from residue number ranges ");
        jCheckBoxRange.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSkipLineActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jCheckBoxFillResidue)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldFillCode, javax.swing.GroupLayout.PREFERRED_SIZE, 26, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jCheckBoxSkipSpace)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldSkipSpace, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jCheckBoxProteinThreeLetterCode)
                    .addComponent(jCheckBoxShowResidueNumber)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jCheckBoxSkipLine)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldSkipLine, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jCheckBoxRange)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldRangeStart, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextFieldRangeEnd, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(64, 64, 64))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldSkipLine, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCheckBoxSkipLine))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldSkipSpace, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCheckBoxSkipSpace))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxFillResidue, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldFillCode, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxShowResidueNumber)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jCheckBoxProteinThreeLetterCode)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBoxRange)
                    .addComponent(jTextFieldRangeStart, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jTextFieldRangeEnd, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 433, Short.MAX_VALUE)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 433, Short.MAX_VALUE)
                    .addComponent(jButtonClose, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 299, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 181, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonClose)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        this.dispose();
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void jCheckBoxSkipLineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxSkipLineActionPerformed
        updateDisplay();
    }//GEN-LAST:event_jCheckBoxSkipLineActionPerformed
    
     
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonClose;
    private javax.swing.JCheckBox jCheckBoxFillResidue;
    private javax.swing.JCheckBox jCheckBoxProteinThreeLetterCode;
    private javax.swing.JCheckBox jCheckBoxRange;
    private javax.swing.JCheckBox jCheckBoxShowResidueNumber;
    private javax.swing.JCheckBox jCheckBoxSkipLine;
    private javax.swing.JCheckBox jCheckBoxSkipSpace;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea;
    private javax.swing.JTextField jTextFieldFillCode;
    private javax.swing.JTextField jTextFieldRangeEnd;
    private javax.swing.JTextField jTextFieldRangeStart;
    private javax.swing.JTextField jTextFieldSkipLine;
    private javax.swing.JTextField jTextFieldSkipSpace;
    // End of variables declaration//GEN-END:variables
    
}
