package pdb_reader.data;
import javax.swing.event.EventListenerList;
import pdb_reader.DataSet;
import pdb_reader.data.spacegroup.SpaceGroup;
import pdb_reader.Global;

public class Atom implements Comparable {
	static public Atom atomclass = new Atom();
	
        static public final int HETROATOM_INDEX = 0;
        static public final int ATOMNUMBER_INDEX = 1;
        static public final int ATOMNAME_INDEX = 2;
        static public final int ELEMENT_INDEX = 3;
        static public final int CHARGE_INDEX = 4;
        static public final int ALTERNATELOCATION_INDEX = 5;
        static public final int RESIDUETYPE_INDEX = 6;
        static public final int CHAINID_INDEX = 7;
        static public final int RESIDUENUMBER_INDEX = 8;
        static public final int INSERTIONCODE_INDEX = 9;
        static public final int X_INDEX = 10;
        static public final int Y_INDEX = 11;
        static public final int Z_INDEX = 12;
        static public final int[] ORTHOGONALCOORDINATE_INDICES = new int[] {X_INDEX, Y_INDEX, Z_INDEX};
        static public final int B_INDEX = 13;
        static public final int OCCUPANCY_INDEX = 14;
        static public final int U11_INDEX = 15;
        static public final int U22_INDEX = 16;
        static public final int U33_INDEX = 17;
        static public final int U12_INDEX = 18;
        static public final int U13_INDEX = 19;
        static public final int U23_INDEX = 20;
        static public final int[] ANISOTROPICU_INDICES = new int[] {U11_INDEX, U22_INDEX, U33_INDEX, U12_INDEX, U13_INDEX, U23_INDEX};
        static public final int SIGMAX_INDEX = 21;
        static public final int SIGMAY_INDEX = 22;
        static public final int SIGMAZ_INDEX = 23;
        static public final int SIGMAB_INDEX = 24;
        static public final int[] SIGMAORTHOGONALCOORDINATE_INDICES = new int[] {SIGMAX_INDEX, SIGMAY_INDEX, SIGMAZ_INDEX};
        static public final int SIGMAOCCUPANCY_INDEX = 25;
        static public final int SIGMAU11_INDEX = 26;
        static public final int SIGMAU22_INDEX = 27;
        static public final int SIGMAU33_INDEX = 28;
        static public final int SIGMAU12_INDEX = 29;
        static public final int SIGMAU13_INDEX = 30;
        static public final int SIGMAU23_INDEX = 31;
        static public final int[] SIGMAANISOTROPICU_INDICES = new int[] {SIGMAU11_INDEX, SIGMAU22_INDEX, SIGMAU33_INDEX, SIGMAU12_INDEX, SIGMAU13_INDEX, SIGMAU23_INDEX};
        static public final int FRACX_INDEX = 32;
        static public final int FRACY_INDEX = 33;
        static public final int FRACZ_INDEX = 34;
        static public final int[] FRACTIONALCOORDINATE_INDICES = new int[] {FRACX_INDEX, FRACY_INDEX, FRACZ_INDEX};
        
        static public final int TOTAL_NUMBER_OF_INDEX = 35;
        
	// Static variables and functions
	//    Default column header values
	static public String[] DataList = new String[] {
		"HetroAtom",
		"Number",
		"Name",
		"Element",
		"Charge",
		"AltLoc",
		"Residue",
		"ChainID",
		"ResNum",
		"InsCode",
		"X",
		"Y",
		"Z",
		"B",
		"Occp",
		"U11",
		"U22",
		"U33",
		"U12",
		"U13",
		"U23",
		"SigX",
		"SigY",
		"SigZ",
		"SigB",
		"SigOccp",
		"SigU11",
		"SigU22",
		"SigU33",
		"SigU12",
		"SigU13",
		"SigU23",
                "x",
                "y",
                "z"
	};
	static public String[] DataToolTip = new String[] {
		"HetroAtom",
		"Atom Number",
		"Atom Name",
		"Element",
		"Charge",
		"Alternate Location",
		"Residue Type",
		"Chain ID",
		"Residue Number",
		"Insertion Code",
		"X",
		"Y",
		"Z",
		"B",
		"Occupancy",
		"U(1,1)",
		"U(2,2)",
		"U(3,3)",
		"U(1,2)",
		"U(1,3)",
		"U(2,3)",
		"Sigma X",
		"Sigma Y",
		"Sigma Z",
		"Sigma B",
		"Sigma Occupancy",
		"Sigma U(1,1)",
		"Sigma U(2,2)",
		"Sigma U(3,3)",
		"Sigma U(1,2)",
		"Sigma U(1,3)",
		"Sigma U(2,3)",
                "Fractional x",
                "Fractional y",
                "Fractional z"
	};
	static public Class[] DataClass = new Class[] {
		Global.booleanclass.getClass(),
		Global.integerclass.getClass(),
		Global.stringclass.getClass(),
		Global.stringclass.getClass(),
		Global.stringclass.getClass(),
		Global.charclass.getClass(),
		Global.stringclass.getClass(),
		Global.charclass.getClass(),
		Global.integerclass.getClass(),
		Global.charclass.getClass(),
		Global.doubleclass.getClass(),
		Global.doubleclass.getClass(),
		Global.doubleclass.getClass(),
		Global.doubleclass.getClass(),
		Global.doubleclass.getClass(),
		Global.integerclass.getClass(),
		Global.integerclass.getClass(),
		Global.integerclass.getClass(),
		Global.integerclass.getClass(),
		Global.integerclass.getClass(),
		Global.integerclass.getClass(),
		Global.doubleclass.getClass(),
		Global.doubleclass.getClass(),
		Global.doubleclass.getClass(),
		Global.doubleclass.getClass(),
		Global.doubleclass.getClass(),
		Global.integerclass.getClass(),
		Global.integerclass.getClass(),
		Global.integerclass.getClass(),
		Global.integerclass.getClass(),
		Global.integerclass.getClass(),
		Global.integerclass.getClass(),
		Global.doubleclass.getClass(),
		Global.doubleclass.getClass(),
		Global.doubleclass.getClass()
	};
	
	//     Default column sizes
	static public int[] DataTextSize = new int[]
	                                               {
		35,
		45,
		45,
		25,
		25,
		20,
		35,
		20,
		40,
		20,
		65,
		65,
		65,
		45,
		45,
		40,
		40,
		40,
		40,
		40,
		40,
		65,
		65,
		65,
		45,
		45,
		40,
		40,
		40,
		40,
		40,
		40,
		65,
		65,
		65
		
		                                           };
	
                static public int compareAscending(Atom o1, Atom o2, int dataIndex)
                {
                    Object a1 = o1.TableData(dataIndex);
                    Object a2 = o2.TableData(dataIndex);
                    if (a2 == null) { if (a1 == null) return 0; else return 1; }
                    if (a1 == null) return -1;
                    
                    if (dataIndex == Atom.CHAINID_INDEX) return compareChainID((Character)a1, (Character)a2);
                    if (dataIndex == Atom.ATOMNAME_INDEX) return compareAtomName(o1, o2);
                    
                    return Global.compareObjects(a1, a2);
                }
                
                static public int compareChainID(char a1, char a2)
                {
                    if (a1 == ' ') return (a2 == ' ') ? 0 : 1;
                    if (a2 == ' ') return -1;
                    return Global.compareObjects(a1, a2);
                }
                
                
                static private String[] PROTEIN_BASIC_ATOMS = {"N", "H", "CA", "HA", "HA1", "HA2", "C", "O"};
                static private char[] GREEK_LETTER_ORDER = {'B', 'G', 'D', 'E', 'Z', 'H', 'T', 'I'};
                static private char[] ATOM_ORDER = {'N', 'C', 'O', 'S', 'H'};
                
                static public int compareAtomName(Atom a1, Atom a2)
                {
                    String c1 = a1.AtomType();
                    String c2 = a2.AtomType();
                    
                    int i1 = Global.StringArrayFindIndex(PROTEIN_BASIC_ATOMS, c1);
                    int i2 = Global.StringArrayFindIndex(PROTEIN_BASIC_ATOMS, c2);
                    if (i1 == -1) i1 = PROTEIN_BASIC_ATOMS.length;
                    if (i2 == -1) i2 = PROTEIN_BASIC_ATOMS.length;
                    int v1 = i1 - i2;
                    if (v1 != 0) return v1;
                    
                    if ((c1.length() < 2) && (c2.length() < 2)) return Global.compareObjects(c1, c2);
                    if ((c1.length() < 2)) return -1;
                    if ((c2.length() < 2)) return 1;
                    
                    if (Character.isDigit(c1.charAt(0))) c1 = c1.substring(1) + c1.charAt(0);
                    if (Character.isDigit(c2.charAt(0))) c2 = c2.substring(1) + c2.charAt(0);
                    int in1 = Global.CharArrayFindIndex(GREEK_LETTER_ORDER, c1.charAt(1));
                    int in2 = Global.CharArrayFindIndex(GREEK_LETTER_ORDER, c2.charAt(1));
                    if (in1 == -1) in1 = GREEK_LETTER_ORDER.length;
                    if (in2 == -1) in2 = GREEK_LETTER_ORDER.length;
                    int va1 = in1 - in2;
                    if (va1 != 0) return va1;
                    
                    if ((c1.length() > 2) && (c2.length() < 3)) return 1;
                    if ((c1.length() < 3) && (c2.length() > 2)) return -1;
                    
                    if ((c1.length() > 2) && (c2.length() > 2))
                    {
                        int value = c1.charAt(2) - c2.charAt(2);
                        if (value != 0) return value;
                    }
                    
                    int ind1 = Global.CharArrayFindIndex(ATOM_ORDER, c1.charAt(0));
                    int ind2 = Global.CharArrayFindIndex(ATOM_ORDER, c2.charAt(0));
                    if (ind1 == -1) ind1 = ATOM_ORDER.length;
                    if (ind2 == -1) ind2 = ATOM_ORDER.length;
                    int val1 = ind1 - ind2;
                    if (val1 != 0) return val1;
                    
                    
                    
                    return Global.compareObjects(c1, c2);
                }
                
                
	// Member data
	protected boolean hetroAtom = false;
	protected int atomNumber = 0;
	protected String atomType = null;
	protected char alternateLocation = ' ';
	protected String residueType = null;
	protected char chainID = ' ';
	protected int residueNumber = 0;
	protected char insertionCode = ' ';
	protected Coordinate XYZ = null;
        protected Coordinate xyz = null;
	protected Coordinate sigmaXYZ = null;
	protected double B = 0;
	protected double sigmaB = 0;
	protected double occupancy = 1;
	protected double sigmaOccupancy = 0;
	protected String element = null;
	protected String charge = null;
	protected int[] anisotropicB = null;
	protected int[] sigmaU = null;
	protected SpaceGroup spaceGroup = null;
        protected EventListenerList dataChangeListener = new EventListenerList();
        
        protected boolean[] ReadingErrorRecords = new boolean[Atom.TOTAL_NUMBER_OF_INDEX + 1];
        public boolean[] getReadingErrorRecords() { return ReadingErrorRecords; }
        
	// Constructors
	public Atom() {}
        public Atom(SpaceGroup sg) 
        {
            spaceGroup = sg;
            atomType = "";
            residueType = "";
            this.OrthogonalCoordinate(new Coordinate());
        }
	public Atom(int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate xyz, double B_Factor, String Element)
	{
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.OrthogonalCoordinate(xyz);
		this.B_Factor(B_Factor);
		this.Element(Element);
	}
	public Atom(int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, String Element)
	{
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.OrthogonalCoordinate(OrthogonalCoordinate);
		this.B_Factor(B_Factor);
		this.Element(Element);

		this.Occupancy(Occupancy);
	}
	public Atom(int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, int[] AnisotropicB, String Element)
	{
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.OrthogonalCoordinate(OrthogonalCoordinate);
		this.B_Factor(B_Factor);
		this.Element(Element);
		this.Occupancy(Occupancy);

		this.AnisotropicB(AnisotropicB);
	}
	public Atom(boolean HetroAtom, int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate xyz, double B_Factor, String Element)
	{
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.OrthogonalCoordinate(xyz);
		this.B_Factor(B_Factor);
		this.Element(Element);

		this.HetroAtom(HetroAtom);
	}
	public Atom(boolean HetroAtom, int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, String Element)
	{
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.OrthogonalCoordinate(OrthogonalCoordinate);
		this.B_Factor(B_Factor);
		this.Element(Element);
		this.HetroAtom(HetroAtom);

		this.Occupancy(Occupancy);
	}
	public Atom(boolean HetroAtom, int AtomNumber, String AtomType, String ResidueType, char ChainID, int ResidueNumber, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, int[] AnisotropicB, String Element)
	{
		this.HetroAtom(HetroAtom);
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.OrthogonalCoordinate(OrthogonalCoordinate);
		this.B_Factor(B_Factor);
		this.Occupancy(Occupancy);
		this.Element(Element);
		this.AnisotropicB(AnisotropicB);
	}	
	public Atom(int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate xyz, double B_Factor, String Element)
	{
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.AlternateLocation(AlternateLocation);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.InsertionCode(InsertionCode);
		this.OrthogonalCoordinate(xyz);
		this.B_Factor(B_Factor);
		this.Element(Element);
	}
	public Atom(int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, String Element)
	{
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.AlternateLocation(AlternateLocation);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.InsertionCode(InsertionCode);
		this.OrthogonalCoordinate(OrthogonalCoordinate);
		this.B_Factor(B_Factor);
		this.Occupancy(Occupancy);
		this.Element(Element);
	}
	public Atom(int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, int[] AnisotropicB, String Element)
	{
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.AlternateLocation(AlternateLocation);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.InsertionCode(InsertionCode);
		this.OrthogonalCoordinate(OrthogonalCoordinate);
		this.B_Factor(B_Factor);
		this.Occupancy(Occupancy);
		this.Element(Element);
		this.AnisotropicB(AnisotropicB);
	}
	public Atom(boolean HetroAtom, int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate xyz, double B_Factor, String Element, String Charge)
	{
		this.HetroAtom(HetroAtom);
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.AlternateLocation(AlternateLocation);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.InsertionCode(InsertionCode);
		this.B_Factor(B_Factor);
		this.Element(Element);
		this.Charge(Charge);
	}
	public Atom(boolean HetroAtom, int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, String Element, String Charge)
	{
		this.HetroAtom(HetroAtom);
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.AlternateLocation(AlternateLocation);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.InsertionCode(InsertionCode);
		this.OrthogonalCoordinate(OrthogonalCoordinate);
		this.B_Factor(B_Factor);
		this.Occupancy(Occupancy);
		this.Element(Element);
		this.Charge(Charge);		
	}
	public Atom(boolean HetroAtom, int AtomNumber, String AtomType, char AlternateLocation, String ResidueType, char ChainID, int ResidueNumber, char InsertionCode, Coordinate OrthogonalCoordinate, double B_Factor, double Occupancy, int[] AnisotropicB, String Element, String Charge)
	{
		this.HetroAtom(HetroAtom);
		this.AtomNumber(AtomNumber);
		this.AtomType(AtomType);
		this.AlternateLocation(AlternateLocation);
		this.ResidueType(ResidueType);
		this.ChainID(ChainID);
		this.ResidueNumber(ResidueNumber);
		this.InsertionCode(InsertionCode);
		this.OrthogonalCoordinate(OrthogonalCoordinate);
		this.B_Factor(B_Factor);
		this.Occupancy(Occupancy);
		this.Element(Element);
		this.AnisotropicB(AnisotropicB);
		this.Charge(Charge);
	}
	
	
	// Interface functions
	//    Output functions
	public boolean HetroAtom() { return hetroAtom; }
	public int AtomNumber() { return atomNumber; }
	public String AtomType() { return atomType; }
	public char AlternateLocation() { return alternateLocation; }
	public String ResidueType() { return residueType; }
	public char ChainID() { return chainID; }
	public int ResidueNumber() { return residueNumber; }
	public char InsertionCode() { return insertionCode; }
	public Coordinate OrthogonalCoordinate() { return XYZ; }
	public Double X() { if (OrthogonalCoordinate() != null) return XYZ.x(); return null; }
	public Double Y() { if (OrthogonalCoordinate() != null) return XYZ.y(); return null; }
	public Double Z() { if (OrthogonalCoordinate() != null) return XYZ.z(); return null; }
        public Coordinate FractionalCoordinate() { return xyz; }
	public Double x() { if (FractionalCoordinate() != null) return xyz.x(); return null; }
	public Double y() { if (FractionalCoordinate() != null) return xyz.y(); return null; }
	public Double z() { if (FractionalCoordinate() != null) return xyz.z(); return null; }
        public Coordinate SigmaCoordinate() { return sigmaXYZ; }
	public Double SigmaX() { if (SigmaCoordinate() != null) return sigmaXYZ.x(); return null; }
	public Double SigmaY() { if (SigmaCoordinate() != null) return sigmaXYZ.y(); return null; }
	public Double SigmaZ() { if (SigmaCoordinate() != null) return sigmaXYZ.z(); return null; }
	public double B_Factor() { return B; }
	public double SigmaB_Factor() { return sigmaB; }
	public double Occupancy() { return occupancy; }
	public double SigmaOccupancy() { return sigmaOccupancy; }
	public String Element() { return element; }
	public String Charge() { return charge; }
	public int[] AnistropicB() { return anisotropicB; }
	public Integer U11() { if (AnistropicB() != null) return AnistropicB()[0]; return null; }
	public Integer U22() { if (AnistropicB() != null) return AnistropicB()[1]; return null; }
	public Integer U33() { if (AnistropicB() != null) return AnistropicB()[2]; return null; }
	public Integer U12() { if (AnistropicB() != null) return AnistropicB()[3]; return null; }
	public Integer U13() { if (AnistropicB() != null) return AnistropicB()[4]; return null; }
	public Integer U23() { if (AnistropicB() != null) return AnistropicB()[5]; return null; }
	public int[] SigmaU() { return sigmaU; }
	public Integer SigmaU11() { if (SigmaU() != null) return SigmaU()[0]; return null; }
	public Integer SigmaU22() { if (SigmaU() != null) return SigmaU()[1]; return null; }
	public Integer SigmaU33() { if (SigmaU() != null) return SigmaU()[2]; return null; }
	public Integer SigmaU12() { if (SigmaU() != null) return SigmaU()[3]; return null; }
	public Integer SigmaU13() { if (SigmaU() != null) return SigmaU()[4]; return null; }
	public Integer SigmaU23() { if (SigmaU() != null) return SigmaU()[5]; return null; }
	public SpaceGroup Spacegroup() { return spaceGroup; }
        public Object TableData(int index)
	{
		switch (index)
		{
		case HETROATOM_INDEX : return HetroAtom();
		case ATOMNUMBER_INDEX : return AtomNumber();
		case ATOMNAME_INDEX : return AtomType();
		case ELEMENT_INDEX : return Element();
		case CHARGE_INDEX : return Charge();
		case ALTERNATELOCATION_INDEX : return AlternateLocation();
		case RESIDUETYPE_INDEX : return ResidueType();
		case CHAINID_INDEX : return ChainID();
		case RESIDUENUMBER_INDEX : return ResidueNumber();
		case INSERTIONCODE_INDEX : return InsertionCode();
		case X_INDEX : return X();
		case Y_INDEX : return Y();
		case Z_INDEX : return Z();
		case B_INDEX : return B_Factor();
		case OCCUPANCY_INDEX : return Occupancy();
		case U11_INDEX : return U11();
		case U22_INDEX : return U22();
		case U33_INDEX : return U33();
		case U12_INDEX : return U12();
		case U13_INDEX : return U13();
		case U23_INDEX : return U23();
		case SIGMAX_INDEX : return SigmaX();
		case SIGMAY_INDEX : return SigmaY();
		case SIGMAZ_INDEX : return SigmaZ();
		case SIGMAB_INDEX : return SigmaB_Factor();
		case SIGMAOCCUPANCY_INDEX : return SigmaOccupancy();
		case SIGMAU11_INDEX : return SigmaU11();
		case SIGMAU22_INDEX : return SigmaU22();
		case SIGMAU33_INDEX : return SigmaU33();
		case SIGMAU12_INDEX : return SigmaU12();
		case SIGMAU13_INDEX : return SigmaU13();
		case SIGMAU23_INDEX : return SigmaU23();
                    case FRACX_INDEX : return x();
                    case FRACY_INDEX : return y();
                    case FRACZ_INDEX : return z();
		}
		return null;
	}
	//    Input functions
	public boolean HetroAtom(boolean HetroAtom) { fireDataChangedEvent(HETROATOM_INDEX, hetroAtom); return hetroAtom = HetroAtom; }
	public int AtomNumber(int AtomNumber) {  fireDataChangedEvent(ATOMNUMBER_INDEX, atomNumber); return atomNumber = AtomNumber;	}
	public String AtomType(String AtomType) {  fireDataChangedEvent(ATOMNAME_INDEX, atomType); return atomType = AtomType; }
	public char AlternateLocation(char AlternateLocation) {	 fireDataChangedEvent(ALTERNATELOCATION_INDEX, alternateLocation); return alternateLocation = AlternateLocation; }
	public String ResidueType(String ResidueType) {  fireDataChangedEvent(RESIDUETYPE_INDEX, residueType); return residueType = ResidueType; }
	public char ChainID(char ChainID) {  fireDataChangedEvent(CHAINID_INDEX, chainID); return chainID = ChainID; }
	public int ResidueNumber(int ResidueNumber) {  fireDataChangedEvent(RESIDUENUMBER_INDEX, residueNumber); return residueNumber = ResidueNumber; }
	public char InsertionCode(char InsertionCode) {  fireDataChangedEvent(INSERTIONCODE_INDEX, insertionCode); return insertionCode = InsertionCode; }
	public Coordinate OrthogonalCoordinate(Coordinate Value) 
        { 
            fireDataChangedEvent(X_INDEX, (XYZ != null) ? XYZ.x() : null);
            fireDataChangedEvent(Y_INDEX, (XYZ != null) ? XYZ.y() : null);
            fireDataChangedEvent(Z_INDEX, (XYZ != null) ? XYZ.z() : null);
            XYZ = Value;
            GenerateFractionalCoordinate();
            return XYZ; 
        }
	public double X(double X) 
        { 
            fireDataChangedEvent(X_INDEX, (XYZ != null) ? XYZ.x() : null);
            if (XYZ == null) XYZ = new Coordinate(); 
            XYZ.x(X); 
            GenerateFractionalCoordinate();
            return XYZ.x(); 
        }
	public double Y(double Y) 
	{ 
            fireDataChangedEvent(Y_INDEX, (XYZ != null) ? XYZ.y() : null);
            if (XYZ == null) XYZ = new Coordinate(); 
            XYZ.y(Y); 
            GenerateFractionalCoordinate();
            return XYZ.y(); 
        }
        public double Z(double Z)
        { 
            fireDataChangedEvent(Z_INDEX, (XYZ != null) ? XYZ.z() : null);
            if (XYZ == null) XYZ = new Coordinate(); 
            XYZ.z(Z); 
            GenerateFractionalCoordinate();
            return XYZ.z(); 
        }
        public Coordinate FractionalCoordinate(Coordinate Value) 
        { 
            if (Spacegroup() != null)
            {
                fireDataChangedEvent(FRACX_INDEX, (xyz != null) ? xyz.x() : null);
                fireDataChangedEvent(FRACY_INDEX, (xyz != null) ? xyz.y() : null);
                fireDataChangedEvent(FRACZ_INDEX, (xyz != null) ? xyz.z() : null);
                xyz = Value;
                GenerateOrthogonalCoordinate();
                return xyz;
            } 
            return null;
        }
	public Double x(double Value) 
        { 
            if (Spacegroup() != null)
            {
                fireDataChangedEvent(FRACX_INDEX, (xyz != null) ? xyz.x() : null);
                if (xyz == null) xyz = new Coordinate();
                xyz.x(Value);
                GenerateOrthogonalCoordinate();
                return Value;
            } 
            return 0.0;
        }
	public Double y(double Value)
        { 
            if (Spacegroup() != null)
            {
                fireDataChangedEvent(FRACY_INDEX, (xyz != null) ? xyz.y() : null);
                if (xyz == null) xyz = new Coordinate();
                xyz.y(Value);
                GenerateOrthogonalCoordinate();
                return Value;
            } 
            return 0.0;
        }
	public Double z(double Value)
        { 
            if (Spacegroup() != null)
            {
                fireDataChangedEvent(FRACZ_INDEX, (xyz != null) ? xyz.z() : null);
                if (xyz == null) xyz = new Coordinate();
                xyz.z(Value);
                GenerateOrthogonalCoordinate();
                return Value;
            } 
            return 0.0;
        }
	public Coordinate SigmaCoordinate(Coordinate SigmaCoordinate) 
        { 
            fireDataChangedEvent(SIGMAX_INDEX, (sigmaXYZ != null) ? sigmaXYZ.x() : null);
            fireDataChangedEvent(SIGMAY_INDEX, (sigmaXYZ != null) ? sigmaXYZ.y() : null);
            fireDataChangedEvent(SIGMAZ_INDEX, (sigmaXYZ != null) ? sigmaXYZ.z() : null);
            return sigmaXYZ = SigmaCoordinate; 
        }
	public double SigmaX(double Value) 
        { 
            fireDataChangedEvent(SIGMAX_INDEX, (sigmaXYZ != null) ? sigmaXYZ.x() : null);
            if (sigmaXYZ == null) sigmaXYZ = new Coordinate(); 
            return sigmaXYZ.x(Value); 
        }
	public double SigmaY(double Value) 
        { 
            fireDataChangedEvent(SIGMAY_INDEX, (sigmaXYZ != null) ? sigmaXYZ.y() : null);
            if (sigmaXYZ == null) sigmaXYZ = new Coordinate(); 
            return sigmaXYZ.y(Value); 
        }
	public double SigmaZ(double Value) 
        { 
            fireDataChangedEvent(SIGMAZ_INDEX, (sigmaXYZ != null) ? sigmaXYZ.z() : null);
            if (sigmaXYZ == null) sigmaXYZ = new Coordinate(); 
            return sigmaXYZ.z(Value); 
        }
	public double B_Factor(double B_Factor) { fireDataChangedEvent(B_INDEX, B); return B = B_Factor; }
	public double SigmaB_Factor(double SigmaB_Factor) { fireDataChangedEvent(SIGMAB_INDEX, sigmaB); return sigmaB = SigmaB_Factor; }
	public double Occupancy(double Occupancy) { fireDataChangedEvent(OCCUPANCY_INDEX, occupancy); return occupancy = Occupancy; }
	public double SigmaOccupancy(double SigmaOccupancy) { fireDataChangedEvent(SIGMAOCCUPANCY_INDEX, sigmaOccupancy); return sigmaOccupancy = SigmaOccupancy; }
	public String Element(String Element) 
	{ 
		if (Element != null) if (Element.length() > 2) Element = Element.substring(0,2);
		fireDataChangedEvent(ELEMENT_INDEX, (element != null) ? element : null);
                return element = Element; 
	}
	public String Charge(String Charge) 
	{ 
		if (Charge != null) if (Charge.length() > 2) Charge = Charge.substring(0,2);
		fireDataChangedEvent(CHARGE_INDEX, (charge != null) ? charge : null);
                return charge = Charge; 
	}
	public int[] AnisotropicB(int[] AnisotropicB) 
        { 
            fireDataChangedEvent(U11_INDEX, (anisotropicB != null) ? anisotropicB[0] : null); 
            fireDataChangedEvent(U22_INDEX, (anisotropicB != null) ? anisotropicB[1] : null);
            fireDataChangedEvent(U33_INDEX, (anisotropicB != null) ? anisotropicB[2] : null);
            fireDataChangedEvent(U12_INDEX, (anisotropicB != null) ? anisotropicB[3] : null);
            fireDataChangedEvent(U13_INDEX, (anisotropicB != null) ? anisotropicB[4] : null);
            fireDataChangedEvent(U23_INDEX, (anisotropicB != null) ? anisotropicB[5] : null);
            return anisotropicB = AnisotropicB; 
        }
	public Integer U11(int Value) { fireDataChangedEvent(U11_INDEX, (anisotropicB != null) ? anisotropicB[0] : null); if (AnistropicB() == null) anisotropicB = new int[6]; return AnistropicB()[0] = Value; }
	public Integer U22(int Value) { fireDataChangedEvent(U22_INDEX, (anisotropicB != null) ? anisotropicB[1] : null); if (AnistropicB() == null) anisotropicB = new int[6]; return AnistropicB()[1] = Value; }
	public Integer U33(int Value) { fireDataChangedEvent(U33_INDEX, (anisotropicB != null) ? anisotropicB[2] : null); if (AnistropicB() == null) anisotropicB = new int[6]; return AnistropicB()[2] = Value; }
	public Integer U12(int Value) { fireDataChangedEvent(U12_INDEX, (anisotropicB != null) ? anisotropicB[3] : null); if (AnistropicB() == null) anisotropicB = new int[6]; return AnistropicB()[3] = Value; }
	public Integer U13(int Value) { fireDataChangedEvent(U13_INDEX, (anisotropicB != null) ? anisotropicB[4] : null); if (AnistropicB() == null) anisotropicB = new int[6]; return AnistropicB()[4] = Value; }
	public Integer U23(int Value) { fireDataChangedEvent(U23_INDEX, (anisotropicB != null) ? anisotropicB[5] : null); if (AnistropicB() == null) anisotropicB = new int[6]; return AnistropicB()[5] = Value; }
	public int[] SigmaU(int[] SigmaU) 
        { 
            fireDataChangedEvent(SIGMAU11_INDEX, (sigmaU != null) ? sigmaU[0] : null); 
            fireDataChangedEvent(SIGMAU22_INDEX, (sigmaU != null) ? sigmaU[1] : null);
            fireDataChangedEvent(SIGMAU33_INDEX, (sigmaU != null) ? sigmaU[2] : null);
            fireDataChangedEvent(SIGMAU12_INDEX, (sigmaU != null) ? sigmaU[3] : null);
            fireDataChangedEvent(SIGMAU13_INDEX, (sigmaU != null) ? sigmaU[4] : null);
            fireDataChangedEvent(SIGMAU23_INDEX, (sigmaU != null) ? sigmaU[5] : null);
            return sigmaU = SigmaU; 
        }
	public Integer SigmaU11(int Value) { fireDataChangedEvent(SIGMAU11_INDEX, (sigmaU != null) ? sigmaU[0] : null); if (SigmaU() == null) sigmaU = new int[6];  return SigmaU()[0] = Value; }
	public Integer SigmaU22(int Value) { fireDataChangedEvent(SIGMAU22_INDEX, (sigmaU != null) ? sigmaU[1] : null); if (SigmaU() == null) sigmaU = new int[6];  return SigmaU()[1] = Value; }
	public Integer SigmaU33(int Value) { fireDataChangedEvent(SIGMAU33_INDEX, (sigmaU != null) ? sigmaU[2] : null); if (SigmaU() == null) sigmaU = new int[6];  return SigmaU()[2] = Value; }
	public Integer SigmaU12(int Value) { fireDataChangedEvent(SIGMAU12_INDEX, (sigmaU != null) ? sigmaU[3] : null); if (SigmaU() == null) sigmaU = new int[6];  return SigmaU()[3] = Value; }
	public Integer SigmaU13(int Value) { fireDataChangedEvent(SIGMAU13_INDEX, (sigmaU != null) ? sigmaU[4] : null); if (SigmaU() == null) sigmaU = new int[6];  return SigmaU()[4] = Value; }
	public Integer SigmaU23(int Value) { fireDataChangedEvent(SIGMAU23_INDEX, (sigmaU != null) ? sigmaU[5] : null); if (SigmaU() == null) sigmaU = new int[6];  return SigmaU()[5] = Value; }
	public SpaceGroup Spacegroup(SpaceGroup Value) { return spaceGroup = Value; }
        public Object TableData(int index, Object Value)
	{
		if (Value != null)
		{
			if ((Atom.DataClass[index] == Global.charclass.getClass()) &&
					(Value.getClass() == Global.stringclass.getClass())) 
			{
				String s = (String)Value;
				if (s.length() > 0) Value = (s.charAt(s.length() - 1));
				else Value = ' ';
			}
		switch (index)
		{
		case HETROATOM_INDEX : return HetroAtom((Boolean)Value);
		case ATOMNUMBER_INDEX : return AtomNumber((Integer)Value);
		case ATOMNAME_INDEX : return AtomType((String)Value);
		case ELEMENT_INDEX : return Element((String)Value);
		case CHARGE_INDEX : return Charge((String)Value);
		case ALTERNATELOCATION_INDEX : return AlternateLocation((Character)Value);
		case RESIDUETYPE_INDEX : return ResidueType((String)Value);
		case CHAINID_INDEX : return ChainID((Character)Value);
		case RESIDUENUMBER_INDEX : return ResidueNumber((Integer)Value);
		case INSERTIONCODE_INDEX : return InsertionCode((Character)Value);
		case X_INDEX : return X((Double)Value);
		case Y_INDEX : return Y((Double)Value);
		case Z_INDEX : return Z((Double)Value);
		case B_INDEX : return B_Factor((Double)Value);
		case OCCUPANCY_INDEX : return Occupancy((Double)Value);
		case U11_INDEX : return U11((Integer)Value);
		case U22_INDEX : return U22((Integer)Value);
		case U33_INDEX : return U33((Integer)Value);
		case U12_INDEX : return U12((Integer)Value);
		case U13_INDEX : return U13((Integer)Value);
		case U23_INDEX : return U23((Integer)Value);
		case SIGMAX_INDEX : return SigmaX((Double)Value);
		case SIGMAY_INDEX : return SigmaY((Double)Value);
		case SIGMAZ_INDEX : return SigmaZ((Double)Value);
		case SIGMAB_INDEX : return SigmaB_Factor((Double)Value);
		case SIGMAOCCUPANCY_INDEX : return SigmaOccupancy((Double)Value);
		case SIGMAU11_INDEX : return SigmaU11((Integer)Value);
		case SIGMAU22_INDEX : return SigmaU22((Integer)Value);
		case SIGMAU33_INDEX : return SigmaU33((Integer)Value);
		case SIGMAU12_INDEX : return SigmaU12((Integer)Value);
		case SIGMAU13_INDEX : return SigmaU13((Integer)Value);
		case SIGMAU23_INDEX : return SigmaU23((Integer)Value);
                case FRACX_INDEX : return x((Double)Value);
                case FRACY_INDEX : return y((Double)Value);
                case FRACZ_INDEX : return z((Double)Value);
		}
		}
                else
                {
                    switch (index)
                    {
		case U11_INDEX : return AnisotropicB(null);
		case U22_INDEX : return AnisotropicB(null);
		case U33_INDEX : return AnisotropicB(null);
		case U12_INDEX : return AnisotropicB(null);
		case U13_INDEX : return AnisotropicB(null);
		case U23_INDEX : return AnisotropicB(null);
		case SIGMAX_INDEX : return SigmaCoordinate(null);
		case SIGMAY_INDEX : return SigmaCoordinate(null);
		case SIGMAZ_INDEX : return SigmaCoordinate(null);
		case SIGMAU11_INDEX : return SigmaU(null);
		case SIGMAU22_INDEX : return SigmaU(null);
		case SIGMAU33_INDEX : return SigmaU(null);
		case SIGMAU12_INDEX : return SigmaU(null);
		case SIGMAU13_INDEX : return SigmaU(null);
		case SIGMAU23_INDEX : return SigmaU(null);
                        
                    }
                }
		return null;
	}	
	

	// Type Conversion Functions
	public AtomPDB GetPDBAtomOfThis()
	{
		if (this.getClass() == AtomPDB.AtomPDBclass.getClass()) return (AtomPDB)this;
		return new AtomPDB((Atom)this);
	}
        
        public Atom clone()
        {
            Atom a = new Atom();
            a.hetroAtom = hetroAtom;
            a.atomNumber = atomNumber;
            a.atomType = atomType;
            a.alternateLocation = alternateLocation;
            a.residueType = residueType;
            a.chainID = chainID;
            a.residueNumber = residueNumber;
            a.insertionCode = insertionCode;
            a.XYZ = XYZ;
            a.xyz = xyz;
            a.sigmaXYZ = sigmaXYZ;
            a.B = B;
            a.sigmaB = sigmaB;
            a.occupancy = occupancy;
            a.sigmaOccupancy = sigmaOccupancy;
            a.element = element;
            a.charge = charge;
            a.anisotropicB = anisotropicB;
            a.sigmaU = sigmaU;
            a.spaceGroup = spaceGroup;
            return a;
        }
        
         
        protected void GenerateFractionalCoordinate()
        {
            if (Spacegroup() != null) 
               if (Spacegroup().scale() != null) 
                    xyz = Global.TransformCoordinates(spaceGroup.scale(), XYZ);
        }
        
        protected void GenerateOrthogonalCoordinate()
        {
             if (Spacegroup().scaleInverse() != null) 
                 XYZ = Global.TransformCoordinates(spaceGroup.scaleInverse(), xyz);
        }
        
        public void addAtomDataChangeListener(AtomDataChangeEventListener listener)
        {
            dataChangeListener.add(AtomDataChangeEventListener.class, listener);
        }
        
        public void removeAtomDataChangeListener(AtomDataChangeEventListener listener)
        {
            dataChangeListener.remove(AtomDataChangeEventListener.class, listener);
        }
        
        protected void fireDataChangedEvent(int changedEntryNumber, Object OldValue)
        {
            AtomDataChangeEvent event = new AtomDataChangeEvent(this, changedEntryNumber, OldValue);
            Object[] listeners = dataChangeListener.getListenerList();
            // Each listener occupies two elements - the first is the listener class
            // and the second is the listener instance
            for (int i=0; i<listeners.length; i+=2) {
                if (listeners[i]==AtomDataChangeEventListener.class) {
                    ((AtomDataChangeEventListener)listeners[i+1]).dataChanged(event);
                }
            }

        }

    public int compareTo(Object o) {
        
        Atom b = (Atom)o;
        
        int diff_atomnum = this.AtomNumber() - b.AtomNumber();
        if (diff_atomnum != 0) return diff_atomnum;
            
        int diff_chain = compareChainID(this.ChainID(), b.chainID);
        if (diff_chain != 0) return diff_chain;
        
        int diff_resnum = this.ResidueNumber() - b.ResidueNumber();
        if (diff_resnum != 0) return diff_resnum;
        
        int diff_atomname = compareAtomName(this, b);
        if (diff_atomname != 0) return diff_atomname;
        
        int diff_altloc = this.AlternateLocation() - b.AlternateLocation();
        if (diff_altloc != 0) return diff_altloc;
        
        return 0;
    }
}
