/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package pdb_reader.data;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/**
 *
 * @author Owner
 */
public class Connectivity implements Comparable{
    
    public static String PDBHeader = "CONECT";
    
    public Atom Base = null;
    public Set<Atom> Branch = new TreeSet<Atom> ();
    
    public Connectivity() {}
    public Connectivity(Atom base, Atom branch)
    {
        Base = base;
        Branch.add(branch);
    }
    
    public Connectivity(Atom base, Atom[] branch)
    {
        Base = base;
        for (int i=0; i<branch.length; i++) Branch.add(branch[i]);
    }
    
    public Connectivity(Atom[] base_branch)
    {
        Base = base_branch[0];
        for (int i=1; i<base_branch.length; i++) Branch.add(base_branch[i]);
    }
    
    public Connectivity(String PDBLine, List<Atom> AtomList)
    {
        ReadPDBLine(PDBLine, AtomList);
    }
    
    public void ReadPDBLine(String line, List<Atom> atomlist)
    {
        /*
         COLUMNS       DATA TYPE       FIELD         DEFINITION
-------------------------------------------------------
 1 -  6       Record name     "CONECT"
 7 - 11       Integer         serial        Atom serial number
12 - 16       Integer         serial        Serial number of bonded atom
17 - 21       Integer         serial        Serial number of bonded atom
22 - 26       Integer         serial        Serial number of bonded atom
27 - 31       Integer         serial        Serial number of bonded atom
*/
         if (line != null)
            if (line.length() > 6)
                if (line.substring(0, 6).equals(PDBHeader))
                {
                    TreeSet<Integer> list = new TreeSet<Integer> ();
                    int base = -1;
                    try {
                        base = Integer.parseInt(line.substring(6, 11).trim());
                        int i = 11;
                        while (i < line.length())
                        {
                            String s = line.substring(i, i+5).trim();
                            if (s.length() > 0) list.add(Integer.parseInt(s));
                            i += 5;
                        }
                    }
                    catch (Exception e) {}
                    
                    if (base != -1)
                    {
                        Base = FindAtomNumber(atomlist, base);
                        Branch = FindAtomList(atomlist, list);
                    }
                }
    }
    
    public String WritePDBLine()
    {
        StringBuilder sb = new StringBuilder();
        
        TreeSet<Integer> list = GetBranchNumbers();
        
        sb.append(PDBHeader);
        sb.append(String.format("%5d", Base.AtomNumber()));
        int count=0;
        for (int i : list)
        {
            if ((count != 0) && (count % 4 == 0))
            {
                sb.append('\n');
                sb.append(PDBHeader);
                sb.append(String.format("%5d", Base.AtomNumber()));
            }
            sb.append(String.format("%5d", i));
            count++;

        }
        
        return sb.toString();
    }
    
    private TreeSet<Integer> GetBranchNumbers()
    {
        TreeSet<Integer> r = new TreeSet<Integer> ();
        
        for (Atom a : Branch)
        {
            r.add(a.AtomNumber());
        }
        
        return r;
    }
    
    private Atom FindAtomNumber(List<Atom> list, int number)
    {
        for (Atom  a : list)
        {
            if (a.AtomNumber() == number) return a;
        }
        return null;
    }
    
    private Set<Atom> FindAtomList(List<Atom> list, TreeSet<Integer> targets)
    {
        Set<Atom> r = new TreeSet<Atom> ();
        
        for (Atom a : list)
        {
            if (targets.contains(a.AtomNumber()))
                r.add(a);
        }
        
        return r;
    }

    public int compareTo(Object o) {
        try {
            Connectivity c = (Connectivity)o;
            
            int diff_baseatom = this.Base.compareTo(c.Base);
            if (diff_baseatom != 0) return diff_baseatom;
            
            int diff_branchsize = this.Branch.size() - c.Branch.size();
            if (diff_branchsize != 0) return diff_branchsize;
            
            Iterator<Atom> i = this.Branch.iterator();
            Iterator<Atom> j = c.Branch.iterator();
            while ((i.hasNext()) && (j.hasNext()))
            {
                Atom a = i.next();
                Atom b = j.next();
                
                int diff_branch = a.compareTo(b);
                if (diff_branch != 0) return diff_branch;
            }
        }
        catch (Exception e) {}
        return 0;
    }
    
    public Connectivity clone()
    {
        Connectivity c = new Connectivity();
        c.Base = this.Base;
        c.Branch = new TreeSet<Atom> (this.Branch);
        return c;
    }
}
