/*
 *  bayreg/zip.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:47 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <math.h>

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_blas.h>
#include <gdl/gdl_cblas.h>
#include <gdl/gdl_math.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_randist.h>
#include <gdl/gdl_specfunc.h>
#include <gdl/gdl_sort_double.h>
#include <gdl/gdl_statistics_double.h>
#include <gdl/gdl_snp_annotation.h>
#include <gdl/gdl_bayesian_regression.h>


void
gdl_bayreg_bf_zip_free (gdl_bayreg_bf_zip * z)
{
	if (z)
	{
		GDL_FREE (z->m);
		GDL_FREE (z->w);
		GDL_FREE (z->bf);
		GDL_FREE (z);	
	}	
}

gdl_bayreg_bf_zip *
gdl_bayreg_bf_zip_fread (FILE * stream)
{
	if (stream)
	{
		int status;
		gdl_bayreg_bf_zip * z;
		
		z = GDL_CALLOC (gdl_bayreg_bf_zip, 1);
		
		status = fread (&z->n, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		z->m  = GDL_MALLOC (size_t, z->n);
		z->w  = GDL_MALLOC (size_t, z->n);
		z->bf = GDL_MALLOC (double, z->n);
		
		status = fread (z->m, sizeof(size_t), z->n, stream);
		GDL_FREAD_STATUS (status, z->n);
		status = fread (z->w, sizeof(size_t), z->n, stream);
		GDL_FREAD_STATUS (status, z->n);
		status = fread (z->bf, sizeof(double), z->n, stream);
		GDL_FREAD_STATUS (status, z->n);
		
		return z;
	}
	return 0;	
}

int
gdl_bayreg_bf_zip_fwrite (FILE * stream, const gdl_bayreg_bf_zip * z)
{
	if (stream && z)
	{
		int status;
		
		status = fwrite (&z->n, sizeof(size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (z->m, sizeof(size_t), z->n, stream);
		GDL_FWRITE_STATUS (status, z->n);
		status = fwrite (z->w, sizeof(size_t), z->n, stream);
		GDL_FWRITE_STATUS (status, z->n);
		status = fwrite (z->bf, sizeof(double), z->n, stream);
		GDL_FWRITE_STATUS (status, z->n);
		
		return GDL_SUCCESS;
	}
	return GDL_EINVAL;	
}

