/*  
 * 	clust/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_clustering.h>

#define N 100

void
test_clust ()
{
	size_t i, j;
	gdl_clustering_workspace * w;
	gdl_clustering * c;
	gdl_rng * r;
	
	r = gdl_rng_alloc (gdl_rng_default);
	
	w = gdl_clustering_workspace_alloc (N);
	
	for (i = 0; i < N; i++)
	{
		double z = gdl_rng_uniform (r);
		if (z >= 0.5)
		{
			for (j = i+1; j < N; j++)
			{
				z = gdl_rng_uniform (r);
				if (z >= 0.5)
				{
					gdl_clustering_workspace_set (w, i, j);
				}
			}
		}
	}
	
	c = gdl_clustering_workspace_done (w);
	
	gdl_test (c == NULL, "gdl_clustering_workspace_done returns valid pointer");
	
	
	printf ("SIZE %d\n", gdl_clustering_size (c));
	for (i = 0; i < gdl_clustering_size (c); i++)
	{
		printf ("CLUSTER %d ==> %d\n", i,gdl_clustering_cluster (c, i) );
	}
	printf ("NCLUST %d\n", gdl_clustering_nclust (c));
	
	for (j = i = 0; i < gdl_clustering_nclust (c); i++)
	{
		printf ("IDX %d %d\n", gdl_clustering_clust_idx (c, i)
		                     , gdl_clustering_clust_size (c, i));		
		j += gdl_clustering_clust_size (c, i);
	}
	printf ("j = %d\n", j);
	gdl_test (j != N, "gdl_clustering_size returns correct size");
	
	gdl_clustering_workspace_free (w);
	gdl_clustering_free (c);
}

int
main (void)
{
	test_clust ();
	exit (gdl_test_summary());
}
