/*  
 *  dna/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:52 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gview_writer.h>
#include <gdl/gdl_gmap.h>
#include <gdl/gdl_gmap_writer.h>
#include <gdl/gdl_locus_type.h>
#include <gdl/gdl_dna_reader.h>



void
test_parse (const gdl_string * file)
{
	gdl_dna_reader   * r;
	gdl_gview_writer * w;
	gdl_gmap_writer  * wm;
	gdl_gmap * map;
	
	r = gdl_dna_reader_alloc (gdl_dna_reader_fasta, "seq-", gdl_false, gdl_true, gdl_false);
	
	gdl_dna_reader_open (r, file);
	
	if (gdl_dna_reader_parse (r)!=GDL_SUCCESS)
	{
		fprintf (stderr, "ERROR : %s\n", r->error);
		return;
	}
	
	gdl_dna_reader_close (r);
	
	w = gdl_gview_writer_alloc (gdl_gview_writer_type_new (gdl_gview_writer_standard));
	
	gdl_gview_writer_open (w, "");
	
	gdl_gview_writer_dump (w, gdl_dna_reader_get_data (r));
	
	gdl_gview_writer_free (w);
	
	wm = gdl_gmap_writer_alloc (gdl_gmap_writer_absolute);
	
	gdl_gmap_writer_open (wm, "");
	
	map = gdl_dna_reader_get_map (r);
	
	gdl_gmap_writer_dump (wm, map);
	
	gdl_gmap_writer_free (wm);	
	
	gdl_locus_type_registry_fprintf (stdout, gdl_dna_reader_get_locus_type (r));
	
	gdl_dna_reader_free (r);
}

int
main (void)
{
	//test_parse ("tests/seq1.txt");
	//test_parse ("tests/seq2.txt");
	//test_parse ("tests/seq3.txt");
	test_parse ("tests/fasta.txt");
	exit (gdl_test_summary());
}
