/*
 *  eqtl/gene_entry.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:47 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

static gdl_eqtl_gene_entry *
gdl_eqtl_gene_entry_alloc (size_t chrom_idx, size_t gene_idx)
{
	gdl_eqtl_gene_entry * e;
	
	e = GDL_MALLOC (gdl_eqtl_gene_entry, 1);
	
	e->chrom_idx = chrom_idx;
	e->gene_idx  = gene_idx;
	
	return e;	
}

static void
gdl_eqtl_gene_entry_free (void * e)
{
	GDL_FREE (e);
}

static void *
gdl_eqtl_gene_entry_fread (FILE * stream)
{
	if (stream)
	{
		int status;
		size_t cidx, gidx;
		
		status = fread (&cidx, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&gidx, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		return gdl_eqtl_gene_entry_alloc (cidx, gidx);
	}
	return 0;	
}

static int
gdl_eqtl_gene_entry_fwrite (FILE * stream, const void * ve)
{
	if (stream)
	{
		int status;
		gdl_eqtl_gene_entry * e = (gdl_eqtl_gene_entry *) ve;
		
		status = fwrite (&e->chrom_idx, sizeof(size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&e->gene_idx, sizeof(size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		
		return GDL_SUCCESS;
	}
	return GDL_EINVAL;	
}

static const gdl_data_interface _gdl_eqtl_gene_entry_interface =
{
	&gdl_eqtl_gene_entry_free,
	NULL,
	NULL,
	&gdl_eqtl_gene_entry_fread,
	&gdl_eqtl_gene_entry_fwrite
};

static const gdl_data_interface * gdl_eqtl_gene_entry_interface = &_gdl_eqtl_gene_entry_interface;
