/*
 *  eqtl/rec.c 
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:47 $, $Version$
 *  
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_randist.h>
#include <gdl/gdl_eqtl_bayes.h>

gdl_eqtl_bayes_snp_record *
gdl_eqtl_bayes_snp_record_alloc (const size_t size)
{
	gdl_eqtl_bayes_snp_record * r;
	
	r = GDL_CALLOC (gdl_eqtl_bayes_snp_record, 1);
	
	r->wbf = GDL_MALLOC (double, size);
	
	return r;
}

void
gdl_eqtl_bayes_snp_record_free (gdl_eqtl_bayes_snp_record * r)
{
	if (r)
	{
		GDL_FREE (r->wbf);
		GDL_FREE (r);	
	}
}

gdl_eqtl_bayes_snp_record *
gdl_eqtl_bayes_snp_record_fread (FILE * stream, const size_t ngrid)
{
	if (stream)
	{
		int status;
		gdl_eqtl_bayes_snp_record * r;
		
		r = gdl_eqtl_bayes_snp_record_alloc (ngrid);
		
		status = fread (&r->cidx, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&r->sidx, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&r->gamma, sizeof(double), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&r->bf, sizeof(double), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&r->position, sizeof(double), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&r->proba, sizeof(double), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (r->wbf, sizeof(double), ngrid, stream);
		GDL_FREAD_STATUS (status, ngrid);
		
		r->snp = gdl_snp_fread (stream);
		GDL_FREAD_STATUS (r->snp!=0, 1);
		
		return r;
	}
	
	return 0;
}

int
gdl_eqtl_bayes_snp_record_fwrite (FILE * stream, const gdl_eqtl_bayes_snp_record * r, const size_t ngrid)
{
	if (stream && r)
	{
		int status;
		
		status = fwrite (&r->cidx, sizeof(size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&r->sidx, sizeof(size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&r->gamma, sizeof(double), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&r->bf, sizeof(double), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&r->position, sizeof(double), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&r->proba, sizeof(double), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (r->wbf, sizeof(double), ngrid, stream);
		GDL_FWRITE_STATUS (status, ngrid);
		
		status = gdl_snp_fwrite (stream, r->snp);
		GDL_FWRITE_STATUS (status, GDL_SUCCESS);
		
		return GDL_SUCCESS;
	}
	return GDL_EINVAL;
}
