/* err/error.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_message.h>

gdl_error_handler_t * gdl_error_handler = NULL;
gdl_warning_handler_t * gdl_warning_handler = NULL;

static void no_error_handler (const char *reason, const char *file, int line, int gdl_errno);

void
gdl_error (const char * reason, const char * file, int line, int gdl_errno)
{
  if (gdl_error_handler) 
    {
      (*gdl_error_handler) (reason, file, line, gdl_errno);
      return ;
    }

  gdl_stream_printf ("ERROR", file, line, reason);

  fflush (stdout);
  fprintf (stderr, "Default GDL error handler invoked.\n");
  fflush (stderr);

  abort ();
}

void
gdl_warning (const char * reason, const char * file, int line,
                int gdl_errno)
{
	if (gdl_error_handler) 
    {
      (*gdl_warning_handler) (reason, file, line, gdl_errno);
      return ;
    }
    gdl_stream_printf ("WARNING", file, line, reason);
}                

gdl_error_handler_t *
gdl_set_error_handler (gdl_error_handler_t * new_handler)
{
  gdl_error_handler_t * previous_handler = gdl_error_handler;
  gdl_error_handler = new_handler;
  return previous_handler;
}


gdl_error_handler_t *
gdl_set_error_handler_off (void)
{
  gdl_error_handler_t * previous_handler = gdl_error_handler;
  gdl_error_handler = no_error_handler;
  return previous_handler;
}

static void
no_error_handler (const char *reason, const char *file, int line, int gdl_errno)
{
  /* do nothing */
  reason = 0;
  file = 0;
  line = 0;
  gdl_errno = 0;
  return;
}


