/* gdl/gdl_message.h
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GDL_MESSAGE_H__
#define __GDL_MESSAGE_H__

#include <gdl/gdl_common.h>

__BEGIN_DECLS

/* Provide a general messaging service for client use.  Messages can
 * be selectively turned off at compile time by defining an
 * appropriate message mask. Client code which uses the GDL_MESSAGE()
 * macro must provide a mask which is or'ed with the GDL_MESSAGE_MASK.
 *
 * The messaging service can be completely turned off
 * by defining GDL_MESSAGING_OFF.  */

void gdl_message(const char * message, const char * file, int line,
                 unsigned int mask);

#ifndef GDL_MESSAGE_MASK
#define GDL_MESSAGE_MASK 0xffffffffu /* default all messages allowed */
#endif

GDL_VAR unsigned int gdl_message_mask ;

/* Provide some symolic masks for client ease of use. */

enum {
  GDL_MESSAGE_MASK_A = 1,
  GDL_MESSAGE_MASK_B = 2,
  GDL_MESSAGE_MASK_C = 4,
  GDL_MESSAGE_MASK_D = 8,
  GDL_MESSAGE_MASK_E = 16,
  GDL_MESSAGE_MASK_F = 32,
  GDL_MESSAGE_MASK_G = 64,
  GDL_MESSAGE_MASK_H = 128
} ;

#ifdef GDL_MESSAGING_OFF        /* throw away messages */ 
#define GDL_MESSAGE(message, mask) do { } while(0)
#else                           /* output all messages */
#define GDL_MESSAGE(message, mask) \
       do { \
       if (mask & GDL_MESSAGE_MASK) \
         gdl_message (message, __FILE__, __LINE__, mask) ; \
       } while (0)
#endif

__END_DECLS

#endif /* __GDL_MESSAGE_H__ */


