/* err/stream.c
 * 
 * Copyright (C) 1996, 1997, 1998, 1999, 2000 Gerard Jungman, Brian Gough
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_message.h>

FILE * gdl_stream = NULL ;
gdl_stream_handler_t * gdl_stream_handler = NULL;

void
gdl_stream_printf (const char *label, const char *file, int line, 
                   const char *reason)
{
  if (gdl_stream == NULL)
    {
      gdl_stream = stderr;
    }
  if (gdl_stream_handler)
    {
      (*gdl_stream_handler) (label, file, line, reason);
      return;
    }
  fprintf (gdl_stream, "gdl: %s:%d: %s: %s\n", file, line, label, reason);

}

gdl_stream_handler_t *
gdl_set_stream_handler (gdl_stream_handler_t * new_handler)
{
  gdl_stream_handler_t * previous_handler = gdl_stream_handler;
  gdl_stream_handler = new_handler;
  return previous_handler;
}

FILE *
gdl_set_stream (FILE * new_stream)
{
  FILE * previous_stream;
  if (gdl_stream == NULL) {
    gdl_stream = stderr;
  }
  previous_stream = gdl_stream;
  gdl_stream = new_stream;
  return previous_stream;
}
