/*  
 *  fmatrix/gdl_fmatrix.h 
 *  
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_vector.h>
#include <gdl/gdl_matrix.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_flabels.h>
#include <gdl/gdl_fview.h>
#include <gdl/gdl_fview_mask.h>
#include <gdl/gdl_fview_wrapper.h>

#ifndef __GDL_FMATRIX_H__
#define __GDL_FMATRIX_H__

__BEGIN_DECLS

typedef struct _gdl_fmatrix gdl_fmatrix;

gdl_fmatrix * gdl_fmatrix_alloc (const gdl_fview * fview, const gdl_mask * mask, gdl_boolean last_level);
gdl_fmatrix * gdl_fmatrix_wrapper_alloc (const gdl_fview_wrapper * fview, gdl_boolean last_level);
gdl_fmatrix * gdl_fmatrix_wrapper_mask_alloc (const gdl_fview_wrapper * fview, const gdl_mask * mask, gdl_boolean last_level);
void gdl_fmatrix_free (gdl_fmatrix * m);

size_t gdl_fmatrix_row_size (const gdl_fmatrix * m);
size_t gdl_fmatrix_column_size (const gdl_fmatrix * m);
size_t gdl_fmatrix_accession_size (const gdl_fmatrix * m);
size_t gdl_fmatrix_factor_size (const gdl_fmatrix * m);
size_t gdl_fmatrix_factor_column_size (const gdl_fmatrix * m, size_t i);
size_t gdl_fmatrix_factor_first_column (const gdl_fmatrix * m, size_t i);
double gdl_fmatrix_get (const gdl_fmatrix * m, size_t i, size_t j);
void gdl_fmatrix_set (gdl_fmatrix * m, size_t i, size_t j, double x);
double gdl_fmatrix_factor_column_get (gdl_fmatrix * m, size_t i, size_t j, size_t a);
void gdl_fmatrix_factor_column_set (gdl_fmatrix * m, size_t i, size_t j, size_t a, double x);
gdl_gvalues * gdl_fmatrix_factor_get (const gdl_fmatrix * m, size_t i, size_t j);
void gdl_fmatrix_factor_set (gdl_fmatrix * m, size_t i, size_t j, const gdl_gvalues * x);
void gdl_fmatrix_factor_set_missing (gdl_fmatrix * m, size_t i, size_t j);
gdl_boolean gdl_fmatrix_factor_is_missing (const gdl_fmatrix * m, size_t i, size_t j);
void gdl_fmatrix_factor_set_all (gdl_fmatrix * m, size_t i, size_t j, double x);
const gdl_matrix  * gdl_fmatrix_get_matrix (const gdl_fmatrix * m);
gdl_flabels * gdl_fmatrix_get_labels (const gdl_fmatrix * m);
gdl_mask * gdl_fmatrix_get_mask (const gdl_fmatrix * m);

int gdl_fmatrix_fprintf (FILE * stream, const gdl_fmatrix * m);

__END_DECLS

#endif /*__GDL_FMATRIX_H__*/
