/*  
 * 	fsheet/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:53 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_fsheet.h>

static gdl_fsheet_type init_1 = 
	{
		1,
		1,
		"\"", // text  seperator = "
		";",  // field seperator = ;
		"\n",
		NULL,
		NULL
	};

static gdl_fsheet_type init_2 = 
	{
		1,
		1,
		"\"", // text  seperator    = "
		"",   // no field seperator
		"\n",
		NULL,
		NULL
	};	

static gdl_fsheet_type init_3 = 
	{
		1,  
		1,  // no column name
		"", // no text  seperator
		"", // no field seperator
		"\n",
		" ", // row name separator
		" ",
	};


void
test_alloc (void)
{
	gdl_fsheet_type * T = gdl_fsheet_type_default();
	gdl_fsheet * fs     = gdl_fsheet_alloc (T);
	
	gdl_test (fs == 0, "gdl_fsheet_alloc returns valid pointer");
	
	gdl_fsheet_free (fs);
}

void
test_init_default (void)
{
	FILE * stream;
	gdl_fsheet_type * T = gdl_fsheet_type_default ();
	gdl_fsheet * fs     = gdl_fsheet_alloc (T);
	
	stream = gdl_fileopen ("tests/sheet1.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	gdl_fileclose ("tests/sheet1.txt", stream);	
	
	gdl_fsheet_free (fs);
}

void
test_init_1 (void)
{
	FILE * stream;
	
	gdl_fsheet * fs     = gdl_fsheet_alloc (&init_1);
	
	stream = gdl_fileopen ("tests/sheet2.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	gdl_fileclose ("tests/sheet2.txt", stream);
	
	gdl_fsheet_free (fs);
}

void
test_init_2 (void)
{
	FILE * stream;
	
	gdl_fsheet * fs     = gdl_fsheet_alloc (&init_2);
	
	stream = gdl_fileopen ("tests/sheet3.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	gdl_fileclose ("tests/sheet3.txt", stream);
	
	gdl_fsheet_free (fs);
}

void
test_init_3 (void)
{
	FILE * stream;
	
	gdl_fsheet * fs     = gdl_fsheet_alloc (&init_3);
	
	stream = gdl_fileopen ("tests/sheet4.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	gdl_fileclose ("tests/sheet4.txt", stream);
	
	gdl_fsheet_free (fs);
}

void
test_iter_rdefault ()
{
	FILE * stream;
	gdl_fsheet_type * T = gdl_fsheet_type_default ();
	gdl_fsheet * fs           = gdl_fsheet_alloc (T);
	gdl_fsheet_itr * itr;
	
	stream = gdl_fileopen ("tests/sheet1.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	itr = gdl_fsheet_iterator_r (fs);
		
	do 
	{
		char * row  = gdl_fsheet_iterator_row (itr);
		char * col  = gdl_fsheet_iterator_column (itr);		
		char * cell = gdl_fsheet_iterator_cell (itr);
		printf ("[%s, %s] =  %s\n", row, col, cell);
	}
	while (gdl_fsheet_iterator_next (itr));
	
	gdl_fsheet_iterator_free (itr);
	
	gdl_fileclose ("tests/sheet1.txt", stream);
	
	gdl_fsheet_free (fs);	
}

void
test_iter_r1 ()
{
	FILE * stream;
	gdl_fsheet * fs           = gdl_fsheet_alloc (&init_1);
	gdl_fsheet_itr * itr;
	
	stream = gdl_fileopen ("tests/sheet2.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	itr = gdl_fsheet_iterator_r (fs);
		
	do 
	{
		char * row  = gdl_fsheet_iterator_row (itr);
		char * col  = gdl_fsheet_iterator_column (itr);		
		char * cell = gdl_fsheet_iterator_cell (itr);
		printf ("[%s, %s] =  %s\n", row, col, cell);
	}
	while (gdl_fsheet_iterator_next (itr));
	
	gdl_fsheet_iterator_free (itr);
	
	gdl_fileclose ("tests/sheet2.txt", stream);
	
	gdl_fsheet_free (fs);	
}

void
test_iter_r2 ()
{
	FILE * stream;
	gdl_fsheet * fs           = gdl_fsheet_alloc (&init_2);
	gdl_fsheet_itr * itr;
	
	stream = gdl_fileopen ("tests/sheet3.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	itr = gdl_fsheet_iterator_r (fs);
		
	do 
	{
		char * row  = gdl_fsheet_iterator_row (itr);
		char * col  = gdl_fsheet_iterator_column (itr);	
		char * cell = gdl_fsheet_iterator_cell (itr);
		printf ("[%s, %s] =  %s\n", row, col, cell);
	}
	while (gdl_fsheet_iterator_next (itr));
	
	gdl_fsheet_iterator_free (itr);
	
	gdl_fileclose ("tests/sheet3.txt", stream);
	
	gdl_fsheet_free (fs);	
}

void
test_iter_r3 ()
{
	FILE * stream;
	gdl_fsheet * fs           = gdl_fsheet_alloc (&init_3);
	gdl_fsheet_itr * itr;
	
	stream = gdl_fileopen ("tests/sheet4.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	itr = gdl_fsheet_iterator_r (fs);
		
	do 
	{
		char * row  = gdl_fsheet_iterator_row (itr);
		char * col  = gdl_fsheet_iterator_column (itr);	
		char * cell = gdl_fsheet_iterator_cell (itr);
		printf ("[%s, NULL=%d] =  %s\n", row, col==NULL, cell);
	}
	while (gdl_fsheet_iterator_next (itr));
	
	gdl_fsheet_iterator_free (itr);
	
	gdl_fileclose ("tests/sheet4.txt", stream);
	
	gdl_fsheet_free (fs);	
}

void
test_iter_cdefault ()
{
	FILE * stream;
	gdl_fsheet_type * T = gdl_fsheet_type_default();
	
	T->cname = 0;
	
	gdl_fsheet * fs     = gdl_fsheet_alloc (T);
	gdl_fsheet_itr * itr;
	
	stream = gdl_fileopen ("tests/sheet1.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	itr = gdl_fsheet_iterator_c (fs);
		
	do 
	{
		char * row  = gdl_fsheet_iterator_row (itr);
		char * col  = gdl_fsheet_iterator_column (itr);		
		char * cell = gdl_fsheet_iterator_cell (itr);
		printf ("[%s, %s] =  %s\n", row, col, cell);
	}
	while (gdl_fsheet_iterator_next (itr));
	
	gdl_fsheet_iterator_free (itr);
	
	itr = gdl_fsheet_iterator_c (fs);
		
	do 
	{
		char * row  = gdl_fsheet_iterator_row (itr);
		char * col  = gdl_fsheet_iterator_column (itr);		
		char * cell = gdl_fsheet_iterator_cell (itr);
		printf ("[%s, %s] =  %s\n", row, col, cell);
	}
	while (gdl_fsheet_iterator_next (itr));
	
	gdl_fsheet_iterator_free (itr);
	
	gdl_fileclose ("tests/sheet1.txt", stream);
	
	gdl_fsheet_free (fs);	
}

void
test_iter_c1 ()
{
	FILE * stream;
	gdl_fsheet * fs           = gdl_fsheet_alloc (&init_1);
	gdl_fsheet_itr * itr;
	
	stream = gdl_fileopen ("tests/sheet2.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	itr = gdl_fsheet_iterator_c (fs);
		
	do 
	{
		char * row  = gdl_fsheet_iterator_row (itr);
		char * col  = gdl_fsheet_iterator_column (itr);		
		char * cell = gdl_fsheet_iterator_cell (itr);
		printf ("[%s, %s] =  %s\n", row, col, cell);
	}
	while (gdl_fsheet_iterator_next (itr));
	
	gdl_fsheet_iterator_free (itr);
	
	gdl_fileclose ("tests/sheet2.txt", stream);
	
	gdl_fsheet_free (fs);	
}

void
test_iter_c2 ()
{
	FILE * stream;
	gdl_fsheet * fs           = gdl_fsheet_alloc (&init_2);
	gdl_fsheet_itr * itr;
	
	stream = gdl_fileopen ("tests/sheet3.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	itr = gdl_fsheet_iterator_c (fs);
		
	do 
	{
		char * row  = gdl_fsheet_iterator_row (itr);
		char * col  = gdl_fsheet_iterator_column (itr);	
		char * cell = gdl_fsheet_iterator_cell (itr);
		printf ("[%s, %s] =  %s\n", row, col, cell);
	}
	while (gdl_fsheet_iterator_next (itr));
	
	gdl_fsheet_iterator_free (itr);
	
	gdl_fileclose ("tests/sheet3.txt", stream);
	
	gdl_fsheet_free (fs);	
}

void
test_iter_c3 ()
{
	FILE * stream;
	gdl_fsheet * fs           = gdl_fsheet_alloc (&init_3);
	gdl_fsheet_itr * itr;
	
	stream = gdl_fileopen ("tests/sheet4.txt", "r");
	
	gdl_fsheet_init (fs, stream);
	
	itr = gdl_fsheet_iterator_c (fs);
		
	do 
	{
		char * row  = gdl_fsheet_iterator_row (itr);
		char * col  = gdl_fsheet_iterator_column (itr);	
		char * cell = gdl_fsheet_iterator_cell (itr);
		printf ("[%s, %s] =  %s\n", row, col, cell);
	}
	while (gdl_fsheet_iterator_next (itr));
	
	gdl_fsheet_iterator_free (itr);
	
	gdl_fileclose ("tests/sheet4.txt", stream);
	
	gdl_fsheet_free (fs);	
}

void
test_iter_r (void)
{
	test_iter_rdefault ();
	test_iter_r1 ();
	test_iter_r2 ();
	test_iter_r3 ();
}

void
test_iter_c (void)
{
	test_iter_cdefault ();
	//test_iter_c1 ();
	//test_iter_c2 ();
	//test_iter_c3 ();
}

void
test_init (void)
{
	test_init_default ();
	test_init_1 ();
	test_init_2 ();
	test_init_3 ();
}

int
main (void)
{
	//test_alloc ();
	//test_init ();
	//test_iter_r ();
	test_iter_c ();
	exit (gdl_test_summary());
}
