/*  
 * 	fuzzy/fuzzy.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h> 
#include <gdl/gdl_hview.h>
#include <gdl/gdl_view.h>
#include <gdl/gdl_fuzzy.h>

gdl_fuzzy_param *
gdl_fuzzy_param_alloc (const gdl_view * view, const gdl_mask * gmask, const gdl_clustering * gclust, const gdl_rng * rng, size_t k)
{
	gdl_fuzzy_param * P;
	
	P = GDL_MALLOC (gdl_fuzzy_param, 1);
	
	P->k      = k;
	P->gmask  = gmask;
	P->gclust = gclust;
	P->rng    = rng;
	P->view   = view;
	P->gview  = gdl_view_get_gview (view);
	P->hview  = gdl_view_get_hview (view);
	
	return P;
}

gdl_fuzzy_param *
gdl_fuzzy_param_galloc (const gdl_gview * gview, const gdl_mask * gmask, const gdl_clustering * gclust, const gdl_rng * rng, size_t k)
{
	gdl_fuzzy_param * P;
	
	P = GDL_CALLOC (gdl_fuzzy_param, 1);
	
	P->k = k;
	P->gmask  = gmask;
	P->rng    = rng;
	P->gview  = gview;
	P->gclust = gclust;
	
	return P;	
}

gdl_fuzzy_param *
gdl_fuzzy_param_halloc (const gdl_hview * hview, const gdl_rng * rng, size_t k)
{
	gdl_fuzzy_param * P;
	
	P = GDL_CALLOC (gdl_fuzzy_param, 1);
	
	P->k = k;
	P->rng   = rng;
	P->hview = hview;
	
	return P;	
}

void
gdl_fuzzy_param_free (gdl_fuzzy_param * P)
{
	if (P)
	{
		GDL_FREE (P);	
	}
}

gdl_fuzzy_workspace *
gdl_fuzzy_workspace_alloc (const gdl_fuzzy_workspace_type * T, gdl_fuzzy_param * P)
{
	gdl_fuzzy_workspace * f;
	
	f = GDL_MALLOC (gdl_fuzzy_workspace, 1);
	
	f->T = T;
	f->P = P;
	
	f->state = gdl_malloc (T->size);
	
	(T->alloc)(f->state, P);
	
	return f;
}

void
gdl_fuzzy_workspace_free (gdl_fuzzy_workspace * f)
{
	if (f)
	{
		(f->T->free)(f->state);
		gdl_fuzzy_param_free (f->P);	
		GDL_FREE (f);
	}
}

int
gdl_fuzzy_workspace_init (gdl_fuzzy_workspace * f)
{
	return (f->T->init)(f->state);
}

int
gdl_fuzzy_workspace_iterate (gdl_fuzzy_workspace * f)
{
	return (f->T->iterate)(f->state);
}

double
gdl_fuzzy_workspace_loglikelihood (gdl_fuzzy_workspace * f)
{
	return (f->T->loglik)(f->state);
}

double
gdl_fuzzy_workspace_residual_sq (gdl_fuzzy_workspace * f)
{
	return (f->T->res_sq)(f->state);
}

double
gdl_fuzzy_workspace_residual_abs (gdl_fuzzy_workspace * f)
{
	return (f->T->res_abs)(f->state);
}

size_t
gdl_fuzzy_workspace_accession_size (gdl_fuzzy_workspace * f)
{
	if (f->T == gdl_fuzzy_gview)
	{
		return GDL_GVIEW_ACCESSION_SIZE (f->P->gview, f->P->gmask);
	}
	else if (f->T == gdl_fuzzy_hview)
	{
		return gdl_hview_accession_size (f->P->hview);
	}
	return 0;
}

size_t
gdl_fuzzy_workspace_locus_size (gdl_fuzzy_workspace * f)
{
	if (f->T == gdl_fuzzy_gview)
	{
		return GDL_GVIEW_LOCUS_SIZE (f->P->gview, f->P->gmask);
	}
	else if (f->T == gdl_fuzzy_hview)
	{
		return gdl_hview_locus_size (f->P->hview);
	}
	return 0;
}

double
gdl_fuzzy_workspace_get_q (const gdl_fuzzy_workspace * f, size_t pop, size_t indiv)
{
	return (f->T->get_q)(f->state, pop, indiv);
}

double
gdl_fuzzy_workspace_get_f (const gdl_fuzzy_workspace * f, size_t pop, size_t loc, size_t allele)
{
	return (f->T->get_f)(f->state, pop, loc, allele);
}

size_t
gdl_fuzzy_workspace_get_f_max (const gdl_fuzzy_workspace * f, size_t pop, size_t loc)
{
	return (f->T->get_f_max)(f->state, pop, loc);
}

size_t
gdl_fuzzy_workspace_get_f_size (const gdl_fuzzy_workspace * f, size_t loc)
{
	return (f->T->get_f_size)(f->state, loc);
}

int
gdl_fuzzy_workspace_fread (gdl_fuzzy_workspace * f, FILE * stream)
{
}

int
gdl_fuzzy_workspace_fwrite (const gdl_fuzzy_workspace * f, FILE * stream)
{
}
