/*  
 * 	fuzzy/gdl_fuzzy.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:03 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FUZZY_H__
#define __GDL_FUZZY_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_gblock.h>
#include <gdl/gdl_gmatrix.h>
#include <gdl/gdl_rng.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_gview.h>
#include <gdl/gdl_gview_mask.h>
#include <gdl/gdl_hview.h>
#include <gdl/gdl_view.h>

__BEGIN_DECLS

typedef struct
{
	size_t k;
	const gdl_view  * view;
	const gdl_gview * gview;
	const gdl_mask * gmask;
	const gdl_clustering * gclust;
	const gdl_hview * hview;
	const gdl_rng * rng;
} gdl_fuzzy_param;

gdl_fuzzy_param * gdl_fuzzy_param_alloc (const gdl_view * view, const gdl_mask * gmask, const gdl_clustering * gclust, const gdl_rng * rng, size_t k);
gdl_fuzzy_param * gdl_fuzzy_param_galloc (const gdl_gview * gview, const gdl_mask * gmask, const gdl_clustering * gclust, const gdl_rng * rng, size_t k);
gdl_fuzzy_param * gdl_fuzzy_param_halloc (const gdl_hview * hview, const gdl_rng * rng, size_t k);
void gdl_fuzzy_param_free (gdl_fuzzy_param * P);

typedef struct
{
  	gdl_string * name;
  	size_t size;
  	int (*alloc) (void * state, const gdl_fuzzy_param * P);
  	int (*free) (void * state);
  	int (*init) (void * state);
  	int (*iterate) (void * state);
  	double (*loglik) (const void * state);
  	double (*res_abs) (const void * state);
  	double (*res_sq) (const void * state);
  	double (*get_q) (const void * state, size_t k, size_t i);
  	double (*get_f) (const void * state, size_t k, size_t l, size_t a);
  	size_t (*get_f_max) (const void * state, size_t k, size_t l);
  	size_t (*get_f_size) (const void * state, size_t l);
  	int (*fread) (FILE * stream, void * state);
  	int (*fwrite) (FILE * stream, const void * state);
} gdl_fuzzy_workspace_type;

typedef struct
{
	const gdl_fuzzy_workspace_type * T;
	gdl_fuzzy_param * P;
	void * state;
} gdl_fuzzy_workspace;

gdl_fuzzy_workspace * gdl_fuzzy_workspace_alloc (const gdl_fuzzy_workspace_type * T, gdl_fuzzy_param * P);
void gdl_fuzzy_workspace_free (gdl_fuzzy_workspace * state);
int gdl_fuzzy_workspace_init (gdl_fuzzy_workspace * state);
int gdl_fuzzy_workspace_iterate (gdl_fuzzy_workspace *state);
double gdl_fuzzy_workspace_loglikelihood (gdl_fuzzy_workspace * state);
double gdl_fuzzy_workspace_residual_sq (gdl_fuzzy_workspace * state);
double gdl_fuzzy_workspace_residual_abs (gdl_fuzzy_workspace * state);
size_t gdl_fuzzy_workspace_accession_size (gdl_fuzzy_workspace * state);
size_t gdl_fuzzy_workspace_locus_size (gdl_fuzzy_workspace * state);
double gdl_fuzzy_workspace_get_q (const gdl_fuzzy_workspace * f, size_t pop, size_t indiv);
double gdl_fuzzy_workspace_get_f (const gdl_fuzzy_workspace * f, size_t pop, size_t loc, size_t allele);
size_t gdl_fuzzy_workspace_get_f_max (const gdl_fuzzy_workspace * f, size_t pop, size_t loc);
size_t gdl_fuzzy_workspace_get_f_size (const gdl_fuzzy_workspace * f, size_t loc);
int gdl_fuzzy_workspace_fread (gdl_fuzzy_workspace * state, FILE * stream);
int gdl_fuzzy_workspace_fwrite (const gdl_fuzzy_workspace * state, FILE * stream);

GDL_VAR const gdl_fuzzy_workspace_type * gdl_fuzzy_gview;
GDL_VAR const gdl_fuzzy_workspace_type * gdl_fuzzy_hview;

__END_DECLS

#endif /* GDL_FUZZY_H */
