/*  
 *  fview/cell.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_fview.h>
#include <gdl/gdl_fview_reader.h>

gdl_fview_reader_cell *
gdl_fview_reader_cell_alloc ()
{
	gdl_fview_reader_cell * c;
	
	c = GDL_CALLOC (gdl_fview_reader_cell, 1);
	
	return c;
}

void
gdl_fview_reader_cell_free (gdl_fview_reader_cell * c)
{
	if (c)
	{
		gdl_gvalues_free (c->point);
		GDL_FREE (c);	
	}	
}
