/*  
 *  fview/gdl_fview_wrapper.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FVIEW_WRAPPER_H__
#define __GDL_FVIEW_WRAPPER_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_gentity.h>
#include <gdl/gdl_mask.h>
#include <gdl/gdl_fview.h>
#include <gdl/gdl_fview_mask.h>

__BEGIN_DECLS

typedef struct _gdl_fview_wrapper_type gdl_fview_wrapper_type;
typedef struct _gdl_fview_wrapper gdl_fview_wrapper;
//typedef struct _gdl_fview_wrapper_missing gdl_fview_wrapper_missing;

gdl_fview_wrapper * gdl_fview_wrapper_alloc (const gdl_fview_wrapper_type * T, const gdl_fview * fview, const gdl_mask * mask);
void gdl_fview_wrapper_free (gdl_fview_wrapper * gw);

const gdl_fview * gdl_fview_wrapper_fview (const gdl_fview_wrapper * gw);
const gdl_mask  * gdl_fview_wrapper_mask (const gdl_fview_wrapper * gw);

size_t gdl_fview_wrapper_accession_size (const gdl_fview_wrapper * gw);
size_t gdl_fview_wrapper_factor_size (const gdl_fview_wrapper * gw);
size_t gdl_fview_wrapper_factor_level_size (const gdl_fview_wrapper * gw, size_t i);
gdl_accession * gdl_fview_wrapper_get_accession (const gdl_fview_wrapper * gw, size_t i);
gdl_factor    * gdl_fview_wrapper_get_factor (const gdl_fview_wrapper * gw, size_t i);
gdl_gvalues_get * gdl_fview_wrapper_get_new (const gdl_fview_wrapper * gw);
int gdl_fview_wrapper_get_value (const gdl_fview_wrapper * gw, size_t i, size_t j, gdl_gvalues_get * g);
gdl_boolean gdl_fview_wrapper_is_missing (const gdl_fview_wrapper * gw, size_t i, size_t j);

gdl_mask * gdl_fview_wrapper_mask_not_informative (const gdl_fview_wrapper * fw, const gdl_mask * mask, const gdl_entity_type * T);

//size_t gdl_fview_wrapper_missing_size (const gdl_fview_wrapper * gw);
//size_t gdl_fview_wrapper_missing_accession_size (const gdl_fview_wrapper * gw);
//size_t gdl_fview_wrapper_missing_factor_size (const gdl_fview_wrapper * gw, size_t r);
//const size_t * gdl_fview_wrapper_missing_factor_idx (const gdl_fview_wrapper * gw, size_t r);
//gdl_gvalues * gdl_fview_wrapper_missing_get (const gdl_fview_wrapper * gw, size_t r, size_t l);
//void gdl_fview_wrapper_missing_reset (const gdl_fview_wrapper * gw, size_t r, size_t l);

//size_t GDL_FVIEW_WRAPPER_ACCESSION_SIZE (const gdl_fview_wrapper * gw, const gdl_mask * mask);
//size_t GDL_FVIEW_WRAPPER_FACTOR_SIZE (const gdl_fview_wrapper * gw, const gdl_mask * mask);
//size_t GDL_FVIEW_WRAPPER_FACTOR_LEVEL_SIZE (const gdl_fview_wrapper * gw, const gdl_mask * mask, size_t i);
//gdl_accession * GDL_FVIEW_WRAPPER_GET_ACCESSION (const gdl_fview_wrapper * gw, const gdl_mask * mask, size_t i);
//gdl_factor    * GDL_FVIEW_WRAPPER_GET_FACTOR (const gdl_fview_wrapper * gw, const gdl_mask * mask, size_t i);
//gdl_gvalues_get * GDL_FVIEW_WRAPPER_GET_NEW (const gdl_fview_wrapper * gw, const gdl_mask * mask);
//int GDL_FVIEW_WRAPPER_GET_VALUE (const gdl_fview_wrapper * gw, const gdl_mask * mask, size_t i, size_t j, gdl_gvalues_get * g);
//gdl_boolean GDL_FVIEW_WRAPPER_IS_MISSING (const gdl_fview_wrapper * gw, const gdl_mask * mask, size_t i, size_t j);

GDL_VAR const gdl_fview_wrapper_type * gdl_fview_wrapper_local;
GDL_VAR const gdl_fview_wrapper_type * gdl_fview_wrapper_global;

__END_DECLS

#endif
