/*  
 *  fview/gdl_fview_writer.h
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#ifndef __GDL_FVIEW_WRITER_H__
#define __GDL_FVIEW_WRITER_H__

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_fview.h>

__BEGIN_DECLS

typedef struct _gdl_fview_writer gdl_fview_writer;

typedef struct
{
	char * missing;
	int (*write)(gdl_fview_writer * writer, const gdl_fview * fview);
} gdl_fview_writer_type;

gdl_fview_writer_type * gdl_fview_writer_type_new (const gdl_fview_writer_type * type);
void gdl_fview_writer_type_free (gdl_fview_writer_type * type);
void gdl_fview_writer_type_missing (gdl_fview_writer_type * t, gdl_string * missing);

struct _gdl_fview_writer
{
	gdl_string * filename;
	gdl_string * error;
	FILE       * stream;
	gdl_fview_writer_type * type;	
};

// High level api
gdl_fview_writer * gdl_fview_writer_alloc (gdl_fview_writer_type * type);
void gdl_fview_writer_free (gdl_fview_writer * writer);
int gdl_fview_writer_open (gdl_fview_writer * writer, const gdl_string * filename);
int gdl_fview_writer_dump (gdl_fview_writer * writer, const gdl_fview * fview);
int gdl_fview_writer_close (gdl_fview_writer * writer);
// Low level api
int gdl_fview_writer_error (gdl_fview_writer * writer, char * format, ...);

GDL_VAR const gdl_fview_writer_type * gdl_fview_writer_standard;

__END_DECLS

#endif /* __GDL_FVIEW_WRITER_H__ */
