/*  
 *  fview/rtype.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_string.h>
#include <gdl/gdl_fview_reader.h>

gdl_fview_reader_type *
gdl_fview_reader_type_new (const gdl_fview_reader_type * type)
{
	if (type)
	{
		gdl_fview_reader_type * clone;
		
		clone = GDL_CALLOC (gdl_fview_reader_type, 1);
		
		clone->missing   = gdl_string_clone (type->missing);
		clone->sep       = gdl_string_clone (type->sep);
		clone->has_acc_name = type->has_acc_name;
		clone->has_fac_header = type->has_fac_header;
		clone->read    = type->read;
		
		return clone;
	}
}

void
gdl_fview_reader_type_free (gdl_fview_reader_type * type)
{
	if (type)
	{
		gdl_string_free (type->missing);
		gdl_string_free (type->sep);
		GDL_FREE (type);
	}
}

void
gdl_fview_reader_type_missing (gdl_fview_reader_type * type, gdl_string * missing)
{
	gdl_string_free (type->missing);
	type->missing = gdl_string_clone (missing);
}

void
gdl_fview_reader_type_separator (gdl_fview_reader_type * type, gdl_string * sep)
{
	gdl_string_free (type->sep);
	type->sep = gdl_string_clone (sep);
}

void
gdl_fview_reader_type_factor_header (gdl_fview_reader_type * type, gdl_boolean has)
{
	type->has_fac_header = has;
}

void
gdl_fview_reader_type_accession_name (gdl_fview_reader_type * type, gdl_boolean has)
{
	type->has_acc_name = has;
}
