/*  
 *  fview/test.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_test.h>
#include <gdl/gdl_clustering.h>
#include <gdl/gdl_fview.h>
#include <gdl/gdl_fview_reader.h>
#include <gdl/gdl_fview_writer.h>
#include <gdl/gdl_check_range.h>

int gdl_check_range = 1;

gdl_fview_reader_type *
test_parse_continuous_type (void)
{
	gdl_fview_reader_type * type =
    	gdl_fview_reader_type_new (gdl_fview_reader_continuous);
    
    gdl_fview_reader_type_missing (type, "?");
    
    return type;
}

int
test_parse_continuous (void)
{
	size_t i, j;
	FILE * stream;
	gdl_fview_reader_type * type;
	gdl_fview_reader      * reader;
	gdl_fview             * f;
	
	type = test_parse_continuous_type ();
	
	reader = gdl_fview_reader_alloc (type);
		
	gdl_fview_reader_open (reader, "examples/cdata.txt");
	
	f = gdl_fview_reader_parse (reader);
	
	if (!f)
	{
		printf ("ERROR : %s\n", reader->error);	
	}
	
	gdl_fview_reader_close (reader);
	
	gdl_fview_reader_free (reader);
	
   stream = gdl_fileopen ("test.dat", "w");
	
	gdl_fview_fwrite (stream, f);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_fview_free (f);
	
	stream = gdl_fileopen ("test.dat", "r");
	
	f = gdl_fview_fread (stream);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_fview_free (f);
}

gdl_fview_reader_type *
test_parse_mixture_type (void)
{
	gdl_fview_reader_type * type =
    	gdl_fview_reader_type_new (gdl_fview_reader_mixture);
    
    gdl_fview_reader_type_missing (type, "?");
    
    return type;
}

int
test_parse_mixture (void)
{
	size_t i, j;
	FILE * stream;
	gdl_fview_reader_type * type;
	gdl_fview_reader      * reader;
	gdl_fview             * f;
	
	type = test_parse_mixture_type ();
	
	reader = gdl_fview_reader_alloc (type);
		
	gdl_fview_reader_open (reader, "examples/mdata.txt");
	
	f = gdl_fview_reader_parse (reader);
	
	if (!f)
	{
		printf ("ERROR : %s\n", reader->error);	
	}
	
	gdl_fview_reader_close (reader);
	
	gdl_fview_reader_free (reader);
	
   stream = gdl_fileopen ("test.dat", "w");
	
	gdl_fview_fwrite (stream, f);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_fview_free (f);
	
	stream = gdl_fileopen ("test.dat", "r");
	
	f = gdl_fview_fread (stream);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_fview_free (f);
}

gdl_fview_reader_type *
test_parse_categorial_type (void)
{
	gdl_fview_reader_type * type =
    	gdl_fview_reader_type_new (gdl_fview_reader_categorial);
    
    gdl_fview_reader_type_missing (type, "?");
    
    return type;
}

int
test_parse_categorial (void)
{
	size_t i, j;
	FILE * stream;
	gdl_fview_reader_type * type;
	gdl_fview_reader      * reader;
	gdl_fview             * f;
	
	type = test_parse_categorial_type ();
	
	reader = gdl_fview_reader_alloc (type);
		
	gdl_fview_reader_open (reader, "examples/ddata.txt");
	
	f = gdl_fview_reader_parse (reader);
	
	if (!f)
	{
		printf ("ERROR : %s\n", reader->error);	
	}
	
	gdl_fview_reader_close (reader);
	
	gdl_fview_reader_free (reader);
	
   stream = gdl_fileopen ("test.dat", "w");
	
	gdl_fview_fwrite (stream, f);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_fview_free (f);
	
	stream = gdl_fileopen ("test.dat", "r");
	
	f = gdl_fview_fread (stream);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_fview_free (f);
}

int
test_virtual (void)
{
	size_t i, j;
	FILE * stream;
	gdl_fview_reader_type * type;
	gdl_fview_reader      * reader;
	gdl_fview_writer      * writer;
	gdl_fview             * f1, * f2, * f3, * f;
	
	type = test_parse_continuous_type ();
	reader = gdl_fview_reader_alloc (type);
	gdl_fview_reader_open (reader, "examples/cdata.txt");
	f1 = gdl_fview_reader_parse (reader);
	gdl_fview_reader_close (reader);
	gdl_fview_reader_free (reader);
	
   type = test_parse_mixture_type ();
	reader = gdl_fview_reader_alloc (type);
	gdl_fview_reader_open (reader, "examples/mdata.txt");
	f2 = gdl_fview_reader_parse (reader);
	gdl_fview_reader_close (reader);
	gdl_fview_reader_free (reader);
	
	type = test_parse_categorial_type ();
	reader = gdl_fview_reader_alloc (type);
	gdl_fview_reader_open (reader, "examples/ddata.txt");
	f3 = gdl_fview_reader_parse (reader);
	gdl_fview_reader_close (reader);
	gdl_fview_reader_free (reader);
	
	f = gdl_fview_alloc (gdl_fview_virtual);
	
	gdl_fview_add (f, "continuous", f1, 1);
	gdl_fview_add (f, "mixture", f2, 1);
	gdl_fview_add (f, "categorial", f3, 1);
	
	stream = gdl_fileopen ("test.dat", "w");
	
	gdl_fview_fwrite (stream, f);
	
	gdl_fileclose ("test.dat", stream);
	
	gdl_fview_free (f);
	
	stream = gdl_fileopen ("test.dat", "r");
	
	f = gdl_fview_fread (stream);
	
	gdl_fileclose ("test.dat", stream);
	
	writer = gdl_fview_writer_alloc (gdl_fview_writer_type_new (gdl_fview_writer_standard));
	
	gdl_fview_writer_open (writer, "test.txt");
	
	gdl_fview_writer_dump (writer, f);
	
	gdl_fview_writer_close (writer);
	
	gdl_fview_writer_free (writer);
	
	gdl_fview_free (f);
}

int
main (void)
{
//	test_parse_continuous ();
//	test_parse_mixture ();
//	test_parse_categorial ();
	test_virtual ();
	exit (gdl_test_summary());
}
