/*  
 *  fview/standard.c
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:33:46 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */
 
#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_util.h>
#include <gdl/gdl_io.h>
#include <gdl/gdl_fsheet.h>
#include <gdl/gdl_fview.h>
#include <gdl/gdl_fview_writer.h>

static int
_standard_write (gdl_fview_writer * writer, const gdl_fview * fview)
{
	size_t i, j, k;
	size_t nf = gdl_fview_factor_size (fview);
	size_t na = gdl_fview_accession_size (fview);
	gdl_gvalues_get * get;
	const gdl_gvalues * gv;
	FILE * stream;
	
	stream = writer->stream;
	
	for (j = 0; j < nf; j++)
	{
		gdl_factor * factor = gdl_fview_get_factor (fview, j);
		
		if (gdl_factor_get_type (factor) == gdl_factor_mixture)
		{
			for (k = 0; k < gdl_factor_size (factor); k++)
			{
				gdl_factor_level * level = gdl_factor_get (factor, k);
				fprintf (stream, "%s:%s", gdl_entity_get_name (factor), gdl_entity_get_name (level));
				if (k < gdl_factor_size (factor)-1 || j < nf - 1)
				{
					fprintf (stream, "\t");	
				}
			}
		}
		else
		{
			fprintf (stream, "%s", factor->name);
			if (j < nf - 1)
			{
				fprintf (stream, "\t");
			}
		}
	}
	fprintf (stream, "\n");
	
	get = gdl_fview_get_new (fview);
	
	for (i = 0; i < na; i++)
	{
		gdl_accession * accession = gdl_fview_get_accession	(fview, i);
		fprintf (stream, "%s", accession->name);
		
		for (j = 0; j < nf; j++)
		{
			gdl_factor * factor = gdl_fview_get_factor (fview, j);
			
			gdl_fview_get_value_f (fview, i, j, get);
			
			gv = gdl_gvalues_get_gvalues (get);
			
			if (gdl_factor_get_type (factor) == gdl_factor_mixture)
			{
				for (k = 0; k < gdl_factor_size (factor); k++)
				{
					if (gv)
					{
						fprintf (stream, "\t%g", gv->values[k]->value);
					}
					else
					{
						fprintf (stream, "\t%s", writer->type->missing);
					}
				}
			}
			else if (gdl_factor_get_type (factor) == gdl_factor_categorial)
			{
				if (gv)
				{
					gdl_factor_level * level = gdl_factor_get (factor, gv->values[0]->idx);
					fprintf (stream, "\t%s", gdl_entity_get_name (level));
				}
				else
				{
					fprintf (stream, "\t%s", writer->type->missing);	
				}
			}
			else
			{
				if (gv)
				{
					fprintf (stream, "\t%g", gv->values[0]->value);
				}
				else
				{
					fprintf (stream, "\t%s", writer->type->missing);
				}	
			}
		}
		fprintf (stream, "\n");
	}
	
	gdl_gvalues_get_free (get);
	
	return GDL_SUCCESS;
}

static gdl_fview_writer_type _gdl_fview_writer_standard = 
{
	"?",
	&_standard_write
};

const gdl_fview_writer_type * gdl_fview_writer_standard 
                                   = &_gdl_fview_writer_standard;
