/*  
 * 	gblock/allele.c 
 *  
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>
#include <gdl/gdl_errno.h>
#include <gdl/gdl_allele_block.h>

gdl_allele_block *
gdl_allele_block_alloc (const size_t n, const size_t l, const size_t p)
{
	gdl_allele_block * b;
	
	b = GDL_MALLOC (gdl_allele_block, 1);
	
	b->n = n;
	b->l = l;
	b->p = p;
	
	b->data = GDL_MALLOC (size_t, n*l*p);
	
	return b;
}

void
gdl_allele_block_free (gdl_allele_block * b)
{
	if (b)
	{
		GDL_FREE (b->data);
		GDL_FREE (b);
	}
}

size_t
gdl_allele_block_get (const gdl_allele_block * b, size_t a, size_t l, size_t p)
{
	return b->data[a*(b->l*b->p)+p*b->l+l];
}

void
gdl_allele_block_set (const gdl_allele_block * b, size_t a, size_t l, size_t p, size_t x)
{
	b->data[a*(b->l*b->p)+p*b->l+l]=x;	
}

gdl_allele_block *
gdl_allele_block_clone (const gdl_allele_block * b)
{
	if (b)
	{
		gdl_allele_block * c = gdl_allele_block_alloc (b->n, b->l, b->p);
		memcpy (c->data, b->data, sizeof(size_t)*c->n*c->l*c->p);
		return c;
	}
	return 0;	
}

gdl_allele_block *
gdl_allele_block_fread (FILE * stream)
{
	if (stream)
	{
		int status;
		size_t n, l, p;
		gdl_allele_block * b;
		
		status = fread (&n, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&l, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		status = fread (&p, sizeof(size_t), 1, stream);
		GDL_FREAD_STATUS (status, 1);
		
		b = gdl_allele_block_alloc (n, l, p);
		
		status = fread (b->data, sizeof(size_t), n*l*p, stream);
		GDL_FREAD_STATUS (status, n*l*p);
		
		return b;
	}
	return 0;	
}

int
gdl_allele_block_fwrite (FILE * stream, const gdl_allele_block * b)
{
	if (stream && b)
	{
		int status;
		
		status = fwrite (&b->n, sizeof(size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&b->l, sizeof(size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (&b->p, sizeof(size_t), 1, stream);
		GDL_FWRITE_STATUS (status, 1);
		status = fwrite (b->data, sizeof(size_t), b->n*b->l*b->p, stream);
		GDL_FWRITE_STATUS (status, b->n*b->l*b->p);
		
		return GDL_SUCCESS;
	}
	return GDL_EINVAL;
}

