/*  
 *  gblock/gdl_frequency_block.h
 *  
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>

#ifndef __GDL_GBLOCK_FREQUENCY_H__
#define __GDL_GBLOCK_FREQUENCY_H__ 

__BEGIN_DECLS

typedef struct 
{
	size_t l;
	size_t t;
	size_t * tna;
	double * data;
} gdl_frequency_block;

gdl_frequency_block * gdl_frequency_block_alloc  (const size_t l, const size_t * na);
void gdl_frequency_block_free (gdl_frequency_block * b);
double gdl_frequency_block_get (const gdl_frequency_block * b, size_t l, size_t a);
void gdl_frequency_block_set (const gdl_frequency_block * b, size_t l, size_t a, double x);

gdl_frequency_block * gdl_frequency_block_fread (FILE * stream);
int gdl_frequency_block_fwrite (FILE * stream, const gdl_frequency_block * f);


typedef struct 
{
	size_t k;
	gdl_frequency_block ** blocks;
} gdl_frequencies_block;

gdl_frequencies_block * gdl_frequencies_block_alloc  (const size_t k, const size_t l, const size_t * na);
void gdl_frequencies_block_free (gdl_frequencies_block * b);
double gdl_frequencies_block_get (const gdl_frequencies_block * b, size_t k, size_t l, size_t a);
void gdl_frequencies_block_set (const gdl_frequencies_block * b, size_t k, size_t l, size_t a, double x);

gdl_frequencies_block * gdl_frequencies_block_fread (FILE * stream);
int gdl_frequencies_block_fwrite (FILE * stream, const gdl_frequencies_block * f);

__END_DECLS

#endif /* __GDL_GBLOCK_FREQUENCY_H__ */
