/*  
 * 	gblock/gdl_gblock_double.h 
 *  
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>

#ifndef __GDL_GBLOCK_DOUBLE_H__
#define __GDL_GBLOCK_DOUBLE_H__ 

__BEGIN_DECLS

typedef struct 
{
	size_t size;
	size_t p;
	size_t *dim;
	size_t *_ssize;
	double *data;
} gdl_block;

typedef gdl_block * gdl_block_ptr;

typedef struct 
{
	size_t size;
	size_t p;
	size_t *dim;
	size_t **nested;
	size_t *_sizes;
	size_t *_ssize;
	size_t **_nssize;
	double *data;
} gdl_nblock;

typedef gdl_nblock * gdl_nblock_ptr;

typedef struct 
{
	size_t size;
	size_t p;
	size_t p1;
	size_t p2;
	size_t *dim;
	size_t **nested;
	size_t *_sizes;
	size_t *_ssize;
	size_t **_nssize;
	double *data;
} gdl_hnblock;

typedef gdl_hnblock * gdl_hnblock_ptr;

gdl_block *gdl_block_alloc  (const size_t p, const size_t *dim);
gdl_block *gdl_block_alloc2 (const size_t p, ...);
void gdl_block_free (gdl_block * b);
double gdl_block_get (const gdl_block * b, ...);
void gdl_block_set (gdl_block * b, ...);
gdl_block *gdl_block_fread (FILE * stream);
int gdl_block_fwrite (FILE * stream, const gdl_block *b);

gdl_nblock *gdl_nblock_alloc (const size_t size, const size_t *dim, size_t ** nested);
void gdl_nblock_free (gdl_nblock * b);
double gdl_nblock_get (const gdl_nblock * b, ...);
void gdl_nblock_set (gdl_nblock * b, ...);
gdl_nblock *gdl_nblock_fread (FILE * stream);
int gdl_nblock_fwrite (FILE * stream, const gdl_nblock *b);

gdl_hnblock *gdl_hnblock_alloc  (const size_t p1, const size_t p2, const size_t *dim, size_t ** nested);
void gdl_hnblock_free (gdl_hnblock * b);
double gdl_hnblock_get (const gdl_hnblock * b, ...);
void gdl_hnblock_set (gdl_hnblock * b, ...);
gdl_hnblock *gdl_hnblock_fread (FILE * stream);
int gdl_hnblock_fwrite (FILE * stream, const gdl_hnblock *b);


__END_DECLS

#endif /* __GDL_GBLOCK_DOUBLE_H__ */
