/*  
 * 	gblock/gdl_gblock_int.h 
 *  
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>

#ifndef __GDL_GBLOCK_FLOAT_H__
#define __GDL_GBLOCK_FLOAT_H__ 

__BEGIN_DECLS

typedef struct 
{
	size_t size;
	size_t p;
	size_t *dim;
	size_t *_ssize;
	float *data;
} gdl_block_float;

typedef gdl_block_float * gdl_block_float_ptr;

typedef struct 
{
	size_t size;
	size_t p;
	size_t *dim;
	size_t **nested;
	size_t *_sizes;
	size_t *_ssize;
	size_t **_nssize;
	float *data;
} gdl_nblock_float;

typedef gdl_nblock_float * gdl_nblock_float_ptr;

typedef struct 
{
	size_t size;
	size_t p;
	size_t p1;
	size_t p2;
	size_t *dim;
	size_t **nested;
	size_t *_sizes;
	size_t *_ssize;
	size_t **_nssize;
	float *data;
} gdl_hnblock_float;

typedef gdl_hnblock_float * gdl_hnblock_float_ptr;

gdl_block_float *gdl_block_float_alloc  (const size_t p, const size_t *dim);
gdl_block_float *gdl_block_float_alloc2 (const size_t p, ...);
void gdl_block_float_free (gdl_block_float * b);
float gdl_block_float_get (const gdl_block_float * b, ...);
void gdl_block_float_set (gdl_block_float * b, ...);
gdl_block_float *gdl_block_float_fread (FILE * stream);
int gdl_block_float_fwrite (FILE * stream, const gdl_block_float *b);

gdl_nblock_float *gdl_nblock_float_alloc (const size_t size, const size_t *dim, size_t ** nested);
void gdl_nblock_float_free (gdl_nblock_float * b);
float gdl_nblock_float_get (const gdl_nblock_float * b, ...);
void gdl_nblock_float_set (gdl_nblock_float * b, ...);
gdl_nblock_float *gdl_nblock_float_fread (FILE * stream);
int gdl_nblock_float_fwrite (FILE * stream, const gdl_nblock_float *b);

gdl_hnblock_float *gdl_hnblock_float_alloc (const size_t p1, const size_t p2, const size_t *dim, size_t **nested);
void gdl_hnblock_float_free (gdl_hnblock_float * b);
float gdl_hnblock_float_get (const gdl_hnblock_float * b, ...);
void gdl_hnblock_float_set (gdl_hnblock_float * b, ...);
gdl_hnblock_float *gdl_hnblock_float_fread (FILE * stream);
int gdl_hnblock_float_fwrite (FILE * stream, const gdl_hnblock_float *b);


__END_DECLS

#endif /* __GDL_GBLOCK_INT_H__ */

