/*  
 * 	gblock/gdl_gblock_int.h 
 *  
 * 
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>

#ifndef __GDL_GBLOCK_SHORT_H__
#define __GDL_GBLOCK_SHORT_H__ 

__BEGIN_DECLS

typedef struct 
{
	size_t size;
	size_t p;
	size_t *dim;
	size_t *_ssize;
	short * data;
} gdl_block_short;

typedef gdl_block_short * gdl_block_short_ptr;

typedef struct 
{
	size_t size;
	size_t p;
	size_t *dim;
	size_t **nested;
	size_t *_sizes;
	size_t *_ssize;
	size_t **_nssize;
	short *data;
} gdl_nblock_short;

typedef gdl_nblock_short * gdl_nblock_short_ptr;

typedef struct 
{
	size_t size;
	size_t p;
	size_t p1;
	size_t p2;
	size_t *dim;
	size_t **nested;
	size_t *_sizes;
	size_t *_ssize;
	size_t **_nssize;
	short *data;
} gdl_hnblock_short;

typedef gdl_hnblock_short * gdl_hnblock_short_ptr;

gdl_block_short *gdl_block_short_alloc  (const size_t p, const size_t *dim);
gdl_block_short *gdl_block_short_alloc2 (const size_t p, ...);
void gdl_block_short_free (gdl_block_short * b);
short gdl_block_short_get (const gdl_block_short * b, ...);
void gdl_block_short_set (gdl_block_short * b, ...);
gdl_block_short *gdl_block_short_fread (FILE * stream);
int gdl_block_short_fwrite (FILE * stream, const gdl_block_short *b);

gdl_nblock_short *gdl_nblock_short_alloc (const size_t size, const size_t *dim, size_t ** nested);
void gdl_nblock_short_free (gdl_nblock_short * b);
short gdl_nblock_short_get (const gdl_nblock_short * b, ...);
void gdl_nblock_short_set (gdl_nblock_short * b, ...);
gdl_nblock_short *gdl_nblock_short_fread (FILE * stream);
int gdl_nblock_short_fwrite (FILE * stream, const gdl_nblock_short *b);

gdl_hnblock_short *gdl_hnblock_short_alloc (const size_t p1, const size_t p2, const size_t *dim, size_t **nested);
void gdl_hnblock_short_free (gdl_hnblock_short * b);
short gdl_hnblock_short_get (const gdl_hnblock_short * b, ...);
void gdl_hnblock_short_set (gdl_hnblock_short * b, ...);
gdl_hnblock_short *gdl_hnblock_short_fread (FILE * stream);
int gdl_hnblock_short_fwrite (FILE * stream, const gdl_hnblock_short *b);


__END_DECLS

#endif /* __GDL_GBLOCK_INT_H__ */

