/*  
 *  gblock/gdl_locus_block.h
 *  
 *  $Author: baptiste $, $Date: 2008-05-13 15:22:04 $, $Version$
 *
 *  Libgdl : a C library for statistical genetics
 * 
 *  Copyright (C) 2003-2006  Jean-Baptiste Veyrieras, INRA, France.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA * 
 */

#include <gdl/gdl_common.h>

#ifndef __GDL_GBLOCK_LOCUS_H__
#define __GDL_GBLOCK_LOCUS_H__ 

__BEGIN_DECLS

typedef struct 
{
	size_t l;
	size_t n;
	size_t p;
	double * data;
} gdl_locus_block;

gdl_locus_block * gdl_locus_block_alloc  (const size_t n, const size_t l, const size_t p);
void gdl_locus_block_free (gdl_locus_block * b);
double gdl_locus_block_get (const gdl_locus_block * b, size_t a, size_t l, size_t p);
void gdl_locus_block_set (const gdl_locus_block * b, size_t a, size_t l, size_t p, double x);

gdl_locus_block * gdl_locus_block_fread (FILE * stream);
int gdl_locus_block_fwrite (FILE * stream, const gdl_locus_block * f);


typedef struct 
{
	size_t k;
	gdl_locus_block ** blocks;
} gdl_loci_block;

gdl_loci_block * gdl_loci_block_alloc  (const size_t k, const size_t n, const size_t l, const size_t p);
void gdl_loci_block_free (gdl_loci_block * b);
double gdl_loci_block_get (const gdl_loci_block * b, size_t k, size_t l, size_t a, size_t j);
void gdl_loci_block_set (const gdl_loci_block * b, size_t k, size_t l, size_t a, size_t j, double x);

gdl_loci_block * gdl_loci_block_fread (FILE * stream);
int gdl_loci_block_fwrite (FILE * stream, const gdl_loci_block * f);

__END_DECLS

#endif /* __GDL_GBLOCK_LOCUS_H__ */
